<?php

/*

	Controller For Sytem..

*/

Class Systems extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->helper('url');
		$this->load->library('session');
		$this->load->model('lwds');
		$this->load->model('cost_center');
		$this->load->model('contractareas');
		$this->load->model('offices');
		$this->load->model('event');
		$this->load->library('session');
		$this->load->library('pagination');
			$this->load->library('excel');
		if( $this->session->userdata('login_id') != 1 )
		{
			$this->session->set_flashdata('error_msg','Not Login Yet');
			redirect('/');
		}


	}

	public static function logMessage(String $errLevel, $msg, $depth=1)
	  {
	    $btStack = debug_backtrace($depth);
	    $callerFrame = $btStack[$depth-1];

	    $sid = substr(session_id(),0,8);
	    $method = $callerFrame['class'].'.'.$callerFrame['function'];
	    $lineNo = $callerFrame['line'];
	    $fullMessage = 'SID:'.$sid.' '.$method.'('.$lineNo.'): '.$msg;

	    log_message($errLevel, $fullMessage);
	  }

	function parseHttpResponse($response)
	  {
	      // Parse the headers
	    $headers = array();

	    $body = null;

	    // Split up the httpResponse
	    $responseParts = explode("\r\n\r\n", $response);
	    foreach ($responseParts as $i => $responsePart)
	      {
	        $lines = explode("\r\n", $responsePart);

	        // If the part has 200 response Code, parse the rest of the lines as headers.
	        //if($lines[0] == "HTTP/1.1 " )
	        if(strpos($lines[0], 'HTTP/1.1') !== false )
	        {
	        if (preg_match('/^HTTP\/1.1 [4,5]/', $lines[0]))
	          {
	          // 4xx or 5xx error
	          // so log the error
	          $this->logMessage('error', 'Line 0='.$lines[0], 2);
	          }

	        foreach ($lines as $j => $line)
	          {
	              if ($j === 0)
	          {
	                  $headers['http_code'] = $line;
	          }
	              else
	              {
	                  list ($key, $value) = explode(': ', $line);

	                  $headers[$key] = $value;
	              }
	          }
	        }
	        // If last element, probably body
	        else if($i === sizeof($responseParts)-1)
	        {
	          $body = json_decode($responsePart,true);
	        }
	      }

	      return array(
	        'headers' => $headers,
	        'body' => $body
	      );
	  }
	function device($serialNumber = null)
	{
		$this->load->model('users');
		if( $this->session->userdata("lone_read") != "1" ){

				$blocked = '1';
				$this->session->unset_userdata('login_id');
				$this->session->unset_userdata('office_id');
				$this->session->unset_userdata('contractarea_id');
				$this->session->unset_userdata('type');
				session_destroy();
				$this->load->library('logger');
				$actual_link = "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
				$this->users->blockUser($blocked,$this->session->userdata('user_id'));
				$this->logger->trigger_log($this->session->userdata('username'),'tried to access restricted page '.$actual_link.'. User account suspeneded ');
				$this->deleteDirectory($this->session->userdata('audioPath'));
				echo '<!DOCTYPE html><html><head><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"><link href="https://fonts.googleapis.com/css?family=Montserrat:400,600" rel="stylesheet"></head><body style="margin:0; padding:0; font-family: Montserrat, sans-serif;"><div style="width:700px; margin:90px auto;"> <div style=" width:680px; border: 10px solid #000; background:#0d1f4f; color:#fff; padding:80px 20px; float:left;"> <span style="font-size:45px; font-weight: 600; float:left; width:100%;"><i class="fa fa-exclamation-triangle" aria-hidden="true"></i> Your account has been temporarily suspended.</span> <span style="font-size: 16px; line-height:26px; float:left; width:100%; padding:30px 0px;">For security reasons, your account has been temporarily suspended. You can contact the Administrator at </span> <span><i class="fa fa-envelope-o" aria-hidden="true"></i>&nbsp;administrator@orbisprotect.com</span> </div></div></body></html>';
				exit;
		}

		//$sql = "SELECT customer.contno, customer.name, customer.serialno, systrans.latitude, systrans.longitude FROM customer, systrans, trantype WHERE customer.linkno IN ( SELECT linkno FROM linkacc START WITH linkacc.linkno IN (".$this->session->userdata('linkAccountFirstGroupID').") CONNECT BY PRIOR linkacc.linkno = linkacc.parent) AND customer.serialno = systrans.serialno AND systrans.transtype = trantype.trantype AND (trantype.descr LIKE '%1000%' OR trantype.descr LIKE '%1100%' OR trantype.descr like '%1700%')";

		//$sql = "SELECT customer.contno, customer.name, customer.serialno, systrans.latitude, systrans.longitude, systrans.lastsignal, eventdef.descr FROM customer, systrans, trantype, outer eventdef WHERE customer.linkno IN ( SELECT linkno FROM linkacc START WITH linkacc.linkno IN (".$this->session->userdata('linkAccountFirstGroupID').") CONNECT BY PRIOR linkacc.linkno = linkacc.parent) AND customer.serialno = systrans.serialno AND systrans.transtype = trantype.trantype AND (trantype.descr LIKE '%1000%' OR trantype.descr LIKE '%1100%' OR trantype.descr like '%1700%') AND systrans.lasteventstcode = eventdef.stcode";

		$sql = "SELECT customer.name,customer.contno,customer.serialno,contsite.phone,systrans.latitude, systrans.longitude,case monitoring.commstate when 0 then 'Yet to be commissioned' when 1 then 'Commissioned' when 2 then 'Decommissioned' end case,entityproperties.propertyvalue,trantype.descr FROM customer,monitoring,systrans,trantype,outer contsite,OUTER entityproperties WHERE customer.linkno IN ( SELECT linkno FROM linkacc START WITH linkacc.linkno IN (".$this->session->userdata('linkAccountFirstGroupID').") CONNECT BY PRIOR linkacc.linkno = linkacc.parent) AND customer.serialno = monitoring.serialno AND customer.serialno = contsite.serialno AND contsite.contid = 1 AND customer.serialno = systrans.serialno AND systrans.transtype = trantype.trantype AND (trantype.descr LIKE '%1000%' OR trantype.descr LIKE '%1100%' OR trantype.descr like '%1700%' OR trantype.descr LIKE 'Orbis Red Alert' OR trantype.descr LIKE 'Sonim' OR trantype.descr LIKE 'Twig' OR trantype.descr LIKE 'Companion' OR trantype.descr LIKE 'IdentiSafe 8' OR trantype.descr LIKE 'Generic Line Interface') AND systrans.serialno = entityproperties.serialno AND entityproperties.entitytype = 15 AND systrans.commsno = entityproperties.transmitterno";

		$prep   = $this->conexion->prepare($sql);
		$prep->execute();
		$resultTotal = $prep->fetchAll(PDO::FETCH_ASSOC);
		//debug($resultTotal,1);
		$coordinates_array = array();
		$i=0;
		if( !empty($resultTotal) )
		{
			for( $k=0; $k<count($resultTotal); $k++ )
			{
				$coordinates_array[$i]['LATITUDE'] = $resultTotal[$k]['LATITUDE'];

				$coordinates_array[$i]['LONGITUDE'] = $resultTotal[$k]['LONGITUDE'];

				$coordinates_array[$i]['INITIALS'] = $resultTotal[$k]['NAME'][0];

				$coordinates_array[$i]['NAME'] = $resultTotal[$k]['NAME'];
				$coordinates_array[$i]['SERIALNO'] = $resultTotal[$k]['SERIALNO'];

				if( !empty($resultTotal[$k]['LASTSIGNAL']) )
				{
					$resultTotal[$k]['LASTSIGNAL'] = date('d M y H:i:s', strtotime($resultTotal[$k]['LASTSIGNAL']));
					$coordinates_array[$i]['LASTSIGNAL'] = $resultTotal[$k]['LASTSIGNAL'];
				}
				else
				{
					$resultTotal[$k]['LASTSIGNAL'] = '-';
					$coordinates_array[$i]['LASTSIGNAL'] = '-';
				}

				if( !empty($resultTotal[$k]['DESCR']) )
				{
					$resultTotal[$k]['DESCR'] = $resultTotal[$k]['DESCR'];
					$coordinates_array[$i]['DESCR'] = $resultTotal[$k]['DESCR'];
				}
				else
				{
					$resultTotal[$k]['DESCR'] = '-';
					$coordinates_array[$i]['DESCR'] = '-';
				}

				$i++;
			}
		}

		$this->session->set_userdata('deviceListCoordinates',$coordinates_array);
		$data['total'] = count($resultTotal);
		$data['lenght_lone_worker'] = $resultTotal;
		$this->load->view('system/device_list', $data);

	}

	function deleteDirectory($dir) {
	    if (!file_exists($dir)) {
	        return true;
	    }

	    if (!is_dir($dir)) {
	        return unlink($dir);
	    }

	    foreach (scandir($dir) as $item) {
	        if ($item == '.' || $item == '..') {
	            continue;
	        }

	        if (!$this->deleteDirectory($dir . DIRECTORY_SEPARATOR . $item)) {
	            return false;
	        }

	    }

		return rmdir($dir);
	}

	function device_data($serialNumber = null)
	{
		$this->load->model('users');

		$checkLoggedInToken = $this->users->checkLoggedInToken( $this->session->userdata('user_id'), $this->session->userdata('loginToken') );
		if( !$checkLoggedInToken ){
			$redirect = base_url().'/user/logout/?session=1';
			redirect($redirect);
		}



		if( $this->session->userdata("lone_read") != "1" ){

				$blocked = '1';
				$this->session->unset_userdata('login_id');
				$this->session->unset_userdata('office_id');
				$this->session->unset_userdata('contractarea_id');
				$this->session->unset_userdata('type');
				session_destroy();
				$this->load->library('logger');
				$actual_link = "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
				$this->users->blockUser($blocked,$this->session->userdata('user_id'));
				$this->logger->trigger_log($this->session->userdata('username'),'tried to access restricted page '.$actual_link.'. User account suspeneded ');
				$this->deleteDirectory($this->session->userdata('audioPath'));
				echo '<!DOCTYPE html><html><head><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"><link href="https://fonts.googleapis.com/css?family=Montserrat:400,600" rel="stylesheet"></head><body style="margin:0; padding:0; font-family: Montserrat, sans-serif;"><div style="width:700px; margin:90px auto;"> <div style=" width:680px; border: 10px solid #000; background:#0d1f4f; color:#fff; padding:80px 20px; float:left;"> <span style="font-size:45px; font-weight: 600; float:left; width:100%;"><i class="fa fa-exclamation-triangle" aria-hidden="true"></i> Your account has been temporarily suspended.</span> <span style="font-size: 16px; line-height:26px; float:left; width:100%; padding:30px 0px;">For security reasons, your account has been temporarily suspended. You can contact the Administrator at </span> <span><i class="fa fa-envelope-o" aria-hidden="true"></i>&nbsp;administrator@orbisprotect.com</span> </div></div></body></html>';
				exit;
		}
		$this->load->view('system/members', $data);
	}

	function getDevices($id)
	{
		//session_write_close();
		$user_id 	=  $this->session->userdata('user_id') ;
		$conexion = new PDO("informix:host=".$this->config->item('pdo_connect')['host'].";service=".$this->config->item('pdo_connect')['service'].";database=".$this->config->item('pdo_connect')['database'].";server=".$this->config->item('pdo_connect')['server'].";protocol=".$this->config->item('pdo_connect')['protocol'].";EnableScrollableCursors=".$this->config->item('pdo_connect')['EnableScrollableCursors'].";client_locale=".$this->config->item('pdo_connect')['client_locale'].";db_locale=".$this->config->item('pdo_connect')['db_locale'] ,$this->config->item('pdo_connect')['db_user'],$this->config->item('pdo_connect')['db_pass']);

		//$sql = "SELECT customer.name,customer.contno,customer.serialno,contsite.phone,systrans.latitude, systrans.longitude,case monitoring.commstate when 0 then 'Yet to be commissioned' when 1 then 'Commissioned' when 2 then 'Decommissioned' end case,entityproperties.propertyvalue,trantype.descr FROM customer,monitoring,systrans,trantype,outer contsite,OUTER entityproperties WHERE customer.linkno IN ( SELECT linkno FROM linkacc START WITH linkacc.linkno IN (".$this->session->userdata('linkAccountFirstGroupID').") CONNECT BY PRIOR linkacc.linkno = linkacc.parent) AND customer.serialno = monitoring.serialno AND customer.serialno = contsite.serialno AND contsite.contid = 1 AND customer.serialno = systrans.serialno AND systrans.transtype = trantype.trantype AND (trantype.descr LIKE '%1000%' OR trantype.descr LIKE '%1100%' OR trantype.descr like '%1700%' OR trantype.descr LIKE 'Orbis Red Alert' OR trantype.descr LIKE 'Sonim' OR trantype.descr LIKE 'Twig' OR trantype.descr LIKE 'Companion' OR trantype.descr LIKE 'IdentiSafe 8' OR trantype.descr LIKE 'Generic Line Interface') AND systrans.serialno = entityproperties.serialno AND entityproperties.entitytype = 15 AND systrans.commsno = entityproperties.transmitterno";

		if ($id == "sortFilterData") {
			$this->load->model('users');
			$searchLastSignal = $this->input->post('searchLastSignal') ;
			$searchtypeSignal = $this->input->post('searchtypeSignal') ;
			$searchSortBy 	  = $this->input->post('searchSortBy') ;
			$searchSortBy	  = explode("_",$searchSortBy) ;
			if (!$searchLastSignal) {
				$searchLastSignal = [] ;
			}
			if (!$searchtypeSignal) {
				$searchtypeSignal = [] ;
			}

			$resultTotal = $this->users->getLiveLoneUserData($user_id, $searchLastSignal, $searchtypeSignal, $searchSortBy);
		} else {

			$sql = "SELECT customer.name,customer.contno,customer.serialno,contsite.phone,systrans.latitude, systrans.longitude, case monitoring.commstate when 0 then 'Yet to be commissioned' when 1 then 'Commissioned' when 2 then 'Decommissioned' end case, entityproperties.propertyvalue,trantype.descr  as type, systrans.lastsignal, eventdef.descr FROM customer,monitoring,systrans,trantype,outer contsite, OUTER entityproperties , outer eventdef WHERE customer.linkno IN ( SELECT linkno FROM linkacc START WITH linkacc.linkno IN ($id) CONNECT BY PRIOR linkacc.linkno = linkacc.parent) AND customer.serialno = monitoring.serialno AND customer.serialno = contsite.serialno AND contsite.contid = 1 AND customer.serialno = systrans.serialno AND systrans.transtype = trantype.trantype AND (trantype.descr LIKE '%1000%' OR trantype.descr LIKE '%1100%' OR trantype.descr like '%1700%' OR trantype.descr LIKE 'Orbis Red Alert' OR trantype.descr LIKE 'Sonim' OR trantype.descr LIKE 'Twig' OR trantype.descr LIKE 'Companion' OR trantype.descr LIKE 'IdentiSafe 8' OR trantype.descr LIKE 'Generic Line Interface' OR trantype.descr LIKE 'Red Alert Welfare') AND systrans.serialno = entityproperties.serialno AND entityproperties.entitytype = 15 AND systrans.commsno = entityproperties.transmitterno AND systrans.lasteventstcode = eventdef.stcode ORDER BY systrans.lastsignal DESC";

				$prep   = $conexion->prepare($sql);
				$prep->execute();
				$resultTotal = $prep->fetchAll(PDO::FETCH_ASSOC);
		}
		$dataToInsert = $resultTotal ; // variable added to insert the original data for sort/filter options
		//=debug($resultTotal,1);
		$coordinates_array = array();
		$i=0;
		$type 		= [] ;
		$lastSignal = [] ;

		if( !empty($resultTotal) )
		{	
			$previousDate = date( 'd-m-Y' , strtotime('-1 day')) ;
			for( $k=0; $k<count($resultTotal); $k++ )
			{
				/*new code added to get type and last signal dynamically*/

				$dataToInsert[$k]['user_id'] = $user_id;
				if ( isset($resultTotal[$k]['TYPE']) && $resultTotal[$k]['TYPE'] ) {
					if ( !in_array( $resultTotal[$k]['TYPE'], $type ) ) {
						$type[] = $resultTotal[$k]['TYPE'] ;
					}
				}

				if ( isset($resultTotal[$k]['DESCR']) && $resultTotal[$k]['DESCR'] ) {
					if ( !in_array($resultTotal[$k]['DESCR'], $lastSignal ) ) {
						$lastSignal[] = $resultTotal[$k]['DESCR'] ;
					}
				}

				if( !empty($resultTotal[$k]['LASTSIGNAL'] && $resultTotal[$k]['LASTSIGNAL'] != "0000-00-00 00:00:00")  )
				{
					$currentDate = date('d-m-Y');
					$toConvert = date('d-m-Y',strtotime($resultTotal[$k]['LASTSIGNAL'])) ;
					if ( $currentDate == $toConvert) {
						$resultTotal[$k]['startEndDateAnchor'] = "/" . $previousDate . "/" . $currentDate;
					} else {
						$resultTotal[$k]['startEndDateAnchor']  = "/" . $toConvert . "/" . $currentDate;
					}
				} else {
					$resultTotal[$k]['startEndDateAnchor'] = "/" . $previousDate . "/" . $currentDate;
				}

				/*new code added to get type and last signal dynamically*/
				if( empty($resultTotal[$k]['LATITUDE']) )
				{
					$resultTotal[$k]['LATITUDE'] = "-";
					$coordinates_array[$i]['LATITUDE'] = "";
				}
				else{
					$coordinates_array[$i]['LATITUDE'] = $resultTotal[$k]['LATITUDE'];
				}

				if( empty($resultTotal[$k]['LONGITUDE']) )
				{
					$resultTotal[$k]['LONGITUDE'] = "-";
					$coordinates_array[$i]['LONGITUDE'] = "";
				}
				else
				{
					$coordinates_array[$i]['LONGITUDE'] = $resultTotal[$k]['LONGITUDE'];
				}

				if( empty($resultTotal[$k]['PROPERTYVALUE']) )
				{
					$resultTotal[$k]['PROPERTYVALUE'] = "-";
				}

				if( empty($resultTotal[$k]['NAME']) )
				{
					$resultTotal[$k]['NAME'] = "-";
				}
				if( empty($resultTotal[$k]['CONTNO']) )
				{
					$resultTotal[$k]['CONTNO'] = "-";
				}
				if( empty($resultTotal[$k]['SERIALNO']) )
				{
					$resultTotal[$k]['SERIALNO'] = "-";
				}
				if( empty($resultTotal[$k]['PHONE']) || $resultTotal[$k]['PHONE'] == '<companion_number>' )
				{
					$resultTotal[$k]['PHONE'] = "-";
				}

				if( empty($resultTotal[$k]['CASE']) )
				{
					$resultTotal[$k]['CASE'] = "-";
				}
				if( empty($resultTotal[$k]['DESCR']) )
				{
					$resultTotal[$k]['DESCR'] = "-";
				}
				/*
				if( empty($resultTotal[$k]['LASTSIGNAL']) )
				{
					$resultTotal[$k]['LASTSIGNAL'] = "-";
				}*/
				if( empty($resultTotal[$k]['TYPE']) )
				{
					$resultTotal[$k]['TYPE'] = "-";
				}


				$coordinates_array[$i]['INITIALS'] = $resultTotal[$k]['NAME'][0];

				$coordinates_array[$i]['NAME'] = $resultTotal[$k]['NAME'];
				$coordinates_array[$i]['SERIALNO'] = $resultTotal[$k]['SERIALNO'];

				if( !empty($resultTotal[$k]['LASTSIGNAL'] && $resultTotal[$k]['LASTSIGNAL'] != "0000-00-00 00:00:00")  )
				{
					$resultTotal[$k]['LASTSIGNAL'] = date('d M y H:i:s', strtotime($resultTotal[$k]['LASTSIGNAL']));
					$coordinates_array[$i]['LASTSIGNAL'] = $resultTotal[$k]['LASTSIGNAL'];
				}
				else
				{
					$resultTotal[$k]['LASTSIGNAL'] = '-';
					$coordinates_array[$i]['LASTSIGNAL'] = '-';
				}

				if( !empty($resultTotal[$k]['DESCR']) )
				{
					$resultTotal[$k]['DESCR'] = $resultTotal[$k]['DESCR'];
					$coordinates_array[$i]['DESCR'] = $resultTotal[$k]['DESCR'];
				}
				else
				{
					$resultTotal[$k]['DESCR'] = '-';
					$coordinates_array[$i]['DESCR'] = '-';
				}

				if( !empty($resultTotal[$k]['TYPE']) )
				{
					$resultTotal[$k]['TYPE'] = $resultTotal[$k]['TYPE'];
					$coordinates_array[$i]['TYPE'] = $resultTotal[$k]['TYPE'];
				}
				else
				{
					$resultTotal[$k]['TYPE'] = '-';
					$coordinates_array[$i]['TYPE'] = '-';
				}

				if( !empty($resultTotal[$k]['PHONE']) )
				{
					$coordinates_array[$i]['PHONE'] = $resultTotal[$k]['PHONE'];
				}
				else
				{
					$coordinates_array[$i]['PHONE'] = '-';
				}

				$i++;
			}
		}

		$this->session->set_userdata('deviceListCoordinates',$coordinates_array);
		//debug($coordinates_array,1);
		$data['total'] = count($resultTotal);
		if (count($resultTotal) > 0 && $id != "sortFilterData") {
			$this->liveLoneWorker($dataToInsert) ;
		}
		echo json_encode([ 'error' => 0, 'total_count' => $data, 'data' => $resultTotal, 'type' => $type, 'lastSignal' =>  $lastSignal, 'dataToInsert' => $dataToInsert]);
	}
	/*ravi code added to add/delete the data in live_lone_worker_table*/
	public function liveLoneWorker($dataToInsert)
	{
		$this->load->model('users');
		$user_id 	  =  $this->session->userdata('user_id') ;
		$userData 	  =  $this->users->getLiveLoneUserDataCount($user_id);
		//$dataToInsert =  $this->input->post('data');

		if( $userData ) {
			$deleteUserOldData = $this->users->deleteLiveLoneUserData($user_id);
			if ( $dataToInsert && $deleteUserOldData ) {
				$insertData = $this->users->insertLiveLoneUserData($dataToInsert);
			}
		} else {
			if ( $dataToInsert ) {
				$insertData = $this->users->insertLiveLoneUserData($dataToInsert);
			}
		}
	}
	/*ravi code added to add/delete the data in live_lone_worker_table*/
function map_ajax_load(){


		$coordinates = $this->session->userdata('deviceListCoordinates');
		//debug($coordinates,1);
		 	$start = $this->input->post('start_page');

		 	if( $this->input->post('page_no') != '1' )
		 	{
		 		//echo 'aj in';
		 		$value_new =  $this->input->post('page_no') - "1";
		 		$start = $value_new * 100;
		 	}
		 	else{
		 		$start = 0;
		 	}
		 	//echo $start; exit;

			$end_page = ($this->input->post('page_no') * 100) - 1;

			//$start = $start + 1;
			$total_count = count($coordinates) / 100;

			for( $var = $start; $var<=$end_page; $var ++)
			{
				if( $var < count($coordinates) ){
					if( !empty($coordinates[$var]['LATITUDE']) ){

						$description = '<table role=presentation><tr role=row><th colspan=2>'.$coordinates[$var]['NAME'].'</th></tr><tr role=row><td role=gridcell>Event Time:</td><td role=gridcell>'.$coordinates[$var]['LASTSIGNAL'].'</td></tr><tr role=row><td role=gridcell>Last Signal:</td><td role=gridcell>'.$coordinates[$var]['DESCR'].'</td></tr> <tr role=row><td role=gridcell>Type:</td><td role=gridcell>'.$coordinates[$var]['TYPE'].'</td></tr> <tr role=row><td role=gridcell>Telephone:</td><td role=gridcell>'.$coordinates[$var]['PHONE'].'</td></tr> </table>';

						$data['point'][] = '{ lat:'.$coordinates[$var]['LATITUDE'].','.'long:'.$coordinates[$var]['LONGITUDE'].','.'initials:"'.$coordinates[$var]['NAME'][0].'", name: "'.$coordinates[$var]['NAME'].'", id: '.$coordinates[$var]['SERIALNO'].', description: "'.$description.'" }';
					}
				}
			}

			$data['point'] = implode(',', $data['point']);

			$data['center_point'] = $this->input->post('center_point');
			$data['username'] = $this->input->post('username');
			$data['event_type'] = $this->input->post('event_type');
			$data['data_time'] = $this->input->post('data_time');
			$view = $this->load->view('geo/map_point',$data, true);

			echo json_encode([ 'error' => 0, 'start' => $start, 'end' => $end_page, 'value_new' => $value_new, 'html' => $view, 'map_point' => $data['point'], 'complete' => $coordinates, 'postform' => $this->input->post()   ]);



}

function listlogheader()
{
	libxml_use_internal_errors(true);
	$url_alarm = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/ListLogHeaders";
	$xml_post_string_alarm = '<?xml version="1.0" encoding="UTF-8" standalone="no" ?>
<SOAP-ENV:Envelope
SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/"
xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
xmlns:SOAP-ENC="http://schemas.xmlsoap.org/soap/encoding/"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
xmlns:xsd="http://www.w3.org/2001/XMLSchema">
<SOAP-ENV:Body>
				 <ListLogHeaders xmlns="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
			 <listLogHeadersRequestKey>
				<UserName>'.encrypt_string($this->session->userdata('sentinel_username'),'d').'</UserName>
				<Password>'.encrypt_string($this->session->userdata('sentinel_password'),'d').'</Password>
				<ServiceVersion>Version_1_104_1</ServiceVersion>
					<LogHeaderFilter>
						<FilterList>
							<LogHeaderFilterListItem>
								<FilterAttribute xsi:type="SerialNumberLogHeaderFilterAttribute">
									<Value>1575</Value>
								</FilterAttribute>
								<FilterOperator xsi:type="EqualityLogHeaderFilterOperator"/>
								<FilterValue xsi:type="LogHeaderFilterComparisonInteger"/>
							</LogHeaderFilterListItem>

							<LogHeaderFilterListItem>
								<FilterAttribute xsi:type="DateRangeLogHeaderFilterAttribute">
									<FromValue>2017-01-01 09:00:00</FromValue>
										<ToValue>2018-01-30 09:00:00</ToValue>
								</FilterAttribute>
								<FilterOperator xsi:type="EqualityLogHeaderFilterOperator"/>
								<FilterValue xsi:type="LogHeaderFilterComparisonDateRange"/>
							</LogHeaderFilterListItem>
						</FilterList>
					</LogHeaderFilter>
			</listLogHeadersRequestKey>
						 </ListLogHeaders>
</SOAP-ENV:Body>
</SOAP-ENV:Envelope>';
		//header( "Content-type: text/xml");
		 	$curl_send_alarm = $this->curl->curl_send($xml_post_string_alarm, $url_alarm);
			$xmlToArray_alarm = $this->curl->xmlToArray($curl_send_alarm);
			debug($xmlToArray_alarm,1);
}

function test_xml(){
	$url_alarm = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/ListLogHeaders";
	$xml_post_string_alarm = '<?xml version="1.0" encoding="UTF-8" standalone="no" ?>
<SOAP-ENV:Envelope
SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/"
xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
xmlns:SOAP-ENC="http://schemas.xmlsoap.org/soap/encoding/"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
xmlns:xsd="http://www.w3.org/2001/XMLSchema">
<SOAP-ENV:Body>
				 <ListLogHeaders xmlns="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
			 <listLogHeadersRequestKey>
				<UserName>'.encrypt_string($this->session->userdata('sentinel_username'),'d').'</UserName>
				<Password>'.encrypt_string($this->session->userdata('sentinel_password'),'d').'</Password>
				<ServiceVersion>Version_1_104_1</ServiceVersion>
					<LogHeaderFilter>
						<FilterList>
							<LogHeaderFilterListItem>
								<FilterAttribute xsi:type="SerialNumberLogHeaderFilterAttribute">
									<Value>1575</Value>
								</FilterAttribute>
								<FilterOperator xsi:type="EqualityLogHeaderFilterOperator"/>
								<FilterValue xsi:type="LogHeaderFilterComparisonInteger"/>
							</LogHeaderFilterListItem>

							<LogHeaderFilterListItem>
								<FilterAttribute xsi:type="DateRangeLogHeaderFilterAttribute">
									<FromValue>2017-01-01 09:00:00</FromValue>
										<ToValue>2018-01-30 09:00:00</ToValue>
								</FilterAttribute>
								<FilterOperator xsi:type="EqualityLogHeaderFilterOperator"/>
								<FilterValue xsi:type="LogHeaderFilterComparisonDateRange"/>
							</LogHeaderFilterListItem>
						</FilterList>
					</LogHeaderFilter>
			</listLogHeadersRequestKey>
						 </ListLogHeaders>
</SOAP-ENV:Body>
</SOAP-ENV:Envelope>';
		 $curl_send_alarm = $this->curl->curl_send($xml_post_string_alarm, $url_alarm);
}

function list_log_detail($serialnumber)
{
	//log detail item
	$url_alarm_detail = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/ListLogDetailItems";
	$xml_post_string_alarm = '<?xml version="1.0" encoding="UTF-8" standalone="no" ?>
	<SOAP-ENV:Envelope
	SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/"
	xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
	xmlns:SOAP-ENC="http://schemas.xmlsoap.org/soap/encoding/"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:xsd="http://www.w3.org/2001/XMLSchema">
	<SOAP-ENV:Body>
				 <ListLogDetailItems xmlns="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
			 <listLogDetailItemsRequestKey>
			 <UserName>'.encrypt_string($this->session->userdata('sentinel_username'),'d').'</UserName>
			 <Password>'.encrypt_string($this->session->userdata('sentinel_password'),'d').'</Password>
				<ServiceVersion>Version_1_104_1</ServiceVersion>
					<LogDetailFilter>
						<FilterList>
						<LogDetailFilterListItem>
						<FilterAttribute xsi:type="SerialNumberLogDetailFilterAttribute"/>
						<FilterOperator xsi:type="EqualityLogDetailFilterOperator"/>
						<FilterValue xsi:type="LogDetailFilterComparisonInteger">
						<Value>'.$serialnumber.'</Value>
						</FilterValue>
								</LogDetailFilterListItem>
						</FilterList>
					</LogDetailFilter>
			</listLogDetailItemsRequestKey>
						 </ListLogDetailItems>
	</SOAP-ENV:Body>
	</SOAP-ENV:Envelope>';

		$curl_send_alarm = $this->curl->curl_send($xml_post_string_alarm, $url_alarm);

		$xmlToArray_alarm = $this->curl->xmlToArray($curl_send_alarm);
		$data['lenght_lone_worker_last_event'] = end($xmlToArray_alarm['ListLogDetailItemsResponse']['ListLogDetailItemsResult']['ListOfLogDetailItems']['LogDetailListItem']);
}
	function members()
	{
		if(isset($_POST['costcenterlwd']) && !empty($_POST['costcenterlwd']) && isset($_POST['contractarealwd']) && !empty($_POST['contractarealwd']) && isset($_POST['officelwd']) && !empty($_POST['officelwd'])){

		    $this->session->set_userdata('costcenterlwd',$_POST['costcenterlwd']);
			$this->session->set_userdata('contractarealwd',$_POST['contractarealwd']);
			$this->session->set_userdata('officelwd',$_POST['officelwd']);
			$data['costcenter'] = $this->cost_center->cc_list();
			$data['contract_areas'] = $this->contractareas->get_all();

			$data['contract_costcenter'] = $this->offices->contract_costcenter();
			$data['office_list'] = $this->offices->get_all_offices();
			$office_list = $this->offices->office_list();

			$contractarea_detail = [];

			if( $this->input->post('select_limit') !="" )
			{
				$data['current_limit'] = $this->input->post('select_limit');
			}
			else
			{
				$data['current_limit'] = 25;
			}

			$config = [

				'base_url' 			=> site_url("lwd/index"),
				'total_rows'		=> $this->lwds->get_count_lwd(),
				'per_page'			=> $data['current_limit'],
				'full_tag_open'		=> '<ul class="pagination pull-right">',
				'full_tag_close'	=> '</ul>',
				'first_tag_open'	=> '<li>',
				'first_tag_close'	=> '</li>',
				'last_tag_open'		=> '<li>',
				'last_tag_close'	=> '</li>',
				'cur_tag_open'		=> '<li class="active"><a>',
				'cur_tag_close'		=> '</a></li>',
				'num_tag_open'		=> '<li>',
				'num_tag_close'		=> '</li>',
				'next_tag_open'		=> '<li>',
				'next_tag_close'	=> '</li>',
				'prev_tag_open'		=> '<li>',
				'prev_tag_close'	=> '</li>'
			];

			if($this->session->userdata('type')=="office") {

				if( $this->input->get('searchbar') )
				{
					$data['detail'] = $this->lwds->office_list_search_lwd($this->session->userdata('office_id'),$this->input->get('searchbar'));
				}
				else
				{
					$data['detail'] = $this->lwds->get_lwd_office_list($this->session->userdata('office_id'),$config['per_page'], $this->uri->segment(3));
				}


				$contractareaname         = $this->lwds->getcontractareaname($this->session->userdata('contractarea_id'));
				$costcentername           = $this->lwds->getcostcentername($contractareaname[0]->costcenter_id);
				$data['contractareaname'] = $contractareaname[0]->contractarea_name;
				$data['costcentername']   = $costcentername[0]->costcenter_name;


			}else{

				if( $this->input->get('searchbar') )
				{
					$this->lwds->search_term = $this->input->get('searchbar');
					$data['detail'] = $this->lwds->office_list_search();
				}
				else
				{
					$data['detail'] = $this->lwds->get_lwd_list_filter($_POST['officelwd'], $config['per_page'], $this->uri->segment(3));
				}


			}
			$this->pagination->initialize($config);

			$this->load->view('system/members', $data);

	   }else{
		    $this->session->set_userdata('costcenterlwd',"");
			$this->session->set_userdata('contractarealwd',"");
			$this->session->set_userdata('officelwd',"");
			$data['costcenter'] = $this->cost_center->cc_list();
			$data['contract_areas'] = $this->contractareas->get_all();
			$data['contract_costcenter'] = $this->offices->contract_costcenter();
			$data['office_list'] = $this->lwds->get_office_lwd_sys();
			$office_list = $this->lwds->get_office_lwd_sys();

			$contractarea_detail = [];

			if( $this->input->post('select_limit') !="" )
			{
				$data['current_limit'] = $this->input->post('select_limit');
			}
			else
			{
				$data['current_limit'] = 25;
			}

			$config = [

				'base_url' 			=> site_url("systems/members"),
				'total_rows'		=> $this->lwds->get_office_lwd_sys(),
				'per_page'			=> $data['current_limit'],
				'full_tag_open'		=> '<ul class="pagination pull-right">',
				'full_tag_close'	=> '</ul>',
				'first_tag_open'	=> '<li>',
				'first_tag_close'	=> '</li>',
				'last_tag_open'		=> '<li>',
				'last_tag_close'	=> '</li>',
				'cur_tag_open'		=> '<li class="active"><a>',
				'cur_tag_close'		=> '</a></li>',
				'num_tag_open'		=> '<li>',
				'num_tag_close'		=> '</li>',
				'next_tag_open'		=> '<li>',
				'next_tag_close'	=> '</li>',
				'prev_tag_open'		=> '<li>',
				'prev_tag_close'	=> '</li>'
			];

			if($this->session->userdata('type')=="office") {
				//echo '2';
				if( $this->input->get('searchbar') )
				{
					$data['detail'] = $this->lwds->office_list_search_lwd($this->session->userdata('office_id'),$this->input->get('searchbar'));
				}
				else
				{
					$data['detail'] = $this->lwds->get_lwd_office_list($this->session->userdata('office_id'),$config['per_page'], $this->uri->segment(3));
				}


				$contractareaname         = $this->lwds->getcontractareaname($this->session->userdata('contractarea_id'));
				$costcentername           = $this->lwds->getcostcentername($contractareaname[0]->costcenter_id);
				$data['contractareaname'] = $contractareaname[0]->contractarea_name;
				$data['costcentername']   = $costcentername[0]->costcenter_name;


			}else{
				if( $this->input->get('searchbar') )
				{
					$this->lwds->search_term = $this->input->get('searchbar');
					$data['detail'] = $this->lwds->office_list_search_sys();
				}
				else
				{
					$data['detail'] = $this->lwds->get_lwd_list_sys($config['per_page'], $this->uri->segment(3));
				}


			}
			$data["links_up"] = $this->pagination->initialize($config);
			$data["links_footer"] = $this->pagination->initialize($config);
			$this->load->view('system/members', $data);

	   }
	}

	function notification()
	{
		$this->load->view('system/notification');
	}

	function viewevent($serialnumber,$start=null, $end=null,$signalType=null)
	{
		$this->load->model('users');

		$checkLoggedInToken = $this->users->checkLoggedInToken( $this->session->userdata('user_id'), $this->session->userdata('loginToken') );
		if( !$checkLoggedInToken ){
			$redirect = base_url().'/user/logout/?session=1';
			redirect($redirect);
		}


		if( $this->session->userdata("lone_read") != "1" ){

				$blocked = '1';
				$this->session->unset_userdata('login_id');
				$this->session->unset_userdata('office_id');
				$this->session->unset_userdata('contractarea_id');
				$this->session->unset_userdata('type');
				session_destroy();
				$this->load->library('logger');
				$actual_link = "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
				$this->users->blockUser($blocked,$this->session->userdata('user_id'));
				$this->logger->trigger_log($this->session->userdata('username'),'tried to access restricted page '.$actual_link.'. User account suspeneded ');
				$this->deleteDirectory($this->session->userdata('audioPath'));
				echo '<!DOCTYPE html><html><head><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"><link href="https://fonts.googleapis.com/css?family=Montserrat:400,600" rel="stylesheet"></head><body style="margin:0; padding:0; font-family: Montserrat, sans-serif;"><div style="width:700px; margin:90px auto;"> <div style=" width:680px; border: 10px solid #000; background:#0d1f4f; color:#fff; padding:80px 20px; float:left;"> <span style="font-size:45px; font-weight: 600; float:left; width:100%;"><i class="fa fa-exclamation-triangle" aria-hidden="true"></i> Your account has been temporarily suspended.</span> <span style="font-size: 16px; line-height:26px; float:left; width:100%; padding:30px 0px;">For security reasons, your account has been temporarily suspended. You can contact the Administrator at </span> <span><i class="fa fa-envelope-o" aria-hidden="true"></i>&nbsp; administrator@orbisprotect.com</span> </div></div></body></html>';
				exit;
		}

		$current_time = date('H:i:s',strtotime('+1hours'));
		if( $start == null && $end == null )
		{
			$start = date('Y-m-d',strtotime('-1days'));
			$end = date('Y-m-d');
		}
		/*elseif ($start != null && $end == null) {
			$currentDate = date('d-m-Y');
			if ( $currentDate == $start) {
				$start = date('Y-m-d',strtotime('-1days'));
			} else {
				$start = date('Y-m-d',strtotime($start));
			}
			$end = date('Y-m-d');
		}*/
		else{
			$start = date('Y-m-d',strtotime($start));
			$end = date('Y-m-d',strtotime($end));
			$this->load->library('logger');
			$this->logger->trigger_log($this->session->userdata('username'),'Events filter applied - date range');
		}
		//exit;

		$url_alarm = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/ListLogDetailItems";
		$xml_post_string_alarm = '<?xml version="1.0" encoding="UTF-8" standalone="no" ?>
							<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:cls="http://www.monitorsoft.com/SentinelXS/clsSentinelXS" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
   <soap:Header/>
   <soap:Body>
      <cls:ListLogDetailItems>
         <!--Optional:-->
         <cls:listLogDetailItemsRequestKey>
            <cls:ServiceVersion>Version_1_110_4</cls:ServiceVersion>
            <!--Optional:-->
            <cls:UserName>'.encrypt_string($this->session->userdata('sentinel_username'),'d').'</cls:UserName>
            <!--Optional:-->
            <cls:Password>'.encrypt_string($this->session->userdata('sentinel_password'),'d').'</cls:Password>
            <!--Optional:-->
            <cls:LogDetailFilter>
               <!--Optional:-->

               <cls:FilterList>
                  <cls:LogDetailFilterListItem>
                     <cls:FilterAttribute  xsi:type="cls:SerialNumberLogDetailFilterAttribute"/>
                     <cls:FilterOperator  xsi:type="cls:EqualityLogDetailFilterOperator"/>
                     <cls:FilterValue  xsi:type="cls:LogDetailFilterComparisonInteger">
                     <cls:Value>'.$serialnumber.'</cls:Value>
                     </cls:FilterValue>
                  </cls:LogDetailFilterListItem>


                   <cls:LogDetailFilterListItem>

                                    <cls:FilterAttribute xsi:type="cls:DateRangeLogDetailFilterAttribute" />

                         <cls:FilterOperator xsi:type="cls:EqualityLogDetailFilterOperator" />

                         <cls:FilterValue xsi:type="cls:LogDetailFilterComparisonDateRange">

                              <cls:FromValue>'.$start.'T00:00:00</cls:FromValue>

                              <cls:ToValue>'.$end.'T'.$current_time.'</cls:ToValue>

                         </cls:FilterValue>

                   </cls:LogDetailFilterListItem>
									 <cls:LogDetailFilterListItem>
								<cls:FilterAttribute xsi:type="cls:LogCategoryLogDetailFilterAttribute" />
								<cls:FilterOperator xsi:type="cls:InLogDetailFilterOperator" />
								<cls:FilterValue xsi:type="cls:LogDetailFilterComparisonLogCategoryList">
											<cls:Value>
												<cls:BaseLogCategoryListItem xsi:type="cls:SignalLogCategoryListItem" />

												<cls:BaseLogCategoryListItem xsi:type="cls:AlarmLogCategoryListItem" />

												<cls:BaseLogCategoryListItem xsi:type="cls:TrackingLogCategoryListItem" />

												<cls:BaseLogCategoryListItem xsi:type="cls:AudioLogCategoryListItem" />


										 </cls:Value>
								</cls:FilterValue>
</cls:LogDetailFilterListItem>
               </cls:FilterList>
            </cls:LogDetailFilter>
         </cls:listLogDetailItemsRequestKey>
      </cls:ListLogDetailItems>
   </soap:Body>
</soap:Envelope>';

			//header('Content-type: application/xml');
			$curl_send_alarm = $this->curl->curl_send($xml_post_string_alarm, $url_alarm);
			$data = array();
			$xmlToArray_alarm = $this->curl->xmlParse($curl_send_alarm);

			$list_log_header_xml = $xmlToArray_alarm['soap:Body']['ListLogDetailItemsResponse']['ListLogDetailItemsResult']['ListOfLogDetailItems']['LogDetailListItem'];

			//$list_log_header_xml = array_reverse($array_reverse);
			//debug($list_log_header_xml, 1) ;

			if( !empty($list_log_header_xml) ) {
				$battery = '';

				if(	!empty($list_log_header_xml['SerialNumber']) ){
					$list_log_header[] = $list_log_header_xml;
				}else{

				for( $M=0; $M<count($list_log_header_xml); $M++ )
					{

						if( $list_log_header_xml[$M]['Identifier'] == '1' )
						{
							//$battery = $list_log_headerss[$M]['Description'];
							$list_log_header_xml[$M-1]['batery'] = $list_log_header_xml[$M]['Description'];
						}
					}

					for( $mm=0; $mm<count($list_log_header_xml); $mm++ )
					{

						if( $list_log_header_xml[$mm]['Identifier'] != '1' )
						{
							//$battery = $list_log_headerss[$M]['Description'];
							$list_log_header[] = $list_log_header_xml[$mm];
						}
						
						if ($signalType != "Orbis%20Red%20Alert") {
							if( $list_log_header_xml[$mm]['Identifier'] == '1'  && $list_log_header_xml[$mm]['LogHeaderIdentifier'] != $list_log_header_xml[$mm-1]['LogHeaderIdentifier'] && $list_log_header_xml[$mm]['EventDescription'] != 'Command Sent')
							{
								//$battery = $list_log_headerss[$M]['Description'];
								$list_log_header[] = $list_log_header_xml[$mm];
							}
						}
						
						if ($signalType == "Orbis%20Red%20Alert") {
							if( $list_log_header_xml[$mm]['Identifier'] == '1'  && $list_log_header_xml[$mm]['LogHeaderIdentifier'] != $list_log_header_xml[$mm-1]['LogHeaderIdentifier'] && ( $list_log_header_xml[$mm]['EventDescription'] == 'Amber Cancel Overdue' || $list_log_header_xml[$mm]['EventDescription'] == "Amber Cancel O'Due") )
							{
								//$battery = $list_log_headerss[$M]['Description'];
								$list_log_header[] = $list_log_header_xml[$mm];
							}
						}
					}

				}
// 				echo '===========<br>';
// debug($list_log_header_xml,1);

					if( !empty($list_log_header) ){
					for( $k=0; $k<count($list_log_header); $k++ )
						{

						//if( $list_log_header[$k]['Identifier'] != '1' ){

							$description = strchr( $list_log_header[$k]['Description'] , "Lat", true );

							if(!empty($list_log_header[$k]['batery'])){
								$list_log_header[$k]['batteryInfo'] = strrchr( $list_log_header[$k]['batery'] , "Bat:" );
								if(!empty( $list_log_header[$k]['batteryInfo'] )){
									$list_log_header[$k]['batteryInfo'] = str_replace('Bat:','', $list_log_header[$k]['batteryInfo']);
									$eventbattery = '<tr role=row><td role=gridcell> Battery :</td><td role=gridcell>'.str_replace('%','', $list_log_header[$k]['batteryInfo']).'%</td></tr>';
								}else{
									$eventbattery = '';
								}

							}
							if( !empty($list_log_header[$k]['LogDateTime']) ) {
							$date = $list_log_header[$k]['LogDateTime'];

							//Convert the date string into a unix timestamp.
							$unixTimestamp = strtotime($date);

							//Get the day of the week using PHP's date function.
							$day = date("l ", $unixTimestamp);
							$date = date("d-M-Y", $unixTimestamp);
							$time = date("H:i A", $unixTimestamp);
							$popupDate = date("d M Y", $unixTimestamp).' '.date("H:i", $unixTimestamp);
							// $list_log_header[$i]['changeDate'] = date("Y-m-d H:i:s", $unixTimestamp);
							// $list_log_header[$i]['changeDateSort'] = date("m/d/Y", $unixTimestamp);
							$LogDateTime =  $day.' '.$date.' '.$time;
							$list_log_header[$k]['logtime'] = $LogDateTime;
							$list_log_header[$k]['popupDate'] = $popupDate;
							//$list_log_header[$k]['LogDateTime'] =
							}

							if(!empty($description))
							{
								$description = '<table role=presentation><tr role=row><th colspan=2>'.str_replace("'","",$description).'</th></tr><tr role=row><td role=gridcell>Event Time:</td><td role=gridcell>'.$LogDateTime.'</td></tr>'.$eventbattery.'</table>';
							}
							else
							{
								//$description = $list_log_header[$k]['Description'].'<br>Event Time: '.$list_log_header[$k]['LogDateTime'].'<br>Event Type: Position Report <br>User';
								$description = '<table role=presentation><tr role=row><th colspan=2>'.str_replace("'","",$list_log_header[$k]['Description']).'</th></tr><tr role=row><td role=gridcell>Event Time:</td><td role=gridcell>'.$LogDateTime.'</td></tr>'.$eventbattery.'</table>';
							}

							// $explode = strchr( $explode , "=" );


							// $explode = str_replace('=(','',$explode);
							// $explode = str_replace(')','',$explode);
							// $explode = explode(',', $explode);
							// //debug($explode,1);
							$long = $list_log_header[$k]['Longitude'];
							$lat = $list_log_header[$k]['Latitude'];
							if( !empty($long) ) {
								$long = (float)$long;
							}

							if( !empty($lat) ) {
								$lat = (float)$lat;
							}

							if( !empty($list_log_header[$k]['Source']) ){

								if( $list_log_header[$k]['Source']['@attributes']['xsi:type'] == 'AudioLogSourceType' )
								{
										$list_log_header[$k]['audio_identifier'] = $list_log_header[$k]['Identifier'];
								}else
								{
									$list_log_header[$k]['audio_identifier'] = 'na';
								}
							}

							// $description = $explode[0].' '.$explode[1].' '.$explode[2];
							// $description = str_replace('Lat','',$description);
							//$description = "'$description'";

							$description = "'$description'";

							if( !empty($long) )
							{
								$data['last_position_report_list'][$k]['position_lat_long']['long'] = $long;

							}else
							{
								$data['last_position_report_list'][$k]['position_lat_long']['long'] = '0';
								//$long='0';
							}
							if( !empty($lat) )
							{
								$data['last_position_report_list'][$k]['position_lat_long']['lat'] = $lat;
							}else
							{
								$data['last_position_report_list'][$k]['position_lat_long']['lat'] = '0';
								//$lat='0';
							}

							// if( !empty($long) && !empty($lat) )
							// {
								//$id = $data['last_position_report_list'][$k]['position_lat_long']['ListLogDetailItemsResponse']['ListLogDetailItemsResult']['ListOfLogDetailItems']['LogDetailListItem'][1]['LogHeaderIdentifier'];
								$id = $list_log_header[$k]['LogHeaderIdentifier'];
								if( !empty($id) )
								{
									if( !empty($lat) && !empty($long) ){
										$map_coordinates[] = '{lat:'."$lat".',long:'."$long".',id:' ."$id".',description:' ."$description".' }';
									}
								}

							// }
						}
					}
					if( !empty($map_coordinates) )
					{
						$this->session->set_userdata('map_coordinates', $map_coordinates);

						for( $var=0; $var<count($map_coordinates); $var++ )
						{
							if( !empty($map_coordinates[$var]) ){
								if( $var <= 0 || $var <= 99 )
								{
									//echo '==='.$var;
									$data['map_coordinates'][] = $map_coordinates[$var];
								}
							}

						}
						//$data['map_coordinates'] = $map_coordinates;
					//debug($data,1);
					$center_point = count($data['map_coordinates'] ) ;
					$center_key = round(($center_point) / 2) ;
						$center_key_point = $data['map_coordinates'][$center_key];
						//debug($center_key_point,1);

						$center_key_point = str_replace('{lat:', '',  $center_key_point);

						$center_key_point = str_replace('long:','',  $center_key_point);

						$data['center_point'] = strchr( str_replace('}','', $center_key_point) ,',id', true );

						$data['map_coordinates'] = implode(',',$map_coordinates);
					}
					else
					{
						$this->session->unset_userdata('map_coordinates');
						$data['map_coordinates'] = '';
					}



			if( !empty($data['last_position_report']) )
			{
					$data['serialnumber'] = $data['last_position_report']['SerialNumber'];
					$data['Identifier'] = $data['last_position_report']['Identifier'];
			}
			else
			{
					$data['serialnumber'] = 0;
					$data['Identifier'] = 0;
			}

			//$eventList = $data['log_header'];
		 	//debug($list_log_header,1);
			// echo '-------------';
			$array_reverse = array_reverse($list_log_header);
			$temp = array();
			$main = array();
			$var = 0;
			for( $e=$var; $e<count($array_reverse);$e++ )
			{
				if( $array_reverse[$e]['EventDescription'] == 'Red Alert' ){
						$array_reverse[$e]['audio'] = '';
						$temp = array();
						$temp[] = $array_reverse[$e];
						//echo 'red alert main';
						//debug($temp);
						//break;
						$new_array = array();
						/*ravi code when "red alert" is at the bottom of the array*/
							if ( ($e+1) >= count($array_reverse) ){
								$temp[count($temp)-1]['audio'] = $new_array;
								$main[] = $temp;
								//$var = $x-1;
								break;
							}
						/*ravi code when "red alert" is at the bottom of the array*/
						for( $x=$e+1; $x<count($array_reverse);$x++ ){
							if( $array_reverse[$x]['EventDescription'] == 'Red Alert Audio' ){
								$new_array[] = $array_reverse[$x];

								//debug($temp);
								//echo 'audio main';
								//debug($temp);
								//break;
							}else{
								$temp[count($temp)-1]['audio'] = $new_array;
								$main[] = $temp;
								$var = $x-1;
								break;
							}
						}

					}elseif($array_reverse[$e]['EventDescription'] != 'Red Alert Audio'){
						$main[][] = $array_reverse[$e];
					}
			}
			//debug($main,1);
			$data['log_header'] = $main;
			$data['last_event'] = end($data['log_header']);
			}else{
				$data['log_header'] = array();
				$data['serialnumber'] = 0;
				$data['Identifier'] = 0;
				$this->session->unset_userdata('map_coordinates');
				$data['map_coordinates'] = '';
			}



			// get site detail from serial number

			$getsitedetail = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/GetSite";
			$xml_getsitedetail = '<?xml version="1.0" encoding="UTF-8" standalone="no" ?>
				<SOAP-ENV:Envelope
				 SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/"
				 xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
				 xmlns:SOAP-ENC="http://schemas.xmlsoap.org/soap/encoding/"
				xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
				xmlns:xsd="http://www.w3.org/2001/XMLSchema">
				<SOAP-ENV:Body>
					<GetSite xmlns="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
						<getSiteRequestKey>
							<UserName>'.encrypt_string($this->session->userdata('sentinel_username'),'d').'</UserName>
							<Password>'.encrypt_string($this->session->userdata('sentinel_password'),'d').'</Password>
							<SerialNumber>'.$serialnumber.'</SerialNumber>
						</getSiteRequestKey>
					</GetSite>
				</SOAP-ENV:Body>
				</SOAP-ENV:Envelope>';

				$curl_getsitedetail = $this->curl->curl_send($xml_getsitedetail, $getsitedetail);
				$xmlToArray_get_sites = $this->curl->xmlParse($curl_getsitedetail);
				$data['get_site_detail'] = $xmlToArray_get_sites['soap:Body']['GetSiteResponse']['GetSiteResult']['SiteInformation'];
				$this->session->set_userdata('device_username',$data['get_site_detail']['Name']);
				// get lat long of position report



		//debug($data['log_header'],1);

		for( $ev=0; $ev<count($data['log_header']); $ev++ ){

			if( $data['log_header'][$ev][0]['EventDescription'] == 'Unknown Event Type+Code' ){
				$data['log_header'][$ev][0]['EventDescription'] = str_replace('+',' ',$data['log_header'][$ev][0]['EventDescription']);
			}

			$data['get_event'][] =  $data['log_header'][$ev][0]['EventDescription'];
		}

		//debug($data['get_event']);

		$unique = array_unique($data['get_event'],SORT_STRING);

		$mo = array();
		$uni_key = 0;

		if ( !empty($unique) ) {
			foreach ($unique as $key =>  $value) {

				if( !empty($value) ){
					$data['unique_event'][] = $value;
				}

			}
		} else {
			$data['unique_event'] = array();
		}

		$this->load->view('system/eventlist',$data);
	}

	function unique_key($array,$keyname){

		 $new_array = array();
		 foreach($array as $key=>$value){

		   if(!isset($new_array[$value[$keyname]])){
		     $new_array[$value[$keyname]] = $value;
		   }

		 }
		 $new_array = array_values($new_array);
		 return $new_array;
		}

	function checkMapPoint()
	{

		if( $this->session->has_userdata('map_coordinates') ){

			$coordinates = $this->session->userdata('map_coordinates');
			$map_id = $this->input->post('id');
			if( !empty($map_id) )
			{
				$data['map_id'] = $map_id;
				$data['event_description'] = $this->input->post('event_description');
				$data['event_logtime'] = $this->input->post('event_logtime');
			}
			else
			{
				$data['map_id'] = 0;
				$data['event_description'] = 0;
				$data['event_logtime'] = 0;
			}
			//$data['center_point'] = $this->input->post('center_point');
			//debug($coordinates,1);
		 	$start = $this->input->post('start_page');

		 	if( $this->input->post('page_no') != '1' )
		 	{
		 		//echo 'aj in';
		 		$value_new =  $this->input->post('page_no') - "1";
		 		$start = $value_new * 100;
		 	}
		 	else{
		 		$start = 0;
		 	}
		 	//echo $start; exit;

			$end_page = ($this->input->post('page_no') * 100) - 1;

			//$start = $start + 1;
			$total_count = count($coordinates) / 100;

			// $cureent_page_1 = $this->input->post('page_no') * 10;

			// $cureent_page = $this->input->post('page_no') * 10;

			// if( $cureent_page > $total_count )
			// {
			// 	$end = ($cureent_page - 1) * 10;
			// }

			// if( $end_page > $total_count )
			// {
			// 	$currentPage = ($this->input->post('page_no') - '1' ) * 10;
			// 	$end_page = $cureent_page - $total_count;
			// }


			//$data['point'] = empty($data['point']);
			//debug($coordinates,1);
			for( $var = $start; $var<=$end_page; $var ++)
			{
				if( $var < count($coordinates) ){
					if( !empty($coordinates[$var]) ){
						$data['point'][] = $coordinates[$var];
					}
				}
			}

			$data['point'] = implode(',', $data['point']);
			//debug($data,1);
	//exit;
			//$start = $end_page + 1;

			//$end_page = $end_page + 10;
			$data['center_point'] = $this->input->post('center_point');
			$view = $this->load->view('geo/dummy',$data, true);

			echo json_encode([ 'error' => 0, 'start' => $start, 'end' => $end_page, 'value_new' => $value_new, 'html' => $view, 'map_point' => $data['point'], 'complete' => $coordinates, 'postform' => $this->input->post()   ]);
		}
		else{

			$data['point'] = '{lat:53.483959,long:-2.244644,id:0,description:"Default location" }';
			$data['center_point'] = '';
			$view = $this->load->view('geo/dummy',$data, true);
			echo json_encode(['error' => 1, 'html' => $view]);
		}

		//debug( $this->session->userdata('map_coordinates') );
	}

	function get_list_log_detail($serialnumber, $start=null, $end=null){

	if( $this->session->userdata('login_id') != 1 )
		{
			echo  json_encode( [ 'error' => '1' ] );
			exit;
		}

		$current_time = date('H:i:s',strtotime('+1hours'));
		if( $start == null && $end == null )
		{
			$start = date('Y-m-d',strtotime('-1days'));
			$end = date('Y-m-d');
		}
		else{
			$start = date('Y-m-d',strtotime($start));
			$end = date('Y-m-d',strtotime($end));
		}

		$url_alarm = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/ListLogDetailItems";
		$xml_post_string_alarm = '<?xml version="1.0" encoding="UTF-8" standalone="no" ?>
							<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:cls="http://www.monitorsoft.com/SentinelXS/clsSentinelXS"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
   <soap:Header/>
   <soap:Body>
      <cls:ListLogDetailItems>
         <!--Optional:-->
         <cls:listLogDetailItemsRequestKey>
            <cls:ServiceVersion>Version_1_110_4</cls:ServiceVersion>
            <!--Optional:-->
            <cls:UserName>'.encrypt_string($this->session->userdata('sentinel_username'),'d').'</cls:UserName>
            <!--Optional:-->
            <cls:Password>'.encrypt_string($this->session->userdata('sentinel_password'),'d').'</cls:Password>
            <!--Optional:-->
            <cls:LogDetailFilter>
               <!--Optional:-->

               <cls:FilterList>
                  <cls:LogDetailFilterListItem>
                     <cls:FilterAttribute  xsi:type="cls:SerialNumberLogDetailFilterAttribute"/>
                     <cls:FilterOperator  xsi:type="cls:EqualityLogDetailFilterOperator"/>
                     <cls:FilterValue  xsi:type="cls:LogDetailFilterComparisonInteger">
                     <cls:Value>'.$serialnumber.'</cls:Value>
                     </cls:FilterValue>
                  </cls:LogDetailFilterListItem>


                   <cls:LogDetailFilterListItem>

                                    <cls:FilterAttribute xsi:type="cls:DateRangeLogDetailFilterAttribute" />

                         <cls:FilterOperator xsi:type="cls:EqualityLogDetailFilterOperator" />

                         <cls:FilterValue xsi:type="cls:LogDetailFilterComparisonDateRange">

                              <cls:FromValue>'.$start.'T00:00:00</cls:FromValue>

                              <cls:ToValue>'.$end.'T'.$current_time.'</cls:ToValue>

                         </cls:FilterValue>

                   </cls:LogDetailFilterListItem>

                    <cls:LogDetailFilterListItem>
                  <cls:FilterAttribute xsi:type="cls:LogCategoryLogDetailFilterAttribute" />
                  <cls:FilterOperator xsi:type="cls:InLogDetailFilterOperator" />
                  <cls:FilterValue xsi:type="cls:LogDetailFilterComparisonLogCategoryList">
                        <cls:Value>
                          <cls:BaseLogCategoryListItem xsi:type="cls:SignalLogCategoryListItem" />

                          <cls:BaseLogCategoryListItem xsi:type="cls:AlarmLogCategoryListItem" />

                          <cls:BaseLogCategoryListItem xsi:type="cls:TrackingLogCategoryListItem" />

                          <cls:BaseLogCategoryListItem xsi:type="cls:AudioLogCategoryListItem" />
                       </cls:Value>
                  </cls:FilterValue>
  </cls:LogDetailFilterListItem>

               </cls:FilterList>
            </cls:LogDetailFilter>
         </cls:listLogDetailItemsRequestKey>
      </cls:ListLogDetailItems>
   </soap:Body>
</soap:Envelope>';


			$curl_send_alarm = $this->curl->curl_send($xml_post_string_alarm, $url_alarm);
			$data = array();
			$xmlToArray_alarm = $this->curl->xmlParse($curl_send_alarm);
			//debug($xmlToArray_alarm,1);
			$list_log_headerss = $xmlToArray_alarm['soap:Body']['ListLogDetailItemsResponse']['ListLogDetailItemsResult']['ListOfLogDetailItems']['LogDetailListItem'];

			if( !empty($list_log_headerss) ) {


				for( $M=0; $M<count($list_log_headerss); $M++ )
					{

						if( $list_log_headerss[$M]['Identifier'] == '1' )
						{
							//$battery = $list_log_headerss[$M]['Description'];
							$list_log_headerss[$M-1]['batery'] = $list_log_headerss[$M]['Description'];
						}
					}

					for( $mm=0; $mm<count($list_log_headerss); $mm++ )
					{

						if( $list_log_headerss[$mm]['Identifier'] != '1' )
						{
							//$battery = $list_log_headerss[$M]['Description'];
							$list_log_header[] = $list_log_headerss[$mm];
						}
					}






					//for( $i=0; $i<count($list_log_header); $i++ )
				for( $i=0; $i<count($list_log_header); $i++ )
					{

						if( !empty($list_log_header[$i]['LogDateTime']) ){
						$date = $list_log_header[$i]['LogDateTime'];

							//Convert the date string into a unix timestamp.
							$unixTimestamp = strtotime($date);
							$day = date("l ", $unixTimestamp);
							$date = date("d-M-Y", $unixTimestamp);
							$time = date("H:i A", $unixTimestamp);

							$list_log_header[$i]['changeDate'] = date("Y-m-d H:i:s", $unixTimestamp);
							$list_log_header[$i]['changeDateSort'] = date("m/d/Y H:i:s", $unixTimestamp);
							$list_log_header[$i]['LogDateTime'] =  $day.'<br>'.$date.'<br>'.$time;
							$list_log_header[$i]['NewLogDateTime'] =  $day.' '.$date.' '.$time;
							$popupDate = date("d M Y", $unixTimestamp).' '.date("H:i", $unixTimestamp);
							$list_log_header[$i]['popupDate'] = $popupDate;
							}

							if( !empty($list_log_header[$i]['batery']) ){
							$list_log_header[$i]['batteryInfo'] = strrchr( $list_log_header[$i]['batery'] , "Bat:" );

							$list_log_header[$i]['batteryInfo'] = str_replace('Bat: ','', $list_log_header[$i]['batteryInfo']);

							$list_log_header[$i]['batteryInfo'] = str_replace('%','', $list_log_header[$i]['batteryInfo']);
							}

							if( !empty($list_log_header[$i]['Description']) ){
								if( empty( strchr($list_log_header[$i]['Description'],'Lat',true) ) )
								{
									$list_log_header[$i]['streetName'] = $list_log_header[$i]['Description'];
								}
								else{
									$list_log_header[$i]['streetName'] = strchr($list_log_header[$i]['Description'],'Lat',true);
								}
							}
							//Get the day of the week using PHP's date function.


							// if( $list_log_header[$i]['Source']['@attributes']['xsi:type'] == 'AudioLogSourceType' )
							// {
							// 		$list_log_header[$i]['audio_identifier'] = $list_log_header[$i]['Identifier'];
							// }else
							// {
							// 	$list_log_header[$i]['audio_identifier'] = 'na';
							// }

							if( $list_log_header[$i]['ContainsMedia'] == 'true' )
							{
									$list_log_header[$i]['audio_identifier'] = $list_log_header[$i]['LogHeaderIdentifier'];
							}
							// else
							// {
							// 	$list_log_header[$i]['audio_identifier'] = '';
							// }


					}
					//debug($list_log_header,1);
						$temp = array();
			$main = array();
			$var = 0;
			for( $e=$var; $e<count($list_log_header);$e++ )
			{
				if( $list_log_header[$e]['EventDescription'] == 'Red Alert' ){
						$list_log_header[$e]['audio'] = '';
						$temp = array();
						$temp[] = $list_log_header[$e];
						//echo 'red alert main';
						//debug($temp);
						//break;
						$new_array = array();
						for( $x=$e+1; $x<count($list_log_header);$x++ ){
							if( $list_log_header[$x]['EventDescription'] == 'Red Alert Audio' ){
								$new_array[] = $list_log_header[$x];

								//debug($temp);
								//echo 'audio main';
								//debug($temp);
								//break;
							}else{
								$temp[count($temp)-1]['audio'] = $new_array;
								$main[] = $temp;
								$var = $x-1;
								break;
							}
						}

					}elseif($list_log_header[$e]['EventDescription'] != 'Red Alert Audio'){
						$main[][] = $list_log_header[$e];
					}
			}


					$data = $main;
					//debug($data,1);
					//$data = $this->unique_key($data,'LogHeaderIdentifier');
			}else{
				$data = array();
			}
			//debug($data,1);

			echo  json_encode( [ 'error' => '0', 'html' => $data ] );

	}

	function edituser()
	{
		$this->load->view('system/edituser');
	}

	function escalation_detail()
	{
		$this->load->view('system/escalation');
	}

	function view_user()
	{
		if( $this->session->userdata('type') != 'superadmin' )
		{
			 redirect('/', 'refresh');
			 die;
		}
		$this->load->model('users');

		if( $this->input->post('select_limit') !="" )
		{
			$data['current_limit'] = $this->input->post('select_limit');
		}
		else
		{
			$data['current_limit'] = 25;
		}

		$config = [
			'base_url' 			=> site_url("systems/view_user"),
			'total_rows'		=> count($this->users->count_lwd()),
			'per_page'			=> $data['current_limit'],
			'full_tag_open'		=> '<ul class="pagination pull-right">',
			'full_tag_close'	=> '</ul>',
			'first_tag_open'	=> '<li>',
			'first_tag_close'	=> '</li>',
			'last_tag_open'		=> '<li>',
			'last_tag_close'	=> '</li>',
			'cur_tag_open'		=> '<li class="active"><a>',
			'cur_tag_close'		=> '</a></li>',
			'num_tag_open'		=> '<li>',
			'num_tag_close'		=> '</li>',
			'next_tag_open'		=> '<li>',
			'next_tag_close'	=> '</li>',
			'prev_tag_open'		=> '<li>',
			'prev_tag_close'	=> '</li>'
		];

		$data['user_list'] = $this->users->get_system_users_list_admin($config['per_page'], $this->uri->segment(3));
		$this->pagination->initialize($config);
		$data['links'] = $this->pagination->create_links();
		$this->load->view('system/user_list',$data);
	}

	function user_add($id = null)
	{
	
	if( $this->session->userdata('type') != 'superadmin' )
	{
		 redirect('/', 'refresh');
		 die;
	}
		// config for PDO
    $conexion = new PDO("informix:host=".$this->config->item('pdo_connect')['host'].";service=".$this->config->item('pdo_connect')['service'].";database=".$this->config->item('pdo_connect')['database'].";server=".$this->config->item('pdo_connect')['server'].";protocol=".$this->config->item('pdo_connect')['protocol'].";EnableScrollableCursors=".$this->config->item('pdo_connect')['EnableScrollableCursors'].";client_locale=".$this->config->item('pdo_connect')['client_locale'].";db_locale=".$this->config->item('pdo_connect')['db_locale'] ,$this->config->item('pdo_connect')['db_user'],$this->config->item('pdo_connect')['db_pass']);

    // get CostCentre

    $CostCentre = "select unique linkacc.linkno , linkacc.name from linkacc, webusers where linkacc.parent = 20 and webusers.agctype = 4 and linkacc.linkno = webusers.agcno";


		$CostCentreQuery   = $conexion->prepare($CostCentre);
		$CostCentreQuery->execute();
		$CostCentreResponse = $CostCentreQuery->fetchAll(PDO::FETCH_ASSOC);
		//debug($CostCentreResponse,1);
    if(!empty($CostCentreResponse)){
      for( $j=0; $j<count($CostCentreResponse); $j++ )
      {
        //$CostCentreResponse[$j]['NAME'] = trim(str_replace('CC', '', $CostCentreResponse[$j]['NAME']));
        $CostCentreResponse[$j]['NAME'] = trim(substr($CostCentreResponse[$j]['NAME'], 3));
      }

      foreach ($CostCentreResponse as $key => $row) {
          // replace 0 with the field's index/key
          $dates[$key]["NAME"]  = $row["NAME"];
          //$dates1[$key]["NAME"]  = $row["NAME"];
      }

       array_multisort($dates, SORT_ASC, $CostCentreResponse);
    }
    else{
      $CostCentreResponse = array();
    }
		$data['CostCentreList'] = $CostCentreResponse;
		$this->load->model('users');
		//debug( $_SESSION,1 );
		if( $id != null )
		{
			$data['user_data'] = $this->users->get_user_data($id);

			//debug($data,1);
			$this->load->view('system/add_user', $data);
		}
		else {
			$this->load->view('system/add_user',$data);
		}
	}

	function add_new()
	{

		if( checkToken( 'portalUserToken', $this->input->post('portalUserToken') ) == false )
		{
			echo 'fail'; exit;
		}

		if( $this->session->userdata('type') != 'superadmin' )
		{

			if( $this->session->userdata('officeID') != 0 )
			{
				if($this->session->userdata('officeID') == $this->input->post('officeID'))
				{
					echo 'fail'; exit;
				}
			}
			if( $this->session->userdata('contractareaID') != 0 )
			{
				if($this->session->userdata('contractareaID') == $this->input->post('contractareaID'))
				{
					echo 'fail'; exit;
				}
			}
			if( $this->session->userdata('costcenterID') != 0 )
			{
				if($this->session->userdata('costcenterID') == $this->input->post('costcenterID'))
				{
					echo 'fail'; exit;
				}
			}
			if( $this->session->userdata('user_write') == 0 )
			{
				echo 'fail'; exit;
			}

		}

		$this->load->model('users');
		$this->load->library('logger');
		if(!empty( $this->input->post('edit_user_id') ))
		{
			$logMessage = 'portal user ['.ucfirst($this->input->post('first_name')).'] account details updated';
			$this->logger->trigger_log($this->session->userdata('username'),$logMessage);
			$add_system_user = $this->users->edit_system_user($this->input->post(),$this->input->post('edit_user_id'));
		}
		else if(!empty( $this->input->post('user_id') ))
		{
			$logMessage = 'New portal user ['.ucfirst($this->input->post('first_name')).'] added';
			$this->logger->trigger_log($this->session->userdata('username'),$logMessage);
			$add_system_user = $this->users->add_system_user($this->input->post(),$this->input->post('user_id'));
		}
		else {
			$add_system_user = $this->users->add_system_user($this->input->post());
		}
		if($add_system_user)
		{

			echo 'done';
		}
		else {
			echo 'fail';
		}
	}

	function logs()
	{

		if( $this->session->userdata('type')  != 'superadmin' ){
			$redirectTo = base_url().'user/dashboard/'.$this->session->userdata('linkAccountFirstGroupID');
			redirect($redirectTo);
		}

		$this->load->model('event');
		//$data['detail'] = $this->event->list_log($config['per_page'], $this->uri->segment(3));
		$data['detail'] = $this->event->get_total_log();
		//$this->pagination->initialize($config);
		//$data['links'] = $this->pagination->create_links();
		$this->load->view('system/log_list',$data);
	}

	function viewtest(){
		$this->load->view('system/testview');
	}

	function xml_test(){
		//get last position report

			// if( file_exists(getcwd().'/audio/audio_'.$this->input->post("audio_identifier").'.wav') )
			// {
			// 	unlink(getcwd().'/audio/audio_'.$this->input->post("audio_identifier").'.wav');
			// }
			$ListMediaRequest = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/ListMedia";
			$ListMediaRequest_xml = '<?xml version="1.0" encoding="UTF-8" standalone="no" ?>

            <SOAP-ENV:Envelope

            xmlns:SOAP-ENV="http://www.w3.org/2003/05/soap-envelope"

            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"

            xmlns:xsd="http://www.w3.org/2001/XMLSchema">

            <SOAP-ENV:Body>

                         <ListMedia xmlns="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">

                     <listMediaRequestKey>

                    <UserName>'.encrypt_string($this->session->userdata('sentinel_username'),'d').'</UserName>
					 <Password>'.encrypt_string($this->session->userdata('sentinel_password'),'d').'</Password>

                        <ServiceVersion>Version_1_104_1</ServiceVersion>

                            <MediaFilter>

                                <FilterList>

                                <MediaFilterListItem>

                                    <FilterAttribute xsi:type="LogHeaderIdentifierMediaFilterAttribute"/>

                                    <FilterOperator xsi:type="EqualityMediaFilterOperator"/>

                                    <FilterValue xsi:type="MediaFilterComparisonInteger">

                                    <Value>'.$this->input->post('audio_identifier').'</Value>

                                    </FilterValue>

                                </MediaFilterListItem>

                                <MediaFilterListItem>
                            		<FilterAttribute xsi:type="SerialNumberMediaFilterAttribute"/>
                            		<FilterOperator xsi:type="EqualityMediaFilterOperator"/>
                            		<FilterValue xsi:type="MediaFilterComparisonInteger">
                             			<Value>'.$this->input->post('serialNumber').'</Value>
                            		</FilterValue>
                        		</MediaFilterListItem>

                                </FilterList>

                            </MediaFilter>

                    </listMediaRequestKey>

                 </ListMedia>

            </SOAP-ENV:Body>

            </SOAP-ENV:Envelope>';

				$ListMediaRequest_curl = $this->curl->curl_send($ListMediaRequest_xml, $ListMediaRequest);

				$ListMediaRequest_curl_array = $this->curl->xmlToArray($ListMediaRequest_curl);


				//debug($ListMediaRequest_curl_array,1);
				$errorPurged = '' ;
				$noData = '';
				if ( isset($ListMediaRequest_curl_array['ListMediaResponse']['ListMediaResult']['ListOfMedia']) && empty($ListMediaRequest_curl_array['ListMediaResponse']['ListMediaResult']['ListOfMedia']) ) {
					$outputFile = '' ;
					$errorPurged = 'purgedError';
				}
				elseif( empty($ListMediaRequest_curl_array['ListMediaResponse']['ListMediaResult']['ListOfMedia']['MediaListItem']['Data']) )
				{
					//$audio_file = $ListMediaRequest_curl_array['ListMediaResponse']['ListMediaResult']['ListOfMedia']['MediaListItem']['Data'];

					//echo 'i=f';
					$newAudioString = '';
					$audio_file = $ListMediaRequest_curl_array['ListMediaResponse']['ListMediaResult']['ListOfMedia']['MediaListItem'];
					$audioPath = $this->session->userdata('audioPath').'/'.$this->input->post("audio_identifier").'/';
					mkdir($audioPath);
					chmod($audioPath, 0777);
					for( $var=0; $var<count($audio_file); $var++ )
					{
						//$newAudioString = $audio_file[$var]['Data'];
						if ( isset($audio_file['SerialNumber']) ||  !isset($audio_file[0]['Data']) ) {
							$noData 		= 'yes';
							break;
						}

						file_put_contents($audioPath.'audio_'.$var.'.wav', base64_decode($audio_file[$var]['Data']));
						$newAudioString .= ' '.$audioPath.'audio_'.$var.'.wav';

					}

					if ( $noData ==  'yes' ) {
						$outputFile 	= '' ;
						$errorPurged 	= 'purgedError';
					} else {
						$outputFile = $this->session->userdata('audioPath').'/'.$this->input->post("audio_identifier").'/fullAudio.wav';
						//echo $newAudioString.' '.$outputFile; exit;
						shell_exec('sox --combine concatenate '.$newAudioString.' '.$outputFile);
						//$audio_file = $newAudioString;
						//echo ; exit;
					}
				}
				else
				{
					//echo 'else';
					//echo $ListMediaRequest_curl_array['ListMediaResponse']['ListMediaResult']['ListOfMedia']['MediaListItem']['Data'];
					$audio_file = $ListMediaRequest_curl_array['ListMediaResponse']['ListMediaResult']['ListOfMedia']['MediaListItem']['Data'];
					$audioPath = $this->session->userdata('audioPath').'/'.$this->input->post("audio_identifier").'/';
					//$audioPath = $this->session->userdata('audioPath').'/'.$this->input->post("audio_identifier").'/';
					mkdir($audioPath);
					chmod($audioPath, 0777);
					$outputFile = file_put_contents($audioPath.'fullAudio.wav', base64_decode($audio_file));
				}
				//exit;
				//debug($audio_file,1);
				sleep(2);
				//$var = file_put_contents(getcwd().'/audio/audio_'.$this->input->post("audio_identifier").'.wav', base64_decode($audio_file));
				if ( $outputFile )
				{
					if (isset($_POST['browser']) && $_POST['browser'] == 'yes') {
						echo json_encode([
							'error' => 0,
							'html' => '<object id="Player_O" classid="clsid:6BF52A52-394A-11d3-B153-00C04F79FAA6"
					                       codebase="http://www.apple.com/qtactivex/qtplugin.cab" height="70px"
					                       type="application/x-oleobject" width="300px">
					                       <param name="url" value="'.base_url().'assets/'.$this->session->userdata('login_name').'/'.$this->input->post("audio_identifier").'/fullAudio.wav">
					                       <param name="autostart" value="false">
					                       <embed id="Player_E" height="70px"
					                           pluginspage="http://www.microsoft.com/Windows/MediaPlayer/"
					                           src="'.base_url().'assets/'.$this->session->userdata('login_name').'/'.$this->input->post("audio_identifier").'/fullAudio.wav" type="application/x-mplayer2" width="400px"></embed>
					                       </param>
					                       </param>
					                   </object><span class="download_audio_btn"><a href="'.base_url().'assets/'.$this->session->userdata('login_name').'/'.$this->input->post("audio_identifier").'/fullAudio.wav" target="_blank"><i class="fa fa-download" aria-hidden="true"></i> &nbsp;&nbsp;Download Audio</a></span>',
							'file' => $outputFile]);

					} else {
					echo json_encode(['error' => 0, 'html' => '<audio id="audioloop"controls><source src="'.base_url().'assets/'.$this->session->userdata('login_name').'/'.$this->input->post("audio_identifier").'/fullAudio.wav" type="audio/wav"></audio><span class="download_audio"><a target="_blank" href="'.base_url().'assets/'.$this->session->userdata('login_name').'/'.$this->input->post("audio_identifier").'/fullAudio.wav" ><i class="fa fa-download" aria-hidden="true"></i></a></span>', 'file' => $outputFile]);
					}
				}
				else{

					if ( $errorPurged = 'purgedError' ) {
						echo json_encode(['error' => 0, 'html' => '<span id="file_error"><strong>The file no longer exists on the server.</strong></span><audio id="audioloop"controls><source src="" type="audio/wav"></audio>']);
					} else {
						echo json_encode(['error' => 0, 'html' => '<span id="file_error"><strong>File not found at server</strong></span><audio id="audioloop"controls><source src="" type="audio/wav"></audio>']);
					}
				}
	}

	function testplay()
	{
		$this->load->view('testxml');
	}

	function test_map()
	{
	 // 	$data['point'] = $this->input->post('data');
	 //  	$view = $this->load->view('geo/dummy',$data, true);
		// echo  json_encode( [ 'error' => '0', 'html' => $view ] );

		$this->load->view('geo/dummy');
	}

	function ListLogDetailItems(){
		//get last position report
			$ListLogDetailItems_url = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/ListLogDetailItems";
			$ListLogDetailItems_xml = '<?xml version="1.0" encoding="UTF-8" standalone="no" ?>
			<SOAP-ENV:Envelope
			SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/"
			xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
			xmlns:SOAP-ENC="http://schemas.xmlsoap.org/soap/encoding/"
			xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
			xmlns:xsd="http://www.w3.org/2001/XMLSchema">
			<SOAP-ENV:Body>
						 <ListLogDetailItems xmlns="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
					 <listLogDetailItemsRequestKey>
					 <UserName>'.encrypt_string($this->session->userdata('sentinel_username'),'d').'</UserName>
					 <Password>'.encrypt_string($this->session->userdata('sentinel_password'),'d').'</Password>
						<ServiceVersion>Version_1_104_1</ServiceVersion>
							<LogDetailFilter>
								<FilterList>
								<LogDetailFilterListItem>
									<FilterAttribute xsi:type="SerialNumberLogDetailFilterAttribute"/>
									<FilterOperator xsi:type="EqualityLogDetailFilterOperator"/>
									<FilterValue xsi:type="LogDetailFilterComparisonInteger">
										<Value>'.$this->input->post('serialnumber').'</Value>
									</FilterValue>
								</LogDetailFilterListItem>
								<LogDetailFilterListItem>
									<FilterAttribute xsi:type="LogHeaderIdentifierLogDetailFilterAttribute"/>
									<FilterOperator xsi:type="EqualityLogDetailFilterOperator"/>
									<FilterValue xsi:type="LogDetailFilterComparisonInteger">
										<Value>'.$this->input->post('Identifier').'</Value>
									</FilterValue>
								</LogDetailFilterListItem>
								</FilterList>
							</LogDetailFilter>
					</listLogDetailItemsRequestKey>
				 </ListLogDetailItems>
			</SOAP-ENV:Body>
			</SOAP-ENV:Envelope>';

				$ListLogDetailItems_curl = $this->curl->curl_send($ListLogDetailItems_xml, $ListLogDetailItems_url);

				$ListLogDetailItems_array = $this->curl->xmlToArray($ListLogDetailItems_curl);

				$ListLogDetailItemsResponse = $ListLogDetailItems_array['ListLogDetailItemsResponse']['ListLogDetailItemsResult']['ListOfLogDetailItems']['LogDetailListItem'];

				if( empty($ListLogDetailItemsResponse['Description']) ){
					$explode = explode(',',$ListLogDetailItemsResponse[1]['Description']);
					$explode = str_replace('Long=(','',$explode);
					$explode = str_replace(')','',$explode);
					$long = $explode[4];
					$lat = $explode[3];

					if( !empty($long) )
					{
						$data['long'] = $long;
					}else
					{
						$data['long'] = '-2.244644';
					}
					if( !empty($lat) )
					{
						$data['lat'] = $lat;
					}else
					{
						$data['lat'] = '53.483959';
					}
					//debug( $data,1 );
					$view = $this->load->view('geo/dummy',$data, true);
					echo  json_encode( [ 'error' => '0', 'html' => $view ] );
				}
				else
				{
					$explode = explode(',',$ListLogDetailItemsResponse['Description']);
					$explode = str_replace('Long=(','',$explode);
					$explode = str_replace(')','',$explode);
					$long = $explode[2];
					$lat = $explode[1];

					if( !empty($long) )
					{
						$data['long'] = $long;
					}else
					{
						$data['long'] = '-2.244644';
					}
					if( !empty($lat) )
					{
						$data['lat'] = $lat;
					}else
					{
						$data['lat'] = '53.483959';
					}
					//debug( $data,1 );
					$view = $this->load->view('geo/dummy',$data, true);
					echo  json_encode( [ 'error' => '0', 'html' => $view ] );
				}
	}

	function decommissioned()
	{
		$url = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/ListSites";

			$xml_post_string = '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope"
                                                xmlns:cls="http://www.monitorsoft.com/SentinelXS/clsSentinelXS"
                                                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
   <soap:Header/>
   <soap:Body>
      <cls:ListSites>
         <!--Optional:-->
         <cls:listSitesRequestKey>
            <cls:ServiceVersion>Version_1_104_1</cls:ServiceVersion>
            <!--Optional:-->
            <cls:UserName>'.encrypt_string($this->session->userdata('sentinel_username'),'d').'</cls:UserName>
            <!--Optional:-->
            <cls:Password>'.encrypt_string($this->session->userdata('sentinel_password'),'d').'</cls:Password>
            <!--Optional:-->
            <cls:SiteFilter>
               <cls:FilterList>
                  <!-- Exlude Templates:-->
                  <cls:SiteFilterListItem>
                     <cls:FilterAttribute xsi:type="cls:IsTemplateSiteFilterAttribute"/>
                     <cls:FilterOperator xsi:type="cls:EqualitySiteFilterOperator"/>
                     <cls:FilterValue xsi:type="cls:SiteFilterComparisonBoolean">
                              <cls:Value>false</cls:Value>
                     </cls:FilterValue>
                  </cls:SiteFilterListItem>

                  <!-- Include Commissioned Only :-->
                  <cls:SiteFilterListItem>
                     <cls:FilterAttribute xsi:type="cls:CommissionedStateSiteFilterAttribute"/>
                     <cls:FilterOperator xsi:type="cls:EqualitySiteFilterOperator"/>
                     <cls:FilterValue xsi:type="cls:SiteFilterComparisonCommissionState">
                              <cls:Value xsi:type="cls:Decommissioned"/>
                     </cls:FilterValue>
                  </cls:SiteFilterListItem>
               </cls:FilterList>
            </cls:SiteFilter>

         </cls:listSitesRequestKey>
      </cls:ListSites>
   </soap:Body>
</soap:Envelope>';


				// get curl response
				$curl_send = $this->curl->curl_send($xml_post_string, $url);
				// convert xml into array

				//try {



				$xmlToArray = $this->curl->xmlToArray($curl_send);

				$count_lone_worker = $xmlToArray['ListSitesResponse']['ListSitesResult']['ListOfSites']['SiteListItem'];
				if(!empty($count_lone_worker))
				{
					if(!empty($count_lone_worker[0]))
					{
						$data['count_lone_worker'] = $count_lone_worker;
					}
					else
					{
						$data['count_lone_worker'][] = $xmlToArray['ListSitesResponse']['ListSitesResult']['ListOfSites']['SiteListItem'];
					}
				}else{
					$data['count_lone_worker'] = array();
				}

		$this->load->view('system/decommissioned',$data);
	}


	function grouping()
	{
		$this->load->view('geo/grouping_test');
	}

	function check_escalation()
	{
		echo $this->session->userdata('selectedLoneWorkerName');
		echo '<br>'.$this->session->userdata('selectedLoneWorkerSerialNumber');
	}

	function linkaccount()
	{
		$url = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/ListLinkAccounts";
		$xml_post_string = '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:cls="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
		<soap:Header/>
		<soap:Body>
			<cls:ListLinkAccounts>
			<!--Optional:-->
				<cls:listLinkAccountsRequestKey>
					<cls:ServiceVersion>Version_1_110_4</cls:ServiceVersion>
					<cls:UserName>'.encrypt_string($this->session->userdata('sentinel_username'),'d').'</cls:UserName>
				<!--Optional:-->
					<cls:Password>'.encrypt_string($this->session->userdata('sentinel_password'),'d').'</cls:Password>
				</cls:listLinkAccountsRequestKey>
			</cls:ListLinkAccounts>
		</soap:Body>
		</soap:Envelope>';
		$curl_send = $this->curl->curl_send($xml_post_string, $url);

		$xmlToArray = $this->curl->xmlToArray($curl_send);
		debug($xmlToArray,1);
	}


	function listlinkaccount()
	{

		$url = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/ListLinkAccountContacts";
		$xml = '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope"
		                                               xmlns:cls="http://www.monitorsoft.com/SentinelXS/clsSentinelXS"
		                                                               xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
<soap:Header/>
		<soap:Body>
		  <cls:ListLinkAccountContacts>
			<cls:listLinkAccountContactsRequest>
					<cls:ServiceVersion>Version_1_111_4</cls:ServiceVersion>
					<cls:UserName>'.encrypt_string($this->session->userdata('sentinel_username'),'d').'</cls:UserName>
					<cls:Password>'.encrypt_string($this->session->userdata('sentinel_password'),'d').'</cls:Password>
					<cls:LinkAccountContactFilter>
						<cls:FilterList>
							<cls:LinkAccountContactFilterListItem>
									<cls:FilterAttribute xsi:type="cls:LinkAccountNumberLinkAccountContactFilterAttribute"/>
									 <cls:FilterOperator xsi:type="cls:EqualityLinkAccountContactFilterOperator"/>
									 <cls:FilterValue xsi:type="cls:LinkAccountContactFilterComparisonInteger">
									 		<cls:Value>'.$this->input->post('identifier').'</cls:Value>
									</cls:FilterValue>
							</cls:LinkAccountContactFilterListItem>
						</cls:FilterList>
					</cls:LinkAccountContactFilter>
			</cls:listLinkAccountContactsRequest>
			</cls:ListLinkAccountContacts>
		</soap:Body>
		</soap:Envelope>';
		$curl_send = $this->curl->curl_send($xml, $url);
		$xmlToArray = $this->curl->xmlToArray($curl_send);

		if( !empty($xmlToArray['ListLinkAccountContactsResponse']['ListLinkAccountContactsResult']['ListOfLinkAccountContacts']) ){

			$data['linkAccountContactResponse'] = $xmlToArray['ListLinkAccountContactsResponse']['ListLinkAccountContactsResult']['ListOfLinkAccountContacts']['LinkAccountContactListItem'];

			if( empty($data['linkAccountContactResponse']['Identifier']) ){

				for( $i=0; $i<count($data['linkAccountContactResponse']); $i++ ){
						if( empty($data[$i]['Name']) ){
								$data[$i]['Name'] = '-';
						}
						if( empty($data[$i]['PhoneNumber']) ){
								$data[$i]['PhoneNumber'] = '-';
						}
						if( empty($data[$i]['WorkNumber']) ){
								$data[$i]['WorkNumber'] = '-';
						}
						if( empty($data[$i]['MobileNumber']) ){
								$data[$i]['MobileNumber'] = '-';
						}
						if( empty($data[$i]['LinkAccountIdentifier']) ){
								$data[$i]['NamLinkAccountIdentifiere'] = '-';
						}
						if( empty($data[$i]['Identifier']) ){
								$data[$i]['Identifier'] = '-';
						}
				}

				echo json_encode([ 'error' => 0, 'html' => $data['linkAccountContactResponse'] ]);
				}
			else if( !empty($data['linkAccountContactResponse']) ){
				$arr[] = $data['linkAccountContactResponse'];
				echo json_encode([ 'error' => 1, 'html' => $arr ]);
			}
			else{
				echo json_encode([ 'error' => 2, 'html' => '']);
			}
		}
		else
		{
				echo json_encode([ 'error' => 2, 'html' => '']);
		}
		//debug($xmlToArray,1);
}

	function createlinkaccountcontact(){
		if( !empty($this->input->post('NumberPriority')) ){
			$string_replace = str_replace('item[]=','',$this->input->post('NumberPriority'));
			$explode = explode( '&', $string_replace );
			//debug( $explode );
			$phonePriority = array_search('phone',$explode);
			$workPriority = array_search('work',$explode);
			$mobilePriority = array_search('mobile',$explode);
		}
		else{
			$phonePriority = 1;
			$workPriority = 2;
			$mobilePriority = 3;
		}
		//exit;
			$url = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/CreateLinkAccountContact";
			$xml = '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:cls="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
			<soap:Header/>
			<soap:Body>
				<cls:CreateLinkAccountContact>
					<cls:createLinkAccountContactRequest>
						<cls:ServiceVersion>Version_1_104_1</cls:ServiceVersion>
						<cls:UserName>'.encrypt_string($this->session->userdata('sentinel_username'),'d').'</cls:UserName>
						<cls:Password>'.encrypt_string($this->session->userdata('sentinel_password'),'d').'</cls:Password>
						<cls:LinkAccountNumber>'.$this->input->post('linkAccountIdentifier').'</cls:LinkAccountNumber>
						<cls:LinkAccountContactDetails>
								<cls:Name>'.$this->input->post('name').'</cls:Name>
								<cls:PhoneNumber>'.$this->input->post('phone_number').'</cls:PhoneNumber>
								<cls:WorkNumber>'.$this->input->post('work_number').'</cls:WorkNumber>
								<cls:MobileNumber>'.$this->input->post('mobile_number').'</cls:MobileNumber>
								<cls:PagerNumber>777-777-777</cls:PagerNumber>
								<cls:LinkAccountContactAddress>
									<cls:AddressLine1>'.$this->input->post('address1').'</cls:AddressLine1>
									<cls:AddressLine2>'.$this->input->post('address2').'</cls:AddressLine2>
								</cls:LinkAccountContactAddress>
								<cls:PhoneNumberPriority>'.$phonePriority.'</cls:PhoneNumberPriority>
								<cls:WorkNumberPriority>'.$workPriority.'</cls:WorkNumberPriority>
								<cls:MobileNumberPriority>'.$mobilePriority.'</cls:MobileNumberPriority>
								<cls:PagerNumberPriority>4</cls:PagerNumberPriority>
								<cls:EmailAddress>'.$this->input->post('EmailAddress').'</cls:EmailAddress>
								</cls:LinkAccountContactDetails>
					</cls:createLinkAccountContactRequest>
				</cls:CreateLinkAccountContact>
			</soap:Body>
			</soap:Envelope>';
			//echo'<br>';
			$curl_send = $this->curl->curl_send($xml, $url);
			$xmlToArray = $this->curl->xmlToArray($curl_send);
			//debug($xmlToArray);
			$response = $xmlToArray['CreateLinkAccountContactResponse']['CreateLinkAccountContactResult'];
			//debug($response);
			if( empty($response['Errors']) ){
				echo json_encode([ 'error' => 0, 'LinkAccountContactIdentifier' => $response['LinkAccountContactIdentifier'] ]);
			}
			else if( !empty($response['Errors']) ){
				echo json_encode([ 'error' => 1, 'message' => $response['Errors']['Message']['MessageText'] ]);
			}
			else {
				echo json_encode([ 'error' => 2, 'message' => 'Unknown error occur while saving Escalation' ]);
			}
			//debug($xmlToArray,1);
	}

	function getEventDetail($serialnumber,$logheaderidentifier,$datetime=null, $username=null,$signaltype=null,$serialno=null)
		{
			$this->load->model('users');
			$current_time = date('H:i:s',strtotime('+1hours'));
			if( $start == null && $end == null )
			{
				$start = date('Y-m-d',strtotime('-1days'));
				$end = date('Y-m-d');
			}
			else{
				$start = date('Y-m-d',strtotime($start));
				$end = date('Y-m-d',strtotime($end));
				$this->load->library('logger');
				$this->logger->trigger_log($this->session->userdata('username'),'Events detail filter applied - date range');
			}
			//exit;

			$url_alarm = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/ListLogDetailItems";
			$xml_post_string_alarm = '<?xml version="1.0" encoding="UTF-8" standalone="no" ?>
	<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:cls="http://www.monitorsoft.com/SentinelXS/clsSentinelXS" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	 <soap:Header/>
	 <soap:Body>
	    <cls:ListLogDetailItems>
	       <!--Optional:-->
	       <cls:listLogDetailItemsRequestKey>
	          <cls:ServiceVersion>Version_1_110_4</cls:ServiceVersion>
	          <!--Optional:-->
	          <cls:UserName>'.encrypt_string($this->session->userdata('sentinel_username'),'d').'</cls:UserName>
	          <!--Optional:-->
	          <cls:Password>'.encrypt_string($this->session->userdata('sentinel_password'),'d').'</cls:Password>
	          <!--Optional:-->
	          <cls:LogDetailFilter>
	             <!--Optional:-->

	             <cls:FilterList>
	                <cls:LogDetailFilterListItem>
	                   <cls:FilterAttribute  xsi:type="cls:SerialNumberLogDetailFilterAttribute"/>
	                   <cls:FilterOperator  xsi:type="cls:EqualityLogDetailFilterOperator"/>
	                   <cls:FilterValue  xsi:type="cls:LogDetailFilterComparisonInteger">
	                   <cls:Value>'.$serialnumber.'</cls:Value>
	                   </cls:FilterValue>
	                </cls:LogDetailFilterListItem>
	                <cls:LogDetailFilterListItem>
	                   <cls:FilterAttribute  xsi:type="cls:LogHeaderIdentifierLogDetailFilterAttribute"/>
	                   <cls:FilterOperator  xsi:type="cls:EqualityLogDetailFilterOperator"/>
	                   <cls:FilterValue  xsi:type="cls:LogDetailFilterComparisonInteger">
	                   <cls:Value>'.$logheaderidentifier.'</cls:Value>
	                   </cls:FilterValue>
	                </cls:LogDetailFilterListItem>

	             </cls:FilterList>
	          </cls:LogDetailFilter>
	       </cls:listLogDetailItemsRequestKey>
	    </cls:ListLogDetailItems>
	 </soap:Body>
	</soap:Envelope>';

				//header('Content-type: application/xml');
				$curl_send_alarm = $this->curl->curl_send($xml_post_string_alarm, $url_alarm);
				$data = array();
				$main = array();
				$xmlToArray_alarm = $this->curl->xmlParse($curl_send_alarm);
				$checkMedia = '';
				if($xmlToArray_alarm['soap:Body']['ListLogDetailItemsResponse']['ListLogDetailItemsResult']['ListOfLogDetailItems']['LogDetailListItem'])
				{
							$data = $xmlToArray_alarm['soap:Body']['ListLogDetailItemsResponse']['ListLogDetailItemsResult']['ListOfLogDetailItems']['LogDetailListItem'];

							if( empty($data['SerialNumber']) )
							{
								$main = $data;
							}
							else{
								$main[] = $data;
							}
							if( !empty($main) )
							{
								for( $m=0; $m<count($main); $m++ ){
									if( !empty($main[$m]['LogDateTime']) )
									{
										$main[$m]['LogDateTimeNew'] = date('d M Y H:i:s', strtotime( $main[$m]['LogDateTime'] ));
									}else{
											$main[$m]['LogDateTimeNew']='-';
									}

									if( empty($main[$m]['UserInitials']) ){
											$main[$m]['UserInitials'] = '-';
									}
									if( empty($main[$m]['Description']) ){
											$main[$m]['Description'] = '-';
									}
									if( $data[$m]['ContainsMedia'] == "true" ){
										$checkMedia = $data[$m]['LogHeaderIdentifier'];

									}

									$main[$m]['datetime']=$this->input->get('datetime');
									$main[$m]['username']=$this->input->get('username');
									$main[$m]['signaltype']=$this->input->get('signaltype');
									$main[$m]['serialno']=$this->input->get('serialno');

								}
							}
							// save data in database to generate reports
							$this->users->insert_report($main);

				echo json_encode([ 'error' => 0, 'data' => $main, 'mediaid' => $checkMedia ]);
				} else {
					echo json_encode([ 'error' => 1, 'data' => '' ]);
				}
			}

		function downloadExcel($serialnumber,$logheaderidentifier)
			{
				$this->load->library('excel');
				$url_alarm = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/ListLogDetailItems";
				$xml_post_string_alarm = '<?xml version="1.0" encoding="UTF-8" standalone="no" ?>
		<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:cls="http://www.monitorsoft.com/SentinelXS/clsSentinelXS" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
		 <soap:Header/>
		 <soap:Body>
		    <cls:ListLogDetailItems>
		       <!--Optional:-->
		       <cls:listLogDetailItemsRequestKey>
		          <cls:ServiceVersion>Version_1_110_4</cls:ServiceVersion>
		          <!--Optional:-->
		          <cls:UserName>'.encrypt_string($this->session->userdata('sentinel_username'),'d').'</cls:UserName>
		          <!--Optional:-->
		          <cls:Password>'.encrypt_string($this->session->userdata('sentinel_password'),'d').'</cls:Password>
		          <!--Optional:-->
		          <cls:LogDetailFilter>
		             <!--Optional:-->

		             <cls:FilterList>
		                <cls:LogDetailFilterListItem>
		                   <cls:FilterAttribute  xsi:type="cls:SerialNumberLogDetailFilterAttribute"/>
		                   <cls:FilterOperator  xsi:type="cls:EqualityLogDetailFilterOperator"/>
		                   <cls:FilterValue  xsi:type="cls:LogDetailFilterComparisonInteger">
		                   <cls:Value>'.$serialnumber.'</cls:Value>
		                   </cls:FilterValue>
		                </cls:LogDetailFilterListItem>
		                <cls:LogDetailFilterListItem>
		                   <cls:FilterAttribute  xsi:type="cls:LogHeaderIdentifierLogDetailFilterAttribute"/>
		                   <cls:FilterOperator  xsi:type="cls:EqualityLogDetailFilterOperator"/>
		                   <cls:FilterValue  xsi:type="cls:LogDetailFilterComparisonInteger">
		                   <cls:Value>'.$logheaderidentifier.'</cls:Value>
		                   </cls:FilterValue>
		                </cls:LogDetailFilterListItem>

		             </cls:FilterList>
		          </cls:LogDetailFilter>
		       </cls:listLogDetailItemsRequestKey>
		    </cls:ListLogDetailItems>
		 </soap:Body>
		</soap:Envelope>';

					//header('Content-type: application/xml');
					$curl_send_alarm = $this->curl->curl_send($xml_post_string_alarm, $url_alarm);
					$data1 = array();
					$data = array();
					$xmlToArray_alarm = $this->curl->xmlParse($curl_send_alarm);
					//debug($xmlToArray_alarm,1);
					$checkMedia = '';
					if($xmlToArray_alarm['soap:Body']['ListLogDetailItemsResponse']['ListLogDetailItemsResult']['ListOfLogDetailItems']['LogDetailListItem']){
								$data1 = $xmlToArray_alarm['soap:Body']['ListLogDetailItemsResponse']['ListLogDetailItemsResult']['ListOfLogDetailItems']['LogDetailListItem'];

								if( empty($data1['SerialNumber']) )
								{
									$data = $data1;
								}
								else
								{
									$data[0] = $data1;
								}

								//debug($data,1);

								for( $m=0; $m<count($data); $m++ ){
									if( !empty($data[$m]['LogDateTime']) )
									{
										//Convert the date string into a unix timestamp.
										$data[$m]['Time'] = $data[$m]['LogDateTime'];
										$unixTimestamp = strtotime($data[$m]['LogDateTime']);

										//Get the day of the week using PHP's date function.
										//$day = date("l ", $unixTimestamp);
										$date = date("d M", $unixTimestamp);
										$time = date("H:i:s", $unixTimestamp);
										$data[$m]['LogDateTime'] = $date.' '.$time;
									}else{
											$data[$m]['LogDateTime']='-';
											$data[$m]['Time'] = '-';
									}

									if( empty($data[$m]['UserInitials']) ){
											$data[$m]['UserInitials'] = '-';
									}
									if( empty($data[$m]['Description']) ){
											$data[$m]['Description'] = '-';
									}

									if( $data[$m]['ContainsMedia'] == "true" ){
										$checkMedia = $data[$m]['LogHeaderIdentifier'];
									}

								}

			$this->load->model('users');

			$get_report_data = $this->users->get_report_data();

			//remove previous file
			if( file_exists($this->session->userdata('audioPath').'/reports/alarmActivationReport.xlsx') )
			{
				unlink($this->session->userdata('audioPath').'/reports/alarmActivationReport.xlsx');
			}


		  	$fileName = 'alarmActivationReport.xlsx';
	        //$empInfo = $this->export->employeeList();
	        $objPHPExcel = new PHPExcel();
	        $objPHPExcel->setActiveSheetIndex(0);
	        // set Header
	        $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Date/Time');
	        $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Unit Name');
	        $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Unit ID');
	        $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Signal Type');
	        // set Row
	        $rowCount = 2;
	        foreach ($get_report_data as $element) {
	            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $element['datetime']);
	            $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $element['username']);
	            $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $element['serialno']);
	            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $element['signaltype']);
	            $rowCount++;
	        }

	        $objPHPExcel->getActiveSheet()->SetCellValue('A3', 'Time');
	        $objPHPExcel->getActiveSheet()->SetCellValue('B3', 'Description');
	        $objPHPExcel->getActiveSheet()->SetCellValue('C3', 'User Initials');
	        $objPHPExcel->getActiveSheet()->SetCellValue('D3', '');
	        // set Row
	        $rowCount1 = 4;
	        foreach ($get_report_data as $element) {
	            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount1, $element['logdatetime']);
	            $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount1, $element['description']);
	            $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount1, $element['userinitials']);
	            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount1, '');
	            $rowCount1++;
	        }
	        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
					// download file
	        $report_path = $this->session->userdata('audioPath').'/reports/';
	        mkdir($report_path);
			chmod($report_path, 0777);
	        $objWriter->save($report_path.$fileName);
	        header("Content-Type: application/vnd.ms-excel");
	        redirect(base_url().'assets/'.$this->session->userdata('login_name').'/reports/'.$fileName);
				}
		}


		function exportPdf($serialnumber,$logheaderidentifier){

			$url_alarm = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/ListLogDetailItems";
			$xml_post_string_alarm = '<?xml version="1.0" encoding="UTF-8" standalone="no" ?>
	<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:cls="http://www.monitorsoft.com/SentinelXS/clsSentinelXS" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	 <soap:Header/>
	 <soap:Body>
			<cls:ListLogDetailItems>
				 <!--Optional:-->
				 <cls:listLogDetailItemsRequestKey>
						<cls:ServiceVersion>Version_1_110_4</cls:ServiceVersion>
						<!--Optional:-->
						<cls:UserName>'.encrypt_string($this->session->userdata('sentinel_username'),'d').'</cls:UserName>
						<!--Optional:-->
						<cls:Password>'.encrypt_string($this->session->userdata('sentinel_password'),'d').'</cls:Password>
						<!--Optional:-->
						<cls:LogDetailFilter>
							 <!--Optional:-->

							 <cls:FilterList>
									<cls:LogDetailFilterListItem>
										 <cls:FilterAttribute  xsi:type="cls:SerialNumberLogDetailFilterAttribute"/>
										 <cls:FilterOperator  xsi:type="cls:EqualityLogDetailFilterOperator"/>
										 <cls:FilterValue  xsi:type="cls:LogDetailFilterComparisonInteger">
										 <cls:Value>'.$serialnumber.'</cls:Value>
										 </cls:FilterValue>
									</cls:LogDetailFilterListItem>
									<cls:LogDetailFilterListItem>
										 <cls:FilterAttribute  xsi:type="cls:LogHeaderIdentifierLogDetailFilterAttribute"/>
										 <cls:FilterOperator  xsi:type="cls:EqualityLogDetailFilterOperator"/>
										 <cls:FilterValue  xsi:type="cls:LogDetailFilterComparisonInteger">
										 <cls:Value>'.$logheaderidentifier.'</cls:Value>
										 </cls:FilterValue>
									</cls:LogDetailFilterListItem>

							 </cls:FilterList>
						</cls:LogDetailFilter>
				 </cls:listLogDetailItemsRequestKey>
			</cls:ListLogDetailItems>
	 </soap:Body>
	</soap:Envelope>';

				//header('Content-type: application/xml');
				$curl_send_alarm = $this->curl->curl_send($xml_post_string_alarm, $url_alarm);
				$data1 = array();
				$xmlToArray_alarm = $this->curl->xmlParse($curl_send_alarm);
				//debug($xmlToArray_alarm,1);
				$checkMedia = '';
				if($xmlToArray_alarm['soap:Body']['ListLogDetailItemsResponse']['ListLogDetailItemsResult']['ListOfLogDetailItems']['LogDetailListItem'])
				{
							$data1 = $xmlToArray_alarm['soap:Body']['ListLogDetailItemsResponse']['ListLogDetailItemsResult']['ListOfLogDetailItems']['LogDetailListItem'];

							if( empty($data1['SerialNumber']) )
							{
								$data = $data1;
							}
							else
							{
								$data[] = $data1;
							}

							for( $m=0; $m<count($data); $m++ ){
								if( !empty($data[$m]['LogDateTime']) )
								{
									//Convert the date string into a unix timestamp.
									$unixTimestamp = strtotime($data[$m]['LogDateTime']);

									//Get the day of the week using PHP's date function.
									//$day = date("l ", $unixTimestamp);
									$date = date("d M", $unixTimestamp);
									$time = date("H:i:s", $unixTimestamp);
									$data[$m]['LogDateTime'] = $date.' '.$time;
								}else{
										$data[$m]['LogDateTime']='-';
								}

								if( empty($data[$m]['UserInitials']) ){
										$data[$m]['UserInitials'] = '-';
								}
								if( empty($data[$m]['Description']) ){
										$data[$m]['Description'] = '-';
								}

							}
								$html_data['export_data'] = $data;

								ob_start();
								// Include the main TCPDF library (search for installation path).
								$this->load->library('pdf');

								header('Content-Type: application/pdf');
								$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
								// set document information
								$pdf->SetCreator(PDF_CREATOR);
								$pdf->SetAuthor('TechArise');
								$pdf->SetTitle('TechArise');
								$pdf->SetSubject('TechArise');
								$pdf->SetKeywords('TechArise');

								// set default header data
								$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

								// set header and footer fonts
								$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
								$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

								$pdf->SetPrintHeader(false);
								$pdf->SetPrintFooter(false);

								// set default monospaced font
								$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

								// set margins
								$pdf->SetMargins(PDF_MARGIN_LEFT, 0, PDF_MARGIN_RIGHT);
								$pdf->SetHeaderMargin(0);
								$pdf->SetFooterMargin(0);

								// set auto page breaks
								//$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
								$pdf->SetAutoPageBreak(TRUE, 0);

								// set image scale factor
								$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

								// set some language-dependent strings (optional)
								if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
										require_once(dirname(__FILE__).'/lang/eng.php');
										$pdf->setLanguageArray($l);
								}

								// set font
								$pdf->SetFont('dejavusans', '', 10);

								// add a page
								$pdf->AddPage();

								// output the HTML content
								$html = $this->load->view('report/exportPdf','',true);
								$pdf->writeHTML($html, true, false, true, false, '');

								// reset pointer to the last page
								$pdf->lastPage();
								ob_end_clean();
								//Close and output PDF document
								$pdf->Output('output.pdf', 'I');


						}
		}

		function deleteLinkAccountContact(){
			$url = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/DeleteLinkAccountContact";
			$xml = '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:cls="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
			<soap:Header/>
			<soap:Body>
				<cls:DeleteLinkAccountContact>
					<cls:deleteLinkAccountContactRequest>
						<cls:ServiceVersion>Version_1_104_1</cls:ServiceVersion>
						<cls:UserName>'.encrypt_string($this->session->userdata('sentinel_username'),'d').'</cls:UserName>
						<cls:Password>'.encrypt_string($this->session->userdata('sentinel_password'),'d').'</cls:Password>
						<cls:LinkAccountNumber>'.$this->input->post('LinkAccountIdentifier').'</cls:LinkAccountNumber>
						<cls:LinkAccountContactIdentifier>'.$this->input->post('identifier').'</cls:LinkAccountContactIdentifier>
					</cls:deleteLinkAccountContactRequest>
				</cls:DeleteLinkAccountContact>
			</soap:Body>
			</soap:Envelope>';
			//echo'<br>';
			$curl_send = $this->curl->curl_send($xml, $url);
			$xmlToArray = $this->curl->xmlToArray($curl_send);
			$respone = $xmlToArray['DeleteLinkAccountContactResponse']['DeleteLinkAccountContactResult'];
			if( empty($respone['Errors']) ){
				echo json_encode([ 'error' => 0 ]);
			}
			else{
				echo json_encode([ 'error' => 1, 'message' => 'Unknown error occur while deleting Escalation' ]);
			}
			//debug($xmlToArray);
	}

	function updatelinkaccountcontact(){

			if( !empty($this->input->post('NumberPriority')) ){
			$string_replace = str_replace('item[]=','',$this->input->post('NumberPriority'));
			$explode = explode( '&', $string_replace );
			//debug( $explode );
			$phonePriority = array_search('phone',$explode);
			$workPriority = array_search('work',$explode);
			$mobilePriority = array_search('mobile',$explode);
			}
			else{
				$phonePriority = $this->input->post('PhoneNumberPriority');
				$workPriority = $this->input->post('WorkNumberPriority');
				$mobilePriority = $this->input->post('MobileNumberPriority');
			}

			$url = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/UpdateLinkAccountContact";
			$xml = '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:cls="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
			<soap:Header/>
			<soap:Body>
				<cls:UpdateLinkAccountContact>
					<cls:updateLinkAccountContactRequest>
						<cls:ServiceVersion>Version_1_104_1</cls:ServiceVersion>
						<cls:UserName>'.encrypt_string($this->session->userdata('sentinel_username'),'d').'</cls:UserName>
						<cls:Password>'.encrypt_string($this->session->userdata('sentinel_password'),'d').'</cls:Password>
						<cls:LinkAccountNumber>'.$this->input->post('linkAccountIdentifier').'</cls:LinkAccountNumber>
						<cls:LinkAccountContactIdentifier>'.$this->input->post('identifier').'</cls:LinkAccountContactIdentifier>
								<cls:LinkAccountContactDetails>
								<cls:Name>'.$this->input->post('name').'</cls:Name>
								<cls:PhoneNumber>'.$this->input->post('phone_number').'</cls:PhoneNumber>
								<cls:WorkNumber>'.$this->input->post('work_number').'</cls:WorkNumber>
								<cls:MobileNumber>'.$this->input->post('mobile_number').'</cls:MobileNumber>
								<cls:PagerNumber>777-777-777</cls:PagerNumber>
								<cls:LinkAccountContactAddress>
									<cls:AddressLine1>'.$this->input->post('address1').'</cls:AddressLine1>
									<cls:AddressLine2>'.$this->input->post('address2').'</cls:AddressLine2>
								</cls:LinkAccountContactAddress>
								<cls:PhoneNumberPriority>'.$phonePriority.'</cls:PhoneNumberPriority>
								<cls:WorkNumberPriority>'.$workPriority.'</cls:WorkNumberPriority>
								<cls:MobileNumberPriority>'.$mobilePriority.'</cls:MobileNumberPriority>
								<cls:PagerNumberPriority>4</cls:PagerNumberPriority>
								<cls:EmailAddress>'.$this->input->post('EmailAddress').'</cls:EmailAddress>
								</cls:LinkAccountContactDetails>
					</cls:updateLinkAccountContactRequest>
				</cls:UpdateLinkAccountContact>
			</soap:Body>
			</soap:Envelope>';
			//echo'<br>';
			$curl_send = $this->curl->curl_send($xml, $url);

			$xmlToArray = $this->curl->xmlToArray($curl_send);
			$resposne = $xmlToArray['UpdateLinkAccountContactResponse']['UpdateLinkAccountContactResult'];
			if( empty($resposne['Errors']) ){
				echo json_encode([ 'error' => 0 ]);
			}else{
				echo json_encode(['error' => 1, 'message' => 'Unknown error occur while updating Escalation']);
			}
			//debug($xmlToArray);
	}

	function event_summary(){
		$this->load->model('users');
		$checkLoggedInToken = $this->users->checkLoggedInToken( $this->session->userdata('user_id'), $this->session->userdata('loginToken') );
		if( !$checkLoggedInToken ){
			$redirect = base_url().'/user/logout/?session=1';
			redirect($redirect);
		}
		if( $this->session->userdata("event_detail_read") != "1" ){

				$blocked = '1';
				$this->session->unset_userdata('login_id');
				$this->session->unset_userdata('office_id');
				$this->session->unset_userdata('contractarea_id');
				$this->session->unset_userdata('type');
				session_destroy();
				$this->load->library('logger');
				$actual_link = "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
				$this->users->blockUser($blocked,$this->session->userdata('user_id'));
				$this->logger->trigger_log($this->session->userdata('username'),'tried to access restricted page '.$actual_link.'. User account suspeneded ');
				$this->deleteDirectory($this->session->userdata('audioPath'));
				echo '<!DOCTYPE html><html><head><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"><link href="https://fonts.googleapis.com/css?family=Montserrat:400,600" rel="stylesheet"></head><body style="margin:0; padding:0; font-family: Montserrat, sans-serif;"><div style="width:700px; margin:90px auto;"> <div style=" width:680px; border: 10px solid #000; background:#0d1f4f; color:#fff; padding:80px 20px; float:left;"> <span style="font-size:45px; font-weight: 600; float:left; width:100%;"><i class="fa fa-exclamation-triangle" aria-hidden="true"></i> Your account has been temporarily suspended.</span> <span style="font-size: 16px; line-height:26px; float:left; width:100%; padding:30px 0px;">For security reasons, your account has been temporarily suspended. You can contact the Administrator at </span> <span><i class="fa fa-envelope-o" aria-hidden="true"></i> &nbsp;administrator@orbisprotect.com</span> </div></div></body></html>';
				exit;
		}
		//echo 'hi'; exit;
		$this->load->view('system/eventsummary');
	}

	function getReasonList(){
		$conexion = new PDO("informix:host=".$this->config->item('pdo_connect')['host'].";service=".$this->config->item('pdo_connect')['service'].";database=".$this->config->item('pdo_connect')['database'].";server=".$this->config->item('pdo_connect')['server'].";protocol=".$this->config->item('pdo_connect')['protocol'].";EnableScrollableCursors=".$this->config->item('pdo_connect')['EnableScrollableCursors'].";client_locale=".$this->config->item('pdo_connect')['client_locale'].";db_locale=".$this->config->item('pdo_connect')['db_locale'] ,$this->config->item('pdo_connect')['db_user'],$this->config->item('pdo_connect')['db_pass']);
		$sql = "select * from cause where nacoscde = 'F'";
		$prep   = $conexion->prepare($sql);
		$prep->execute();
		$resultTotal = $prep->fetchAll(PDO::FETCH_ASSOC);
		//debug($resultTotal);
		if( !empty($resultTotal) ){
			echo json_encode([ 'error' => 0, 'causes' => $resultTotal ]);
		}else{
			echo json_encode(['error' => 1, 'message' => 'No result found']);
		}
	}

	function getEventSummary($mainID,$groupID,$selectedCause,$startDate,$endDate){
		$conexion = new PDO("informix:host=".$this->config->item('pdo_connect')['host'].";service=".$this->config->item('pdo_connect')['service'].";database=".$this->config->item('pdo_connect')['database'].";server=".$this->config->item('pdo_connect')['server'].";protocol=".$this->config->item('pdo_connect')['protocol'].";EnableScrollableCursors=".$this->config->item('pdo_connect')['EnableScrollableCursors'].";client_locale=".$this->config->item('pdo_connect')['client_locale'].";db_locale=".$this->config->item('pdo_connect')['db_locale'] ,$this->config->item('pdo_connect')['db_user'],$this->config->item('pdo_connect')['db_pass']);

		$startDate = date( 'Y-m-d' , strtotime($startDate));
		$endDate = date( 'Y-m-d' , strtotime($endDate));
		$currentTime =  "23:59:59";

		//$sql = "SELECT customer.name, systrans.netaddr, systrans.commsno, trantype.descr, sumlog.evtime, sumlog.sectime Closed, CASE cause.descr WHEN NULL THEN 'Unassigned Cause' ELSE cause.descr END CASE FROM customer, sumlog, cause, systrans, trantype WHERE customer.linkno IN (SELECT linkno FROM linkacc START WITH linkacc.linkno IN ($groupID) CONNECT BY PRIOR linkacc.linkno=linkacc.parent) AND customer.serialno=sumlog.serialno AND sumlog.evtime >='".$startDate." 00:00:00' AND sumlog.evtime <='".$endDate." 00:00:00' AND sumlog.stcode in ( SELECT stcode FROM eventdef WHERE upper(descr) IN ('MANUAL POSITION','AMBER ALERT','RED ALERT')) AND sumlog.cause=cause.cause AND sumlog.serialno=systrans.serialno AND sumlog.commsno=systrans.commsno AND systrans.transtype=trantype.trantype AND cause.descr='".$selectedCause."' ORDER BY sumlog.evtime";

		//$sql = "SELECT customer.serialno , customer.name, systrans.netaddr, systrans.commsno, trantype.descr, sumlog.evtime, sumlog.sectime Closed, CASE cause.descr WHEN NULL THEN 'Unassigned Cause' ELSE cause.descr END CASE FROM customer, sumlog, cause, systrans, trantype WHERE customer.linkno IN (SELECT linkno FROM linkacc START WITH linkacc.linkno IN ($groupID) CONNECT BY PRIOR linkacc.linkno=linkacc.parent) AND customer.serialno=sumlog.serialno AND sumlog.evtime >='".$startDate." 00:00:00' AND sumlog.evtime <='".$endDate." 00:00:00' AND sumlog.stcode in ( SELECT stcode FROM eventdef WHERE upper(descr) IN ('MANUAL POSITION','AMBER ALERT','RED ALERT')) AND sumlog.cause=cause.cause AND sumlog.serialno=systrans.serialno AND sumlog.commsno=systrans.commsno AND systrans.transtype=trantype.trantype AND cause.descr='".$selectedCause."' ORDER BY sumlog.evtime";

	//	$sql = "SELECT customer.name, systrans.netaddr, systrans.commsno, trantype.descr, sumlog.evtime, sumlog.sectime Closed, CASE cause.descr WHEN NULL THEN 'Unassigned Cause' ELSE cause.descr END CASE FROM customer, sumlog, cause, systrans, trantype WHERE customer.linkno IN (SELECT linkno FROM linkacc START WITH linkacc.linkno IN (20) CONNECT BY PRIOR linkacc.linkno=linkacc.parent) AND customer.serialno=sumlog.serialno AND sumlog.evtime >='2018-11-01 00:00:00' AND sumlog.evtime <='2019-01-04 00:00:00' AND sumlog.stcode in ( SELECT stcode FROM eventdef WHERE upper(descr) IN ('MANUAL POSITION','AMBER ALERT','RED ALERT')) AND sumlog.cause=cause.cause AND sumlog.serialno=systrans.serialno AND sumlog.commsno=systrans.commsno AND systrans.transtype=trantype.trantype AND cause.descr='Lightning' ORDER BY sumlog.evtime";


		if( $selectedCause == 'All' )
		{
		//$sql = "SELECT customer.serialno , customer.name, systrans.netaddr, systrans.commsno, trantype.descr, sumlog.evtime, sumlog.sectime Closed, cause.descr, sumlog.lseqno FROM customer, sumlog, cause, systrans, trantype WHERE customer.linkno IN (SELECT linkno FROM linkacc START WITH linkacc.linkno IN ($groupID) CONNECT BY PRIOR linkacc.linkno=linkacc.parent) AND customer.serialno=sumlog.serialno AND sumlog.evtime >='".$startDate." 00:00:00' AND sumlog.evtime <='".$endDate." 00:00:00' AND sumlog.stcode in ( SELECT stcode FROM eventdef WHERE upper(descr) IN ('MANUAL POSITION','AMBER ALERT','RED ALERT')) AND sumlog.serialno=systrans.serialno AND sumlog.commsno=systrans.commsno AND systrans.transtype=trantype.trantype";

		$sql = "SELECT customer.serialno , customer.name, systrans.netaddr, systrans.commsno, trantype.descr as description, sumlog.evtime,sumlog.sectime Closed, cause.descr as cause_descr, sumlog.lseqno, eventdef.descr as SIGNAL_TYPE FROM customer, sumlog, cause, systrans, trantype, eventdef WHERE customer.linkno IN (SELECT linkno FROM linkacc START WITH linkacc.linkno IN ($groupID) CONNECT BY PRIOR linkacc.linkno=linkacc.parent)AND customer.serialno=sumlog.serialno AND sumlog.evtime >='".$startDate." 00:00:00' AND sumlog.evtime <='".$endDate." " .$currentTime. "' AND sumlog.serialno=systrans.serialno AND sumlog.commsno=systrans.commsno AND systrans.transtype=trantype.trantype AND sumlog.stcode=eventdef.stcode AND upper(eventdef.descr) IN ('MANUAL POSITION','AMBER ALERT','RED ALERT')";
		}
		else{
		//$sql = "SELECT customer.serialno , customer.name, systrans.netaddr, systrans.commsno, trantype.descr, sumlog.evtime, sumlog.sectime Closed, CASE cause.descr WHEN NULL THEN 'Unassigned Cause' ELSE cause.descr END CASE, sumlog.lseqno FROM customer, sumlog, cause, systrans, trantype WHERE customer.linkno IN (SELECT linkno FROM linkacc START WITH linkacc.linkno IN ($groupID) CONNECT BY PRIOR linkacc.linkno=linkacc.parent) AND customer.serialno=sumlog.serialno AND sumlog.evtime >='".$startDate." 00:00:00' AND sumlog.evtime <='".$endDate." 00:00:00' AND sumlog.stcode in ( SELECT stcode FROM eventdef WHERE upper(descr) IN ('MANUAL POSITION','AMBER ALERT','RED ALERT')) AND sumlog.cause=cause.cause AND sumlog.serialno=systrans.serialno AND sumlog.commsno=systrans.commsno AND systrans.transtype=trantype.trantype AND cause.descr='".str_replace( '%20', ' ',  $selectedCause)."' ORDER BY sumlog.evtime";

		$sql = "SELECT customer.serialno , customer.name, systrans.netaddr, systrans.commsno, trantype.descr, sumlog.evtime, sumlog.sectime Closed,CASE cause.descr WHEN NULL THEN 'Unassigned Cause' ELSE cause.descr END CASE, sumlog.lseqno , eventdef.descr as SIGNAL_TYPE FROM customer, sumlog, cause, systrans, trantype , eventdef WHERE customer.linkno IN (SELECT linkno FROM linkacc START WITH linkacc.linkno IN ($groupID) CONNECT BY PRIOR linkacc.linkno=linkacc.parent)AND customer.serialno=sumlog.serialno AND sumlog.evtime >='".$startDate." 00:00:00'AND sumlog.evtime <='".$endDate." " .$currentTime. "' AND sumlog.cause=cause.cause AND sumlog.serialno=systrans.serialno AND sumlog.commsno=systrans.commsno AND systrans.transtype=trantype.trantype AND cause.descr='".str_replace( '%20', ' ',  $selectedCause)."' AND sumlog.stcode=eventdef.stcode AND UPPER(eventdef.descr) IN ('MANUAL POSITION','AMBER ALERT','RED ALERT') ORDER BY sumlog.evtime";

		}

		$prep   = $conexion->prepare($sql);
		$prep->execute();
		$resultTotal = $prep->fetchAll(PDO::FETCH_ASSOC);
		//debug($resultTotal,1);
		if( !empty($resultTotal) ){

				for( $i=0; $i<count($resultTotal); $i++ ){
					$resultTotal[$i]['EVTIME'] = date('D M y H:i:s', strtotime($resultTotal[$i]['EVTIME']));
					if( isset($resultTotal[$i]['CLOSED']) || $resultTotal[$i]['CLOSED'] != '' )
					{
						$resultTotal[$i]['CLOSED'] = date('D M y H:i:s', strtotime($resultTotal[$i]['CLOSED']));
					}
					else{
						$resultTotal[$i]['CLOSED'] = '-';
					}
					$resultTotal[$i]['POPUPTIME'] = date('d M y H:i:s', strtotime($resultTotal[$i]['CLOSED']));
					if( isset($resultTotal[$i]['CASE']) || $resultTotal[$i]['CASE'] == '' )
					{
						$resultTotal[$i]['CASE'] = '-';
					}
				}

			echo json_encode([ 'error' => 0, 'events' => $resultTotal ]);
		}else{
			echo json_encode(['error' => 1, 'message' => 'No result found']);
		}

	}

	function GetLinkAccountContactRequest()
	{
		$url = "http://www.monitorsoft.com/SentinelXS/clsSentinelXS/GetLinkAccountContact";
		$xml = '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope"
		                                               xmlns:cls="http://www.monitorsoft.com/SentinelXS/clsSentinelXS"
		                                                               xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
<soap:Header/>
		<soap:Body>
		  <cls:GetLinkAccountContact>
			<cls:getLinkAccountContactRequest>
					<cls:ServiceVersion>Version_1_111_4</cls:ServiceVersion>
					<cls:UserName>'.encrypt_string($this->session->userdata('sentinel_username'),'d').'</cls:UserName>
					<cls:Password>'.encrypt_string($this->session->userdata('sentinel_password'),'d').'</cls:Password>
					<cls:LinkAccountNumber>'.$this->input->post('linkAccountIdentifier').'</cls:LinkAccountNumber>
					<cls:LinkAccountContactIdentifier>'.$this->input->post('linkAccountContactIdentifier').'</cls:LinkAccountContactIdentifier>
			</cls:getLinkAccountContactRequest>
			</cls:GetLinkAccountContact>
		</soap:Body>
		</soap:Envelope>';
		$curl_send = $this->curl->curl_send($xml, $url);
		$xmlToArray = $this->curl->xmlToArray($curl_send);
		if( !empty($xmlToArray) )
		{
			$data = $xmlToArray['GetLinkAccountContactResponse']['GetLinkAccountContactResult']['LinkAccountContactInformation'];
			echo json_encode([ 'error' => 0, 'data' => $data ]);
		}
		//debug($xmlToArray);
	}

	function suspend_user()
	{
		$this->load->model('users');
		if( $this->input->post('select_limit') !="" )
		{
			$data['current_limit'] = $this->input->post('select_limit');
		}
		else
		{
			$data['current_limit'] = 25;
		}

		$config = [
			'base_url' 			=> site_url("systems/suspend_user"),
			'total_rows'		=> count($this->users->count_lwd()),
			'per_page'			=> $data['current_limit'],
			'full_tag_open'		=> '<ul class="pagination pull-right">',
			'full_tag_close'	=> '</ul>',
			'first_tag_open'	=> '<li>',
			'first_tag_close'	=> '</li>',
			'last_tag_open'		=> '<li>',
			'last_tag_close'	=> '</li>',
			'cur_tag_open'		=> '<li class="active"><a>',
			'cur_tag_close'		=> '</a></li>',
			'num_tag_open'		=> '<li>',
			'num_tag_close'		=> '</li>',
			'next_tag_open'		=> '<li>',
			'next_tag_close'	=> '</li>',
			'prev_tag_open'		=> '<li>',
			'prev_tag_close'	=> '</li>'
		];

		$data['user_list'] = $this->users->get_system_users_list_admin($config['per_page'], $this->uri->segment(3));
		$this->pagination->initialize($config);
		$data['links'] = $this->pagination->create_links();
		$this->load->view('system/suspendUser',$data);
	}

	function globalescalation()
	{
		$this->load->model('users');
		$checkLoggedInToken = $this->users->checkLoggedInToken( $this->session->userdata('user_id'), $this->session->userdata('loginToken') );
		if( !$checkLoggedInToken ){
			$redirect = base_url().'/user/logout/?session=1';
			redirect($redirect);
		}

		$this->load->view('system/globalescalation');
	}

	public function generatePortalUserToken()
	{

		$token = generateToken('portalUserToken');
		echo $token;
	}


	public function cctvCamera()
	{

		$this->load->view('system/cctv');

	}

} //class end
