<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Welcome extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	public function index()
	{
		//$this->load->view('welcome_message');
		phpinfo();
	}

	function email_user()
	{
		 $this->load->library('email');
		 $this->email->from('jatin@iivo.io', 'Anil Labs');
        /*$data = array(
             'userName'=> 'Anil Kumar Panigrahi'
                 );*/

		$this->email->to('gunjan@iivo.io');  // replace it with receiver mail id
		$this->email->subject('test template'); // replace it with relevant subject

		$body = $this->load->view('test/email.php');
		$this->email->message($body);
		$this->email->send();
	}

	function checking(){
		$this->load->model('users');

			$get_report_data['export_data'] = $this->users->get_report_data();

			//debug($get_report_data,1);

			$this->load->view('report/alarm_activation',$get_report_data);

	}

	function getPdf(){

			$this->load->model('users');

			$get_report_data['export_data'] = $this->users->get_report_data();

			$html = $this->load->view('report/alarm_activation',$get_report_data,true);


			$this->load->library('pdf');

			ob_start();

			 $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
			 // set document information
			 $pdf->SetCreator(PDF_CREATOR);
			 $pdf->SetAuthor('Alarm Activation Report');
			 $pdf->SetTitle('Alarm Activation Report');
			 $pdf->SetSubject('Alarm Activation Report');
			 $pdf->SetKeywords('Alarm Activation Report');

			 // set default header data
			// $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

			 // set header and footer fonts
			/// $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
			/// $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

			 $pdf->SetPrintHeader(false);
			 $pdf->SetPrintFooter(false);

			 // set default monospaced font
			 $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

			 // set margins
			 //$pdf->SetMargins(PDF_MARGIN_LEFT, 0, PDF_MARGIN_RIGHT);
			// $pdf->SetHeaderMargin(0);
			 ///$pdf->SetFooterMargin(0);

			 // set auto page breaks
			 //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
			 $pdf->SetAutoPageBreak(TRUE, 0);

			 // set image scale factor
			 $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

			 // set some language-dependent strings (optional)
			 if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
					 require_once(dirname(__FILE__).'/lang/eng.php');
					 $pdf->setLanguageArray($l);
			 }

			 // set font
			 $pdf->SetFont('dejavusans', '', 10);

			 // add a page
			 $pdf->AddPage();

			 // output the HTML content
			 //echo '---'.$SessionData; exit;
			 $pdf->writeHTML($html, true, false, true, false, '');

			 // reset pointer to the last page
			 $pdf->lastPage();
			 ob_end_clean();
			 //Close and output PDF document
			 $pdf->Output('Alarm Activation Report '.date('H:i:s').'.pdf', 'D');
	}

	function escalation_summary_export($format){

		$this->load->model('users');
		$get_escalation_summary_data = $this->users->get_escalation_summary_data();

		for ($i=0; $i < count($get_escalation_summary_data) ; $i++) {
				$get_escalation_summary_data[$i]['child_data_new'] = unserialize($get_escalation_summary_data[$i]['child_data']);
		}

		$data['Individual'] = 	$get_escalation_summary_data;
		$data['Global'] = 	$this->users->get_global_escalation_summary_data();

		if( $format == 'pdf' ){

			$html = $this->load->view('report/exportPdf',$data,true);

			$this->load->library('pdf');

			ob_start();

			 $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
			 // set document information
			 $pdf->SetCreator(PDF_CREATOR);
			 $pdf->SetAuthor('Ecalation Summary Report');
			 $pdf->SetTitle('Ecalation Summary Report');
			 $pdf->SetSubject('Ecalation Summary Report');
			 $pdf->SetKeywords('Ecalation Summary Report');

			 // set default header data
			// $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

			 // set header and footer fonts
			/// $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
			/// $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

			 $pdf->SetPrintHeader(false);
			 $pdf->SetPrintFooter(false);

			 // set default monospaced font
			 $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

			 // set margins
			 //$pdf->SetMargins(PDF_MARGIN_LEFT, 0, PDF_MARGIN_RIGHT);
			// $pdf->SetHeaderMargin(0);
			 ///$pdf->SetFooterMargin(0);

			 // set auto page breaks
			 //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
			 $pdf->SetAutoPageBreak(TRUE, 0);

			 // set image scale factor
			 $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

			 // set some language-dependent strings (optional)
			 if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
					 require_once(dirname(__FILE__).'/lang/eng.php');
					 $pdf->setLanguageArray($l);
			 }

			 // set font
			 $pdf->SetFont('dejavusans', '', 10);

			 // add a page
			 $pdf->AddPage();

			 // output the HTML content
			 //echo '---'.$SessionData; exit;
			 $pdf->writeHTML($html, true, false, true, false, '');

			 // reset pointer to the last page
			 $pdf->lastPage();
			 ob_end_clean();
			 //Close and output PDF document
			 $pdf->Output('Ecalation Summary Report'.date('H:i:s').'.pdf', 'D');
		}

		/* if export in excel */
		else if( $format == 'excel' )
		{

			$get_escalation_summary_data = $this->users->get_escalation_summary_data_excel();

			$m=0;
			for ($i=0; $i < count($get_escalation_summary_data) ; $i++) {
				$get_escalation_summary_data[$m] = unserialize($get_escalation_summary_data[$i]['child_data']);
				$m++;
			}

			$this->load->library('excel');
			//remove previous file
			if( file_exists($this->session->userdata('audioPath').'/reports/Ecalation Summary Report.xlsx') )
			{
				unlink($this->session->userdata('audioPath').'/reports/Ecalation Summary Report.xlsx');
			}

			$fileName = 'Ecalation Summary Report.xlsx';
	        //$empInfo = $this->export->employeeList();
	        $objPHPExcel = new PHPExcel();
	        $objPHPExcel->setActiveSheetIndex(0);
	        // set Header
	        $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'PRIORITY');
			$objPHPExcel->getActiveSheet()->SetCellValue('B1', 'CONTACT NAME');
			$objPHPExcel->getActiveSheet()->SetCellValue('C1', 'MOBILE');
			$objPHPExcel->getActiveSheet()->SetCellValue('D1', 'BUSINESS');
			$objPHPExcel->getActiveSheet()->SetCellValue('E1', 'HOME');
			$objPHPExcel->getActiveSheet()->SetCellValue('F1', 'OTHER');
			$objPHPExcel->getActiveSheet()->SetCellValue('G1', 'EMAIL');
			$objPHPExcel->getActiveSheet()->SetCellValue('H1', 'CONTACT TYPE');

	        // set Row
	        $rowCount = 2;

	        for( $i=0; $i<count($get_escalation_summary_data); $i++ )
	        {

	        		for( $m=0; $m<count($get_escalation_summary_data[$i]); $m++ )
	        		{


	        			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $get_escalation_summary_data[$i][$m]['PRIORITY']);
	        			$objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $get_escalation_summary_data[$i][$m]['NAME']);
	        			$objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, $get_escalation_summary_data[$i][$m]['MOBILE']);
	        			$objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, $get_escalation_summary_data[$i][$m]['WORK1']);
	        			$objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, $get_escalation_summary_data[$i][$m]['PHONE']);
	        			$objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, $get_escalation_summary_data[$i][$m]['PAGER']);
	        			$objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount, $get_escalation_summary_data[$i][$m]['EMAIL']);
	        			$objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, $get_escalation_summary_data[$i][$m]['USERTYPE']);
	        				$rowCount++;
	        		}
	        }


	        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
					// download file
	        $report_path = $this->session->userdata('audioPath').'/reports/';
	         if(!is_dir($report_path))
	        {
	        	mkdir($report_path);	
	        }
			chmod($report_path, 0777);
	        $objWriter->save($report_path.$fileName);
	        header("Content-Type: application/vnd.ms-excel");
	        redirect(base_url().'assets/'.$this->session->userdata('login_name').'/reports/'.$fileName);

		}
		else{
			echo '<h3>Invalid Request Format</h3>';
		}
	}

	function signalHistoryExport($format){

		$this->load->model('users');
		$getSignalHistoryExport = $this->users->getSignalHistoryExport();
		$data['export_data'] = $getSignalHistoryExport;
		if( $format == 'pdf' ){
			$html = $this->load->view('report/signalHistoryPdf',$data,true);
			$this->load->library('pdf');

			ob_start();

			 $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
			 // set document information
			 $pdf->SetCreator(PDF_CREATOR);
			 $pdf->SetAuthor('Signal History Report');
			 $pdf->SetTitle('Signal History Report');
			 $pdf->SetSubject('Signal History Report');
			 $pdf->SetKeywords('Signal History Report');

			 $pdf->SetPrintHeader(false);
			 $pdf->SetPrintFooter(false);

			 // set default monospaced font
			 $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
			 $pdf->SetAutoPageBreak(TRUE, 0);

			 // set image scale factor
			 $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

			 // set some language-dependent strings (optional)
			 if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
					 require_once(dirname(__FILE__).'/lang/eng.php');
					 $pdf->setLanguageArray($l);
			 }

			 // set font
			 $pdf->SetFont('dejavusans', '', 8);

			 // add a page

			 $pdf->AddPage();
			 $pdf->writeHTML($html, true, false, true, false, '');

			 // reset pointer to the last page
			 $pdf->lastPage();
			 ob_end_clean();
			 //Close and output PDF document
			 $pdf->Output('Signal History Report'.date('H:i:s').'.pdf', 'I');
		}
		else if( $format == 'excel' )
		{
			$this->load->library('excel');
			//remove previous file
			if( file_exists($this->session->userdata('audioPath').'/reports/signalHistoryReport.xlsx') )
			{
				unlink($this->session->userdata('audioPath').'/reports/signalHistoryReport.xlsx');
			}


		  	$fileName = 'signalHistoryReport.xlsx';
	        //$empInfo = $this->export->employeeList();
	        $objPHPExcel = new PHPExcel();
	        $objPHPExcel->setActiveSheetIndex(0);
	        // set Header
	        $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Time');
	        $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Name');
	        $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Mobile Number');
	        $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Signal Type');
	        $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Address');
	        $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Cause');
	        
	        $objPHPExcel->getActiveSheet()->getStyle('A1:F1')->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A1:F1')->getFont()->setSize(12);
			$objPHPExcel->getActiveSheet()->getStyle('A1:F1')->applyFromArray(
								array(
								'fill' => array(
									'type' => PHPExcel_Style_Fill::FILL_SOLID,
									'color' => array('rgb' => 'fbf128')
								)
							)
						);
			$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(false);
			$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
			
			$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(false);
			$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
			
			$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(false);
			$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
			
			$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(false);
			$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
			
			$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(false);
			$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(60);
			
			
			$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(false);
			$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
	        
	        
	        
	        // set Row
	        $rowCount = 2;
	        foreach ($getSignalHistoryExport as $element) {
	            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $element['EVTIME']);
	            $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $element['NAME']);
	            //$objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $element['CONTRACT']);
	           // $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $element['OFFICE']);
	            $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $element['phone']);
	            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $element['DESCR']);
	            //$objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $element['LATITUDE']);
	            //$objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $element['LONGITUDE']);
	            $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $element['address']);
	            $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $element['cause']);
	            $rowCount++;
	        }
	        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
					// download file
	        $report_path = $this->session->userdata('audioPath').'/reports/';
	        if(!is_dir($report_path))
	        {
	        	mkdir($report_path);	
	        }
	        
			chmod($report_path, 0777);
	        $objWriter->save($report_path.$fileName);
	        header("Content-Type: application/vnd.ms-excel");
	        redirect(base_url().'assets/'.$this->session->userdata('login_name').'/reports/'.$fileName);
		}
		else{
			echo '<h3>Invalid Request Format</h3>';
		}
	}


	function userActivityReport()
	{
		$this->load->model('users');
		
		$alphas = range('A', 'Z');
		$format = $this->input->post('typeToExport') ; 
		$columnsToSearch = $this->input->post('columNamesToExport') ; 
		$explodeSearch    = explode(',', $columnsToSearch) ;
		if (isset($explodeSearch[0]) && $explodeSearch[0]) {
			//$haveExtraColumns = true;
			array_unshift($explodeSearch,"CONTRACT","OFFICE","USERNAME", "serialno");
		} else {
			//$haveExtraColumns = false;
			$explodeSearch = ["CONTRACT","OFFICE","USERNAME", "serialno"] ;
		}
		$countExpodeSearch = count($explodeSearch) ;
		$headingOptions = 'A1:' . $alphas[$countExpodeSearch-1] . '1';
		//echo $headingOptions ;
		//'A1:K1'
		//debug($explodeSearch, 1) ;
		//die;
		$getUserActivityReport = $this->users->getUserActivityReport($explodeSearch);
		//debug($getUserActivityReport,1);
		if( $format =='pdf' )
		{
			$data['export_data'] = $getUserActivityReport;
			$data['columnData']  = $explodeSearch;
			$html = $this->load->view('report/userActivityPdf',$data,true);
			$this->load->library('pdf');

			ob_start();

			 $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
			 // set document information
			 $pdf->SetCreator(PDF_CREATOR);
			 $pdf->SetAuthor('User Activity Report');
			 $pdf->SetTitle('User Activity Report');
			 $pdf->SetSubject('User Activity Report');
			 $pdf->SetKeywords('User Activity Report');

			 $pdf->SetPrintHeader(false);
			 $pdf->SetPrintFooter(false);

			 // set default monospaced font
			 $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
			 $pdf->SetAutoPageBreak(TRUE, 0);

			 // set image scale factor
			 $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

			 // set some language-dependent strings (optional)
			 if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
					 require_once(dirname(__FILE__).'/lang/eng.php');
					 $pdf->setLanguageArray($l);
			 }

			 // set font
			 $pdf->SetFont('dejavusans', '', 8);

			 // add a page

			 $pdf->AddPage();
			 $pdf->writeHTML($html, true, false, true, false, '');

			 // reset pointer to the last page
			 $pdf->lastPage();
			 ob_end_clean();
			 //Close and output PDF document
			 $pdf->Output('User Activity Report '.date('H:i:s').'.pdf', 'I');
		}
		else if( $format == 'excel' )
		{
			$this->load->library('excel');
			//remove previous file
			if( file_exists($this->session->userdata('audioPath').'/reports/userActivityReport.xlsx') )
			{
				unlink($this->session->userdata('audioPath').'/reports/userActivityReport.xlsx');
			}


		  	//$fileName = 'userActivityReport.xlsx';
		  	$fileName = 'User_Activity_Report_'.date('His').'.xlsx';
	        //$empInfo = $this->export->employeeList();
	        $objPHPExcel = new PHPExcel();
	        $objPHPExcel->setActiveSheetIndex(0);
	        // set Header
	         /* To set the value of heading starts*/
	         
	         $counterHeading = 0 ;
	         foreach ($explodeSearch as $dataHeading) {
				$objPHPExcel->getActiveSheet()->SetCellValue($alphas[$counterHeading] . '1', strtoupper(str_replace("_"," ",$dataHeading)));
				$counterHeading++;
			 }
			 
			 /* To set the value of heading ends*/
			 
			 /* To set theheading font & color starts */
			 
	         $objPHPExcel->getActiveSheet()->getStyle($headingOptions)->getFont()->setBold(true);
			 $objPHPExcel->getActiveSheet()->getStyle($headingOptions)->getFont()->setSize(12);
			 $objPHPExcel->getActiveSheet()->getStyle($headingOptions)->applyFromArray(
							array(
							'fill' => array(
								'type' => PHPExcel_Style_Fill::FILL_SOLID,
								'color' => array('rgb' => 'fbf128')
							)
						)
					);
					
			/* To set theheading font & color ends */	
			
			/* To set the heading colum width and freeze the heading starts */	
			
			 for ($i=0; $i<$countExpodeSearch ; $i++) {
				$objPHPExcel->getActiveSheet()->getColumnDimension($alphas[$i])->setAutoSize(false);
				$objPHPExcel->getActiveSheet()->getColumnDimension($alphas[$i])->setWidth(30);
			 }
	         $objPHPExcel->getActiveSheet()->freezePane($alphas[$countExpodeSearch].'2');
	         
	         /* To set the heading colum width and freeze the heading ends */
	         
	        // set Row
	        $rowCount = 2;
	        
	        /* To set the column values starts */
	        
	        foreach ($getUserActivityReport as $element) {
	            for($i = 0; $i<$countExpodeSearch; $i++) {
					$objPHPExcel->getActiveSheet()->SetCellValue($alphas[$i] . $rowCount, $element[$explodeSearch[$i]]);
				}
	            $rowCount++;
	        }
	        
	        /* To set the column values ends */
	        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
					// download file
	        $report_path = $this->session->userdata('audioPath').'/reports/';
	        if(!is_dir($report_path))
	        {
	        	mkdir($report_path);	
	        }
			chmod($report_path, 0777);
	        $objWriter->save($report_path.$fileName);
	        header("Content-Type: application/vnd.ms-excel");
	        redirect(base_url().'assets/'.$this->session->userdata('login_name').'/reports/'.$fileName);
		}
		else{
			echo '<h3>Invalid Request Format</h3>';
		}
	}

	function dummy_mo()
	{
		$this->load->helper('captcha');
		$original_string = array_merge(range(0,9), range('a','z'), range('A', 'Z'));
			 $original_string = implode("", $original_string);
			 $captcha = substr(str_shuffle($original_string), 0, 6);

				//Field validation failed.  User redirected to login page
			 $vals = array(
							 'word' => $captcha,
							 'img_path' => './captcha/',
							 'img_url' => 'http://mycodeignitor.org/captcha/',
							 'font_path' => BASEPATH.'fonts/texb.ttf',
							 'img_width' => 150,
							 'img_height' => 50,
							 'expiration' => 7200
			 );

			 $cap = create_captcha($vals);
			 $data['image'] = $cap['image'];
			 echo '<img src="'.$cap['image'].'.jpg">';
	}
	
	function downloadUserDetailsAdmin(){
		
		
		
		$linkAccountType   = $this->input->post('linkAccountTypeform') ; 
		$linkAccountNumber = $this->input->post('linkAccountNumberForm');
		
		if ( !$linkAccountType && !$linkAccountNumber ) {
		
			exit("Invalid data.") ;
		
		} 
		
		$this->load->model('users');
		//$userDetailFolderPath = "/var/www/html/orbis_lwp_portal/assets/userdetailsadmin/" ;
		$userDetailFolderPath = $this->config->item('directoryPath') . 'userdetailsadmin/' ;
		//$getUserActivityReport = $this->users->getUserDetailsReport();
		$getUserActivityReport = $this->users->getUserDetailsReportNew($linkAccountType, $linkAccountNumber);
		
		$this->load->library('excel');
		//remove previous file
		if( file_exists($userDetailFolderPath.'/userDetailsReport.xlsx') )
		{
			unlink($userDetailFolderPath.'/userDetailsReport.xlsx');
		}


		$fileName = 'userDetailsReport.xlsx';
		$objPHPExcel = new PHPExcel();
		$objPHPExcel->setActiveSheetIndex(0);
		// set Header
		$objPHPExcel->getActiveSheet()->SetCellValue('A1', 'User Name');
		$objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Forename');
		$objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Surname');
		$objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Email');
		$objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Cost Centre');
		$objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Contract Area');
		$objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Office');
		$objPHPExcel->getActiveSheet()->SetCellValue('H1', 'User Status');
		$objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Account Status');
		$objPHPExcel->getActiveSheet()->getStyle('A1:I1')->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('A1:I1')->getFont()->setSize(12);
		$objPHPExcel->getActiveSheet()->getStyle('A1:I1')->applyFromArray(
							array(
							'fill' => array(
								'type' => PHPExcel_Style_Fill::FILL_SOLID,
								'color' => array('rgb' => 'fbf128')
							)
						)
					);
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
		
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
		
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
		
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
		
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
		
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
		
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
		
		$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
		
		$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(20);
		
		$objPHPExcel->getActiveSheet()->freezePane('J2');
		
		$rowCount = 2;
		foreach ($getUserActivityReport as $element) {
			
			$costcentrename 	 =  ( $element['costcentrename'] == "0" ? "-" : $element['costcentrename']) ;
			$contractareaname	 =  ( $element['contractareaname'] == "0" ? "-" : $element['contractareaname']);
			$officename 		 =  ( $element['officename'] == "0" ? "-" : $element['officename']);
			
			if($element['user_status'] == '1'){
                    $userStatus = "Active";
            } else {
					$userStatus = "Disabled";
			}
			
			
			if($element['user_block'] == '0'){
				$accountStatus = "Active" ;
			} else {
			
				$accountStatus = "Suspended" ;
			}
			
			$objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $element['username']);
			$objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $element['first_name']);
			$objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $element['sur_name']);
			$objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $element['email']);
			$objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $costcentrename);
			$objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $contractareaname);
			$objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $officename);
			$objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $userStatus);
			$objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $accountStatus);
			$rowCount++;
		}
		$objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
		if(!is_dir($userDetailFolderPath))
		{
			mkdir($userDetailFolderPath);	
		}
		chmod($userDetailFolderPath, 0777);
		$objWriter->save($userDetailFolderPath.$fileName);
		header("Content-Type: application/vnd.ms-excel");
		redirect(base_url().'assets/userdetailsadmin/'.$fileName);
	}
	
	
	//Download Excel/PDF Event detail summary
	
	// New Event summary query functionality for search filters.
	
	function downloadEventDetailSummary(){
		
		$userLevel 			= $this->input->post('currentlyHierachySelected'); 
		$groupID   			= $this->input->post('currentlyHierachySelectedID');
		$startDate 			= $this->input->post('startDateToDownload');
		$endDate   			= $this->input->post('endDateToDownload');
		$searchName   		= $this->input->post('searchNameValue');
		$searchserialNumber = $this->input->post('searchserialNumberValue');
		$searchtypeSignal   = $this->input->post('signalTypeLength');
		$format				= $this->input->post('formatToDownload');
		
		//~ $userLevel 			= "CC"; 
		//~ $groupID   			= "43806";
		//~ $startDate 			= "22-05-2020";
		//~ $endDate   			= "22-06-2020";
		//~ $searchName   		= $this->input->post('searchName');
		//~ $searchserialNumber = $this->input->post('searchserialNumber');
		//~ $searchtypeSignal   = json_decode($this->input->post('searchtypeSignal'));
		//~ $format				= "pdf" ;
		
		
		
		if (!$userLevel && !$groupID && !$startDate && !$endDate) {
		
			echo "Invalid request." ;
			exit;
		}
		
		
		$conexion = new PDO("informix:host=".$this->config->item('pdo_connect')['host'].";service=".$this->config->item('pdo_connect')['service'].";database=".$this->config->item('pdo_connect')['database'].";server=".$this->config->item('pdo_connect')['server'].";protocol=".$this->config->item('pdo_connect')['protocol'].";EnableScrollableCursors=".$this->config->item('pdo_connect')['EnableScrollableCursors'].";client_locale=".$this->config->item('pdo_connect')['client_locale'].";db_locale=".$this->config->item('pdo_connect')['db_locale'] ,$this->config->item('pdo_connect')['db_user'],$this->config->item('pdo_connect')['db_pass']);

		$startDate = date( 'Y-m-d' , strtotime($startDate));
		$endDate = date( 'Y-m-d' , strtotime($endDate));
		$currentTime =  "23:59:59";
		
		$sql = "";
			
		$sql .= "SELECT customer.name, systrans.netaddr, customer.serialno, sumlog.evtime, eventdef.descr, link_OF.name as linkofname,  sumlog.lseqno as LSEQNO, link_CA.name as linkcaname, link_CC.name as linkccname, 
		 (select replace(replace(evstring,'A:1 ',''), 'T:Orbis Red Alert(1) ','') from detlog where serialno = sumlog.serialno and lseqno = sumlog.lseqno and dseqno = (select min(dseqno) from detlog where serialno = sumlog.serialno and lseqno = sumlog.lseqno and catag = 34)) as location
		FROM
		sumlog, customer, eventdef, systrans, linkacc link_OF, linkacc link_CA, linkacc link_CC, linkacc link_L4
		WHERE
		sumlog.serialno = customer.serialno and sumlog.stcode = eventdef.stcode  and sumlog.serialno = systrans.serialno and sumlog.commsno = systrans.commsno
		and customer.linkno = link_OF.linkno and link_OF.parent = link_CA.linkno and link_CA.parent = link_CC.linkno and link_CC.parent = link_L4.linkno" ;
		
		if ($searchtypeSignal) {
			//$searchtypeSignal 	= "'". implode("', '", $searchtypeSignal) ."'";
			$sql .= " AND sumlog.stcode in ($searchtypeSignal)";
		} else{
			$sql .= " AND sumlog.stcode in (991,992,993,994,995,984,985,986,1277,1278,1752,1753,1953,1969,2001,2002,2008,2009)" ;
		}
		
		$sql .= " and sumlog.evtype IN (1,0) and link_$userLevel.linkno = $groupID and sumlog.evtime >= '".$startDate." 00:00:00' and sumlog.evtime < '".$endDate." " .$currentTime. "'";
		
		if ( $searchName ) {
			$sql .= " and customer.name='".$searchName."'";
		}
		
		if ( $searchserialNumber ) {
			$sql .= " and customer.serialno='".$searchserialNumber."'";
		}
		
		 $sql .= " order by sumlog.evtime DESC" ;


		$prep   = $conexion->prepare($sql);
		$prep->execute();
		$resultTotal = $prep->fetchAll(PDO::FETCH_ASSOC);
		//debug($resultTotal,1);
		if( !empty($resultTotal) ){
			
			if( $format =='pdf' )
			{
				$data['resultTotal'] = $resultTotal;
				$html = $this->load->view('report/event_detail_summary_pdf',$data,true);
				$this->load->library('pdf');

				ob_start();

				 $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
				 // set document information
				 $pdf->SetCreator(PDF_CREATOR);
				 $pdf->SetAuthor('Event Detail Summary');
				 $pdf->SetTitle('Event Detail Summary');
				 $pdf->SetSubject('Event Detail Summary');
				 $pdf->SetKeywords('UEvent Detail Summary');

				 $pdf->SetPrintHeader(false);
				 $pdf->SetPrintFooter(false);

				 // set default monospaced font
				 $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
				 $pdf->SetAutoPageBreak(TRUE, 0);

				 // set image scale factor
				 $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

				 // set some language-dependent strings (optional)
				 if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
						 require_once(dirname(__FILE__).'/lang/eng.php');
						 $pdf->setLanguageArray($l);
				 }

				 // set font
				 $pdf->SetFont('dejavusans', '', 8);

				 // add a page

				 $pdf->AddPage();
				 $pdf->writeHTML($html, true, false, true, false, '');

				 // reset pointer to the last page
				 $pdf->lastPage();
				 ob_end_clean();
				 //Close and output PDF document
				 $pdf->Output('Event Detail Summary '.date('H:i:s').'.pdf', 'I');
			}
			elseif( $format == 'excel' )
			{
				$this->load->library('excel');
				
				$fileName = 'Event_Detail_Summary_'.date('His').'.xlsx';
				
				$objPHPExcel = new PHPExcel();
				$objPHPExcel->setActiveSheetIndex(0);
				// set Header
				$objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Username');
				$objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Mobile Number');
				$objPHPExcel->getActiveSheet()->SetCellValue('C1', 'DateTime');
				$objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Signal Type');
				$objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Address');
				
				
				$objPHPExcel->getActiveSheet()->getStyle('A1:E1')->getFont()->setBold(true);
				$objPHPExcel->getActiveSheet()->getStyle('A1:E1')->getFont()->setSize(12);
				$objPHPExcel->getActiveSheet()->getStyle('A1:E1')->applyFromArray(
									array(
									'fill' => array(
										'type' => PHPExcel_Style_Fill::FILL_SOLID,
										'color' => array('rgb' => 'fbf128')
									)
								)
							);
				$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(false);
				$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
				
				$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(false);
				$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
				
				$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(false);
				$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
				
				$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(false);
				$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
				
				$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(false);
				$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(60);
				
				//$objPHPExcel->getActiveSheet()->freezePane('F2');
				
				$rowCount = 2;
				foreach ($resultTotal as $element) {
					
					//To get the Address by removing lat/long and other things
					
					if( isset($element['LOCATION']) || $element['LOCATION'] != '' )
					{
						//$resultTotal[$i]['LOCATION'] = $resultTotal[$i]['LOCATION'];
						if ( strpos($element['LOCATION'],"Lat,Long=") ) {
							
							$string = $element['LOCATION'] ;
							$explode = explode(" ", $string) ; 
							
							$nameWithoutLatLong = str_replace(end($explode),"",$string);
							
							$address = $nameWithoutLatLong ;
							
						
						} else {
							$address = $element['LOCATION'] ;
						}
						
					}
					else{
						$address = '-';
					}
					
					$objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $element['NAME']);
					$objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $element['NETADDR']);
					$objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, date('d F y H:i:s', strtotime($element['EVTIME'])));
					$objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $element['DESCR']);
					$objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $address);
					$rowCount++;
				}
				
				$objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
				
				
				$report_path = $this->session->userdata('audioPath').'/reports/';
				
				 if(!is_dir($report_path))
				 {
						mkdir($report_path);	
				 }
				
				
				chmod($report_path, 0777);
				$objWriter->save($report_path.$fileName);
				header("Content-Type: application/vnd.ms-excel");
				redirect(base_url().'assets/'.$this->session->userdata('login_name').'/reports/'.$fileName);
			
				// Excel part ends
			}  else {
				echo '<h3>Invalid Request Format</h3>';
				exit;
			}
			
		}else{
			echo "No result found." ;
			exit;
		}

	}
	
	public function downloadLogs() {
		
		$orderbyCoumnName 			= $this->input->post('orderbyCoumnName'); 
		$orderbyCoumnDirection   	= $this->input->post('orderbyCoumnDirection');
		$searchNameValue 			= $this->input->post('searchNameValue');
		$format						= $this->input->post('formatToDownload');
		
		if ( empty($format	) ) {
			exit("Invalid request format") ;
		}
		
		
		$this->load->model('event');
		
		if( !empty($searchNameValue) ) {
		
			$resultTotal = $this->event->getExportDataWithSearch($orderbyCoumnName, $orderbyCoumnDirection, $searchNameValue) ;
			
			
		} else {
		
			$resultTotal = $this->event->getExportDataWithOutSearch($orderbyCoumnName, $orderbyCoumnDirection) ;
		}
		
		
		
		//debug($resultTotal, 1) ;
		
		if ($resultTotal) {
			
				$this->load->library('excel');
				
				$fileName = 'Logs_'.date('His').'.xlsx';
				
				$objPHPExcel = new PHPExcel();
				$objPHPExcel->setActiveSheetIndex(0);
				// set Header
				$objPHPExcel->getActiveSheet()->SetCellValue('A1', 'IP Address');
				$objPHPExcel->getActiveSheet()->SetCellValue('B1', 'User Name');
				$objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Activity Logged');
				$objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Log Time');
				
				
				$objPHPExcel->getActiveSheet()->getStyle('A1:D1')->getFont()->setBold(true);
				$objPHPExcel->getActiveSheet()->getStyle('A1:D1')->getFont()->setSize(12);
				$objPHPExcel->getActiveSheet()->getStyle('A1:D1')->applyFromArray(
									array(
									'fill' => array(
										'type' => PHPExcel_Style_Fill::FILL_SOLID,
										'color' => array('rgb' => 'fbf128')
									)
								)
							);
				$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(false);
				$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
				
				$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(false);
				$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
				
				$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(false);
				$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
				
				$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(false);
				$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
				
				$rowCount = 2;
				foreach ($resultTotal as $element) {
					
					
					$objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $element['ip_address']);
					$objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $element['log_name']);
					$objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $element['logMessage']);
					$objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $element['create_at']);
					$rowCount++;
				}
				
				$objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
				
				
				$report_path = $this->session->userdata('audioPath').'/reports/';
				
				 if(!is_dir($report_path))
				 {
						mkdir($report_path);	
				 }
				
				
				chmod($report_path, 0777);
				$objWriter->save($report_path.$fileName);
				header("Content-Type: application/vnd.ms-excel");
				redirect(base_url().'assets/'.$this->session->userdata('login_name').'/reports/'.$fileName);
			
				// Excel part ends
			
		
		} else {
			echo "There is some problem, please try again later" ;
		}
		
		
		
		
	
	}
	
	

}
