<?php

Class Pushnotifications extends CI_Controller
{
	private static $API_ACCESS_KEY = 'AIzaSyD4E2D3IJ3ONbd96-qzIl4JgmjJMzHy1PY';

	function __construct()
	{
		parent::__construct();
		$this->load->library('session');
		$this->load->helpers('url');
		$this->load->model('users');
	}

	public function getOTATemplateSettings() {
		$costCenterId   = '' ;
		$userId  	    = '' ;
		$haveData		=  true;
		$selectHTML 	=  "" ;
		if( $this->session->userdata('type') != 'superadmin' ) {

			if ( $this->session->userdata('costcenterID') != '' ) {
				$costCenterId = $this->session->userdata('costcenterID') ;
				$userId 	  = $this->session->userdata('user_id') ;
			} else {
				echo json_encode([ 'error' => 1, 'message' => 'No Cost Center Found.' ]);
				exit;
			}

		} else {
			$userId = 'superadmin' ;
		}
		$dataModel['costCenterId']  = $costCenterId;
		$dataModel['userId'] 		= $userId;
		$getOTATemplateSettings = $this->users->getOTATemplateSettings($dataModel) ;
		$templateId = $this->input->post('templateId') ;
		//debug($getOTATemplateSettings) ;
		if ( $getOTATemplateSettings ) {
			if ($templateId) {
				$idToCheck = $templateId ;
			} else {
				$idToCheck =  $getOTATemplateSettings[0]['id'] ;
			}
			$error = 0 ;
			$message = "Data Found" ;
			foreach ($getOTATemplateSettings as $data) {
				if( $this->session->userdata('type') == 'superadmin' ) {
					$templateFor =  ( $data['cost_centre_name'] ? '(Assigned to '. $data['cost_centre_name'] .')' : '(Not Assigned)') ;
				} else {
					$templateFor = "" ;
				}
				$selectHTML .= '<option value="' . $data['id']  .'" ' . ( $data['id'] == $idToCheck ? 'selected' : '') . '>' . $data['device_settings_name'] . $templateFor . '</option>';

				if ( $data['id'] == $idToCheck ) {
					if ($data['fall_detect_senstivity'] == 1){
						$fall_detect_senstivity = '1 (Low)' ;
					} elseif($data['fall_detect_senstivity'] == 5) {
						$fall_detect_senstivity = '5 (High)' ;
					} else {
						$fall_detect_senstivity = $data['fall_detect_senstivity'] ;
					}
					
					$dynamicTextActivityBasedLocation = "" ;
					if ($data['gps_pos_criteria'] == 1){
						$gps_pos_criteria = "Alarm Activation Only" ;
					} elseif($data['gps_pos_criteria'] == 2) {
						$gps_pos_criteria = "All Signals But No Timer" ;
					} elseif($data['gps_pos_criteria'] == 4) {
						$gps_pos_criteria = "Activity Based Locations" ;
						$dynamicTextActivityBasedLocation = "<span class='__ComingSoonRight'>(Only applicable to Android App v1.1.0)</span>" ;
					} else {
						$gps_pos_criteria = "All Signals And Timer" ;
					}

					$otaTemplateData .= '<tr><td style="padding:7px 0"><div class="row"> <div class="col-sm-12 col-lg-6 col-md-6 float-left pl-0 __leftupdatesetting"> <div class="table-responsive OTaSettingtablenew"> <table class="table mb-0"> <tr style="display:none"> <td>SIP Calling</td> <td class="text-center"> <div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' . ( $data['sip_call'] == 0 ? 'OFF' : 'ON' ) .'</label></div> </td> </tr> <tr> <td><img class="_icon_ota" src="'. base_url() .'img/otaicon/power.png" alt=""> Trigger SOS <span class="__ComingSoon1" style= "font-size:11px;">(Not available in IOS devices)</span></td> <td class="text-center"> <div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' . ( $data['trigger_sos'] == 0 ? 'OFF' : 'ON' ) .'</label></div> </td> </tr> <tr><td style="position:relative;padding-top:6px!important;"><span class="__addedSubdirector"><img class="_icon_ota" src="'. base_url() .'img/otaicon/sub-directory.png" alt=""></span><img class="_icon_ota _icon_hidden" src="'. base_url() .'img/otaicon/gear.png" alt="">Level</td> <td class="text-center" style="padding-top: 6px!important;"> <div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' . ( $data['sos_press_level'] == 1 ? 'LOW' : 'High' ) .'</label></div> </td> </tr> <tr style="display:none"> <td><img class="_icon_ota" src="'. base_url() .'img/otaicon/jack.png" alt=""> RIP Alarm</td> <td class="text-center"> <div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' . ( $data['rip_alarm'] == 0 ? 'OFF' : 'ON' ) .'</label></div> </td> </tr> <tr style="display:none"> <td>FALL DETECT</td> <td class="text-center"> <div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' . ( $data['fall_detect'] == 0 ? 'OFF' : 'ON' ) .'</label></div> </td> </tr> <tr style="display:none"> <td> Sensitivity</td> <td class="text-center"> <div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' . $fall_detect_senstivity .'</label></div> </td> </tr> <tr> <td><img class="_icon_ota" src="'. base_url() .'img/otaicon/login.png" alt=""> Allow Users to Access Settings</td> <td class="text-center"> <div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' . ( $data['settings'] == 0 ? 'Restricted' : 'Allowed' ) .'</label></div> </td> </tr><tr> <td><img class="_icon_ota" src="'. base_url() .'img/otaicon/createUpdate.png" alt=""> <span style="float:left; width: 205px;">Create / Update and Delete Escalations</span></td> <td class="text-center" style="vertical-align: top!important;"> <div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' . ( $data['escalation_status'] == 0 ? 'Restricted' : 'Allowed' ) .'</label></div> </td> </tr> <tr> <td><img class="_icon_ota" src="'. base_url() .'img/otaicon/email.png" alt=""> SMS Signalling</td> <td class="text-center"> <div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' . ( $data['sms'] == 0 ? 'OFF' : 'ON' ) .'</label></div> </td> </tr> <tr> <td><img class="_icon_ota" src="'. base_url() .'img/otaicon/evidence.png" alt=""> Fingerprint Lock</td> <td class="text-center"> <div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' . ( $data['finger_print_lock'] == 0 ? 'OFF' : 'ON' ) .'</label></div> </td> </tr> <tr> <td><img class="_icon_ota" src="'. base_url() .'img/otaicon/calendar.png" alt=""> Calendar</td> <td class="text-center"> <div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' . ( $data['calendar'] == 0 ? 'OFF' : 'ON' ) .'</label></div> </td> </tr><tr style="display:none"> <td><img class="_icon_ota" src="'. base_url() .'img/otaicon/navigation.png" alt=""> Activity Based Locations</td> <td class="text-center"> <div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' . ( $data['activity_based_locations'] == 0 ? 'OFF' : 'ON' ) .'</label></div> </td> </tr> </table></div> </div> <!-- end left col --> <div class="col-sm-12 col-lg-6 col-md-6 float-right pl-0 pr-0 __rightupdatesetting"> <div class="table-responsive OTaSettingtablenew"> <table class="table mb-0"> <tr> <td><img class="_icon_ota" src="'. base_url() .'img/otaicon/min.png" alt=""> Min Mandown Timer</td> <td class="text-center"> <div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' . $data['min_man_down_timer_minutes'] .' Minutes '.$data['min_man_down_timer_seconds'] .' Seconds</label></div> </td> </tr> <tr> <td><img class="_icon_ota" src="'. base_url() .'img/otaicon/max.png" alt=""> Max Mandown Timer</td> <td class="text-center"> <div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' . $data['max_man_down_timer_minutes'] .' Minutes '.$data['max_man_down_timer_seconds'] .' Seconds</label></div> </td> </tr><tr> <td><img class="_icon_ota" src="'. base_url() .'img/otaicon/amber_timer_pre_alerts.png" alt=""> Amber Timer Pre - alerts<span class="__ComingSoon" style="font-size:11px;">(Only applicable to Android App v1.1.0)</span></td> <td class="text-center"> <div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' . $data['amber_timer_pre_alert_minutes'] .' Minutes '.$data['amber_timer_pre_alert_seconds'] .' Seconds</label></div> </td> </tr> <tr> <td><img class="_icon_ota" src="'. base_url() .'img/otaicon/min.png" alt=""> Min Amber Timer</td> <td class="text-center"> <div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' . $data['min_amber_timer_hours'] .' Hours '.$data['min_amber_timer_minutes'] .' Minutes</label></div> </td> </tr> <tr> <td><img class="_icon_ota" src="'. base_url() .'img/otaicon/max.png" alt=""> Max Amber Timer</td> <td class="text-center"> <div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' . $data['max_amber_timer_hours'] .' Hours '.$data['max_amber_timer_minutes'] .' Minutes</label></div> </td> </tr> <tr> <td><img class="_icon_ota" src="'. base_url() .'img/otaicon/navigation.png" alt=""> GPS Positioning Criteria</td> <td class="text-center"> <div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' . $gps_pos_criteria .'</label>'.$dynamicTextActivityBasedLocation.'</div> </td> </tr> <tr> <td><img class="_icon_ota" src="'. base_url() .'img/otaicon/timer.png" alt=""> GPS Position Update Frequency</td> <td class="text-center"> <div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' . $data['gps_update_frequ_minutes'] .' Minutes </label></div> </td> </tr> <tr> <td><img class="_icon_ota" src="'. base_url() .'img/otaicon/gps_icon.png" alt=""> Coordinates Refresh Rate <span class="__ComingSoon" style="font-size:11px;">(Only applicable to Android App v1.1.0)</span></td> <td class="text-center"> <div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' . $data['coorrdinates_refresh_rate'] .' Seconds </label></div> </td> </tr></table></div> </div> <!-- end right col --></div> <!-- end row--></td></tr>';
				}
			}
		} else {
			$selectHTML 	  = '<option value="">No Template Found</option>';
			$otaTemplateData  =  '<tr><td>No Data Found</td></tr>' ;
			$error = 0 ;
			$message = "No Data Found" ;
			$haveData		=  false;
		}
		echo json_encode(['error' => $error, 'message' => $message, 'selectHTML' => $selectHTML, 'otaTemplateData' => $otaTemplateData, 'id' => $idToCheck, 'haveData' => $haveData    ]) ;
	}

	/*
	 * Function to send the template settings to devices.
	*/
	public function getDataFromOperatorsTable_send_notifactions_android() {
		$numberArray	 = $this->input->post('numberArray') ;
		$mergeArrayResults = [];
		$checkError		   = 0;
		$errorIOS		   = 0 ;
		$resultIOS		   = '' ;
		$error 			   = 0 ;
		if($numberArray) {

				$templateId	 	 = $this->input->post('templateId') ;
				$getData		 = $this->users->getDataFromOperatorsTable($this->input->post('numberArray')) ;
				$getTemplateData = $this->users->getSingleTemplateData($templateId) ;


				if($getData) {
					$fcmDeviceToken 	= [] ;
					$errorToCheckToken 	= [] ;
					$errorToCheck 		= [] ;
					$counter 			= 0 ;
					$counterToken 		= 0 ;

					//for ios

					$fcmDeviceTokenIOS 		= [] ;
					$errorToCheckTokenIOS 	= [] ;
					$counterTokenIOS 		= 0 ;



					foreach($getData as $data) {
						if (isset($data['device_token']) && $data['device_token']) {

							if ( $data['device_type'] == "android" ) {
									$fcmDeviceToken[] 			      		      	  = $data['device_token'] ;
									$errorToCheckToken[$counterToken]['name']	  	  =   $data['loginname'] ;
									$errorToCheckToken[$counterToken]['number']	 	  =   $data['number'] ;
									$errorToCheckToken[$counterToken]['deviceType']	  =   $data['device_type'] ;
									$counterToken++;
							}

							if ( $data['device_type'] == "ios" ) {
									$fcmDeviceTokenIOS[] 			      		           = $data['device_token'] ;
									$errorToCheckTokenIOS[$counterTokenIOS]['name']	       =   $data['loginname'] ;
									$errorToCheckTokenIOS[$counterTokenIOS]['number']  	   =   $data['number'] ;
									$errorToCheckTokenIOS[$counterTokenIOS]['deviceType']  =   $data['device_type'] ;
									$counterTokenIOS++;
							}

						} else {
							$checkError		  							=   1;
							$errorToCheck[$counter]['name']	  		 	=   $data['loginname'] ;
							$errorToCheck[$counter]['number']	  	  	=   $data['number'] ;
							$errorToCheck[$counter]['errorMessage']	  	=   'Not Sent' ;
							$counter++ ;
						}

					}

					if( $fcmDeviceToken ||   $fcmDeviceTokenIOS) {

						$url 			= 'https://fcm.googleapis.com/fcm/send' ;
						$serverKey      = self::$API_ACCESS_KEY ;
						$data = [

							   //'sipCall' 					=> $getTemplateData[0]['sip_call'] ,
							   'triggerSos' 				=> $getTemplateData[0]['trigger_sos'],
							   'presslabel' 				=> $getTemplateData[0]['sos_press_level'],
							   'ripAlarm'   				=> $getTemplateData[0]['rip_alarm'],
							  // 'fallDetect'    				=> $getTemplateData[0]['fall_detect'],
							  // 'fallSenstivity'				=> $getTemplateData[0]['fall_detect_senstivity'],
							   'minmandowntimerminutes' 	=> $getTemplateData[0]['min_man_down_timer_minutes'],
							   'minmandowntimerseconds'		=> $getTemplateData[0]['min_man_down_timer_seconds'],
							   'maxmandowntimerminutes'		=> $getTemplateData[0]['max_man_down_timer_minutes'],
							   'maxmandowntimerseconds'		=> $getTemplateData[0]['max_man_down_timer_seconds'],
							   'minambertimerhours'			=> $getTemplateData[0]['min_amber_timer_hours'],
							   'minambertimerminutes'		=> $getTemplateData[0]['min_amber_timer_minutes'],
							   'maxambertimerhours'			=> $getTemplateData[0]['max_amber_timer_hours'],
							   'maxambertimerminutes'		=> $getTemplateData[0]['max_amber_timer_minutes'],
							   'gpsfrequencyupdate'			=> $getTemplateData[0]['gps_update_frequ_minutes'],
							   'settings'					=> $getTemplateData[0]['settings'],
							   'gpsposcriteria'				=> $getTemplateData[0]['gps_pos_criteria'],
							   'settingName'				=> $getTemplateData[0]['device_settings_name'],
							   'settingId'					=> $getTemplateData[0]['id'],
							   'sms'						=> $getTemplateData[0]['sms'],
							   'finger_print_lock'			=> $getTemplateData[0]['finger_print_lock'],
							   'calendar'					=> $getTemplateData[0]['calendar'],
							   'activity_based_locations'	=> $getTemplateData[0]['activity_based_locations'],
							   'coorrdinates_refresh_rate'	=> $getTemplateData[0]['coorrdinates_refresh_rate'],
							   'escalation_status'			=> $getTemplateData[0]['escalation_status'],
							   'amber_timer_pre_alerts_minutes'		=> $getTemplateData[0]['amber_timer_pre_alert_minutes'],
							   'amber_timer_pre_alerts_seconds'		=> $getTemplateData[0]['amber_timer_pre_alert_seconds']
							] ;
					
						$headers = array(
							'Authorization: key=' . $serverKey,
							'Content-Type: application/json'
						);

						if ( $fcmDeviceToken ) {  // for android devices to send notifications
							
						   $message = array(
									'message' => 'This is a testing message',
									'title' => 'Configuration received.',
									//'subtitle' => 'This is a subtitle. subtitle',
									'tickerText' => 'Ticker text here...Ticker text here...',
									'vibrate' => 1,
									'sound' => 1,
									'largeIcon' => 'large_icon',
									'smallIcon' => 'small_icon',
									'data' => json_encode($data)
							);


							$fields = array(
								'registration_ids' => $fcmDeviceToken,
								'data' => $message,
								'priority' 		=> 'high'
							);

							$ch = curl_init();
							// Set the url, number of POST vars, POST data
							curl_setopt($ch, CURLOPT_URL, $url);
							curl_setopt($ch, CURLOPT_POST, true);
							curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
							curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

							// Disabling SSL Certificate support temporarly
							curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
							if ($fields) {
								curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
							}

							// Execute post
							$result = curl_exec($ch);

							if ($result === FALSE) {
							   // die('Curl failed: ' . curl_error($ch));
							   $errorAndroid = 'Curl failed: ' . curl_error($ch) ;
							   $error = 1 ;
							   $resultAndroid = '' ;
							} else {

								$resultArray = json_decode($result, true);

								if (isset($resultArray['results']) && $resultArray['results']) {
									$counterNew = 0 ;
									foreach($resultArray['results'] as $data) {

										if (isset($data['error'])) {
											$errorToCheckToken[$counterNew]['errorMessage'] = $data['error'] ;
											$checkError	=   1;
										} else{
											$errorToCheckToken[$counterNew]['errorMessage'] = 'Sent' ;
											$this->users->saveUserTemplateSettings($getTemplateData[0]['id'], $errorToCheckToken[$counterNew]['number'], $getTemplateData[0]['gps_pos_criteria'], $errorToCheckToken[$counterNew]['name']) ;
										}

										$counterNew++;
									}
								}

								$resultAndroid = $result ;
								$error = 0 ;
								$errorAndroid = "";
							}

							// Close connection
							curl_close($ch);
						}

						if ( $fcmDeviceTokenIOS ) {  // for ios devices to send notifications
						
							if ( $data['gpsposcriteria'] == "4" ) {
								$data['gpsposcriteria'] = "3" ;
								$data['gpsfrequencyupdate'] = "15" ;
							}
							
							$message = array(
									'message' => 'This is a testing message',
									'title' => 'Configuration received.',
									//'subtitle' => 'This is a subtitle. subtitle',
									'tickerText' => 'Ticker text here...Ticker text here...',
									'vibrate' => 1,
									'sound' => 1,
									'largeIcon' => 'large_icon',
									'smallIcon' => 'small_icon',
									'data' => json_encode($data)
							);

							$fields = array(
								'registration_ids' => $fcmDeviceTokenIOS,
								'notification' 	   => $message,
								'mutable_content'   => true,
								'content_available' => true,
								'apnsPushType'      => "background",
								'priority' 		   => 'high'
							);

							$ch = curl_init();
							// Set the url, number of POST vars, POST data
							curl_setopt($ch, CURLOPT_URL, $url);
							curl_setopt($ch, CURLOPT_POST, true);
							curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
							curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

							// Disabling SSL Certificate support temporarly
							curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
							if ($fields) {
								curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
							}

							// Execute post
							$result = curl_exec($ch);

							if ($result === FALSE) {
							   // die('Curl failed: ' . curl_error($ch));
							   $errorIosMsg = 'Curl failed: ' . curl_error($ch) ;
							   $errorIOS 	= 1 ;
							   $resultIOS 	= '' ;
							} else {

								$resultArray = json_decode($result, true);

								if (isset($resultArray['results']) && $resultArray['results']) {
									$counterNew = 0 ;
									foreach($resultArray['results'] as $data) {

										if (isset($data['error'])) {
											$errorToCheckTokenIOS[$counterNew]['errorMessage'] = $data['error'] ;
											$checkError	=   1;
										} else{
											$errorToCheckTokenIOS[$counterNew]['errorMessage'] = 'Sent' ;
											//$this->users->saveUserTemplateSettings($getTemplateData[0]['id'], $errorToCheckTokenIOS[$counterNew]['number'], $getTemplateData[0]['gps_pos_criteria'], $errorToCheckTokenIOS[$counterNew]['name']) ;
										}

										$counterNew++;
									}
								}

								$resultIOS = $result ;
								$errorIOS = 0 ;
								$errorIosMsg = "";
							}

							// Close connection
							curl_close($ch);
						}

						if ( $error == '1' && $errorIOS == '1') { //if curl failed for both ios and android
							$error = 1 ;
						} else {
							$error = 0 ;
						}

						$mergeArrayResults   = array_merge($errorToCheckToken, $errorToCheckTokenIOS, $errorToCheck) ;

					}else {
							$resultAndroid = "";
							$error = 1 ;
							$errorAndroid = "The selected device is not logged in or not using the latest version of the app. The device will not not receive the messages.";
					}
				} else {
							$resultAndroid = "";
							$error = 1 ;
							$errorAndroid = "No users found!!!";
				}
			} else {
							$resultAndroid = "";
							$error = 1 ;
							$errorAndroid = "No users found!!!";
			}

		echo json_encode([ 'error' => $error, 'errorAndroid' => $errorAndroid, 'resultAndroid' => $resultAndroid, 'mergeArrayResults' => $mergeArrayResults, 'checkError' => $checkError, 'resultIOS' => $resultIOS ]) ;


	}

	/*
	 * Function to send the broadcast message.
	*/

	public function sendBroadcastingMessage() {
		//$numberArray	 = $this->input->post('numberArray') ;
		//$numberArray	 = $this->session->userdata('numberArrayBroadcastMessage') ;
		$numberArray	 = json_decode($this->input->post('selectedUserData')) ;

		if ( !$numberArray ) {
			echo json_encode([ 'error' => 1, 'errorAndroid' => 'Please select users.' ]) ;
			exit ;
		}
		$numberArrayNew  = [] ;

		$from 		     = $this->input->post('from') ;
		$mainMessage	 = $this->input->post('message') ;
		$title	 		 = $this->input->post('title') ;
		$uniqueId		 = time().'-'.mt_rand();

		$add_compose_message_details = $this->users->add_compose_message_details($from, $mainMessage, $title) ;

		if (!$add_compose_message_details) {
			echo json_encode([ 'error' => 1, 'errorAndroid' => 'Network error, please try again later.' ]) ;
			exit ;
		}

		$count = 0 ;
		$array = (array) $numberArray;

		foreach($numberArray as $key => $value) {
			$numberArrayNew[] = $value->phone ;
			$numberArray[$key]->unique_id  =  $uniqueId;
			$numberArray[$key]->main_user_id  =  $this->session->userdata('user_id');
			$numberArray[$key]->main_user_cost_center_id  =  $this->session->userdata('costcenterID');
			$numberArray[$key]->compose_message_id  =  $add_compose_message_details;
			$numberArray[$key]->sent_at  =  date("Y-m-d H:i:s");
			$count++;
		}

		$add_broadcast_message_user_details = $this->users->add_broadcast_message_user_details($numberArray) ;

		if (!$add_broadcast_message_user_details) {
			echo json_encode([ 'error' => 1, 'errorAndroid' => 'Network error, please try again later.' ]) ;
			exit ;
		}

		$mergeArrayResults = [];
		//debug($_POST, 1) ;
		$checkError		   = 0;

		$errorIOS		   = 0 ;
		$resultIOS		   = '' ;
		$error 			   = 0 ;


		if($numberArray) {

				$getData		 = $this->users->getDataFromOperatorsTable($numberArrayNew) ;

				if($getData) {

					$this->load->library('logger');
					$logMessage = 'Broadcast Messaging, a message has been sent <br /> Title: '.$title.'<br /> Message: '.$mainMessage;
					$this->logger->trigger_log($this->session->userdata('username'),$logMessage);

					$fcmDeviceToken 	= [] ;
					$errorToCheckToken 	= [] ;
					$errorToCheck 		= [] ;
					$counter 			= 0 ;
					$counterToken 		= 0 ;


					//for ios

					$fcmDeviceTokenIOS 		= [] ;
					$errorToCheckTokenIOS 	= [] ;
					$counterTokenIOS 		= 0 ;



					foreach($getData as $data) {
						if (isset($data['device_token']) && $data['device_token']) {

							if ( $data['device_type'] == "android" ) {
								$fcmDeviceToken[] 			      		     	  = $data['device_token'] ;
								$errorToCheckToken[$counterToken]['name']	 	  =   $data['loginname'] ;
								$errorToCheckToken[$counterToken]['number']	  	  =   $data['number'] ;
								$errorToCheckToken[$counterToken]['deviceType']	  =   $data['device_type'] ;
								$counterToken++;
							}

							if ( $data['device_type'] == "ios" ) {
									$fcmDeviceTokenIOS[] 			      		           = $data['device_token'] ;
									$errorToCheckTokenIOS[$counterTokenIOS]['name']	       =   $data['loginname'] ;
									$errorToCheckTokenIOS[$counterTokenIOS]['number'] 	   =   $data['number'] ;
									$errorToCheckTokenIOS[$counterTokenIOS]['deviceType']  =   $data['device_type'] ;
									$counterTokenIOS++;
							}

						} else {
							$checkError		  							=   1;
							$errorToCheck[$counter]['name']	  		 	=   $data['loginname'] ;
							$errorToCheck[$counter]['number']	  	  	=   $data['number'] ;
							$errorToCheck[$counter]['errorMessage']	  	=   'Not Sent' ;
							$this->users->updateBroadcastmessage($data['number'], $uniqueId, 'User Logged Off');
							$counter++ ;
						}

					}

					//$fcmDeviceToken = ['ddALj7YFOAU:APA91bGpmiHHPjemYrKTzfAOdmN62k68cvKmU2xFtUP-TBLo-qqoeYLnJjN_H5nrZetjPfWgk890BIPF_sIETuKQ_a_-zFtjLKxPgIxTYi4I3Omeg0oWpPLBO_oI_BqsUnywpcB3Ir--'] ;
					if( $fcmDeviceToken ||   $fcmDeviceTokenIOS ) {

						$url 			= 'https://fcm.googleapis.com/fcm/send' ;
						$serverKey      = self::$API_ACCESS_KEY ;
						$message = array(
							'message' => $mainMessage,
							'title' => $title,
							'subtitle' => $mainMessage,
							'tickerText' => 'Ticker text here...Ticker text here...',
							'vibrate' => 1,
							'sound' => 1,
							'largeIcon' => 'large_icon',
							'smallIcon' => 'small_icon',
							'from_compose_message'      =>$from,
							'currentModule' => 'broadcastmessage'
						);

						$headers = array(
							'Authorization: key=' . $serverKey,
							'Content-Type: application/json'
						);


						if ( $fcmDeviceToken ) {  // for android devices to send notifications
								$fields = array(
									'registration_ids' => $fcmDeviceToken,
									'data' => $message,
									'priority' 		=> 'high'
								);

								//$result =  $this->useCurl($url, $headers, json_encode($fields));
								$ch = curl_init();
								// Set the url, number of POST vars, POST data
								curl_setopt($ch, CURLOPT_URL, $url);
								curl_setopt($ch, CURLOPT_POST, true);
								curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
								curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

								// Disabling SSL Certificate support temporarly
								curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
								if ($fields) {
									curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
								}

								// Execute post
								$result = curl_exec($ch);
								if ($result === FALSE) {
								   // die('Curl failed: ' . curl_error($ch));
								   $errorAndroid = 'Curl failed: ' . curl_error($ch) ;
								   $error = 1 ;
								   $resultAndroid = '' ;
								} else {
									$resultArray = json_decode($result, true);

									if (isset($resultArray['results']) && $resultArray['results']) {
										$counterNew = 0 ;
										foreach($resultArray['results'] as $data) {

											if (isset($data['error'])) {
												$errorToCheckToken[$counterNew]['errorMessage'] = $data['error'] ;
												$this->users->updateBroadcastmessage($errorToCheckToken[$counterNew]['number'], $uniqueId, $data['error']);
												$checkError	=   1;
											} else{
												$errorToCheckToken[$counterNew]['errorMessage'] = 'Sent' ;
												$this->users->updateBroadcastmessage($errorToCheckToken[$counterNew]['number'], $uniqueId, 'delivered');
											}

											$counterNew++;
										}
									}

									$resultAndroid = $result ;
									$error = 0 ;
									$errorAndroid = "";
								}

								// Close connection
								curl_close($ch);
							 }


							 if ( $fcmDeviceTokenIOS ) {  // for ios devices to send notifications
								$fields = array(
									'registration_ids' => $fcmDeviceTokenIOS,
									'notification' => $message,
									'content_available' => true,
									'priority' 		=> 'high'
								);

								//$result =  $this->useCurl($url, $headers, json_encode($fields));
								$ch = curl_init();
								// Set the url, number of POST vars, POST data
								curl_setopt($ch, CURLOPT_URL, $url);
								curl_setopt($ch, CURLOPT_POST, true);
								curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
								curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

								// Disabling SSL Certificate support temporarly
								curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
								if ($fields) {
									curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
								}

								// Execute post
								$result = curl_exec($ch);
								if ($result === FALSE) {
								   // die('Curl failed: ' . curl_error($ch));
								   $errorIosMsg = 'Curl failed: ' . curl_error($ch) ;
								   $errorIOS 	= 1 ;
								   $resultIOS 	= '' ;
								} else {
									$resultArray = json_decode($result, true);

									if (isset($resultArray['results']) && $resultArray['results']) {
										$counterNew = 0 ;
										foreach($resultArray['results'] as $data) {

											if (isset($data['error'])) {
												$errorToCheckTokenIOS[$counterNew]['errorMessage'] = $data['error'] ;
												$this->users->updateBroadcastmessage($errorToCheckTokenIOS[$counterNew]['number'], $uniqueId, $data['error']);
												$checkError	=   1;
											} else{
												$errorToCheckTokenIOS[$counterNew]['errorMessage'] = 'Sent' ;
												$this->users->updateBroadcastmessage($errorToCheckTokenIOS[$counterNew]['number'], $uniqueId, 'delivered');
											}

											$counterNew++;
										}
									}

									$resultIOS = $result ;
									$errorIOS = 0 ;
									$errorIosMsg = "" ;
								}
							 // Close connection
								curl_close($ch);
							 }

							 if ( $error == '1' && $errorIOS == '1') { //if curl failed for both ios and android
								$error = 1 ;
							} else {
								$error = 0 ;
							}

							$mergeArrayResults   = array_merge($errorToCheckToken, $errorToCheckTokenIOS, $errorToCheck) ;


					}else {
							$resultAndroid = "";
							$error = 1 ;
							$errorAndroid = "The selected device is not logged in or not using the latest version of the app. The device will not not receive the messages.";
					}
				} else {
							$resultAndroid = "";
							$error = 1 ;
							$errorAndroid = "No users found!!!";
				}
			} else {
							$resultAndroid = "";
							$error = 1 ;
							$errorAndroid = "No users found!!!";
			}

		echo json_encode([ 'error' => $error, 'errorAndroid' => $errorAndroid, 'resultAndroid' => $resultAndroid, 'mergeArrayResults' => $mergeArrayResults, 'checkError' => $checkError, 'resultIOS' => $resultIOS ]) ;

	}

	/*
	 * Function to send the notification to devices and get the devices configuration back in response.
	*/
	public function sendConfigurationFCM(){
		//NotRegistered, 	InvalidRegistration errors from FCM
		$numberArray	 = json_decode($this->input->post('numberArray')) ;
		$uniqueId	 	 = $this->input->post('uniqueId') ;
		//$explodeNumbers  = explode(',', $numberArray) ;
		$mergeArrayResults = [];
		$checkError		   = 0;

		$errorIOS		   = 0 ;
		$resultIOS		   = '' ;
		$error 			   = 0 ;

		if($numberArray) {

				$getData		 = $this->users->getDataFromOperatorsTable($numberArray) ;

				if($getData) {
					$fcmDeviceToken 	= [] ;
					$errorToCheckToken 	= [] ;
					$errorToCheck 		= [] ;
					$counter 			= 0 ;
					$counterToken 		= 0 ;


					//for ios

					$fcmDeviceTokenIOS 		= [] ;
					$errorToCheckTokenIOS 	= [] ;
					$counterTokenIOS 		= 0 ;
					$fcmDeviceIOSNumbers 	= [] ;

					foreach($getData as $data) {
						if (isset($data['device_token']) && $data['device_token']) {

							if ( $data['device_type'] == "android" ) {

								$fcmDeviceToken[] 			      		      	  = $data['device_token'] ;
								$errorToCheckToken[$counterToken]['name']	  	  =   $data['loginname'] ;
								$errorToCheckToken[$counterToken]['number']	 	  =   $data['number'] ;
								$errorToCheckToken[$counterToken]['deviceType']	  =   $data['device_type'] ;
								$counterToken++;
							}


							if ( $data['device_type'] == "ios" ) {
									$fcmDeviceTokenIOS[] 			      		           = $data['device_token'] ;
									$fcmDeviceIOSNumbers[] 			      		           = $data['number'] ;
									$errorToCheckTokenIOS[$counterTokenIOS]['name']	       = $data['loginname'] ;
									$errorToCheckTokenIOS[$counterTokenIOS]['number'] 	   = $data['number'] ;
									$errorToCheckTokenIOS[$counterTokenIOS]['deviceType']  = $data['device_type'] ;
									$counterTokenIOS++;
							}

						} else {
							$checkError		  							=   1;
							$errorToCheck[$counter]['name']	  		 	=   $data['loginname'] ;
							$errorToCheck[$counter]['number']	  	  	=   $data['number'] ;
							$errorToCheck[$counter]['errorMessage']	  	=   'Logged Off' ;
							$this->users->updateFCMGetConfiguration($data['number'], $uniqueId, 'Logged Off', '-');
							$counter++ ;
						}

					}


					if( $fcmDeviceToken ||   $fcmDeviceTokenIOS) {

						$url 			= 'https://fcm.googleapis.com/fcm/send' ;
						$serverKey      = self::$API_ACCESS_KEY ;
						$message = array(
							'title' 		=> 'getConfiguration',
							'uniqueId'		=>  $uniqueId,
							'priority' 		=> 'high'
						);

						$headers = array(
							'Authorization: key=' . $serverKey,
							'Content-Type: application/json'
						);

						if ( $fcmDeviceToken ) {  // for android devices to send notifications

								$fields = array(
									'registration_ids' => $fcmDeviceToken,
									'data' => $message,
									'priority' =>  'high'
								);

								//$result =  $this->useCurl($url, $headers, json_encode($fields));
								$ch = curl_init();
								// Set the url, number of POST vars, POST data
								curl_setopt($ch, CURLOPT_URL, $url);
								curl_setopt($ch, CURLOPT_POST, true);
								curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
								curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

								// Disabling SSL Certificate support temporarly
								curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
								if ($fields) {
									curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
								}

								// Execute post
								$result = curl_exec($ch);
								if ($result === FALSE) {
								   // die('Curl failed: ' . curl_error($ch));
								   $errorAndroid = 'Curl failed: ' . curl_error($ch) ;
								   $error = 1 ;
								   $resultAndroid = '' ;
								} else {
									$resultArray = json_decode($result, true);
									if (isset($resultArray['results']) && $resultArray['results']) {
										$counterNew = 0 ;
										foreach($resultArray['results'] as $data) {

											if (isset($data['error'])) {
												$errorToCheckToken[$counterNew]['errorMessage'] = $data['error'] ;
												$this->users->updateFCMGetConfiguration($errorToCheckToken[$counterNew]['number'], $uniqueId, $data['error'], 'android');
												$checkError	=   1;
											} else{
												$errorToCheckToken[$counterNew]['errorMessage'] = 'Sent' ;
												$this->users->updateFCMGetConfiguration($errorToCheckToken[$counterNew]['number'], $uniqueId, 'Sent', 'android');
											}

											$counterNew++;
										}
									}

									$resultAndroid = $result ;
									$error = 0 ;
									$errorAndroid = "";

								}

								// Close connection
								curl_close($ch);


						}

						if ( $fcmDeviceTokenIOS ) {   // for ios devices to send notifications
							   /*
								$fields = array(
									'registration_ids' => $fcmDeviceTokenIOS,
									'notification' => $message,
									'priority' =>  'high'
								);

								//$result =  $this->useCurl($url, $headers, json_encode($fields));
								$ch = curl_init();
								// Set the url, number of POST vars, POST data
								curl_setopt($ch, CURLOPT_URL, $url);
								curl_setopt($ch, CURLOPT_POST, true);
								curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
								curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

								// Disabling SSL Certificate support temporarly
								curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
								if ($fields) {
									curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
								}

								// Execute post
								$result = curl_exec($ch);
								if ($result === FALSE) {
								   // die('Curl failed: ' . curl_error($ch));
								   $errorIosMsg = 'Curl failed: ' . curl_error($ch) ;
								   $errorIOS 	= 1 ;
								   $resultIOS 	= '' ;
								} else {
									$resultArray = json_decode($result, true);

									if (isset($resultArray['results']) && $resultArray['results']) {
										$counterNew = 0 ;
										foreach($resultArray['results'] as $data) {

											if (isset($data['error'])) {
												$errorToCheckTokenIOS[$counterNew]['errorMessage'] = $data['error'] ;
												$this->users->updateFCMGetConfiguration($errorToCheckTokenIOS[$counterNew]['number'], $uniqueId, $data['error']);
												$checkError	=   1;
											} else{
												$errorToCheckTokenIOS[$counterNew]['errorMessage'] = 'Sent' ;
												$this->users->updateFCMGetConfiguration($errorToCheckTokenIOS[$counterNew]['number'], $uniqueId, 'Sent');
											}

											$counterNew++;
										}
									}

									$resultIOS = $result ;
									$errorIOS = 0 ;
									$errorIosMsg = "" ;

								}

								// Close connection
								curl_close($ch);

							*/

							foreach ( $fcmDeviceIOSNumbers as $iosInsertData) {
								$this->users->updateFCMGetConfiguration($iosInsertData, $uniqueId, 'Sent', 'ios');
							}
						}


						if ( $error == '1' && $errorIOS == '1') { //if curl failed for both ios and android
							$error = 1 ;
						} else {
							$error = 0 ;
						}

						$mergeArrayResults   = array_merge($errorToCheckToken, $errorToCheckTokenIOS, $errorToCheck) ;
						session_start();
						$this->session->set_userdata('getConfigUniqueId', $uniqueId);
						session_write_close();

						//~ debug($errorToCheckToken) ;
						//~ debug($errorToCheckTokenIOS) ;
						//~ debug($errorToCheck) ;
						//~ debug($mergeArrayResults, 1) ;

					}else {
							$resultAndroid = "";
							$error = 1 ;
							$errorAndroid = "The selected device is not logged in or not using the latest version of the app. The device will not not receive the messages.";
					}
				} else {
							$resultAndroid = "";
							$error = 1 ;
							$errorAndroid = "No users found!!!";
				}
			} else {
							$resultAndroid = "";
							$error = 1 ;
							$errorAndroid = "No users found!!!";
			}

		echo json_encode([ 'error' => $error, 'errorAndroid' => $errorAndroid, 'resultAndroid' => $resultAndroid, 'mergeArrayResults' => $mergeArrayResults, 'checkError' => $checkError, 'resultIOS' => $resultIOS ]) ;


	}


	// Data to add uniqueid, name, phone, serial number, transmitter type once the first time get configuration is clicked

	public function addDataGetConfiguration() {
		$dataToInsert = json_decode($this->input->post('dataToInsert'));

		if ($dataToInsert) {

			if ( $this->users->addFirstDataToGetConfiguration($dataToInsert) ) {
				$error = 0;
			}else {
				$error = 1;
			}

		} else {
			$error = 1;
		}


		echo json_encode([ 'error' => $error ]) ;
	}

	// Data to add uniqueid, name, phone, serial number, transmitter type once the first time refresh is clicked

	public function addDataGetConfigurationOnRefresh() {
		$getConfigUniqueId = $this->input->post('getConfigUniqueId');
		$uniqueIdNew	   = time().'-'.mt_rand();
		$data			   = '' ;
		if ($getConfigUniqueId) {

			if ( $data = $this->users->addFirstDataToGetConfigurationOnRefresh($getConfigUniqueId, $uniqueIdNew) ) {
				$error = 0;
				//delete previous entries
				//$this->users->deletePreviousConfiguration($getConfigUniqueId) ;
			}else {
				$error = 1;
			}

		} else {
			$error = 1;
		}


		echo json_encode([ 'error' => $error, 'data' => $data, 'uniqueIdNew' =>  $uniqueIdNew]) ;
	}


	public function getAppSettingsResponse() { //use if you want to change data here

		  /*
	   //need to update number key
	   if ( ( isset($dataFromApp['unique_id']) && !empty('unique_id') ) &&  ( isset($dataFromApp['number']) && !empty('number') ) )	{

			   $data		 = [] ;

			   $data['triggerSos'] 	= ( isset($dataFromApp['trigger_sos']) ? ($dataFromApp['trigger_sos'] == 0 ? 'OFF' : 'ON')  : '');
			   $data['presslabel'] 	= ( isset($dataFromApp['trigger_level']) ? ($dataFromApp['trigger_level'] == 1? 'LOW' : 'HIGH')  : '');
			   $data['ripAlarm'] 	= ( isset($dataFromApp['rip_alarm']) ? ($dataFromApp['rip_alarm'] == 0 ? 'OFF' : 'ON')  : '');
			   $data['fallDetect'] 	= ( isset($dataFromApp['fall_detect']) ? ($dataFromApp['fall_detect'] == 0 ? 'OFF' : 'ON')  : '');
			   if (isset($dataFromApp['fall_detect_sensitivity']){
				   if($dataFromApp['fall_detect_sensitivity'] == 1){
						$data['fallSenstivity']  = '1 (Low)' ;
				   } elseif($dataFromApp['fall_detect_sensitivity'] == 5) {
						$data['fallSenstivity'] = '5 (High)' ;
				   } else {
						$data['fallSenstivity'] = $dataFromApp['fall_detect_sensitivity'] ;
				   }
			   } else {
				  $data['fallSenstivity'] = '' ;
			   }

			   $data['minmandowntimerminutes'] 	= ( isset($dataFromApp['minmandowntimerminutes']) ?  $dataFromApp['minmandowntimerminutes'] : '');
			   $data['minmandowntimerseconds'] 	= ( isset($dataFromApp['minmandowntimerseconds']) ?  $dataFromApp['minmandowntimerseconds'] : '');
			   $data['maxmandowntimerminutes'] 	= ( isset($dataFromApp['maxmandowntimerminutes']) ?  $dataFromApp['maxmandowntimerminutes'] : '');
			   $data['maxmandowntimerseconds'] 	= ( isset($dataFromApp['maxmandowntimerseconds']) ?  $dataFromApp['maxmandowntimerseconds'] : '');
			   $data['minambertimerhours'] 		= ( isset($dataFromApp['minambertimerhours']) ?  $dataFromApp['minambertimerhours'] : '');
			   $data['minambertimerminutes'] 	= ( isset($dataFromApp['minambertimerminutes']) ?  $dataFromApp['minambertimerminutes'] : '');
			   $data['maxambertimerhours'] 		= ( isset($dataFromApp['maxambertimerhours']) ?  $dataFromApp['maxambertimerhours'] : '');
			   $data['maxambertimerminutes'] 	= ( isset($dataFromApp['maxambertimerminutes']) ?  $dataFromApp['maxambertimerminutes'] : '');

			   if (isset($dataFromApp['gps_position_criteria']){

				   if ($dataFromApp['gps_position_criteria'] == 1){

						$data['gpsposcriteria']  = "Alarm Activation Only" ;

				   } elseif($dataFromApp['gps_position_criteria'] == 2) {

						$data['gpsposcriteria']  = "All Signals But No Timer" ;

				   } else {

						$data['gpsposcriteria']  = "All Signals And Timer" ;

				   }
			   } else {
						$data['gpsposcriteria']  = "" ;
			   }


			   $data['gpsfrequencyupdate'] 	= ( isset($dataFromApp['gps_frequency']) ?  $dataFromApp['gps_frequency'] : '');
			   $data['settings'] 		    = ( isset($dataFromApp['settings_access']) ? ($dataFromApp['settings_access'] == 0 ? 'RESTRICTED' : 'ALLOWED')  : '');
			   $data['settings_name'] 		= ( isset($dataFromApp['setting_name']) ?  $dataFromApp['setting_name'] : '');
			   $data['settings_id'] 		= ( isset($dataFromApp['setting_id']) ?  $dataFromApp['setting_id'] : '');


			   $data['calendar'] 	= ( isset($dataFromApp['calendar']) ? ($dataFromApp['calendar'] == 0 ? 'OFF' : 'ON')  : '');


			   if (isset($dataFromApp['finger_print_lock']){

				   if ($dataFromApp['finger_print_lock'] == 0){

						$data['finger_print_lock']  = "OFF" ;

				   } elseif($dataFromApp['finger_print_lock'] == 1) {

						$data['finger_print_lock']  = "ON" ;

				   } else {

						$data['finger_print_lock']  = "N/A" ;

				   }
			   } else {
						$data['finger_print_lock']  = "" ;
			   }



			   if ($dataFromApp['unique_id'], $dataFromApp['number'], $data ) {
					$error = 0;
					$message = "Data updated successfully.";
			   } else {
					$error = 1;
					$message = "Data not updated .";
			   }

	   } else {
			   $error = 1;
			   $message = "Number/Unique can not be empty";
	   }


	   debug($data, 1) ;
	   echo json_encode([ 'error' => $error, 'message' => $message ]) ;
	   */

	}

	public function getConfigurationFCM() {
		$getConfigUniqueId = trim($this->input->post('getConfigUniqueId'));
		$getConfiguration = $this->users->getConfigurationFCM($getConfigUniqueId) ;
		$error = 0;
		$message = "" ;
		echo json_encode([  'error' => $error, 'message' => $message, 'getConfiguration' => $getConfiguration ]) ;
	}


	public function getSingleConfiguration() {
		$id 					= $this->input->post('id')  ;
		$getSingleConfiguration = $this->users->getSingleConfiguration($id) ;
		$otaTemplateData   = "" ;
		$otherAppSettings  = "" ;
		$gps_lat		   = "" ;
		$gps_lng		   = "" ;
		$userName		   = "" ;
		$device_type	   = "" ;

		$error = 0 ;

		if ($getSingleConfiguration) {
			foreach ($getSingleConfiguration as $data) {

					if( $data['device_type'] == "ios" ){
						$classIos   = "hidden" ;
						$deviceName = "iOS" ;
						$classLower = "classLower" ;
					} else {
						$classIos 	= "" ;
						$deviceName = $data['device_type'] ;
						$classLower = "classLower" ;

					}


					if ($data['settings_name']) {
						$settingName     = $data['settings_name'] ;
						$maxManDownTimer = $data['maxmandowntimerminutes'] .' Minutes '.$data['maxmandowntimerseconds'] .' Seconds' ;
						$maxAmberTimer 	 = $data['maxambertimerhours'] .' Hours '.$data['maxambertimerminutes'] .' Minutes'    ;
						//$amberTimerPreAlerts = $data['amber_timer_pre_alert_minutes'] .' Minutes '.$data['amber_timer_pre_alert_seconds'] .' Seconds' ;
					} else {
						$settingName 	 = "Default" ;
						$maxManDownTimer = $data['maxmandowntimerminutes'] .' Minutes '.$data['maxmandowntimerseconds'] .' Seconds' ;
						$maxAmberTimer 	 = $data['maxambertimerhours'] .' Hours '.$data['maxambertimerminutes'] .' Minutes'    ;
						//$amberTimerPreAlerts = $data['amber_timer_pre_alert_minutes'] .' Minutes '.$data['amber_timer_pre_alert_seconds'] .' Seconds' ;
					}
					
					if ( $data['amber_timer_pre_alert_minutes'] == "-" && $data['amber_timer_pre_alert_seconds'] == "-" ) {
						$amberTimerPreAlerts = "-" ;
					} else {
						$amberTimerPreAlerts = $data['amber_timer_pre_alert_minutes'] .' Minutes '.$data['amber_timer_pre_alert_seconds'] .' Seconds' ;
					}
					
					
					
					
					if ($data['fallSenstivity']) {
						if ($data['fallSenstivity'] == 1){
							$fall_detect_senstivity = '1 (Low)' ;
						} elseif($data['fallSenstivity'] == 5) {
							$fall_detect_senstivity = '5 (High)' ;
						} else {
							$fall_detect_senstivity = $data['fallSenstivity'] ;
						}
					} else {
						  $fall_detect_senstivity = '-' ;
					}
					
					
					$dynamicTextActivityBasedLocation = "" ;
					
					if ($data['gpsposcriteria']) {
						if ($data['gpsposcriteria'] == 1){
							$gps_pos_criteria = "Alarm Activation Only" ;
						} elseif($data['gpsposcriteria'] == 2) {
							$gps_pos_criteria = "All Signals But No Timer" ;
						} elseif($data['gpsposcriteria'] == 4) {
							$gps_pos_criteria = "Activity Based Locations" ;
							$dynamicTextActivityBasedLocation = "<span class='__ComingSoonRight'>(Only applicable to Android App v1.1.0)</span>" ;
						} else {
							$gps_pos_criteria = "All Signals And Timer" ;
						}
					} else {
						$gps_pos_criteria = '-' ;
					}

					if (isset($data['coorrdinates_refresh_rate']) && $data['coorrdinates_refresh_rate'] != "-") {
						$coordinateRefreshRate = $data['coorrdinates_refresh_rate']." Seconds";
					} else {
						$coordinateRefreshRate = "-" ;
					}


					if ( isset($data['escalation_status']) ) {

						if ( $data['escalation_status'] == "0") {
							$escalation_status = "Restricted" ;
						} elseif( $data['escalation_status'] == "1" ) {
							$escalation_status = "Allowed" ;
						} else {
							$escalation_status = "-" ;
						}

					} else {
						$escalation_status = "-" ;
					}


					$otaTemplateData .= '<tr><td><img class="_icon_ota" src="'. base_url() .'img/otaicon/gear.png" alt="">SETTINGS NAME</td><td><div class="form-group __truncate" title="' . $settingName    .'">' . $settingName    .'</div></td></tr><tr class="' . $classIos    .'"><td><img class="_icon_ota" src="'. base_url() .'img/otaicon/power.png" alt="">TRIGGER SOS</td><td><div class="form-group">' . ( $data['triggerSos'] == 0 ? 'OFF' : 'ON' )    .'</div></td></tr><tr class="' . $classIos    .'"><td style="position:relative"><span class="__addedSubdirector"><img class="_icon_ota" src="'. base_url() .'img/otaicon/sub-directory.png" alt=""></span><img class="_icon_ota _icon_hidden" src="'. base_url() .'img/otaicon/gear.png" alt="">Level</td><td><div class="form-group">' . ( $data['presslabel'] == 1 ? 'LOW' : 'High' )    .'</div></td></tr><tr><td><img class="_icon_ota" src="'. base_url() .'img/otaicon/jack.png" alt="">RIP ALARM</td><td><div class="form-group">' . ( $data['ripAlarm'] == 0 ? 'OFF' : 'ON' )    .'</div></td></tr><tr><td><img class="_icon_ota" src="'. base_url() .'img/otaicon/min.png" alt=""> Min Mandown Timer	</td><td><div class="form-group">' .  $data['minmandowntimerminutes'] .' Minutes '.$data['minmandowntimerseconds'] .' Seconds</div></td></tr><tr><td><img class="_icon_ota" src="'. base_url() .'img/otaicon/max.png" alt="">Max Mandown Timer</td><td><div class="form-group">' .  $maxManDownTimer .'</div></td></tr><tr><td><img class="_icon_ota" src="'. base_url() .'img/otaicon/amber_timer_pre_alerts.png" alt="">Amber Timer Pre - alerts<span class="__ComingSoon">(Only applicable to Android App v1.1.0)</span></td><td><div class="form-group">' .  $amberTimerPreAlerts .'</div></td></tr><tr><td><img class="_icon_ota" src="'. base_url() .'img/otaicon/min.png" alt="">Min Amber Timer</td><td><div class="form-group">' .  $data['minambertimerhours'] .' Hours '.$data['minambertimerminutes'] .' Minutes</div></td></tr><tr><td><img class="_icon_ota" src="'. base_url() .'img/otaicon/max.png" alt="">Max Amber Timer</td><td><div class="form-group">' .  $maxAmberTimer .'</div></td></tr><tr><td><img class="_icon_ota" src="'. base_url() .'img/otaicon/navigation.png" alt="">GPS Positioning Criteria</td><td><div class="form-group">' .  $gps_pos_criteria .$dynamicTextActivityBasedLocation.'</div></td></tr><tr><td><img class="_icon_ota" src="'. base_url() .'img/otaicon/timer.png" alt="">GPS Frequency</td><td><div class="form-group">' .  $data['gpsfrequencyupdate'] .' Minutes </div></td></tr><tr><td><img class="_icon_ota" src="'. base_url() .'img/otaicon/login.png" alt="">Ability to access settings</td><td><div class="form-group">' . ( $data['settings'] == 0 ? 'Restricted' : 'Allowed' )    .'</div></td></tr><tr class="' . $classIos    .'"><td><img class="_icon_ota" src="'. base_url() .'img/otaicon/gps_icon.png" alt="">Coordinates Refresh Rate<span class="__ComingSoon">(Only applicable to Android App v1.1.0)</span></td><td><div class="form-group">' . $coordinateRefreshRate    .'</div></td></tr><tr><td><img class="_icon_ota" src="'. base_url() .'img/otaicon/createUpdate.png" alt=""><span style="float:left; width:165px;">Create / Update and Delete Escalations</span></td><td style="vertical-align: top!important;"><div class="form-group">' . $escalation_status    .'</div></td></tr>';


					if ($data['finger_print_lock'] == "0"){
						$finger_print_lock = "OFF" ;
					} elseif($data['finger_print_lock'] == "1") {
						$finger_print_lock = "ON" ;
					} else {
						$finger_print_lock = "-" ;
					}
					
					if ( empty($data["imei_no"]) ) {
						$data["imei_no"] = "-" ;
					}
					//$otherAppSettings .= '<tr><td>Calendar</td><td><div class="form-group">' . ( $data['calendar'] == 0 ? 'OFF' : 'ON' )   .'</div></td></tr><tr><td>Finger Print Lock</td><td><div class="form-group">' .  $finger_print_lock   .'</div></td></tr>' ;

					$otherAppSettings .= '<tr><td><img class="_icon_ota" src="'. base_url() .'img/otaicon/calendar.png" alt="">Calendar</td><td><div class="form-group">' . ( $data['calendar'] == 0 ? 'OFF' : 'ON' ) .'</div></td></tr><tr><td><img class="_icon_ota" src="'. base_url() .'img/otaicon/evidence.png" alt="">Finger Print Lock</td><td><div class="form-group">' . $finger_print_lock .'</div></td></tr><tr><td><img class="_icon_ota" src="'. base_url() .'img/otaicon/email.png" alt="">SMS Signalling</td><td><div class="form-group">' . ( $data["sms"] == "0" ? "Off" : ( $data["sms"] == "1" ? "On" : "-") )  .'</div></td></tr><tr style="display:none"><td><img class="_icon_ota" src="'. base_url() .'img/otaicon/walk.png" alt="">Activity Based Locations</td><td><div class="form-group">' . ( $data["activity_based_locations"] == "0" ? "Off" : ( $data["activity_based_locations"] == "1" ? "On" : "-") )  .'</div></td></tr><tr><td colspan="2"><span class="_midTDheader">Device Info</span></td></tr><tr><td>Device Type</td><td class="'.$classLower.'"><div class="form-group">'.$deviceName.' </div></td></tr><tr><td>Device ID</td><td><div class="form-group">' . $data["device_id"] . ' </div></td></tr><tr class="' . $classIos    .'"><td>Is device on MDM</td><td><div class="form-group">' . $data["is_device_on_mdm"] . ' </div></td></tr><tr><td>IMEI Number</td><td><div class="form-group">' . $data["imei_no"] . '</div></td><tr><td>Carrier</td><td><div class="form-group">' . $data["carrier"] . '</div></td></tr><tr><td>Model</td><td><div class="form-group">' . $data["model"] . '</div></td></tr><tr><td>Device Version</td><td><div class="form-group">' . $data["version"] . '</div></td></tr><tr><td>App  Version</td><td><div class="form-group">' . $data["app_version"] . '</div></td></tr><tr><td>App Name</td><td><div class="form-group">' . $data["app_name"] . '</div></td></tr>';


					$gps_lat		   =  $data['gps_lat']  ;
					$gps_lng		   =  $data['gps_lng']  ;
					$userName		   =  $data['name']  ;
					$device_type	   =  $data['device_type']  ;
				}
			} else {
				$error = 1;
			}

			echo json_encode([ 'error' => $error, 'otaTemplateData' => $otaTemplateData, 'otherAppSettings' => $otherAppSettings, 'gps_lat' => $gps_lat, 'gps_lng' => $gps_lng, 'userName' => $userName, 'device_type' => $device_type ]) ;
	}


	function getUserForOperatorTable() {
		//die('Please be sure you want to import the users data.');

		$conexion = new PDO("informix:host=".$this->config->item('pdo_connect')['host'].";service=".$this->config->item('pdo_connect')['service'].";database=".$this->config->item('pdo_connect')['database'].";server=".$this->config->item('pdo_connect')['server'].";protocol=".$this->config->item('pdo_connect')['protocol'].";EnableScrollableCursors=".$this->config->item('pdo_connect')['EnableScrollableCursors'].";client_locale=".$this->config->item('pdo_connect')['client_locale'].";db_locale=".$this->config->item('pdo_connect')['db_locale'] ,$this->config->item('pdo_connect')['db_user'],$this->config->item('pdo_connect')['db_pass']);


				/*$sql    = "select contsite.phone, customer.name, customer.serialno, systrans.recid
		from customer, contsite, systrans
		where customer.serialno = contsite.serialno
		and customer.serialno = systrans.serialno
		and contsite.contid = 1
		and systrans.recid in (7, 40);";*/
		
		
		$sql    = "select contsite.phone, customer.name, customer.serialno, systrans.recid, customer.linkno as offlinkno, linkacc_1.parent as calinkno, linkacc_3.linkno
from customer, contsite, systrans, OUTER (linkacc linkacc_1, OUTER (linkacc linkacc_2, OUTER (linkacc linkacc_3, OUTER (linkacc linkacc_4))))
where customer.serialno = contsite.serialno
and customer.linkno = linkacc_1.linkno
and linkacc_1.parent = linkacc_2.linkno
and linkacc_2.parent = linkacc_3.linkno
and linkacc_3.parent = linkacc_4.linkno
and contsite.contid = 1
and customer.serialno = systrans.serialno
and systrans.recid in (7, 40);";
		
		
		$query   = $conexion->prepare($sql);
		$query->execute();
		$queryResponse = $query->fetchAll(PDO::FETCH_ASSOC);
		$userData = $this->users->insertUserDataOperators($queryResponse);

		//debug($queryResponse, 1) ;

		//echo '<br>Total Rows: '.count($queryResponse);
		//echo '<br>Updated Rows: '.count($userData);
	}

	public function getAllSignalsAndTimerUsers() {

		$data = $this->users->getAllSignalsAndTimerUsers() ;


		//$getGoogleFCMToken = $data['googleFCMTOkens'] ;
		//$userData		   = $data['userData'] ;

		$getGoogleFCMToken  = $data ;

		//$insertRecord 	   = $this->users->insertCurlRecord() ;
		//$concatData		   = "" ;

		if ( $getGoogleFCMToken ) {

			$url 			= 'https://fcm.googleapis.com/fcm/send' ;
			$serverKey      = self::$API_ACCESS_KEY ;
			$message = array(
				'title' => 'checkForAllSignalsAndTimerUsers',
				'responseId' => $insertRecord,
			);

			$headers = array(
				'Authorization: key=' . $serverKey,
				'Content-Type: application/json'
			);

			$fields = array(
				'registration_ids' => $getGoogleFCMToken,
				'data' => $message,
				'priority' 		=> 'high'
			);

			$ch = curl_init();
			// Set the url, number of POST vars, POST data
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

			// Disabling SSL Certificate support temporarly
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			if ($fields) {
				curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
			}

			// Execute post
			$result = curl_exec($ch);
			if ($result === FALSE) {
			   // die('Curl failed: ' . curl_error($ch));

			   $message  = 'Curl failed: ' . curl_error($ch) ;


			} else {

				$resultArray = json_decode($result, true);
				//debug($resultArray) ;

				/**Concat All data in  last_curl_check Table***
				$concatData .= 'Success = ' . $resultArray['success'] . ', Failure = ' .  $resultArray['failure'].PHP_EOL ;

				if ( ( isset( $resultArray['results']  ) &&  $resultArray['results'] ) && $userData ) {
					$counterResult = 0 ;

					foreach ( $resultArray['results'] as $resultsArrayData ) {

						$concatData .= "Name = " . $userData[$counterResult]['loginname'].', Number = '.$userData[$counterResult]['number'] ;

						if ( isset( $resultsArrayData['error'] ) ) {
							$concatData .= ", Message = " . $resultsArrayData['error'] ;
						} elseif( isset( $resultsArrayData['message_id'] ) ) {
							$concatData .= ", Message = " . $resultsArrayData['message_id'] ;
						} else {
							$concatData .= ", Message = some other"  ;
						}

						$concatData .=	PHP_EOL ;
						$counterResult++ ;
					}

				}

				/**Concat All data in  last_curl_check Table***/


				$message = "Curl successful, Notifications sent to valid FCM tokens" ;

			}

			// Close connection
			curl_close($ch);

		} else {

			$message = "No Users Found" ;

		}

		//echo $concatData ;
		$logCurlDetails = $this->users->logCurlDetails('getAllSignalsAndTimerUsers', $message) ;
		//$logCurlDetails = $this->users->updateCurlRecord($insertRecord, $message, $concatData) ;

		echo $message ;

	}


	public function fcmResponse () { // This function is used for insight 55


		$id 		= $this->input->post('id') ;
		$number 	= $this->input->post('number') ;
		$user_name 	= $this->input->post('user_name') ;

		if ( $id && $number && $user_name) {

			$addData  = $this->users->updateFCMCronResponse($id, $number, $user_name) ;

			if ($addData) {
				$dataStatus = 1 ;
				$message 	= "Success" ;
			} else {
				$dataStatus = 0 ;
				$message 	= "Internal Server Error" ;
			}

		} else {
			$dataStatus = 0 ;
			$message 	= "Missing required Parameters" ;
		}

		echo json_encode([ 'dataStatus' => $dataStatus, 'message' => $message ]);

	}


	public function pushNotificationIOS() {


		$getGoogleFCMToken = ['fDsNHrCQ-06doO7066E9U4:APA91bHsAKz2njBhtin84d5QRs6lGfGD0NMkfNs4YwNCwQTp12wo_eUwtExqG6Mus0qSHqPhuaK6bNffl8aTr06ixQMdTGdBm-BSwEjMyAj76PT2sjReZUJAMWbUg10_AAQ21yaNyq1h'] ;


		$url 			= 'https://fcm.googleapis.com/fcm/send' ;
		$serverKey      = self::$API_ACCESS_KEY ;

		$data = [

				   //'sipCall' 					=> $getTemplateData[0]['sip_call'] ,
				   'triggerSos' 				=> "1",
				   'presslabel' 				=> "1",
				   'ripAlarm'   				=> "1",
				  // 'fallDetect'    				=> $getTemplateData[0]['fall_detect'],
				  // 'fallSenstivity'				=> $getTemplateData[0]['fall_detect_senstivity'],
				   'minmandowntimerminutes' 	=> "1",
				   'minmandowntimerseconds'		=> "1",
				   'maxmandowntimerminutes'		=> "1",
				   'maxmandowntimerseconds'		=> "1",
				   'minambertimerhours'			=> "1",
				   'minambertimerminutes'		=> "1",
				   'maxambertimerhours'			=> "1",
				   'maxambertimerminutes'		=> "1",
				   'gpsfrequencyupdate'			=> "1",
				   'settings'					=> "1",
				   'gpsposcriteria'				=> "1",
				   'settingName'				=> "1",
				   'settingId'					=> "1",
				   'sms'						=> "1",
				   'finger_print_lock'			=> "1",
				   'calendar'					=> "1"
		] ;

		$message = array(
			'title' 		=> 'Configuration received IOS test.',
			'message'		=> 'Please set the configuration.' ,
			'data' 		    => json_encode($data)
		);

		$headers = array(
			'Authorization: key=' . $serverKey,
			'Content-Type: application/json'
		);

		$fields = array(
			'registration_ids' => $getGoogleFCMToken,
			'notification' 	   => $message,
			'priority' 		   => 'high'
		);

		$ch = curl_init();
		// Set the url, number of POST vars, POST data
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		// Disabling SSL Certificate support temporarly
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		if ($fields) {
			curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
		}

		// Execute post
		$result = curl_exec($ch);
		if ($result === FALSE) {
		   // die('Curl failed: ' . curl_error($ch));

		   $message  = 'Curl failed: ' . curl_error($ch) ;


		} else {

				$message = "Curl successful, Notifications sent to valid FCM tokens" ;

				echo $message ;

				$resultArray = json_decode($result, true);


				debug($resultArray, 1) ;

				$message = "Curl successful, Notifications sent to valid FCM tokens" ;

		}

			// Close connection
			curl_close($ch);

	}





	public function sendHomesafeGeofenceNotifications() {

		$latitude 		= $this->input->post('latitude') ;
		$longitude	 	= $this->input->post('longitude') ;
		$radius 		= $this->input->post('radius') ;
		$phone 			= $this->input->post('phone') ;
		$serialNumber 	= $this->input->post('serialNumber') ;
		$name 			= $this->input->post('name') ;
		$homeSafeName 	= $this->input->post('homeSafeName') ;
		$fcmDeviceToken = "" ;
		$deviceType 	= "" ;
		$error   		= "" ;
		$message 		= "" ;
		$resultArray	= "" ;

		$getData = $this->users->getSingleDataFromOperatorsTable($phone) ;

		if($getData) {
			//debug($getData) ;
				if (isset($getData['device_token']) && $getData['device_token']) {

					if ( $getData['device_type'] == "android" ) {
						$fcmDeviceToken 			= $getData['device_token'] ; // FCM notification token
						$deviceType	  				= $getData['device_type'] ;  // ios / android
					}


					if ( $getData['device_type'] == "ios" ) {
						$fcmDeviceToken 			= $getData['device_token'] ; // FCM notification token
						$deviceType	  				= $getData['device_type'] ;  // ios / android
					}

					if( $fcmDeviceToken ) {

						$fcmDeviceToken = [$fcmDeviceToken] ;

						$url 			= 'https://fcm.googleapis.com/fcm/send' ;
						$serverKey      = self::$API_ACCESS_KEY ;

						$data = [

							   'latitude' 				=> $latitude,
							   'longitude' 				=> $longitude,
							   'radius'   				=> $radius,
							   'name' 					=> $homeSafeName
							] ;
						$message = array(
							'message' => 'This is a testing message',
							'title' => 'Geofence configuration received.',
							'tickerText' => 'Ticker text here...Ticker text here...',
							'vibrate' => 1,
							'sound' => 1,
							'largeIcon' => 'large_icon',
							'smallIcon' => 'small_icon',
							'data' => json_encode($data)
						);

						$headers = array(
							'Authorization: key=' . $serverKey,
							'Content-Type: application/json'
						);

						if ( $deviceType == "android" ) {

							$fields = array(
								'registration_ids' => $fcmDeviceToken,
								'data' => $message,
								'priority' 		=> 'high'
							);

							$ch = curl_init();
							// Set the url, number of POST vars, POST data
							curl_setopt($ch, CURLOPT_URL, $url);
							curl_setopt($ch, CURLOPT_POST, true);
							curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
							curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

							// Disabling SSL Certificate support temporarly
							curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
							if ($fields) {
								curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
							}

							// Execute post
							$result = curl_exec($ch);

							if ($result === FALSE) {
							   // die('Curl failed: ' . curl_error($ch));
							   $message = 'Curl failed: ' . curl_error($ch) ;
							   $error = 2 ;
							} else {

								$resultArray = json_decode($result, true);
								//debug($resultArray, 1) ;
								if (isset($resultArray['results']) && $resultArray['results']) {
									$counterNew = 0 ;
									foreach($resultArray['results'] as $nData) {

										if ($counterNew == "1") {
											break ;
										}

										if (isset($nData['error'])) {
											$actualErrorMessage = $nData['error'] ;
											$message = 'Homesafe geofencing configuration not sent' ;
											$error = 1 ;
										} else{
											$message = 'Homesafe Location created and sent to the device' ;
											$error = 0 ;
											//Data to save
										}

										$counterNew++;
									}
								} else {
										$error   = 1 ;
										$message = "No response from FCM.";
								}
							}

							// Close connection
							curl_close($ch);



						}



						if ( $deviceType == "ios" ) {  // for ios devices to send notifications


							$fields = array(
								'registration_ids' => $fcmDeviceToken,
								'notification' 	   => $message,
								'mutable_content'  => true,
								'content_available' => true,
								'apnsPushType'      => "background",
								'priority' 		   => 'high'
							);

							$ch = curl_init();
							// Set the url, number of POST vars, POST data
							curl_setopt($ch, CURLOPT_URL, $url);
							curl_setopt($ch, CURLOPT_POST, true);
							curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
							curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

							// Disabling SSL Certificate support temporarly
							curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
							if ($fields) {
								curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
							}

							// Execute post
							$result = curl_exec($ch);

							if ($result === FALSE) {
							   $message = 'Curl failed: ' . curl_error($ch) ;
							   $error = 2 ;
							} else {

								$resultArray = json_decode($result, true);

								if (isset($resultArray['results']) && $resultArray['results']) {
									$counterNew = 0 ;
									foreach($resultArray['results'] as $nData) {

										if ($counterNew == "1") {
											break ;
										}

										if (isset($nData['error'])) {
											$actualErrorMessage = $nData['error'] ;
											$message = 'Homesafe geofencing configuration not sent' ;
											$error = 1 ;
										} else{
											$message = 'Homesafe Location created and sent to the device' ;
											$error = 0 ;
											//Data to save
										}

										$counterNew++;
									}
								} else {
										$error   = 2 ;
										$message = "No response from FCM.";
								}
							}

							// Close connection
							curl_close($ch);
						}




					} else {

						$error   = 2 ;
						$message = "The selected device is not logged in or not using the latest version of the app. The device will not not receive the messages.";

					}




			} else {
					$error   = 2 ;
					$message = "The selected device is not logged in or not using the latest version of the app. The device will not not receive the messages.";
			}

		} else {

				$error   = 2 ;
				$message = "No users found";
		}

		//save the data in database if notification is sent

		if ( $error   == "0" ) {
			$preparTableData['name']		  = $name ;
			$preparTableData['phone'] 		  = $phone ;
			$preparTableData['serial_number'] = $serialNumber ;
			$preparTableData['latitude'] 	  = $latitude ;
			$preparTableData['longitude']     = $longitude ;
			$preparTableData['radius']        = $radius ;
			$preparTableData['homesafe_name'] = $homeSafeName ;
			$preparTableData['device_type']   = $deviceType ;
			$preparTableData['created_from']  = "web" ;


			$saveInfo = $this->users->saveInfoHomesafeGeofnece($preparTableData) ;
		}


		echo json_encode([ 'error' => $error, 'message' => $message, 'deviceType' => $deviceType, 'resultArray' => $resultArray  ]) ;

	}

	public function getUserGeofenceDeatils() {

		$serialNumber = $this->input->post('serialNumber') ;

		//$serialNumber = "158295" ;

		if ($serialNumber) {

			$getUserData = $this->users->getUserGeofenceDeatils($serialNumber) ;

			if ($getUserData) {
				$error = 0 ;
				$data  = $getUserData ;
			} else {
				$error = 1 ;
				$data  = "" ;
			}


		} else {
			$error = 1 ;
			$data  = "" ;
		}

		echo json_encode([ 'error' => $error, 'data' => $data ]) ;

	}

	
	
	
	/* Cron functionality to send geofence details to android users only from homesafe_geofencing_user_details */ 
	
	public function cronForHomesafeUserDetails() {

		$data = $this->users->cronForHomesafeUserDetails() ;
		
		if ($data) {
			
			$url 			= 'https://fcm.googleapis.com/fcm/send' ;
			$serverKey      = self::$API_ACCESS_KEY ;
			
			foreach( $data as $newData ) {
			
				$data = [

				   'latitude' 				=> $newData['latitude'],
				   'longitude' 				=> $newData['longitude'],
				   'radius'   				=> $newData['radius'],
				   'name' 					=> $newData['homesafe_name'],
				   'serialNumber' 			=> $newData['serial_number']
				] ;
			
				$message = array(
					'title' => 'cronForHomesafeUserDetails',
					'data' => json_encode($data)
				);
				
				
				$headers = array(
					'Authorization: key=' . $serverKey,
					'Content-Type: application/json'
				);

				$fields = array(
					'to'		 => $newData['device_token'],
					'data' 		 => $message,
					'priority' 	 => 'high'
				);
				
				$ch = curl_init();
				
				curl_setopt($ch, CURLOPT_URL, $url);
				curl_setopt($ch, CURLOPT_POST, true);
				curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
				if ($fields) {
					curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
				}

				$result = curl_exec($ch);
				if ($result === FALSE) {
					
					//$message  = 'Curl failed: ' . curl_error($ch) ;
					//Curl Failed

				} else {

					//$resultArray = json_decode($result, true);
					//Curl Success
					
					//debug($resultArray) ;
				}
				
				
				curl_close($ch);
				
				
				
			}
		
		
		
			$message = "Curl successful, Notifications sent to valid FCM tokens" ;
		
		} else {

			$message = "No Users Found" ;

		}
		
		echo $message ;

	}
	
	
	
}
