<?php



class Moodlewebservices extends CI_Controller {


	public $wsCurlUrl ;

	function __construct()
	{
		parent::__construct();

		$this->load->library('curlmoodle');
		$this->load->model('elearningmoodle');
		$this->load->model('users');

		$this->wsCurlUrl = $this->config->item('moodle')['wsdomain'].$this->config->item('moodle')['wsfilepath'].'?wstoken='.$this->config->item('moodle')['wstoken'].'&moodlewsrestformat='.$this->config->item('moodle')['wsrestformat'] ;

	}
	
	
	public function checkSession() {
	
		debug($_SESSION, 1) ;
	
	}

	public function getAllCourses() {

		/*$checkLoggedInToken = $this->users->checkLoggedInToken( $this->session->userdata('user_id'), $this->session->userdata('loginToken') );

		if( !$checkLoggedInToken ){
			echo json_encode([ 'error' => '1', 'msg' => 'unauthorized']);
			exit ;
		}*/

		$functionname = 'core_course_get_courses_by_field';
		$serverurl = $this->wsCurlUrl.'&wsfunction='.$functionname ;

		$response = $this->curlmoodle->post($serverurl);
		$data = [] ;

		$response =  json_decode($response, true) ;

		if (!$response) {
			echo json_encode([ 'error' => '1', 'msg' => 'no data found', 'data' => $data ]);
			exit;
		}

		$counter = 0 ;
		foreach($response['courses'] as $courses) {
			
			if ( isset($courses['id']) && $courses['id'] == "1" ) {
				continue;
			}
			
			$data[$counter]['title']     = ( isset($courses['displayname']) && $courses['displayname'] ? $courses['displayname'] : '-' ) ;
			$data[$counter]['summary']   = ( isset($courses['summary']) && $courses['summary'] ? trim(strip_tags($courses['summary'])) : '-' ) ;
			$data[$counter]['courseId']  = ( isset($courses['id']) && $courses['id'] ? $courses['id'] : '' ) ;
			$data[$counter]['image']     = ( isset($courses['overviewfiles'][0]['fileurl']) && $courses['overviewfiles'][0]['fileurl'] ? $courses['overviewfiles'][0]['fileurl'] : 'noImage' ) ;


			$data[$counter]['getCourseCostCentres'] = $this->elearningmoodle->getCourseCostCentres($courses['id']) ;

			$counter++ ;
		}

		echo json_encode([ 'error' => '0', 'msg' => 'data found', 'data' => $data ]);

		//debug($data, 1) ;

	}



	public function getAllCoursesForReporting() {
		
		$data = [] ;
		$courseNotFound = "" ;
		$costCenterId = $this->input->post('costCenterId') ;
		
		if (!$costCenterId ) {
			echo json_encode([ 'error' => '1', 'msg' => 'Missing required parameter cost center id', 'data' => $data ]);
			exit;
		}

		if ( $costCenterId == "all" ) {
			
			$functionname = 'core_course_get_courses_by_field';
			$serverurl 	  = $this->wsCurlUrl.'&wsfunction='.$functionname ;
			$response 	  = $this->curlmoodle->post($serverurl);
			$response 	  =  json_decode($response, true) ;
			
		
			if ( isset($response['courses']) && $response['courses'] ) {
				
				$counter = 0 ;
				foreach($response['courses'] as $courses) {

					$data[$counter]['title']     = ( isset($courses['displayname']) && $courses['displayname'] ? $courses['displayname'] : '-' ) ;
					$data[$counter]['summary']   = ( isset($courses['summary']) && $courses['summary'] ? trim(strip_tags($courses['summary'])) : '-' ) ;
					$data[$counter]['courseId']  = ( isset($courses['id']) && $courses['id'] ? $courses['id'] : '' ) ;
					$data[$counter]['image']     = ( isset($courses['overviewfiles'][0]['fileurl']) && $courses['overviewfiles'][0]['fileurl'] ? $courses['overviewfiles'][0]['fileurl'] : 'noImage' ) ;


					//$data[$counter]['getCourseCostCentres'] = $this->elearningmoodle->getCourseCostCentres($courses['id']) ;

					$counter++ ;
				}
				
				echo json_encode([ 'error' => '0', 'msg' => 'data found', 'data' => $data ]);
				exit;
				
			} else {
					echo json_encode([ 'error' => '1', 'msg' => 'no data found', 'data' => $data ]);
					exit;
			}
			
		
		} else {
		
		
			$getAllCoursesManager = $this->elearningmoodle->getAllCoursesManager($costCenterId) ;
			
			if (!$getAllCoursesManager) {
				echo json_encode([ 'error' => '1', 'msg' => 'No courses assigned', 'data' => $data ]);
				exit;
			}
			
			
			$counter = 0 ;
			
			foreach($getAllCoursesManager as $courses) {
		   
		   
				$parameters = array(
					"field" => 'id',
					"value" =>  $courses['course_id']
				);



				$functionname = 'core_course_get_courses_by_field';
				$serverurl = $this->wsCurlUrl.'&wsfunction='.$functionname ;

				$response = $this->curlmoodle->post($serverurl, $parameters);
				
				$response =  json_decode($response, true) ;
			   
				if ( isset($response['courses'][0]['id']) && $response['courses'][0]['id'] ==  $courses['course_id'] ) {
					
					$data[$counter]['title']     = ( isset($response['courses'][0]['displayname']) && $response['courses'][0]['displayname'] ? $response['courses'][0]['displayname'] : '-' ) ;
					$data[$counter]['summary']   = ( isset($response['courses'][0]['summary']) && $response['courses'][0]['summary'] ? trim(strip_tags($response['courses'][0]['summary'])) : '-' ) ;
					$data[$counter]['courseId']  = ( isset($response['courses'][0]['id']) && $response['courses'][0]['id'] ? $response['courses'][0]['id'] : '' ) ;
					$data[$counter]['image']     = ( isset($response['courses'][0]['overviewfiles'][0]['fileurl']) && $response['courses'][0]['overviewfiles'][0]['fileurl'] ? $response['courses'][0]['overviewfiles'][0]['fileurl'] : 'noImage' ) ;


					//$data[$counter]['getCourseCostCentres'] = $this->elearningmoodle->getTraineeInitialsListingManager($courses['id'],$userLinkAccountid, $dbColumnName) ;

					$counter++ ;
				} else {
					$courseNotFound .= $courses['course_id'].', ' ;
				}
		  }
		  
		  if ($data) {
			$error = '0';
			$msg   = 'data found';
		  } else {
			$error = '1';
			$msg   = 'data found but courses not found in elearning website';
		  }
		  
		  echo json_encode([ 'error' => $error, 'msg' => $msg, 'data' => $data, 'courseNotFound' => $courseNotFound ]);
		  exit;
		}
	}
	
	
	
	
	
	public function getCourseDetailMoodle() {

		/*$checkLoggedInToken = $this->users->checkLoggedInToken( $this->session->userdata('user_id'), $this->session->userdata('loginToken') );

		if( !$checkLoggedInToken ){
			echo json_encode([ 'error' => '1', 'msg' => 'unauthorized']);
			exit ;
		}*/

		$mainCourseId    = $this->input->post('mainCourseId');
		//$mainCourseId    = "4" ;

		/***1st part to get image url**/
		$parameters = array(
			"field" => 'id',
			"value" => $mainCourseId,
		);

		$functionname = 'core_course_get_courses_by_field';
		$serverurl = $this->wsCurlUrl.'&wsfunction='.$functionname ;

		$response1 = $this->curlmoodle->post($serverurl, $parameters);
		$response1 =  json_decode($response1, true) ;

		$data = [] ;

		$data['title']     = ( isset($response1['courses'][0]['displayname']) && $response1['courses'][0]['displayname'] ? $response1['courses'][0]['displayname'] : '-' ) ;
		$data['summary']   = ( isset($response1['courses'][0]['summary']) && $response1['courses'][0]['summary'] ? trim(strip_tags($response1['courses'][0]['summary'])) : '-' ) ;
		$data['courseId']  = ( isset($response1['courses'][0]['id']) && $response1['courses'][0]['id'] ? $response1['courses'][0]['id'] : '' ) ;
		$data['image']     = ( isset($response1['courses'][0]['overviewfiles'][0]['fileurl']) && $response1['courses'][0]['overviewfiles'][0]['fileurl'] ? $response1['courses'][0]['overviewfiles'][0]['fileurl'] : 'noImage' ) ;
		/***1st part to get image url**/



		/***2nd part to get number of sections**/
		$functionname = 'core_course_get_courses';
		$serverurl = $this->wsCurlUrl.'&wsfunction='.$functionname ;

		$parameter = [

					'options' => [
							'ids' => [$mainCourseId]
					]

				];

		$response2 = $this->curlmoodle->post($serverurl, $parameter);
		$response2 = json_decode($response2, true);

		$data['numsections']     = ( isset($response2[0]['numsections'])  ? $response2[0]['numsections'] : '-' ) ;

		/***2nd part to get number of sections**/

		echo json_encode([ 'error' => '0', 'msg' => 'data found', 'data' => $data ]);


	}

	function addUserToMoodle() {

		/*$checkLoggedInToken = $this->users->checkLoggedInToken( $this->session->userdata('user_id'), $this->session->userdata('loginToken') );

		if( !$checkLoggedInToken ){
			echo json_encode([ 'error' => '1', 'msg' => 'unauthorized']);
			exit ;
		}*/



		if( $this->session->userdata('login_id') != 1 )
		{
			echo json_encode([ 'error' => '1', 'msg' => 'unauthorized']);
			exit ;
		}


		//Pending to remove my email and add the dynamic email in email section.
		$requestData = $this->input->post() ;

		$username = trim(strtolower($requestData['email'])) ;

		$userId = $this->elearningmoodle->addtraineeUser($requestData, $username) ;

		if (!$userId) {
			echo json_encode([ 'error' => '1', 'msg' => 'Internal server problem']);
			exit ;
		}



		$functionname = 'core_user_create_users';
		$serverurl = $this->wsCurlUrl.'&wsfunction='.$functionname ;

		$user = array(
			"username"     => trim(strtolower($requestData['email'])), // must be unique.
			"password"     => $requestData['password'],  // atleast contain one capital letter
			"firstname"    => $requestData['firstName'],
			"lastname"     => $requestData['lastName'],
			"email"        => $requestData['email'], // must be unique
			"phone2"       =>  $requestData['contactNumber'],
			"customfields" => [
						["type" => "sentry_trainee_id", "value" => $userId],
			]
		);

		$users = array($user);

		$param = array("users" => $users);

		$response = $this->curlmoodle->post($serverurl, $param);
		$response = json_decode($response, true);

		if ( !$response ) {
			$removeUser = $this->elearningmoodle->deleteTraineeUser($userId) ;
			echo json_encode([ 'error' => '1', 'msg' => 'No response from web service api']);
			exit ;
		}

		if ( isset($response['debuginfo']) ) {
			$removeUser = $this->elearningmoodle->deleteTraineeUser($userId) ;
			echo json_encode([ 'error' => '1', 'msg' => $response['debuginfo']]);
			exit ;
		}

		if ( isset($response['exception']) && isset($response['message'])  ) {
			$removeUser = $this->elearningmoodle->deleteTraineeUser($userId) ;
			echo json_encode([ 'error' => '1', 'msg' => $response['message']]);
			exit ;
		}


		if ( isset($response[0]['id']) && $response[0]['id'] ) {

			 $moodleUserId = $response[0]['id'] ;

			 $dataEmail   			= $requestData ;
			 $dataEmail['username'] = $username ;
			 $dataEmail['type'] 	= "addUser" ;

			 /***Send email to user with credentials***/
			 $sendCredentialsEmail = $this->sendCredentialsEmail($dataEmail) ;

			 $finalMessage = "Trainee added" ;

			 if( $sendCredentialsEmail == "mailSent" ) {
					$updateTraineeTable['email_status'] = '1' ;

			 } else {
					$updateTraineeTable['email_status'] = '0' ;
					$finalMessage .= "  Credentials email not sent" ;
			 }
			  /***Send email to user with credentials***/


			 /***Update trainee users data for moodle id and email status***/
			 $updateTraineeTable['moodle_user_id'] = $moodleUserId ;

			 $updateTraineeUserMoodleIdEmailStatus = $this->elearningmoodle->updateTraineeUserMoodleIdEmailStatus($updateTraineeTable, $userId) ;
			 /***Update trainee users data for moodle id and email status***/



			 /***Enrol user to the course***/
			 $enrolUserToCourse = $this->enrolCreatedUserToCourse($requestData['mainCourseId'], $moodleUserId) ;
			 /***Enrol user to the course***/


			 /***Final response***/
			 if ( $enrolUserToCourse['status'] == "0" ) { // user not enroled to course
				 $finalMessage .= " " . $enrolUserToCourse['message'] ;
			 } else {
				//Add data in course table
				  $postInsertCourseData['course_id'] 			  = $requestData['mainCourseId'];
				  $postInsertCourseData['sentry_trainee_user_id'] = $userId;
				  $postInsertCourseData['moodle_user_id'] 		  = $moodleUserId;
				  $postInsertCourseData['assigned_by_user_type']  = ( $this->session->userdata('type') == "superadmin" ? '1':'2') ;
				  $postInsertCourseData['assigned_by_user_id']	  = $this->session->userdata('user_id') ;
				  $postInsertCourseData['assigned_by_user_name']  = $this->session->userdata('username') ;

				  $insertCourseData = $this->elearningmoodle->insertCourseData($postInsertCourseData) ;
			 }

			 //Pending to add the course detail in database.

			 echo json_encode([ 'error' => '0', 'msg' => $finalMessage]);
			 exit ;

			 /***Final response***/

		} else {
			$removeUser = $this->elearningmoodle->deleteTraineeUser($userId) ;
			echo json_encode([ 'error' => '1', 'msg' => 'No response from web service api']);
			exit ;
		}




	}


	public function sendCredentialsEmail(	$dataEmail)
    {

		$email 	  =  trim($dataEmail['email']) ;
		//$email  =  "webmasterdevops@gmail.com" ;

		$subject  =  "Elearning" ;
		$message  =  "Elearning" ;

		if ( $dataEmail['type'] == "addUser") {

			$subject  =  "Orbis protect elearning portal account created" ;

		//	$message  = "Your account has been created for Orbis protect elearning portal, below are the details:<br/>Username:".$dataEmail['username']."<br/>Password:".$dataEmail['password'] ;

				$message  = '<div style="width:100%; margin:0 auto">
	          <div style="width:100%; float:left; background:#f7f7f7; padding:30px 50px;">
								<div style="width:550px; float:left>
	              <span style="width:100%; font-size:30px; float:left; color:#1f3161; margin-bottom:15px;">Welcome!</span>
	              <span style="width:100%; font-size:15px; float:left; color:#333; margin-bottom:15px;">We are excited to have you get started.</span>
	              <span style="width:100%; font-size:15px; float:left; color:#1f3161; font-weight:bold; margin-bottom:15px;">Your account has been created for Orbis protect elearning portal, below are the details:</span>
	              <table style="width:350px; float:left; margin-bottom:15px;" cellspacing="0" cellpadding="0" border="1">
	                  <tr>
	                    <td style="padding:10px; width: 90px;">Username</td>
	                    <td style="padding:10px; width:250px">'.$dataEmail['username'].'</td>
	                  </tr>
	                  <tr>
	                    <td style="padding:10px; width: 90px;">Password</td>
	                    <td style="padding:10px; width:250px">'.$dataEmail['password'].'</td>
	                  </tr>

	              </table>
	              <span style="width:100%; float:left;">
	              <a href="http://52.56.223.226/login/index.php" style="background:#1f3161; color:#fff; float:left; padding: 9px 30px; font-size:14px; font-weight: bold; border-radius:4px;">Login</a>
	            </span>
	          </div></div>
	      </div>' ;


		}


		if ( $dataEmail['type'] == "updateUser") {

			$subject  =  "Orbis protect elearning password updated" ;

			//$message  = "Your password has been updated for Orbis protect elearning portal, below are the details:<br/>Password:".$dataEmail['password'] ;

			$message  = '<div style="width:100%; float:left; background:#f7f7f7; padding:30px 50px;">
					<div style="width:550px; float:left>
              <span style="width:100%; font-size:30px; float:left; color:#1f3161; margin-bottom:15px;">Password Updated</span>
              <span style="width:100%; font-size:15px; float:left; color:#1f3161; font-weight:bold; margin-bottom:15px;">Your password has been updated for Orbis protect elearning portal, below are the details:</span>
              <table style="width:350px; float:left; margin-bottom:15px;" cellspacing="0" cellpadding="0" border="1">
                  <tr>
                    <td style="padding:10px; width: 90px;">Password</td>
                    <td style="padding:10px; width:250px">'.$dataEmail['password'].'</td>
                  </tr>
              </table>
              <span style="width:100%; float:left;">
              <a href="http://52.56.223.226/login/index.php" style="background:#1f3161; color:#fff; float:left; padding: 9px 30px; font-size:14px; font-weight: bold; border-radius:4px;">Login</a>
            </span>
          </div>
      </div>	' ;
		}



		$config = Array(
		  'protocol' 	 => 'smtp',
		  'smtp_host'	 => 'smtp.office365.com',
		  'smtp_port' 	 =>  587,
		  'smtp_user'	 => 'orbisreports@orbisprotect.com',
		  'smtp_pass'	 => 'Haqa5302',
		  'smtp_crypto'  => 'tls',
		  'mailtype' 	 => 'html',
		);

	    $this->load->library('email', $config);
	    $this->email->set_newline("\r\n");
	    $this->email->set_crlf( "\r\n" );
	    $this->email->from('orbisreports@orbisprotect.com', 'Orbis');
	    $this->email->to($email);

	    $this->email->subject($subject);
	    $this->email->message($message);

	    if($this->email->send())
	    {
			return "mailSent" ;
		}
	    else
	    {
		  //$errorMail = $this->email->print_debugger() ;
		  return "mailNotSent" ;
	    }
	}

	/***Mail function to send email***/


	public function enrolCreatedUserToCourse($mainCourseId, $moodleUserId) {


		$functionname = 'enrol_manual_enrol_users';
		$serverurl = $this->wsCurlUrl.'&wsfunction='.$functionname ;

		$parameter = array(
			"roleid"     => '5',
			"userid"     => $moodleUserId,
			"courseid"   => $mainCourseId
		);

		$parameters = array($parameter);

		$param = array("enrolments" => $parameters);

		$response = $this->curlmoodle->post($serverurl, $param);
		$response = json_decode($response, true);



		$message = "";
		$data	 = [];

		if ( isset($response['exception']) ) {

			$message .= "Error course enrolment" ;

			if ( isset($response['message']) ) {
				$message .= ": " . $response['message'] ;
			}

			if ( isset($response['debuginfo']) ) {
				$message .= " " . $response['debuginfo'] ;
			}

			$data['status']  = '0' ;
			$data['message'] = $message ;

		} else {
			$data['status']  = '1' ;
			$data['message'] = $message ;
		}


		 return $data ;

		//~ debug($response) ;
		//~ debug($data, 1) ;
	}

	public function test() {

		$data = $this->elearningmoodle->getCourseUsers(4) ;

	}


	function updateUserToMoodle() {

		/*$checkLoggedInToken = $this->users->checkLoggedInToken( $this->session->userdata('user_id'), $this->session->userdata('loginToken') );

		if( !$checkLoggedInToken ){
			echo json_encode([ 'error' => '1', 'msg' => 'unauthorized']);
			exit ;
		}*/


		if( $this->session->userdata('login_id') != 1 )
		{
			echo json_encode([ 'error' => '1', 'msg' => 'unauthorized']);
			exit ;
		}


		//Pending to remove my email and add the dynamic email in email section.
		$requestData = $this->input->post() ;


		/***If email is changed, check any email exists***/
		if ( $requestData['emailUpdate'] != $requestData['emailUpdateOrignal'] ) {

			$functionname = 'core_user_get_users';
			$serverurl = $this->wsCurlUrl.'&wsfunction='.$functionname ;

			$user = array(
				"key"       =>   "email",
				"value"     =>   $requestData['emailUpdate'],
			);


			$users = array($user);

			$param = array("criteria" => $users);

			$response = $this->curlmoodle->post($serverurl, $param);
			$response = json_decode($response, true);

			if ( isset($response['users']) && $response['users'] ) {
				echo json_encode([ 'error' => '1', 'msg' => 'Email already exists']);
				exit ;
			}

		}
		/***If email is changed, check any email exists***/


		$functionname = 'core_user_update_users';
		$serverurl = $this->wsCurlUrl.'&wsfunction='.$functionname ;

		$dataToUpdateLocalDb['first_name'] 			   = $requestData['firstNameUpdate'] ;
		$dataToUpdateLocalDb['last_name']              = $requestData['lastNameUpdate'] ;
		$dataToUpdateLocalDb['email']      			   = $requestData['emailUpdate'] ;
		$dataToUpdateLocalDb['mobile']     			   = $requestData['contactNumberUpdate'] ;
		$dataToUpdateLocalDb['created_by'] 		 	   = ( $this->session->userdata('type') == "superadmin" ? '1':'2') ;
	    $dataToUpdateLocalDb['created_by_user_id'] 	   = $this->session->userdata('user_id') ;
	    $dataToUpdateLocalDb['created_by_user_name']   = $this->session->userdata('username') ;
	    $dataToUpdateLocalDb['cost_centre_id'] 		   = $requestData['costCentreIdForDB'] ;
	    $dataToUpdateLocalDb['contract_area_id'] 	   = $requestData['contractAreaIdForDB'] ;
	    $dataToUpdateLocalDb['office_id'] 		 	   = $requestData['officeIdForDB'] ;
	    $dataToUpdateLocalDb['cost_centre_name'] 	   = $requestData['costCentreName'] ;
	    $dataToUpdateLocalDb['contract_area_name'] 	   = $requestData['contractAreaName'] ;
	    $dataToUpdateLocalDb['office_name'] 		   = $requestData['officeName'] ;




		if ( isset($requestData['passwordUpdate']) && $requestData['passwordUpdate']) {
			$user = array(
				"id"           => $requestData['moodleidtraineeupdate'],
				"password"     => $requestData['passwordUpdate'],
				"firstname"    => $requestData['firstNameUpdate'],
				"lastname"     => $requestData['lastNameUpdate'],
				"email"        => $requestData['emailUpdate'], // must be unique
				"phone2"       =>  $requestData['contactNumberUpdate'],
			);

			$dataToUpdateLocalDb['password']     =  encrypt_string($requestData['passwordUpdate']) ;

			$sendEmail = true ;
		} else {
				$user = array(
					"id"           => $requestData['moodleidtraineeupdate'],
					"firstname"    => $requestData['firstNameUpdate'],
					"lastname"     => $requestData['lastNameUpdate'],
					"email"        => $requestData['emailUpdate'], // must be unique
					"phone2"       =>  $requestData['contactNumberUpdate']
				);

				$sendEmail = false ;
		}

		//~ if ($sendEmail) {
			//~ echo "send email" ;
		//~ } else {
			//~ echo "don't send email" ;
		//~ }
		//~ echo $sendEmail ;



		$users = array($user);

		$param = array("users" => $users);

		$response = $this->curlmoodle->post($serverurl, $param);
		$response = json_decode($response, true);

		// below pending for tomorrow, test for the errors like email password and others

		$message = "" ;


		if ( isset($response['exception']) ) {

			$message .= "Error update" ;

			if ( isset($response['message']) ) {
				$message .= ": " . $response['message'] ;
			}

			if ( isset($response['debuginfo']) ) {
				$message .= " " . $response['debuginfo'] ;
			}


			echo json_encode([ 'error' => '1', 'msg' => $message]);
			exit ;

		} else {


			$message .= "Trainee updated" ;

			$updateTrainee = $this->elearningmoodle->updateTrainee($dataToUpdateLocalDb, $requestData['moodleidtraineeupdate']) ;


			/***Send email if password is updated***/

			if ($sendEmail) {
				$dataEmail['type'] 	    = "updateUser" ;
				$dataEmail['password']  = $requestData['passwordUpdate'] ;
				$dataEmail['email']		= $requestData['emailUpdate'] ;


				$sendCredentialsEmail = $this->sendCredentialsEmail($dataEmail) ;

				if( $sendCredentialsEmail == "mailNotSent" ) {
						$message .= "  Mail no sent for updated password" ;
				}
			}

			/***Send email if password is updated***/


			echo json_encode([ 'error' => '0', 'msg' => $message]);
			exit ;
		}

	}


	public function removeTraineeFromCourse() {

		/*$checkLoggedInToken = $this->users->checkLoggedInToken( $this->session->userdata('user_id'), $this->session->userdata('loginToken') );

		if( !$checkLoggedInToken ){
			echo json_encode([ 'error' => '1', 'msg' => 'unauthorized']);
			exit ;
		}*/


		$courseTableId 	   = $this->input->post('courseTableId');
	    $mainCourseId      = $this->input->post('mainCourseId');
	    $moodleidTrainee   = $this->input->post('moodleidTrainee');


		 if(!$courseTableId && !$mainCourseId && !$moodleidTrainee) {
			 echo json_encode([ 'error' => '1', 'msg' => 'Missing required parameters']);
			 exit ;
		 }

		$functionname = 'enrol_manual_unenrol_users';
		$serverurl = $this->wsCurlUrl.'&wsfunction='.$functionname ;

		$parameter = array(
			"userid"     => $moodleidTrainee,
			"courseid"   => $mainCourseId
		);

		$parameters = array($parameter);

		$param = array("enrolments" => $parameters);

		$response = $this->curlmoodle->post($serverurl, $param);
		$response = json_decode($response, true);



		$message = "";

		if ( isset($response['exception']) ) {

			$message .= "Error" ;

			if ( isset($response['message']) ) {
				$message .= ": " . $response['message'] ;
			}

			if ( isset($response['debuginfo']) ) {
				$message .= " " . $response['debuginfo'] ;
			}


			echo json_encode([ 'error' => '1', 'msg' => $message]);
			exit ;

		} else {
			$updateTrainee = $this->elearningmoodle->removeTraineeFromCourse($courseTableId) ;

			echo json_encode([ 'error' => '0', 'msg' => 'Trainee removed']);
			exit ;
		}

	}

	public function assignTraineeToCourse() {

		/*$checkLoggedInToken = $this->users->checkLoggedInToken( $this->session->userdata('user_id'), $this->session->userdata('loginToken') );

		if( !$checkLoggedInToken ){
			echo json_encode([ 'error' => '1', 'msg' => 'unauthorized']);
			exit ;
		}*/


		$mainCourseId 	   = $this->input->post('mainCourseId');
	    $sentryUserId      = $this->input->post('sentryUserId');
	    $moodleUserId      = $this->input->post('moodleUserId');


		 if(!$mainCourseId && !$sentryUserId && !$moodleUserId) {
			 echo json_encode([ 'error' => '1', 'msg' => 'Missing required parameters']);
			 exit ;
		 }

		$functionname = 'enrol_manual_enrol_users';
		$serverurl = $this->wsCurlUrl.'&wsfunction='.$functionname ;

		$parameter = array(
			"roleid"     => '5',
			"userid"     => $moodleUserId,
			"courseid"   => $mainCourseId
		);

		$parameters = array($parameter);

		$param = array("enrolments" => $parameters);

		$response = $this->curlmoodle->post($serverurl, $param);
		$response = json_decode($response, true);



		$message = "";

		if ( isset($response['exception']) ) {

			$message .= "Error" ;

			if ( isset($response['message']) ) {
				$message .= ": " . $response['message'] ;
			}

			if ( isset($response['debuginfo']) ) {
				$message .= " " . $response['debuginfo'] ;
			}


			echo json_encode([ 'error' => '1', 'msg' => $message]);
			exit ;

		} else {

			//Add data in course table
		    $postInsertCourseData['course_id'] 			      = $mainCourseId;
		    $postInsertCourseData['sentry_trainee_user_id']   = $sentryUserId;
		    $postInsertCourseData['moodle_user_id'] 		  = $moodleUserId;
		    $postInsertCourseData['assigned_by_user_type']    = ( $this->session->userdata('type') == "superadmin" ? '1':'2') ;
		    $postInsertCourseData['assigned_by_user_id']	  = $this->session->userdata('user_id') ;
		    $postInsertCourseData['assigned_by_user_name']	  = $this->session->userdata('username') ;

		    $insertCourseData = $this->elearningmoodle->insertCourseData($postInsertCourseData) ;


			echo json_encode([ 'error' => '0', 'msg' => 'Course assigned']);
			exit ;
		}

	}



	public function getAllCoursesManagerOld() {

		$data = [] ;

		$getAllCoursesManager = "" ;


		$userLinkAccountid = $this->input->post('userLinkAccountid')  ;
		$dbColumnName      = $this->input->post('dbColumnName') ;

		if (!$userLinkAccountid || !$dbColumnName) {
			echo json_encode([ 'error' => '1', 'msg' => 'Missing required parameters', 'data' => $data ]);
			exit;
		}


		if(  $this->session->has_userdata('costcenterID')  && $this->session->userdata('costcenterID') != 0 ){
			$loneWorkerCCId = $this->session->userdata('costcenterID')  ;
			$getAllCoursesManager = $this->elearningmoodle->getAllCoursesManager($loneWorkerCCId) ;

	   } else {
			echo json_encode([ 'error' => '1', 'msg' => 'Link account number not found', 'data' => $data ]);
			exit;
	   }


	   if (!$getAllCoursesManager) {
			echo json_encode([ 'error' => '1', 'msg' => 'No courses assigned', 'data' => $data ]);
			exit;
	   }

	    $courseIdString = "" ;

		$counter = 1 ;

		foreach($getAllCoursesManager as $courseId) {
			$courseIdString .= $courseId['course_id'] ;

			if( count($getAllCoursesManager) != $counter ) {
				$courseIdString .= "," ;
			}

			$counter++ ;
		}


		$parameters = array(
			"field" => 'ids',
			"value" => $courseIdString
		);



		$functionname = 'core_course_get_courses_by_field';
		$serverurl = $this->wsCurlUrl.'&wsfunction='.$functionname ;

		$response = $this->curlmoodle->post($serverurl, $parameters);


		$response =  json_decode($response, true) ;

		if (!$response) {
			echo json_encode([ 'error' => '1', 'msg' => 'no data found', 'data' => $data ]);
			exit;
		}


		if ( isset($response['exception']) ) {

			$message .= "Error" ;

			if ( isset($response['message']) ) {
				$message .= ": " . $response['message'] ;
			}

			if ( isset($response['debuginfo']) ) {
				$message .= " " . $response['debuginfo'] ;
			}


			echo json_encode([ 'error' => '1', 'msg' => $message, 'data' => $data]);
			exit ;

		}


		$counter = 0 ;
		foreach($response['courses'] as $courses) {

			$data[$counter]['title']     = ( isset($courses['displayname']) && $courses['displayname'] ? $courses['displayname'] : '-' ) ;
			$data[$counter]['summary']   = ( isset($courses['summary']) && $courses['summary'] ? trim(strip_tags($courses['summary'])) : '-' ) ;
			$data[$counter]['courseId']  = ( isset($courses['id']) && $courses['id'] ? $courses['id'] : '' ) ;
			$data[$counter]['image']     = ( isset($courses['overviewfiles'][0]['fileurl']) && $courses['overviewfiles'][0]['fileurl'] ? $courses['overviewfiles'][0]['fileurl'] : 'noImage' ) ;


			$data[$counter]['getCourseCostCentres'] = $this->elearningmoodle->getTraineeInitialsListingManager($courses['id'],$userLinkAccountid, $dbColumnName) ;

			$counter++ ;
		}


		echo json_encode([ 'error' => '0', 'msg' => 'data found', 'data' => $data ]);

		//debug($data, 1) ;

	}
	
	
	
	public function getAllCoursesManager() {

		$data = [] ;

		$getAllCoursesManager = "" ;


		$userLinkAccountid = $this->input->post('userLinkAccountid')  ;
		$dbColumnName      = $this->input->post('dbColumnName') ;

		if (!$userLinkAccountid || !$dbColumnName) {
			echo json_encode([ 'error' => '1', 'msg' => 'Missing required parameters', 'data' => $data ]);
			exit;
		}


		if(  $this->session->has_userdata('costcenterID')  && $this->session->userdata('costcenterID') != 0 ){
			$loneWorkerCCId = $this->session->userdata('costcenterID')  ;
			$getAllCoursesManager = $this->elearningmoodle->getAllCoursesManager($loneWorkerCCId) ;

	   } else {
			echo json_encode([ 'error' => '1', 'msg' => 'Link account number not found', 'data' => $data ]);
			exit;
	   }


	   if (!$getAllCoursesManager) {
			echo json_encode([ 'error' => '1', 'msg' => 'No courses assigned', 'data' => $data ]);
			exit;
	   }
	   
	   $counter = 0 ;
	   $courseNotFound = "" ;
	   
	   foreach($getAllCoursesManager as $courses) {
		   
		   
		    $parameters = array(
				"field" => 'id',
				"value" =>  $courses['course_id']
			);



			$functionname = 'core_course_get_courses_by_field';
			$serverurl = $this->wsCurlUrl.'&wsfunction='.$functionname ;

			$response = $this->curlmoodle->post($serverurl, $parameters);
			
			$response =  json_decode($response, true) ;
		   
			if ( isset($response['courses'][0]['id']) && $response['courses'][0]['id'] ==  $courses['course_id'] ) {
				
				$data[$counter]['title']     = ( isset($response['courses'][0]['displayname']) && $response['courses'][0]['displayname'] ? $response['courses'][0]['displayname'] : '-' ) ;
				$data[$counter]['summary']   = ( isset($response['courses'][0]['summary']) && $response['courses'][0]['summary'] ? trim(strip_tags($response['courses'][0]['summary'])) : '-' ) ;
				$data[$counter]['courseId']  = ( isset($response['courses'][0]['id']) && $response['courses'][0]['id'] ? $response['courses'][0]['id'] : '' ) ;
				$data[$counter]['image']     = ( isset($response['courses'][0]['overviewfiles'][0]['fileurl']) && $response['courses'][0]['overviewfiles'][0]['fileurl'] ? $response['courses'][0]['overviewfiles'][0]['fileurl'] : 'noImage' ) ;


				$data[$counter]['getCourseCostCentres'] = $this->elearningmoodle->getTraineeInitialsListingManager($response['courses'][0]['id'],$userLinkAccountid, $dbColumnName) ;

				$counter++ ;
			} else {
				$courseNotFound .= $courses['course_id'].', ' ;
			}
		}

		if ($data) {
			$error = '0';
			$msg   = 'data found';
		} else {
			$error = '1';
			$msg   = 'data found but courses not found in elearning website';
		}
		echo json_encode([ 'error' => $error, 'msg' => $msg, 'data' => $data, 'courseNotFound' => $courseNotFound ]);

		//debug($data, 1) ;

	}
	
	public function courseCompletionReportAdmin() {
		
		
		$mainCourseId 	   		= $this->input->post('mainCourseId');
	    //$sentryUserId      		= $this->input->post('sentryUserId');
	    $data			  	 	= [] ;
	    $headingActivities		= [] ;
	    
	    //~ $mainCourseId 	   = 4;
	    //~ $sentryUserId      = 47;
	    
	    if( !$mainCourseId ) {
			 echo json_encode([ 'error' => '1', 'message' => 'Missing required parameters', 'data' =>  $data, 'headingActivities' => $headingActivities]);
			 exit ;
		}
	    
	    /*Get course activities*/
	    
	    
	    $getCourseActivities = $this->getCourseActivities($mainCourseId, 2) ;
	    
	    
	    if ( isset($getCourseActivities['exception']) ) {

			$message .= "Error" ;

			if ( isset($getCourseActivities['message']) ) {
				$message .= ": " . $getCourseActivities['message'] ;
			}
			
			echo json_encode([ 'error' => '1', 'message' => $message, 'data' => $data, 'headingActivities' => $headingActivities]);
			exit ;

		} else if ( isset($getCourseActivities['statuses']) && ! $getCourseActivities['statuses']) {
			echo json_encode([ 'error' => '1', 'message' => 'Completion information is not enabled for any activity, so none can be displayed.', 'data' => $data, 'headingActivities' => $headingActivities]);
			exit ;
		} else if( isset($getCourseActivities['statuses']) && $getCourseActivities['statuses']) {
			
			foreach( $getCourseActivities['statuses'] as $key ) {
			
				
				$functionname = 'core_course_get_course_module';
				$serverurl = $this->wsCurlUrl.'&wsfunction='.$functionname ;

				$parameter = array(
					"cmid"     => $key['cmid'] 
				);
				
				$response = $this->curlmoodle->post($serverurl, $parameter);
				$response = json_decode($response, true);
				
				if ( isset($response['cm']['name']) &&  $response['cm']['name'] ) {
					$headingActivities[] = $response['cm']['name'] ;
				} else {
					$headingActivities[] = $response['cm']['name'] ;
				}
			
			}
			
		} else {
		
			echo json_encode([ 'error' => '1', 'message' => 'No response from the WebService API', 'data' => $data, 'headingActivities' => $headingActivities]);
			exit ;
		}
	    
	   
	  
	    
	    /*Get course activities*/
	   
	
		$getUsersForCourse = $this->elearningmoodle->courseCompletionReportAdmin($mainCourseId) ; 
		
		if (!$getUsersForCourse) {
			 echo json_encode([ 'error' => '0', 'message' => 'There are no users in this course or group for whom completion information is displayed.', 'data' =>  $data, 'headingActivities' => $headingActivities]);
			 exit ;
		}
		
		
		$counter = 0 ;
		foreach( $getUsersForCourse as $key ) {
			
			$getCourseActivitiesAll = $this->getCourseActivities($mainCourseId, $key['moodleIdTraineeTable']) ;
				
				if ( isset($getCourseActivitiesAll['exception']) ) {
					//do nothing
				} else {
					
					
					$data[$counter]['name'] = $key['first_name'] . ' ' . $key['last_name'] ;
					$data[$counter]['email'] = $key['email'];
					$columnCounter = 0 ;
					
					foreach( $getCourseActivitiesAll['statuses'] as $key ) {
						
						if ( isset($key['state']) ) {
							//$data[$counter]['column' . $columnCounter] = $key['state'] ;
							
							$data[$counter]['column'][$columnCounter] = $key['state'] ;
						} else {
							//$data[$counter]['column' . $columnCounter] = '0' ;
							$data[$counter]['column'][$columnCounter] = '0' ;
						}
						$columnCounter++ ;
					}
					
					
					$counter++ ;
					
				}
				
				
		}
		
		echo json_encode([ 'error' => '0', 'message' => 'Data found moodle', 'data' =>  $data, 'headingActivities' => $headingActivities]);
		 
	}
	
	
	public function courseCompletionReportManager() {
		
		
		$mainCourseId 	   		= $this->input->post('mainCourseId');
	    $dbColumnName			= $this->input->post('dbColumnName');
	    $userLinkAccountid		= $this->input->post('userLinkAccountid');
	    
	    $data			  	 	= [] ;
	    $headingActivities		= [] ;
	    
	    if( !$mainCourseId || !$dbColumnName || !$userLinkAccountid ) {
			 echo json_encode([ 'error' => '1', 'message' => 'Missing required parameters', 'data' =>  $data, 'headingActivities' => $headingActivities]);
			 exit ;
		}
	    
	    /*Get course activities*/
	    
	    
	    $getCourseActivities = $this->getCourseActivities($mainCourseId, 2) ;
	    
	    
	    if ( isset($getCourseActivities['exception']) ) {

			$message .= "Error" ;

			if ( isset($getCourseActivities['message']) ) {
				$message .= ": " . $getCourseActivities['message'] ;
			}
			
			echo json_encode([ 'error' => '1', 'message' => $message, 'data' => $data, 'headingActivities' => $headingActivities]);
			exit ;

		} else if ( isset($getCourseActivities['statuses']) && ! $getCourseActivities['statuses']) {
			echo json_encode([ 'error' => '1', 'message' => 'Completion information is not enabled for any activity, so none can be displayed.', 'data' => $data, 'headingActivities' => $headingActivities]);
			exit ;
		} else if( isset($getCourseActivities['statuses']) && $getCourseActivities['statuses']) {
			
			foreach( $getCourseActivities['statuses'] as $key ) {
			
				
				$functionname = 'core_course_get_course_module';
				$serverurl = $this->wsCurlUrl.'&wsfunction='.$functionname ;

				$parameter = array(
					"cmid"     => $key['cmid'] 
				);
				
				$response = $this->curlmoodle->post($serverurl, $parameter);
				$response = json_decode($response, true);
				
				if ( isset($response['cm']['name']) &&  $response['cm']['name'] ) {
					$headingActivities[] = $response['cm']['name'] ;
				} else {
					$headingActivities[] = $response['cm']['name'] ;
				}
			
			}
			
		} else {
		
			echo json_encode([ 'error' => '1', 'message' => 'No response from the WebService API', 'data' => $data, 'headingActivities' => $headingActivities]);
			exit ;
		}
	    
	   
	  
	    
	    /*Get course activities*/
	   
	
		$getUsersForCourse = $this->elearningmoodle->courseCompletionReportManager($mainCourseId, $dbColumnName, $userLinkAccountid) ; 
		
		if (!$getUsersForCourse) {
			 echo json_encode([ 'error' => '0', 'message' => 'There are no users in this course or group for whom completion information is displayed.', 'data' =>  $data, 'headingActivities' => $headingActivities]);
			 exit ;
		}
		
		
		$counter = 0 ;
		foreach( $getUsersForCourse as $key ) {
			
			$getCourseActivitiesAll = $this->getCourseActivities($mainCourseId, $key['moodleIdTraineeTable']) ;
				
				if ( isset($getCourseActivitiesAll['exception']) ) {
					//do nothing
				} else {
					
					
					$data[$counter]['name'] = $key['first_name'] . ' ' . $key['last_name'] ;
					$data[$counter]['email'] = $key['email'];
					$columnCounter = 0 ;
					
					foreach( $getCourseActivitiesAll['statuses'] as $key ) {
						
						if ( isset($key['state']) ) {
							//$data[$counter]['column' . $columnCounter] = $key['state'] ;
							
							$data[$counter]['column'][$columnCounter] = $key['state'] ;
						} else {
							//$data[$counter]['column' . $columnCounter] = '0' ;
							$data[$counter]['column'][$columnCounter] = '0' ;
						}
						$columnCounter++ ;
					}
					
					
					$counter++ ;
					
				}
				
				
		}
		
		echo json_encode([ 'error' => '0', 'message' => 'Data found moodle', 'data' =>  $data, 'headingActivities' => $headingActivities]);
		 
	}
	
	
	
	
	public function getCourseActivities($mainCourseId, $sentryUserId) {
		
		
		$functionname = 'core_completion_get_activities_completion_status';
		$serverurl = $this->wsCurlUrl.'&wsfunction='.$functionname ;

		$parameter = array(
			"courseid"     => $mainCourseId,
			"userid"       => $sentryUserId
			
		);
		
		$response = $this->curlmoodle->post($serverurl, $parameter);
		$response = json_decode($response, true);
	
		return $response ;
	}
}
