<?php

Class Broadcastmessage extends CI_Controller
{
	
	function __construct()
	{
		ini_set('display_errors', 1);
		ini_set('display_startup_errors', 1);
		error_reporting(E_ALL);
		parent::__construct();
		$this->load->library('session');
		$this->load->helpers('url');
		$this->load->model('users');
	}
	
	
	public function getLoneWorkerByGroup() {
	
		$serialNumber = $this->input->post('serialNumber')  ;
		
		$conexion = new PDO("informix:host=".$this->config->item('pdo_connect')['host'].";service=".$this->config->item('pdo_connect')['service'].";database=".$this->config->item('pdo_connect')['database'].";server=".$this->config->item('pdo_connect')['server'].";protocol=".$this->config->item('pdo_connect')['protocol'].";EnableScrollableCursors=".$this->config->item('pdo_connect')['EnableScrollableCursors'].";client_locale=".$this->config->item('pdo_connect')['client_locale'].";db_locale=".$this->config->item('pdo_connect')['db_locale'] ,$this->config->item('pdo_connect')['db_user'],$this->config->item('pdo_connect')['db_pass']);
		
		$sql = "SELECT customer.name,customer.contno,customer.serialno,contsite.phone,customer.linkno,case monitoring.commstate when 0 then 'Yet to be commissioned' when 1 then 'Commissioned' when 2 then 'Decommissioned' end case,entityproperties.propertyvalue,trantype.descr FROM customer,monitoring,systrans,trantype,outer contsite,OUTER entityproperties WHERE customer.linkno IN ( SELECT linkno FROM linkacc START WITH linkacc.linkno IN ($serialNumber) CONNECT BY PRIOR linkacc.linkno=linkacc.parent) AND customer.serialno=monitoring.serialno AND customer.serialno=contsite.serialno AND contsite.contid=1 AND customer.serialno=systrans.serialno AND systrans.transtype=trantype.trantype AND ( trantype.descr LIKE 'RedAlert Pro') AND systrans.serialno=entityproperties.serialno AND entityproperties.entitytype=15 AND systrans.commsno=entityproperties.transmitterno  order by customer.name ASC";
		
		$prep   = $conexion->prepare($sql);
		$prep->execute();
		$resultTotal = $prep->fetchAll(PDO::FETCH_ASSOC);


		if( !empty($resultTotal) )
		{
			$transmitterTypeFilters = [] ;
			$statusTypeFilters 		= [] ;
			for( $m=0; $m<count($resultTotal); $m++ )
			{
				
				if( empty($resultTotal[$m]['NAME']) )
				{
					$resultTotal[$m]['NAME'] = '-';
				}

				if( empty($resultTotal[$m]['CONTNO']) )
				{
					$resultTotal[$m]['CONTNO'] = '-';
				}

				if( empty($resultTotal[$m]['SERIALNO']) )
				{
					$resultTotal[$m]['SERIALNO'] = '-';
				}

				if( empty($resultTotal[$m]['PHONE']) )
				{
					$resultTotal[$m]['PHONE'] = '';
				}

				if( empty($resultTotal[$m]['DESCR']) )
				{
					$resultTotal[$m]['DESCR'] = '-';
				}

			}

			echo json_encode(['error' => 0, 'data'=> $resultTotal, 'message'=>'Yes record found.']);
		}
		else
		{
			echo json_encode(['error' => 1, 'message'=>'No record found.']);
		}
	}
	
	
	public function sessionForComposeMessage() {
		session_start();
		$numberArray = json_decode($this->input->post('numberArray')) ;
		$serialArray = json_decode($this->input->post('serialArray')) ;
		
		if ($numberArray) {
			$this->session->set_userdata('numberArrayBroadcastMessage', $numberArray);
			$hierarchyData = [] ;
			$hierarchyData['hierarchyuserLevel']		=  $this->input->post('hierarchyuserLevel') ;
			$hierarchyData['hierarchygetLoneWorkersId'] =  $this->input->post('hierarchygetLoneWorkersId') ;
			$hierarchyData['contractAreaId'] 		    =  $this->input->post('contractAreaId') ;
			$hierarchyData['costCenterIdSelected'] 		=  $this->input->post('costCenterIdSelected') ; // this is only called in admin ajax broad_message.js/custom_message.js
			$this->session->set_userdata('currentHierarchyBroadcastMessage', $hierarchyData);
			
			
			$this->session->set_userdata('serialArrayForSelectedBoxBroadcastMessage', $serialArray);
			
			// session to set if request is coming from custom message and not to show the "Add More Users TITLE "button at compose message page.
				$redirectedFrom = $this->input->post('redirectedFrom') ;
				$this->session->set_userdata('redirectedFrom_broadcastmessagepage', $redirectedFrom);
			// session to set if request is coming from custom message and not to show the "Add More Users TITLE "button at compose message page.
			
			$error = 0 ;
			$message = "Session updated successfully." ;
		} else {
			$error = 1 ;
			$message = "No numbersfound" ;
		}
		session_write_close();
		echo json_encode(['error' => $error, 'message'=> $message]);
	}
	
	
	public function unsetSingleSessionComposeMessage(){
		ini_set('display_errors', 1);
		ini_set('display_startup_errors', 1);
		error_reporting(E_ALL);	
		$indexToUnset    = $this->input->post('indexToUnset')  ;
		$sessionValue 	 = $this->session->userdata('numberArrayBroadcastMessage');
		unset($sessionValue[$indexToUnset]);
		$this->session->set_userdata('numberArrayBroadcastMessage', $sessionValue);
		echo json_encode([ 'error' => 0 ]);
	}
	
	public function dataSentItems() {
		$requestData 	    = $this->input->post();
		$dataSentItems 		= $this->users->dataSentItems($requestData);
		echo json_encode($dataSentItems);
	}
	
	public function dataSentItemsAdmin() {
		$requestData 	    = $this->input->post();
		$dataSentItems 		= $this->users->dataSentItemsAdmin($requestData);
		echo json_encode($dataSentItems);
	}
	
	public function getLoneWorkerByGroupOnCompose() {
		$serialNumber = $this->input->post('serialNumber')  ;
		
		$conexion = new PDO("informix:host=".$this->config->item('pdo_connect')['host'].";service=".$this->config->item('pdo_connect')['service'].";database=".$this->config->item('pdo_connect')['database'].";server=".$this->config->item('pdo_connect')['server'].";protocol=".$this->config->item('pdo_connect')['protocol'].";EnableScrollableCursors=".$this->config->item('pdo_connect')['EnableScrollableCursors'].";client_locale=".$this->config->item('pdo_connect')['client_locale'].";db_locale=".$this->config->item('pdo_connect')['db_locale'] ,$this->config->item('pdo_connect')['db_user'],$this->config->item('pdo_connect')['db_pass']);
		
		$sql = "SELECT customer.name,customer.contno,customer.serialno,contsite.phone,customer.linkno,case monitoring.commstate when 0 then 'Yet to be commissioned' when 1 then 'Commissioned' when 2 then 'Decommissioned' end case,entityproperties.propertyvalue,trantype.descr FROM customer,monitoring,systrans,trantype,outer contsite,OUTER entityproperties WHERE customer.linkno IN ( SELECT linkno FROM linkacc START WITH linkacc.linkno IN ($serialNumber) CONNECT BY PRIOR linkacc.linkno=linkacc.parent) AND customer.serialno=monitoring.serialno AND customer.serialno=contsite.serialno AND contsite.contid=1 AND customer.serialno=systrans.serialno AND systrans.transtype=trantype.trantype AND ( trantype.descr LIKE 'RedAlert Pro' OR trantype.descr LIKE 'RedAlert Welfare') AND systrans.serialno=entityproperties.serialno AND entityproperties.entitytype=15 AND systrans.commsno=entityproperties.transmitterno  order by customer.name ASC";
		
		$prep   = $conexion->prepare($sql);
		$prep->execute();
		$resultTotal = $prep->fetchAll(PDO::FETCH_ASSOC);


		if( !empty($resultTotal) )
		{
			$transmitterTypeFilters = [] ;
			$statusTypeFilters 		= [] ;
			for( $m=0; $m<count($resultTotal); $m++ )
			{
				
				if( empty($resultTotal[$m]['NAME']) )
				{
					$resultTotal[$m]['NAME'] = '-';
				}

				if( empty($resultTotal[$m]['CONTNO']) )
				{
					$resultTotal[$m]['CONTNO'] = '-';
				}

				if( empty($resultTotal[$m]['SERIALNO']) )
				{
					$resultTotal[$m]['SERIALNO'] = '-';
				}

				if( empty($resultTotal[$m]['PHONE']) )
				{
					$resultTotal[$m]['PHONE'] = '';
				}

				if( empty($resultTotal[$m]['DESCR']) )
				{
					$resultTotal[$m]['DESCR'] = '-';
				}

			}

			echo json_encode(['error' => 0, 'data'=> $resultTotal, 'message'=>'Yes record found.']);
		}
		else
		{
			echo json_encode(['error' => 1, 'message'=>'No record found.']);
		}
	}
}
	
