$(document).ready(function () {

	getDataForPage('mainPageLoad') ;

	$(document).on("click", "#submit-button", function() {
		$("#__awsFormFileUpload").submit();
	});

	/***To Upload the files to AWS S3 Bucket***/
	$("#__awsFormFileUpload").on('submit',(function(e) {
		e.preventDefault();
		  var currentlySelectedFolder = $(".currentAnchorSelected").closest('li').data('delimeter') ;
		  var formData				  = new FormData(this) ;
		  formData.append('folderName', currentlySelectedFolder);

		  $.ajax({
				 url: base_url + 'upload/upload_file_to_base64_Aws/',
				 type: "POST",
				// data:  new FormData(this),
				 data:  formData,
				 contentType: false,
				 cache: false,
				 processData:false,
				 dataType: 'json',
				 beforeSend : function()
				 {
					$("#__fileuploadloaderCSS").show() ;
					$("#submit-button").prop("disabled", true);
					$("#submit-button").text("Uploading...");
					//$("#submit-button").hide() ;
				 },
				    success: function(data)
				 {

					$("#submit-button").text("Upload");
					if(data.error == 1) {
						//$(".__requiredMessage").text(data.message) ;
						//$("#submit-button").show() ;
						$("#submit-button").prop("disabled", false);
						$("#__fileuploadloaderCSS").hide() ;
						toastr.error("Please select a file to upload","Error",{closeButton:!0});
						//alert(data.message);
					} else {
						if (data.message == "") {
							$("#__fileuploadloaderCSS").hide() ;
							toastr.error("File type not allowed","Error",{closeButton:!0});
						} else {
							$("#__fileuploadloaderCSS").hide() ;
							if (data.folderName == "__mainRootFolder"){
								getDataForPrefixes('getRootDataFiles') ;
							} else {
								getDataForPrefixes(data.folderName) ;
							}
							pond.removeFiles();
							//alert(data.message) ;
							toastr.success("File(s) uploaded successfully","Success",{closeButton:!0});

						}
						//$("#submit-button").show() ;
						$("#submit-button").prop("disabled", false);


						//~ $(".__requiredMessage").text(data.message) ;
						//~ $("#__awsFormFileUpload")[0].reset();
						//~ getDataForPage('uploadPageLoad') ;
						//~ $("#node_1_anchor").addClass("currentAnchorSelected") ;
					}
			  },
			 error: function (jqXHR, exception) {
				   // $("#submit-button").show() ;
					$("#submit-button").prop("disabled", false);
					$("#submit-button").text("Upload");
					$("#__fileuploadloaderCSS").hide() ;
					toastr.error("Network error, please try again later.","Error",{closeButton:!0});
			 }
		});
	 }));
	 /***To Upload the files to AWS S3 Bucket***/


	 /***To list the data of currently selected folder***/
	 $(document).on("click", ".jstree-anchor", function() {

		//alert('here') ;
		if ( $(this).hasClass("currentAnchorSelected") ) {
			//alert('Do not hit AJAX') ;
		} else {
			$("a.jstree-anchor").removeClass("currentAnchorSelected") ;
			$(this).addClass("currentAnchorSelected") ;
			var prefix = $(this).parent().data('delimeter') ;

			var currentAnchorId = $(this).attr('id') ;

			if ( currentAnchorId == "node_1_anchor") {
				$('#__deleteFolderTop, #__shareFolderTop').attr('disabled','disabled');
				getDataForPrefixes('getRootDataFiles');
			} else {
				$('#__deleteFolderTop, #__shareFolderTop').removeAttr('disabled');
				getDataForPrefixes(prefix) ;
			}
		}

	 });
	 /***To list the data of currently selected folder***/


	 /***To Delete single object***/
	 $(document).on("click", "#__singleDelete", function() {
			var key = $(this).closest('tr').data('uniquekey') ;
			if (key){
				if (confirm('Are You Sure?')){
					deleteSingleObject(key) ;
				}
			} else {
				alert('Object key is required.' ) ;
			}
	 });
	 /***To Delete single object***/


	 /***To Delete Multiple selected objects***/

	 $(document).on("click", "#__deleteMultipleFiles", function() {
		var rowCountChecked = $('input[type=checkbox][name=check]:checked').length;

		if ( rowCountChecked > 0 ) {
			if (confirm('Are You Sure?')){
				$('#__deleteMultipleFiles, #__shareMultipleFiles').attr('disabled','disabled');
				deleteMultipleObjects();
			}
		} else {
			alert("Please select files.") ;
		}

	 });



	 /***To Delete Multiple selected objects***/


	 /***To create a new folder with empty file***/
		 $(document).on("click", "#__addFolderButton", function() {
			$("#__folderContainerInputBox").show() ;
			$("#__createNewFolder").focus() ;
		 });


		 $(document).on("keyup", "#__createNewFolder", function(e) {
			var yourInput = $(this).val();
			re = /[`~#$%^&*()_|+\-=?;:'",<>\{\}\[\]\\\/@! ]/gi;
			var isSplChar = re.test(yourInput);
			if(isSplChar)
			{
			  var no_spl_char = yourInput.replace(/[`~#$%^&*()_|+\-=?;:'",<>\{\}\[\]\\\/@! ]/gi, '');
			  $(this).val(no_spl_char);
			}


			if (e.keyCode === 13) {
				if (yourInput == '' ) {
					toastr.error("Please enter name.","Error",{closeButton:!0});
				} else if( yourInput.length < 5 || yourInput.length > 30) {
					toastr.error("Name can't be less then 5 or more then 30 characters.","Error",{closeButton:!0});
				} else {

					/***check folde name don't exists***/

					var folderNameExists = false;

					$('ul#__treeStructureData li').each(function (index) {

						var currentFolderName  = $(this).data("delimeter") ;

						if ( currentFolderName == yourInput + "/") {
							folderNameExists = true ;
						}
					});

					if (!folderNameExists) {

							createAwsFolderWithEmptyFile(yourInput) ;

					} else {
						toastr.error("Folder name already exists.","Error",{closeButton:!0});
					}
					/***check folde name don't exists***/
				}
			}


			if (e.key === "Escape" || e.key == 27) { // escape key maps to keycode `27`
				$("#__folderContainerInputBox").hide() ;
				$(this).val('');
			}

		})
	 /***To create a new folder with empty file***/

	/***On click of folder delete at top***/
	$(document).on("click", "#__deleteFolderTop", function() {
		var currentPrefix = $("a.currentAnchorSelected").closest('li').data('delimeter') ;

		if ( currentPrefix == "__mainRootFolder") {
			alert("Please select a folder to delete.") ;
		} else {

			if (confirm('Are You Sure?')){
				$('#__deleteFolderTop, #__shareFolderTop').attr('disabled','disabled');
				deletSelectedFolder(currentPrefix) ;
			}
			$("#__deleteFolderTop").tooltip('hide');
		}
	});
	/***On click of folder delete at top***/

	/***On click of folder delete at side***/
	$(document).on("click", "#__deleteFolderSide", function() {
		var currentPrefix = $(this).closest('li').data('delimeter') ;

		if ( currentPrefix == "__mainRootFolder") {
			alert("Please select a folder to delete.") ;
		} else {

			if (confirm('Are You Sure?')){
				$('#__deleteFolderTop, #__shareFolderTop').attr('disabled','disabled');
				deletSelectedFolder(currentPrefix) ;
			}
		}
	});
	/***On click of folder delete at side***/


	/***Rename a file***/
	$(document).on("keyup", "#__newFileName", function(e) {
			var yourInput = $(this).val();
			re = /[`~#$%^&*()_|+\-=?;:'",<>\{\}\[\]\\\/@! .]/gi;
			var isSplChar = re.test(yourInput);
			if(isSplChar)
			{
			  var no_spl_char = yourInput.replace(/[`~#$%^&*()_|+\-=?;:'",<>\{\}\[\]\\\/@! .]/gi, '');
			  $(this).val(no_spl_char);
			}
	});


	$(document).on("click", "#__renameObject", function() {
		$('#__renameObjectForm')[0].reset() ;
		var name 	   = $(this).closest("tr").data('name') ;
		var objectKey  = $(this).closest("tr").data('uniquekey') ;
		var folderName = $("a.currentAnchorSelected").closest('li').data('delimeter') ;

		$('#__previousFileName').attr('placeholder','Current file name: ' + name);
		$("#__previousFileNameValue").val(objectKey);
		$("#__folderName").val(folderName);

		$('#addfoldermodal').modal('show');

	});

	$(document).on("click", "#__submitRenameObject", function(e) {

		e.preventDefault() ;
		var newName = $("#__newFileName").val() ;
		if (newName == "") {
		  toastr.error("Please enter name.","Error",{closeButton:!0});
		} else if( newName.length < 5 || newName.length > 50) {
			toastr.error("Name can't be less then 5 or more then 50 characters.","Error",{closeButton:!0});
		} else {

			$('#addfoldermodal').modal('hide');
			$.ajax({
				  url: base_url + 'upload/renameFileName' ,
				  type: 'post',
				  dataType: 'json',
				  data: $('#__renameObjectForm').serialize() ,
				  beforeSend : function()
				  {
					$("#__rightBoxTable").hide() ;
					$("#__skeltonLoaderLeftSide").show();
				  },
				  success:function(response){
					  $('#__renameObjectForm')[0].reset();
					  if (response.error == 0) {
						  //alert(response.message);
							toastr.success("File Renamed","Success",{closeButton:!0})
						  $("input[name='select-all']").prop('checked', false);

						  if (response.folderName == "__mainRootFolder"){
							getDataForPrefixes('getRootDataFiles') ;
						  } else {
							getDataForPrefixes(response.folderName) ;
						  }

						//  $("a.jstree-anchor").removeClass("currentAnchorSelected") ;
						 // $('li[data-delimeter = "'+ response.folderName +'"] a.jstree-anchor').addClass('currentAnchorSelected');
					  } else {
							$("#__rightBoxTable").show() ;
							$("#__skeltonLoaderLeftSide").hide();
							alert(response.message) ;
					  }
				  }, error: function (jqXHR, exception) {
					    $('#__renameObjectForm')[0].reset();
					    $("#__rightBoxTable").show() ;
						$("#__skeltonLoaderLeftSide").hide();
						toastr.error("Network error, please try again later.","Error",{closeButton:!0});
				  }
			 });
		}

	});



	/***Rename a file***/



	/***Move a file***/

	$(document).on("click", "#__moveObject", function() {
		var objectKey  		   = $(this).closest("tr").data('uniquekey') ;
		var selectedFolderName = $("a.currentAnchorSelected").closest('li').data('delimeter') ;
		var htmlLi 		 = "" ;
		var htmlSelect	 = "" ;
		var liTreeLength = $('ul#__treeStructureData li').length ;

		$("#__moveObjectKeyName").val(objectKey) ;


		//liTreeLength = 0 ;

		if ( liTreeLength > 0 ) {
			htmlSelect   += '<option value="">Select directory</option>' ;
			$('ul#__treeStructureData li').each(function (index) {

				var currentFolderName  = $(this).data("delimeter") ;

				if ( currentFolderName != selectedFolderName) {

					//htmlLi += '<li data-delimeter="'+currentFolderName+'"><span> <i class="ft-folder"></i> '+currentFolderName.replace("/", "")+'</span></li>' ;

					htmlSelect   += '<option ata-delimeter="'+currentFolderName+'" value="'+currentFolderName+'">'+currentFolderName.replace("/", "")+'</option>' ;
				}
			});
		} else {
			//htmlLi += '<li data-delimeter="no_folder_found"><i class="ft-folder"></i> <span>No folders found.</span></li>' ;

			htmlSelect   += '<option value="">No folders found.</option>' ;
		}
		$('#__moveObjectButton').attr('disabled','disabled');
		//$("#__movedirectorylist").html(htmlLi) ;
		$("#__moveFileFolders").html(htmlSelect) ;
		$('#movefilemodal').modal('show');
	});

	$(document).on("click", "ul#__movedirectorylist li", function() {

		if ( $(this).hasClass("moveselecteddirectroy") ) {

		} else {
			$("ul#__movedirectorylist li").removeClass("moveselecteddirectroy") ;
			$(this).addClass("moveselecteddirectroy") ;

			$('#__moveObjectButton').removeAttr('disabled');
		}

	});

	$(document).on("change", "#__moveFileFolders", function() {

		var currentValue = $(this).val();

		if ( currentValue == "" ) {
			$('#__moveObjectButton').attr('disabled','disabled');
		} else {
			$('#__moveObjectButton').removeAttr('disabled');
		}
	});



	$(document).on("click", "#__moveObjectButton", function() {
		var fromFolderName  = $("a.currentAnchorSelected").closest('li').data('delimeter') ; //tree structure selected folder
		//var toFolderName 	= $("ul#__movedirectorylist li.moveselecteddirectroy").data('delimeter') ; // modal selected folder
		var toFolderName 	= $("#__moveFileFolders").val() ; // modal selected folder
		var objectKeyName   = $("#__moveObjectKeyName").val() ;
		$('#movefilemodal').modal('hide');
		$.ajax({
				  url: base_url + 'upload/moveFile' ,
				  type: 'post',
				  dataType: 'json',
				  data: {'fromFolderName': fromFolderName, 'toFolderName': toFolderName, 'objectKeyName': objectKeyName},
				  beforeSend : function()
				  {
					$("#__rightBoxTable").hide() ;
					$("#__skeltonLoaderLeftSide").show();
				  },
				  success:function(response){
					  $("#__moveObjectKeyName").val('') ;
					  if (response.error == 0) {
						  //alert(response.message) ;
							toastr.success("File moved to the destination successfully","Success",{closeButton:!0})
						  $("input[name='select-all']").prop('checked', false);

						  if (response.folderName == "__mainRootFolder"){
							getDataForPrefixes('getRootDataFiles') ;
						  } else {
							getDataForPrefixes(response.folderName) ;
						  }

						//  $("a.jstree-anchor").removeClass("currentAnchorSelected") ;
						 // $('li[data-delimeter = "'+ response.folderName +'"] a.jstree-anchor').addClass('currentAnchorSelected');
					  } else {
							$("#__rightBoxTable").show() ;
							$("#__skeltonLoaderLeftSide").hide();
							alert(response.message) ;
					  }
				  }, error: function (jqXHR, exception) {
					    $("#__moveObjectKeyName").val('') ;
					    $("#__rightBoxTable").show() ;
						$("#__skeltonLoaderLeftSide").hide();
						toastr.error("Network error, please try again later.","Error",{closeButton:!0});
				  }
			 });

	});
	/***Move a file***/

	/***Share a folder***/

	$(document).on("click", "#__shareFolderTop, .__shareFolderSide", function() {
		var currentPosition = $(this).data("shareposition") ;

		$("#__folderToshareNameDelimeter").val('') ;

		if ( currentPosition == "side" ) {
			var selectedFolderDelimeter  = $(this).closest('li').data('delimeter') ;
			var selectedFoldeName  		 = $(this).closest('li').data('name') ;
		} else {
			var selectedFolderDelimeter  = $("a.currentAnchorSelected").closest('li').data('delimeter') ;
			var selectedFoldeName  		 = $("a.currentAnchorSelected").closest('li').data('name') ;
		}

		if ( selectedFolderDelimeter != "__mainRootFolder") {
			$.ajax({
			  url: base_url + 'upload/getCostCenterUsers' ,
			  type: 'post',
			  dataType: 'json',
			  data: { 'selectedFolderDelimeter': selectedFolderDelimeter },
			  beforeSend : function()
			  {

				   $("#__dynamicFolderName").text(selectedFoldeName);

				   //To make the two search boxes empty

				   $(".form-control.filter").val('');

				   //To make the two search boxes empty

				   $(".bootstrap-duallistbox-container").hide() ;
				   $("#__shareFolderButton").hide() ;
				   $("#__hideShareModalCostCentreUsers").show() ;

				   $('#myShareModal').modal('show');

			  },
			  success:function(response){
				   if (response.error == 0) {
					   $("#__folderToshareNameDelimeter").val(selectedFolderDelimeter) ;

					   $('.duallistbox-custom-text').empty();
					   $(".duallistbox-custom-text").html(response.content) ;
					   $('.duallistbox-custom-text').bootstrapDualListbox('refresh', true);

					   if (response.isShared == "isShared") {
							$("#__shareFolderButton").removeAttr("disabled") ;
					   } else {
							$('#__shareFolderButton').attr('disabled','disabled');
					   }
					   $(".duallistbox-custom-text").attr("id", response.isShared)


					   $("#__hideShareModalCostCentreUsers").hide() ;
					   $(".bootstrap-duallistbox-container").show() ;
					   $("#__shareFolderButton").show() ;

				  } else {
						toastr.warning(response.message,"Notification",{closeButton:!0});
						$('#myShareModal').modal('hide');
				  }
			  }, error: function (jqXHR, exception) {
					toastr.error("Network error, please try again later.","Error",{closeButton:!0});
					$('#myShareModal').modal('hide');
			  }
			});
		} else {
			toastr.error("Please select a folder.","Error",{closeButton:!0});
			$('#myShareModal').modal('hide');
		}
	});


	$(document).on("click", "#__shareFolderButton", function() {

		var selectedUsersLength 		= $("#bootstrap-duallistbox-selected-list_ > option").length ;
		var folderToshareNameDelimeter	= $("#__folderToshareNameDelimeter").val() ;
		var dataToInsert = [] ;

		if (folderToshareNameDelimeter) {
			if ( selectedUsersLength > 0 ) {
				$("#bootstrap-duallistbox-selected-list_ > option").each(function() {

					var costCenter 		= $(this).data('costcenterid');
					var costCenterName  = $(this).data('costcentername');
					var conCatData 		= { cost_center_id: costCenter, cost_centre_name: costCenterName, folder_name: folderToshareNameDelimeter } ;
					dataToInsert.push(conCatData) ;
				});

			}

			$.ajax({
			  url: base_url + 'upload/add_delete_shared_folder_users' ,
			  type: 'post',
			  dataType: 'json',
			  data: { 'dataToInsert':  JSON.stringify(dataToInsert), 'selectedUsersLength': selectedUsersLength, 'folderToshareNameDelimeter':  folderToshareNameDelimeter} ,
			  success:function(response){
				   if (response.error == 0) {
					   $('#myShareModal').modal('hide');
					   toastr.success(response.message,"Success",{closeButton:!0})
				  } else {
						toastr.warning(response.message,"Error",{closeButton:!0});
				  }
			  }, error: function (jqXHR, exception) {
					toastr.error("Network error, please try again later.","Error",{closeButton:!0});
			  }
			});
		} else {
			toastr.error("Please select a folder.","Error",{closeButton:!0});
		}

	});

	$('.duallistbox-custom-text').on('change',function(){
		var currentID = $(this).attr('id') ;
		if( currentID == "notShared" ) {
			if ( $("#bootstrap-duallistbox-selected-list_ > option").length > 0 ) {
				$("#__shareFolderButton").removeAttr("disabled")
			} else {
				$('#__shareFolderButton').attr('disabled','disabled');
			}
		}
	})

	/***Share a folder***/


	/***Rename a folder***/
	$(document).on("click", function(e) {
			if ($(e.target).is(".__renameFolderButton") === false || $(e.target).is(".__renameFolderInputText") === false) {

		$("ul#__treeStructureData li").removeClass('__currentlyRenamingLi') ;

				$('.__renameFolderInput').each(function (index) {
					$(this).hide();
					$(this).closest('li').find("a.jstree-anchor").show() ;
				});
			}
		});

		$(document).on("click", ".__renameFolderInputText", function(e) {
			e.stopPropagation();
		})
	// Show hide the input box of rename
	$(document).on("click", ".__renameFolderButton", function(e) {

		$('.__renameFolderInput').each(function (index) {
			$(this).hide();
			$(this).closest('li').find("a.jstree-anchor").show() ;
			$(this).closest('li').removeClass('__currentlyRenamingLi') ;
		});

		var closestLi	= $(this).closest('li') ;
		var currentSelectedFolder = closestLi.data('delimeter') ;


		if ( currentSelectedFolder == "__mainRootFolder" ) {
			toastr.error("Please select a folder.","Error",{closeButton:!0});
		} else {
			closestLi.find("a.jstree-anchor").hide();
			closestLi.find('.__renameFolderInput').show()
			var searchInput = closestLi.find('.__renameFolderInputText');
			var strLength 	= searchInput.val().length * 2;
			searchInput.focus();
			searchInput[0].setSelectionRange(strLength, strLength);
			closestLi.addClass('__currentlyRenamingLi') ;
		}
		e.stopPropagation();
	});


	// When key is pressed in rename input
	$(document).on("keyup", ".__renameFolderInputText", function(e) {
			var closestLi	= $(this).closest('li') ;

			var yourInput = $(this).val();
			re = /[`~#$%^&*()_|+\-=?;:'",<>\{\}\[\]\\\/@! ]/gi;
			var isSplChar = re.test(yourInput);
			if(isSplChar)
			{
			  var no_spl_char = yourInput.replace(/[`~#$%^&*()_|+\-=?;:'",<>\{\}\[\]\\\/@! ]/gi, '');
			  $(this).val(no_spl_char);
			}


			if (e.keyCode === 13) {
				if (yourInput == '' ) {
					toastr.error("Please enter name.","Error",{closeButton:!0});
				} else if( yourInput.length < 5 || yourInput.length > 30) {
					toastr.error("Name can't be less then 5 or more then 30 characters.","Error",{closeButton:!0});
				} else {

					/***check folde name don't exists***/

					var folderNameExists = false;
					var currentDelimeter = closestLi.data('delimeter') ;

					$('ul#__treeStructureData li').each(function (index) {

						var currentFolderName  = $(this).data("delimeter") ;

						if ( currentFolderName == yourInput + "/") {
							folderNameExists = true ;
						}
					});

					if (!folderNameExists) {
						//alert("rename the folder.") ;
						var newDelimeter = yourInput + "/" ;

						$.ajax({
							  url: base_url + 'upload/renameFolder' ,
							  type: 'post',
							  dataType: 'json',
							  data : { 'currentDelimeter': currentDelimeter, 'newDelimeter': newDelimeter},
							   beforeSend : function()
							  {
								  $("#__rightBoxTable").hide() ;
								  $("#__skeltonLoaderLeftSide").show();
								  closestLi.find('.__renameFolderInputText').attr("disabled", "disabled");
							  },
							  success:function(response){
								   if (response.error == 0) {

										getDataForPrefixes(newDelimeter) ;

										toastr.success(response.message,"Success",{closeButton:!0});

										$("a.jstree-anchor").removeClass("currentAnchorSelected") ;

										closestLi.find("a.jstree-anchor").html('<i class="jstree-icon jstree-themeicon feather icon-folder jstree-themeicon-custom" role="presentation"></i>' + newDelimeter.replace("/", "") ).show().addClass('currentAnchorSelected');

										closestLi.find('.__renameFolderInput').hide() ;

										closestLi.find('.__renameFolderInputText').val(newDelimeter.replace("/", ""));

										closestLi.data('delimeter', newDelimeter);

										closestLi.data('name', newDelimeter.replace("/", ""));

										closestLi.find('.__renameFolderInputText').removeAttr("disabled");

										closestLi.removeClass('__currentlyRenamingLi');

								  } else {
										toastr.error(response.message,"Error",{closeButton:!0});
								  }
							  }, error: function (jqXHR, exception) {
									toastr.error("Network error, please try again later.","Error",{closeButton:!0});
							  }
					   });
					} else {
						toastr.error("Folder name already exists.","Error",{closeButton:!0});
					}
					/***check folde name don't exists***/
				}
			}


			if (e.key === "Escape" || e.key == 27) { // escape key maps to keycode `27`
				$(".__renameFolderInput").hide() ;
				closestLi.find("a.jstree-anchor").show();
				$(this).val(closestLi.data('name'));
				closestLi.removeClass('__currentlyRenamingLi');
			}

	}) ;


	/***Rename a folder***/


}); // end of document ready


 function getDataForPage(pageLoadType) {
	$('#__deleteFolderTop, #__shareFolderTop').attr('disabled','disabled');
	$.ajax({
		  url: base_url + 'upload/listBucketObjectsAjax' ,
		  type: 'post',
		  dataType: 'json',
		   beforeSend : function()
		  {
				if ( pageLoadType == "uploadPageLoad" ) {
					 $("#__rightBox, #__leftBox").hide() ;
					 $("#__hideonUploadFile").hide() ;
				}
				$("#__skeltonLoaderMain").show();
		  },
		  success:function(response){
			   if (response.error == 0) {
				  if (response.rightSideContent != "") {
					$("#__tableBodyData").html(response.rightSideContent) ;
				  } else {
					$("#__tableBodyData").html("<tr class='__noResultsFound'><td colspan='4' class='text-center'>No files found</td></tr>");
				  }
				  $("#__treeStructureData").html(response.treeStructureContent) ;
				  $("#__skeltonLoaderMain").hide();
				  $("#__topBox, #__rightBox, #__leftBox").show() ;
			  } else {
					toastr.error(response.message,"Error",{closeButton:!0});
					$("#__skeltonLoaderMain").hide();

			  }
		  }, error: function (jqXHR, exception) {
			    toastr.error("Network error, please try again later.","Error",{closeButton:!0});
				$("#__skeltonLoaderMain").hide();
		  }
	 });
 }

  // Get files for folders
  function getDataForPrefixes(prefix) {
	$('#__deleteMultipleFiles, #__shareMultipleFiles').attr('disabled','disabled');

	$.ajax({
		  url: base_url + 'upload/listBucketObjectsAjaxPrefixes' ,
		  type: 'post',
		  dataType: 'json',
		  data: { prefix: prefix } ,
		  beforeSend : function()
		  {
			// $("#__tableBodyData").html("<tr><td colspan='4'>Loading...</td></tr>");
			$("#__rightBoxTable").hide() ;
			$("#__skeltonLoaderLeftSide").show();
		  },
		  success:function(response){
			  if (response.error == 0) {
				  if (response.rightSideContent != "") {
					$("#__tableBodyData").html(response.rightSideContent) ;
				  } else {
					$("#__tableBodyData").html("<tr class='__noResultsFound'><td colspan='4' class='text-center'>No files found</td></tr>");
				  }
				  $("input[name='select-all']").prop('checked', false);
				   $("#__skeltonLoaderLeftSide").hide();
				   $("#__rightBoxTable").show() ;
			  } else {
					toastr.error(response.message,"Error",{closeButton:!0});
			  }
		  }, error: function (jqXHR, exception) {
				toastr.error("Network error, please try again later.","Error",{closeButton:!0});
		  }
	 });
 }


function deleteSingleObject(key) {
	var rowCount = $('#__tableBodyData tr').length;
	//alert(rowCount) ;
	//return false;
	var currentlySelectedFolder = $(".currentAnchorSelected").closest('li').data('delimeter') ;
	$.ajax({
		  url: base_url + 'upload/deleteSingleObject' ,
		  type: 'post',
		  dataType: 'json',
		  data: { key: key, 'folderName':  currentlySelectedFolder} ,
		  beforeSend : function()
		  {
			// $("#__tableBodyData").html("<tr><td colspan='4'>Loading...</td></tr>");
			$("#__rightBoxTable").hide() ;
			$("#__skeltonLoaderLeftSide").show();
		  },
		  success:function(response){
			  if (response.error == 0) {
				  toastr.success(response.message,"Success",{closeButton:!0});
				  $("input[name='select-all']").prop('checked', false);

				  if (response.folderName == "__mainRootFolder"){
					getDataForPrefixes('getRootDataFiles') ;
				  } else {
					getDataForPrefixes(response.folderName) ;
				  }

				//  $("a.jstree-anchor").removeClass("currentAnchorSelected") ;
				 // $('li[data-delimeter = "'+ response.folderName +'"] a.jstree-anchor').addClass('currentAnchorSelected');

			  } else {
				    toastr.error(response.message,"Error",{closeButton:!0});
			  }
		  }, error: function (jqXHR, exception) {
			    toastr.error("Network error, please try again later.","Error",{closeButton:!0});
		  }
	 });

}


function deleteMultipleObjects() {

	var objectKeyArray = [] ;
	var currentlySelectedFolder = $(".currentAnchorSelected").closest('li').data('delimeter') ;

	$('input[type=checkbox][name=check]:checked').each(function (index) {
		var objectKey = $(this).closest('tr').data('uniquekey') ;
		objectKeyArray.push(objectKey) ;
	});

	if (objectKeyArray.length > 0) {

			$.ajax({
			  url: base_url + 'upload/deleteMultipleObjects' ,
			  type: 'post',
			  dataType: 'json',
			  data: { key: JSON.stringify(objectKeyArray), 'folderName':  currentlySelectedFolder} ,
			  beforeSend : function()
			  {
				$("#__rightBoxTable").hide() ;
				$("#__skeltonLoaderLeftSide").show();
			  },
			  success:function(response){
				  if (response.error == 0) {
					  toastr.success(response.message,"Success",{closeButton:!0});
					  $("input[name='select-all']").prop('checked', false);

					  if (response.folderName == "__mainRootFolder"){
						getDataForPrefixes('getRootDataFiles') ;
					  } else {
						getDataForPrefixes(response.folderName) ;
					  }

					  //$("a.jstree-anchor").removeClass("currentAnchorSelected") ;
					  //$('li[data-delimeter = "'+ response.folderName +'"] a.jstree-anchor').addClass('currentAnchorSelected');

				  } else {
						toastr.error(response.message,"Error",{closeButton:!0});
						$('#__deleteMultipleFiles, #__shareMultipleFiles').removeAttr('disabled','disabled');
				  }
			  }, error: function (jqXHR, exception) {
					toastr.error("Network error, please try again later.","Error",{closeButton:!0});
					$('#__deleteMultipleFiles, #__shareMultipleFiles').removeAttr('disabled','disabled');
			  }
		 });

	} else {
		$('#__deleteMultipleFiles, #__shareMultipleFiles').removeAttr('disabled','disabled');
		toastr.error("Please select files.","Error",{closeButton:!0});
	}

}

function createAwsFolderWithEmptyFile(newfolderName) {

	if (newfolderName) {

			$.ajax({
			  url: base_url + 'upload/createAwsFolderWithEmptyFile' ,
			  type: 'post',
			  dataType: 'json',
			  data: { 'newfolderName': newfolderName } ,
			  beforeSend : function()
			  {
					$("#__rightBox, #__leftBox").hide() ;
					$("#__hideonUploadFile").hide() ;
					$("#__skeltonLoaderMain").show();
			  },
			  success:function(response){
				  if (response.error == 0) {

					  //alert(response.message) ;
						toastr.success("Directory created","Success",{closeButton:!0})

					  $("a.jstree-anchor").removeClass("currentAnchorSelected") ;
					  $("ul#__treeStructureData li").removeClass("jstree-last") ;
					   $("input[name='select-all']").prop('checked', false);

					  var htmlNewFolder = '<li class="jstree-node  jstree-leaf jstree-last" data-delimeter="'+response.folderName+'/" data-name="'+newfolderName+'"><i class="jstree-icon jstree-ocl" role="presentation"></i><a class="jstree-anchor currentAnchorSelected" style="margin-left:5px;" href="javascript:void(0)"><i class="jstree-icon jstree-themeicon feather icon-folder jstree-themeicon-custom" role="presentation"></i>'+response.folderName+'</a><span class="__renameFolderInput" style="display:none"><i class="jstree-icon jstree-themeicon feather icon-folder jstree-themeicon-custom" role="presentation"></i><input aria-lebal="Rename" class="__renameFolderInputText" type="text" value="'+response.folderName+'"  /></span><span class="__jstreeicon_social"><a href="javascript:void(0)" id ="__deleteFolderSide"> <i class="fa fa-trash" aria-hidden="true" ></i></a><a href="javascript:void(0)" class="__renameFolderButton"> <i class="fa fa-pencil-square-o" aria-hidden="true" ></i></a> <a href="javascript:void(0)" class ="__shareFolderSide" data-shareposition ="side"> <i class="fa fa-share-alt" aria-hidden="true"></i></a></span></li>' ;
					   $("ul#__treeStructureData").append(htmlNewFolder) ;
						$("#__skeltonLoaderMain").hide();
						$("#__rightBox, #__leftBox").show() ;
						$("#__folderContainerInputBox").hide() ;
						$("#__createNewFolder").val('');
						getDataForPrefixes(response.folderName) ;
						$('#__deleteMultipleFiles, #__shareMultipleFiles').removeAttr('disabled','disabled');
				  } else {
						toastr.error(response.message,"Error",{closeButton:!0});
						$("#__skeltonLoaderMain").hide();
						$("#__rightBox, #__leftBox").show() ;
				  }
			  }, error: function (jqXHR, exception) {
					toastr.error("Network error, please try again later.","Error",{closeButton:!0});
					$("#__skeltonLoaderMain").hide();
					$("#__rightBox, #__leftBox").show() ;
			  }
		 });

	} else {
		toastr.error("Please enter name.","Error",{closeButton:!0});
	}

}


function deletSelectedFolder(currentPrefix) {

	if (currentPrefix) {

			$.ajax({
			  url: base_url + 'upload/deleteSelectedFolder' ,
			  type: 'post',
			  dataType: 'json',
			  data: { 'folderName': currentPrefix } ,
			  beforeSend : function()
			  {
					$("#__rightBox, #__leftBox").hide() ;
					$("#__hideonUploadFile").hide() ;
					$("#__skeltonLoaderMain").show();
			  },
			  success:function(response){
				  if (response.error == 0) {

					  //alert(response.message) ;
						toastr.success("Directory deleted","Success",{closeButton:!0});

					  $("a.jstree-anchor").removeClass("currentAnchorSelected") ;
					  $("input[name='select-all']").prop('checked', false);
					   //add anchor class pending.


						$("#__skeltonLoaderMain").hide();
						//$("#__rightBox, #__leftBox").show() ;

						getDataForPage('mainPageLoad') ;
						$("#node_1_anchor").addClass("currentAnchorSelected") ;
						//$('#__deleteFolderTop, #__shareFolderTop').removeAttr('disabled','disabled');

				  } else {
						toastr.error(response.message,"Error",{closeButton:!0});
						$("#__skeltonLoaderMain").hide();
						$("#__rightBox, #__leftBox").show() ;
						$('#__deleteFolderTop, #__shareFolderTop').removeAttr('disabled','disabled');
				  }
			  }, error: function (jqXHR, exception) {
					toastr.error("Network error, please try again later.","Error",{closeButton:!0});
					$("#__skeltonLoaderMain").hide();
					$("#__rightBox, #__leftBox").show() ;
					$('#__deleteFolderTop, #__shareFolderTop').removeAttr('disabled','disabled');
			  }
		 });

	} else {
		$('#__deleteFolderTop, #__shareFolderTop').removeAttr('disabled','disabled');
		toastr.error("Please select a folder to delete.","Error",{closeButton:!0});
	}

}
