<?php

Class Users extends CI_Model
{
	public function __construct()
	{
		parent::__construct();

	}

	function count_cost_center()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->count_all('newcostcentres');
	}

	function count_contract_area()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->count_all('newcontractareas');
	}

	function count_office()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->count_all('newoffices');
	}

	function count_lwd()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('user')->order_by('create_at', 'desc')->get()->result_array();
	}

	function get_office_lwd()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('operators')->where(['office' => '23'])->get()->result_array();
	}

	function get_system_users_list_admin()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('user')->order_by('create_at', 'desc')->get()->result_array();
	}


	function get_system_users_list_admin_new($linkAccountType, $linkAccountNumber)
	{
		$this->mysql = $this->load->database('mysql', true);

		if ( $linkAccountType ==  "all" ) {
			return $this->mysql->select('*')->from('user')->order_by('create_at', 'desc')->get()->result_array();
		} else {

			return $this->mysql->select('*')->from('user')->where([$linkAccountType => $linkAccountNumber])->order_by('create_at', 'desc')->get()->result_array();
		}
	}


	function getUserDetailsReportNew($linkAccountType, $linkAccountNumber)
	{
		$this->mysql = $this->load->database('mysql', true);

		if ( $linkAccountType ==  "all" ) {
			return $this->mysql->select('username, first_name, sur_name, email, costcentrename, contractareaname, 	officename, user_status, user_block')->from('user')->order_by('create_at', 'desc')->get()->result_array();
		} else {

			return $this->mysql->select('username, first_name, sur_name, email, costcentrename, contractareaname, 	officename, user_status, user_block')->from('user')->where([$linkAccountType => $linkAccountNumber])->order_by('create_at', 'desc')->get()->result_array();
		}
	}


	function get_system_users_list($id,$type,$session_id)
	{
		$this->mysql = $this->load->database('mysql', true);

		if ( $type == "officeID") {
			$userType = "office" ;
		} elseif( $type  == "contractareaID") {
			$userType = "contractarea" ;
		} else {
			$userType = "costcenter" ;
		}

		return $this->mysql->select('user_id,username,first_name,sur_name,email,telephone,agency_type,user_status,user_block')->from('user')->where([ $type => $id, 'user_id !=' => $session_id, 'parent_id' =>  $session_id, 'user_type' => $userType ])->order_by('create_at', 'desc')->get()->result_array();
	}

	function get_user_data($id)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('user')->where('user_id' , $id)->get()->first_row('array');
	}

	function add_system_user($data,$parent_id = null)
	{
		$this->mysql = $this->load->database('mysql', true);

		unset($data['portalUserToken']);
		unset($data['costcentre_list']);
		unset($data['contractarea_id']);
		unset($data['office_list']);
		//debug($data,1);
		// event_log
		$row['log_name'] = "add new user";
		$row['user_type'] = "1";
		//$this->mysql->insert('logs',$row);

		if($data['password']){
			$data['password'] =  encrypt_string($data['password']);
		}
		if($data['sentinel_username']){
			$data['sentinel_username'] =  encrypt_string($data['sentinel_username']);
		}
		if($data['sentinel_password']){
			$data['sentinel_password'] =  encrypt_string($data['sentinel_password']);
		}

		if($data['sentinel_passcode']){
			$data['sentinel_passcode'] =  encrypt_string($data['sentinel_passcode']);
		}

		// add user
		unset($data['edit_user_id']);
		unset($data['confirm_password']);
		if(!empty($data['user_id']))
		{
			$data['parent_id'] = $data['user_id'];
			unset($data['user_id']);
		}

		if(  empty($data['user_status']) )
		{
			$data['user_status'] = '0';
		}

		if(  empty($data['service_status']) )
		{
			$data['service_status'] = '0';
		}

		if(  empty($data['storage_status']) )
		{
			$data['storage_status'] = '0';
		}
		
		if(  empty($data['dashboard_maps']) )
		{
			$data['dashboard_maps'] = '0';
		}
		
		if(  empty($data['app_users_report']) )
		{
			$data['app_users_report'] = '0';
		}
		
		
		if(  empty($data['to_play_audio_player_status']) )
		{
			$data['to_play_audio_player_status'] = '0';
		}
		
		if(  empty($data['lms_status']) )
		{
			$data['lms_status'] = '0';
		}

		 ### OtA Broadcast Message ###

		 if(  empty($data['ota_read']) )
		{
			$data['ota_read'] = '0';
		}

		if(  empty($data['ota_write']) )
		{
			$data['ota_write'] = '0';
		}

		if(  empty($data['broadcast_message_read']) )
		{
			$data['broadcast_message_read'] = '0';
		}

		if(  empty($data['broadcast_message_write']) )
		{
			$data['broadcast_message_write'] = '0';
		}


		 ### OtA Broadcast Message ###

		### New Feed by orbis ###

		if(  empty($data['global_escalations_read']) )
		{
			$data['global_escalations_read'] = '0';
		}

		if(  empty($data['global_escalations_write']) )
		{
			$data['global_escalations_write'] = '0';
		}

		if(  empty($data['elearning_read']) )
		{
			$data['elearning_read'] = '0';
		}

		if(  empty($data['user_guides_read']) )
		{
			$data['user_guides_read'] = '0';
		}

		if(  empty($data['user_videos_read']) )
		{
			$data['user_videos_read'] = '0';
		}

		if(  empty($data['services_statushub_read']) )
		{
			$data['services_statushub_read'] = '0';
		}



		### New Feed by orbis ###



		if(  empty($data['user_block']) && $data['user_block'] != '0' )
		{
			$data['user_block'] = '1';
		}

		if(  empty($data['lone_read']) )
		{
			$data['lone_read'] = '0';
		}
		if( !isset($data['lone_write']) )
		{
			$data['lone_write'] = '0';
		}

		if( !isset($data['manage_lone_write']) )
		{
			$data['manage_lone_write'] = '0';
		}
		if( empty($data['manage_lone_read']) )
		{
			$data['manage_lone_read'] = '0';
		}

		if( empty($data['decommission_read']) )
		{
			$data['decommission_read'] = '0';
		}
		if( !isset($data['decommission_write']) )
		{
			$data['decommission_write'] = '0';
		}

		if( empty($data['user_read']) )
		{
			$data['user_read'] = '0';
		}
		if( !isset($data['user_write']) )
		{
			$data['user_write'] = '0';
		}

		if( !isset($data['user_activity_read']) )
		{
			$data['user_activity_read'] = '0';
		}

		if( !isset($data['event_detail_read']) )
		{
			$data['event_detail_read'] = '0';
		}

		if( !isset($data['alarm_activation_read']) )
		{
			$data['alarm_activation_read'] = '0';
		}

		if( !isset($data['user_escalation_read']) )
		{
			$data['user_escalation_read'] = '0';
		}

		if( !isset($data['amber_alert_utilisation_read']) )
		{
			$data['amber_alert_utilisation_read'] = '0';
		}

		if( !isset($data['system_schedule_read']) )
		{
			$data['system_schedule_read'] = '0';
		}

		if( !isset($data['auto_reporting_read']) )
		{
			$data['auto_reporting_read'] = '0';
		}
		$data['sentinal_integration_show_hide'] = '0';
		//debug($data,1);
		$this->mysql->insert('user',$data);
		//echo $this->mysql->last_query();exit;
		return $this->mysql->insert_id();
	}

	function edit_system_user($data,$id)
	{
		$this->mysql = $this->load->database('mysql', true);

		unset($data['edit_user_id']);
		unset($data['user_id']);
		unset($data['confirm_password']);
		unset($data['portalUserToken']);

		unset($data['costcentre_list']);
		unset($data['contractarea_id']);
		unset($data['office_list']);

		if($data['sentinel_username']){
			$data['sentinel_username'] =  encrypt_string($data['sentinel_username']);
		}
		if($data['sentinel_password']){
			$data['sentinel_password'] =  encrypt_string($data['sentinel_password']);
		}

		if(  empty($data['user_status']) )
		{
			$data['user_status'] = '0';
		}

		if(  empty($data['service_status']) )
		{
			$data['service_status'] = '0';
		}

		if(  empty($data['storage_status']) )
		{
			$data['storage_status'] = '0';
		}
		
		
		if(  empty($data['dashboard_maps']) )
		{
			$data['dashboard_maps'] = '0';
		}
		
		if(  empty($data['app_users_report']) )
		{
			$data['app_users_report'] = '0';
		}
		
		
		if(  empty($data['to_play_audio_player_status']) )
		{
			$data['to_play_audio_player_status'] = '0';
		}
		
		
		if(  empty($data['lms_status']) )
		{
			$data['lms_status'] = '0';
		}

		 ### OtA Broadcast Message ###

		 if(  empty($data['ota_read']) )
		{
			$data['ota_read'] = '0';
		}

		if(  empty($data['ota_write']) )
		{
			$data['ota_write'] = '0';
		}

		if(  empty($data['broadcast_message_read']) )
		{
			$data['broadcast_message_read'] = '0';
		}

		if(  empty($data['broadcast_message_write']) )
		{
			$data['broadcast_message_write'] = '0';
		}


		 ### OtA Broadcast Message ###


		### New Feed by orbis ###

		if(  empty($data['global_escalations_read']) )
		{
			$data['global_escalations_read'] = '0';
		}

		if(  empty($data['global_escalations_write']) )
		{
			$data['global_escalations_write'] = '0';
		}

		if(  empty($data['elearning_read']) )
		{
			$data['elearning_read'] = '0';
		}

		if(  empty($data['user_guides_read']) )
		{
			$data['user_guides_read'] = '0';
		}

		if(  empty($data['user_videos_read']) )
		{
			$data['user_videos_read'] = '0';
		}

		if(  empty($data['services_statushub_read']) )
		{
			$data['services_statushub_read'] = '0';
		}



		### New Feed by orbis ###




		if( $data['user_status'] == 1 )
		{
			$query = $this->mysql->select('*')->from('login_attempt')->where([ 'ip' => $_SERVER['REMOTE_ADDR'], 'username' => $data['username']  ])->get()->first_row('array');
			if( !empty($query))
			{
				$row['username'] = '';
				$row['attempt'] = 0;
				$this->mysql->where('id',$query['id'])->update('login_attempt',$row);
			}
		}

		if(  empty($data['user_block']) && $data['user_block'] != '0' )
		{
			$data['user_block'] = '1';
		}

		if(  empty($data['lone_read']) )
		{
			$data['lone_read'] = '0';
		}
		if( !isset($data['lone_write']) )
		{
			$data['lone_write'] = '0';
		}

		if( !isset($data['manage_lone_write']) )
		{
			$data['manage_lone_write'] = '0';
		}
		if( empty($data['manage_lone_read']) )
		{
			$data['manage_lone_read'] = '0';
		}

		if( empty($data['decommission_read']) )
		{
			$data['decommission_read'] = '0';
		}
		if( !isset($data['decommission_write']) )
		{
			$data['decommission_write'] = '0';
		}

		if( empty($data['user_read']) )
		{
			$data['user_read'] = '0';
		}
		if( !isset($data['user_write']) )
		{
			$data['user_write'] = '0';
		}

		if( !isset($data['user_activity_read']) )
		{
			$data['user_activity_read'] = '0';
		}

		if( !isset($data['event_detail_read']) )
		{
			$data['event_detail_read'] = '0';
		}

		if( !isset($data['alarm_activation_read']) )
		{
			$data['alarm_activation_read'] = '0';
		}

		if( !isset($data['user_escalation_read']) )
		{
			$data['user_escalation_read'] = '0';
		}

		if( !isset($data['amber_alert_utilisation_read']) )
		{
			$data['amber_alert_utilisation_read'] = '0';
		}


		if( !isset($data['system_schedule_read']) )
		{
			$data['system_schedule_read'] = '0';
		}


		if( !isset($data['auto_reporting_read']) )
		{
			$data['auto_reporting_read'] = '0';
		}

		return $this->mysql->where('user_id', $id)->update('user',$data);

	}

	// get geofence
	function get_location_geofence($id)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('area,zoomLevel')->from('officeArea')->where('officeId',$id)->get()->first_row('array');
	}

	//geofence first time
	function get_data_first_time()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('area,zoomLevel')->from('officeArea')->order_by('create_at','desc')->get()->first_row('array');
	}

	function count_geo()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('geofence')->where('agency_type','1')->get()->result_array();
	}

	// add geofence Model
	function geofence_add($data)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->insert('geofence',$data);
	}

	//update geofence
	function update_geofence($data,$id)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->where( 'geofence_id', $id )->update( 'geofence', $data );
	}

	function delete_geofence($id)
	{
		$this->mysql->where('officeID', $id)->delete('officeArea');
		return $this->mysql->where('geofence_id',$id)->delete('geofence');
	}

	function geofencelist()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('geofence')->order_by('create_at', 'desc')->get()->result_array();
	}
	function get_all_lwd(){
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('operators')->get()->result_array();
	}

	function generate_token($data)
	{
		$this->mysql = $this->load->database('mysql', true);
		$this->mysql->insert('token',$data);
		return $this->mysql->insert_id();
	}

	function getTokenID($id)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('token')->where('id',$id)->get()->first_row('array');
	}

	function getToken($token,$id)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('token')->where(['token' => $token, 'user_id' => $id])->order_by('create_at','desc')->get()->first_row('array');
	}

	function get_user_detail($email)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('user')->where('email',$email)->get()->first_row('array');
	}

	function ResetPassword($password,$id)
	{
		$this->load->helpers('encrypt');
		$this->mysql = $this->load->database('mysql', true);
		$data['password'] = encrypt_string($password);
		return $this->mysql->where('user_id', $id)->update('user',$data);
	}

	function insert_report($data){
		$this->mysql = $this->load->database('mysql', true);
		if( !empty($data) ) {

			$this->mysql->query('truncate reporting');

			for ($i=0; $i <count($data) ; $i++) {
				$row[$i]['serialnumber'] = $data[$i]['SerialNumber'];
				$row[$i]['logheaderidentifier'] = $data[$i]['LogHeaderIdentifier'];
				$row[$i]['logdatetime'] = $data[$i]['LogDateTimeNew'];
				$row[$i]['identifier'] = $data[$i]['Identifier'];
				$row[$i]['eventdescription'] = $data[$i]['EventDescription'];
				$row[$i]['description'] = $data[$i]['Description'];
				$row[$i]['containsmedia'] = $data[$i]['ContainsMedia'];
				$row[$i]['longitude'] = $data[$i]['Longitude'];
				$row[$i]['latitude'] = $data[$i]['Latitude'];
				$row[$i]['userinitials'] = $data[$i]['UserInitials'];

				$row[$i]['datetime'] = $data[$i]['datetime'];
				$row[$i]['username'] = $data[$i]['username'];
				$row[$i]['signaltype'] = $data[$i]['signaltype'];
				$row[$i]['serialno'] = $data[$i]['serialno'];

				$this->mysql->insert('reporting',$row[$i]);
			}
		}
	}

	function get_report_data(){
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('reporting')->get()->result_array();
	}


	function insert_escalation_summary($data){
		$userId 	 =  $this->session->userdata('user_id') ;
		$this->mysql = $this->load->database('mysql', true);
		//$this->mysql->query('truncate escalation_summary');
		$this->mysql->delete('escalation_summary', array('user_id' => $userId));
		$row = array();
		for ($i=0; $i <count($data) ; $i++) {
			$row[$i]['main_name'] = $data[$i]['main_name'];
			$row[$i]['child_data'] = $data[$i]['child_data'];
			$row[$i]['user_id'] = $userId;
			$this->mysql->insert('escalation_summary',$row[$i]);
		}
	}

	function global_escalation_summary($data)
	{
		$userId 	 =  $this->session->userdata('user_id') ;
		$this->mysql = $this->load->database('mysql', true);
			//$this->mysql->query('truncate global_escalation_summary');
			$this->mysql->delete('global_escalation_summary', array('user_id' => $userId));
			$row = array();
			for ($i=0; $i <count($data) ; $i++) {
				$row[$i]['NAME'] = $data[$i]['NAME'];
				$row[$i]['PRIORITY'] = $data[$i]['PRIORITY'];
				$row[$i]['MOBILE'] = $data[$i]['MOBILE'];
				$row[$i]['WORK1'] = $data[$i]['WORK1'];
				$row[$i]['PHONE'] = $data[$i]['PHONE'];
				$row[$i]['PAGER'] = $data[$i]['PAGER'];
				$row[$i]['EMAIL'] = $data[$i]['EMAIL'];
				$row[$i]['user_id'] = $userId;
				$this->mysql->insert('global_escalation_summary',$row[$i]);
			}
	}


	function empty_escalation_summary()
	{
		$userId 	 =  $this->session->userdata('user_id') ;
		$this->mysql = $this->load->database('mysql', true);
		//$this->mysql->query('truncate escalation_summary');
		$this->mysql->delete('escalation_summary', array('user_id' => $userId));
	}

	function empty_global_escalation_summary()
	{
		$userId 	 =  $this->session->userdata('user_id') ;
		$this->mysql = $this->load->database('mysql', true);
		//$this->mysql->query('truncate global_escalation_summary');
		$this->mysql->delete('global_escalation_summary', array('user_id' => $userId));
	}

	function get_escalation_summary_data(){
		$userId 	 =  $this->session->userdata('user_id') ;
		$this->mysql = $this->load->database('mysql', true);
		//return $this->mysql->select('*')->from('escalation_summary')->get()->result_array();
		return $this->mysql->select('*')->from('escalation_summary')->where([ 'user_id' => $userId ])->get()->result_array();
	}

	function get_global_escalation_summary_data(){
		$userId 	 =  $this->session->userdata('user_id') ;
		$this->mysql = $this->load->database('mysql', true);
		//return $this->mysql->select('*')->from('global_escalation_summary')->get()->result_array();
		return $this->mysql->select('*')->from('global_escalation_summary')->where([ 'user_id' => $userId ])->get()->result_array();
	}

	function get_escalation_summary_data_excel(){
		$userId 	 =  $this->session->userdata('user_id') ;
		$this->mysql = $this->load->database('mysql', true);
		//return $this->mysql->select('child_data')->from('escalation_summary')->get()->result_array();
		return $this->mysql->select('child_data')->from('escalation_summary')->where([ 'user_id' => $userId ])->get()->result_array();
	}

	function signalHistoryData($data)
	{

		$userId 	 =  $this->session->userdata('user_id') ;
		$this->mysql = $this->load->database('mysql', true);
		//$this->mysql->query('truncate signal_history');
		$this->mysql->delete('signal_history', array('user_id' => $userId));
		for( $m=0; $m<count($data); $m++ )
		{
			$row[$m]['EVTIME'] = $data[$m]['LSEQNO_data']['EVTIME'];
			$row[$m]['SERIALNO'] = $data[$m]['LSEQNO_data']['SERIALNO'];
			$row[$m]['NAME'] = $data[$m]['LSEQNO_data']['USERNAME'];
			$row[$m]['DESCR'] = $data[$m]['LSEQNO_data']['DESCR'];
			$row[$m]['LATITUDE'] = $data[$m]['LSEQNO_data']['LATITUDE'];
			$row[$m]['LONGITUDE'] = $data[$m]['LSEQNO_data']['LONGITUDE'];
			$row[$m]['address'] = $data[$m]['LSEQNO_data']['address'];
			$row[$m]['user_id'] = $userId;

			$this->mysql->insert('signal_history',$row[$m]);
		}
	}

	function signalHistoryDataNew($data)
	{

		$userId 	 =  $this->session->userdata('user_id') ;
		$this->mysql = $this->load->database('mysql', true);
		//$this->mysql->query('truncate signal_history');
		$this->mysql->delete('signal_history', array('user_id' => $userId));
		for( $m=0; $m<count($data); $m++ )
		{
			$row[$m]['EVTIME'] 		= $data[$m]['EVTIME'];
			$row[$m]['SERIALNO'] 	= $data[$m]['SERIALNO'];
			$row[$m]['NAME'] 		= $data[$m]['NAME'];
			$row[$m]['DESCR'] 		= $data[$m]['DESCR'];
			$row[$m]['address'] 	= $data[$m]['LOCATIONTITLE'];
			$row[$m]['cause'] 		= $data[$m]['CAUSE'];
			$row[$m]['phone'] 		= $data[$m]['NETADDR'];
			$row[$m]['user_id'] 	= $userId;

			$this->mysql->insert('signal_history',$row[$m]);
		}
	}


	function getSignalHistoryExport(){
		$userId 	 =  $this->session->userdata('user_id') ;
		$this->mysql = $this->load->database('mysql', true);
		//return $this->mysql->select('*')->from('signal_history')->get()->result_array();
		return $this->mysql->select('*')->from('signal_history')->where([ 'user_id' => $userId ])->get()->result_array();
	}

	function deleteSignalHistoryReport(){
		$userId 	 =  $this->session->userdata('user_id') ;
		$this->mysql = $this->load->database('mysql', true);
		$this->mysql->delete('signal_history', array('user_id' => $userId));
	}

	function userActivityReport($data)
	{
		ini_set('display_errors', 1);
		ini_set('display_startup_errors', 1);
		error_reporting(E_ALL);
		//debug($data, 1) ;
		$userId 	 =  $this->session->userdata('user_id') ;
		$this->mysql = $this->load->database('mysql', true);
		//$this->mysql->query('truncate userActivityReport');
		$this->mysql->delete('userActivityReport', array('user_id' => $userId));

		//debug($data,1);

		for ($m=0; $m < count($data) ; $m++) {
			$amber_alert_other	=  	   ( isset($data[$m]['transmittertypeother']['Amber_Alert']) ? $data[$m]['transmittertypeother']['Amber_Alert'] : 0 ) ;

			$amber_alert_audio		=  ( isset($data[$m]['transmittertypeaudio']['Amber_Alert']) ? $data[$m]['transmittertypeaudio']['Amber_Alert'] : 0 ) ;

			$amber_alert_start_other =  ( isset($data[$m]['transmittertypeother']['Amber_Alert_Start']) ? $data[$m]['transmittertypeother']['Amber_Alert_Start'] : 0 ) ;

			$amber_cancel_o_Due__OrbisApp_other = ( isset($data[$m]['transmittertypeother']['Amber_Cancel_O_Due__OrbisApp_']) ? $data[$m]['transmittertypeother']['Amber_Cancel_O_Due__OrbisApp_'] : 0 ) ;

			$amber_cancel_o_Due__OrbisApp_audio =   ( isset($data[$m]['transmittertypeaudio']['Amber_Cancel_O_Due__OrbisApp_']) ? $data[$m]['transmittertypeaudio']['Amber_Cancel_O_Due__OrbisApp_'] : 0 ) ;

			$Amber_Cancel_Overdue_other = ( isset($data[$m]['transmittertypeother']['Amber_Cancel_Overdue']) ? $data[$m]['transmittertypeother']['Amber_Cancel_Overdue'] : 0 ) ;

			$Amber_Cancel_Overdue_audio =   ( isset($data[$m]['transmittertypeaudio']['Amber_Cancel_Overdue']) ? $data[$m]['transmittertypeaudio']['Amber_Cancel_Overdue'] : 0 ) ;

			$amber_alert_audio_audio		=  ( isset($data[$m]['transmittertypeaudio']['Amber_Alert_Audio']) ? $data[$m]['transmittertypeaudio']['Amber_Alert_Audio'] : 0 ) ;

			$Fall_audio		=  ( isset($data[$m]['transmittertypeaudio']['Fall']) ? $data[$m]['transmittertypeaudio']['Fall'] : 0 ) ;

			$Man_Down_audio		=  ( isset($data[$m]['transmittertypeaudio']['Man_Down']) ? $data[$m]['transmittertypeaudio']['Man_Down'] : 0 ) ;

			$Red_Alert_Audio_audio		=  ( isset($data[$m]['transmittertypeaudio']['Red_Alert_Audio']) ? $data[$m]['transmittertypeaudio']['Red_Alert_Audio'] : 0 ) ;


			//New added for identiSafe8 and 1000 devices

			$Information_Amber_Start_other =  ( isset($data[$m]['transmittertypeother']['Information___Amber_Start']) ? $data[$m]['transmittertypeother']['Information___Amber_Start'] : 0 ) ;



			$row[$m]['CONTRACT'] 					= $data[$m]['CONTRACT'];
			$row[$m]['OFFICE']						= $data[$m]['OFFICE'];
			$row[$m]['USERNAME'] 					= $data[$m]['NAME'];
			$row[$m]['serialno'] 					= $data[$m]['SERIALNO'];
			$row[$m]['Transmitter_Type'] 			= $data[$m]['TRANSMITTERNAME'];

			$row[$m]['IMEI_Number'] 				= $data[$m]['PROPERTYVALUE'];
			$row[$m]['Mobile_Number'] 				= $data[$m]['NETADDR'];
			$row[$m]['Date_Time_Of_Last_Signal'] 	= $data[$m]['LASTSIGNAL'];

			/*$row[$m]['Amber_Alerts_Data'] 	  		 = ( $data[$m]['transmittertypeother']['Amber_Alert'] +  $data[$m]['transmittertypeother']['Amber_Alert_Start'] );
			$row[$m]['Amber_Alerts_Voice'] 	         = ( $data[$m]['transmittertypeaudio']['Amber_Alert_Audio'] +  $data[$m]['transmittertypeaudio']['Amber_Alert'] + $data[$m]['transmittertypeaudio']['Amber_Alert_Start'] );

			$row[$m]['Red_Alerts_Data'] 			 = $data[$m]['transmittertypeother']['Red_Alert'];
			$row[$m]['Red_Alerts_Voice'] 			 = ( $data[$m]['transmittertypeaudio']['Amber_Cancel_O_Due__OrbisApp_'] + $data[$m]['transmittertypeaudio']['Fall'] + $data[$m]['transmittertypeaudio']['Amber_Cancel_Overdue'] + $data[$m]['transmittertypeaudio']['Man_Down'] + $data[$m]['transmittertypeaudio']['Red_Alert_Audio'] );


			$row[$m]['Man_Down_Alert'] 				 = $data[$m]['transmittertypeother']['Man_Down'];
			$row[$m]['Fall_Alert']						 = $data[$m]['transmittertypeother']['Fall'];
			$row[$m]['Amber_Exceed']			 	 = ( $data[$m]['transmittertypeother']['Amber_Cancel_Overdue'] + $data[$m]['transmittertypeother']['Amber_Cancel_O_Due__OrbisApp_'] );
			*/

			$row[$m]['Amber_Alerts_Data'] 	  		 = ( $amber_alert_other +   $amber_alert_start_other + $Information_Amber_Start_other );

			$row[$m]['Amber_Alerts_Voice'] 	         = ( $amber_alert_audio_audio +  $amber_alert_audio  );

			$row[$m]['Red_Alerts_Data'] 			 = ( isset($data[$m]['transmittertypeother']['Red_Alert']) ? $data[$m]['transmittertypeother']['Red_Alert'] : 0 ) ;



			$row[$m]['Red_Alerts_Voice'] 			 = ( $amber_cancel_o_Due__OrbisApp_audio + $Fall_audio + $Amber_Cancel_Overdue_audio + $Man_Down_audio + $Red_Alert_Audio_audio );


			$row[$m]['Man_Down_Alert'] 				 = ( isset($data[$m]['transmittertypeother']['Man_Down']) ? $data[$m]['transmittertypeother']['Man_Down'] : 0 );

			$row[$m]['Fall_Alert']						 = ( isset($data[$m]['transmittertypeother']['Fall']) ? $data[$m]['transmittertypeother']['Fall'] : 0 );

			$row[$m]['Amber_Exceed']			 	 = ( $Amber_Cancel_Overdue_other + $amber_cancel_o_Due__OrbisApp_other );

			$row[$m]['user_id'] = $userId;


			$this->mysql->insert('userActivityReport',$row[$m]);
		}
	}

	function getUserActivityReport($explodeSearch)
	{
		$userId 	 =  $this->session->userdata('user_id') ;
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select($explodeSearch)->from('userActivityReport')->where([ 'user_id' => $userId ])->get()->result_array();

	}

	function deleteUserActivityReport(){
		$userId 	 =  $this->session->userdata('user_id') ;
		$this->mysql = $this->load->database('mysql', true);
		$this->mysql->delete('userActivityReport', array('user_id' => $userId));
	}

	function updateMyAccount($data,$id){
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->where('user_id', $id)->update('user',$data);
	}



	function updateUserEmail($data,$id){
		$this->mysql = $this->load->database('mysql', true);
		$this->mysql->where('user_id', $id)->update('user',$data);
		return $this->mysql->affected_rows();
	}

	function blockUser($status,$ID)
	{
		$this->mysql = $this->load->database('mysql', true);
		$data['user_block'] = $status;
		return $this->mysql->where('user_id', $ID)->update('user',$data);
	}

	function checkUserNameDb($type,$value){
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('user')->where($type,$value)->get()->first_row('array');
	}

	function ipCount()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('login_attempt')->where('ip', $_SERVER['REMOTE_ADDR'])->get()->first_row('array');
	}

	function failedLogin($username){
		$this->mysql = $this->load->database('mysql', true);
				$query = $this->mysql->select('*')->from('login_attempt')->where([ 'ip' => $_SERVER['REMOTE_ADDR'], 'username' => $username  ])->get()->first_row('array');
				if( empty($query) )
				{
					$data['attempt'] = 1;
					$data['username'] = $username;
					$data['ip'] = $_SERVER['REMOTE_ADDR'];
					$data['created_date'] = date( 'Y-m-d H:i:s' );
					$this->session->set_userdata('attempt', $data['attempt']);
					$this->mysql->insert('login_attempt',$data);
				}
				if( !empty($query) )
				{
					$data['attempt'] = ++$query['attempt'];
					$data['username'] = $username;
					$data['updated_date'] = date( 'Y-m-d H:i:s' );

					if( $data['attempt'] >= 5 ){
						$getData = $this->mysql->select('user_id')->from('user')->where('username',$username)->get()->first_row();
						if( !empty($getData) ){
							$row['user_status'] = '0';
							$this->mysql->where('user_id',$getData->user_id)->update('user',$row);
						}
					}

					$this->session->set_userdata('attempt', $data['attempt']);
					$this->mysql->where('id',$query['id'])->update('login_attempt',$data);
				}
			return $data['attempt'];

	}

	function successLogin($username){
		$this->mysql = $this->load->database('mysql', true);
		$getData = $this->mysql->select('user_id,login_attempt')->from('user')->where('username',$username)->get()->first_row();
		$data['user_id'] = $getData->user_id;
		$data['login_attempt'] = 0;
		$this->mysql->where('user_id',$getData->user_id)->update('user',$data);
	}

	function insertToken($id,$token){
		$this->mysql = $this->load->database('mysql', true);
		$data['token'] = $token;
		return $this->mysql->where('user_id',$id)->update('user',$data);
	}

	function checkLoggedInToken($id,$token)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('user_id,email,username')->from('user')->where([ 'user_id' => $id, 'token' => $token ])->get()->first_row('array');
	}

	function removeToken($id,$token)
	{
		$this->mysql = $this->load->database('mysql',true);
		$data['token'] = '';
		return $this->mysql->where('user_id',$id)->update('user',$data);
	}

	function checkCurrentPassword($password,$id){
		$this->mysql = $this->load->database('mysql',true);
		return $this->mysql->select('user_id')->from('user')->where([ 'password' => encrypt_string($password), 'user_id' => $id ])->get()->first_row('array');
		//echo $this->mysql->last_query();
	}

	//ravi created code starts here

	function getLiveLoneUserDataCount($userId){
		$this->mysql = $this->load->database('mysql',true);
		$query = $this->mysql->select('*')->from('live_lone_workers')->where([ 'user_id' => $userId ])->get();
		return $query->num_rows();
		//echo $this->mysql->last_query();
	}

	function insertLiveLoneUserData($data)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->insert_batch('live_lone_workers',$data);
	}

	function deleteLiveLoneUserData($userId)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->delete('live_lone_workers', array('user_id' => $userId));
	}

	function getLiveLoneUserData($userId, $searchLastSignal, $searchtypeSignal, $searchSortBy){
		$this->mysql = $this->load->database('mysql',true);
		if ( $searchLastSignal && $searchtypeSignal ) {
			$searchLastSignal = "'". implode("', '", $searchLastSignal) ."'";
			$searchtypeSignal = "'". implode("', '", $searchtypeSignal) ."'";
			/*return $this->mysql->select('*')
					->from('live_lone_workers')
					->where([ 'user_id' => $userId ])
					->where_in('DESCR', $searchLastSignal)
					->or_where_in('TYPE',$searchtypeSignal)
					->order_by($searchSortBy[0], $searchSortBy[1])
					->get()
					->result_array();*/
			$SQL = "Select * from live_lone_workers where user_id = '" . $userId . "' AND (DESCR IN($searchLastSignal) AND TYPE IN($searchtypeSignal))" ;
			$query = $this->mysql->query($SQL);
			return $query->result_array();
		} elseif ($searchLastSignal) {
			return $this->mysql->select('*')
					->from('live_lone_workers')
					->where([ 'user_id' => $userId ])
					->where_in('DESCR', $searchLastSignal)
					->order_by($searchSortBy[0], $searchSortBy[1])
					->get()
					->result_array();
		} elseif ($searchtypeSignal) {
			return $this->mysql->select('*')
					->from('live_lone_workers')
					->where([ 'user_id' => $userId ])
					->where_in('TYPE', $searchtypeSignal)
					->order_by($searchSortBy[0], $searchSortBy[1])
					->get()
					->result_array();
		} else {
			return $this->mysql->select('*')
					->from('live_lone_workers')
					->where([ 'user_id' => $userId ])
					->order_by($searchSortBy[0], $searchSortBy[1])
					->get()
					->result_array();
		}
	}

	function get_user_billing_refrence()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('get_current_user_billing_refrence_number')->where(['id' => '1'])->get()->result_array();
	}

	function update_user_billing_refrence($setValue)
	{
		$this->mysql = $this->load->database('mysql', true);
		$this->mysql->where('id', '1');
		$this->mysql->set('current_number', $setValue);
		$this->mysql->update('get_current_user_billing_refrence_number');
	}

	function deleteLoginAttempts($userName)
	{
		$this->mysql = $this->load->database('mysql', true);
		$this->mysql->where('username', $userName);
		$this->mysql->delete('login_attempt');
	}

	function getUserDetailsReport()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('username, first_name, sur_name, costcentrename, contractareaname, 	officename, user_status, user_block')->from('user')->get()->result_array();
	}

	function insertAddedLoneWorkersData($data, $apiResponseMessage, $errorType) {
		$dataNew = [];
		$dataNew['name']  					= $data['name1'];
		$dataNew['phone'] 					= $data['number1'];
		$dataNew['unique_id'] 				= $data['uniqueId'];
		$dataNew['api_response_message']	= $apiResponseMessage;
		$dataNew['error_type']			    = $errorType;
		$this->mysql = $this->load->database('mysql', true);
		$this->mysql->insert('add_lone_worker_data',$dataNew);
	}

	function getAddedLoneWorkers($uniqueId)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('add_lone_worker_data')->where(['unique_id' => $uniqueId])->get()->result_array();
	}

	function addedLoneWorkersErrorType($uniqueId)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('add_lone_worker_data')->where(['unique_id' => $uniqueId, 'error_type' => '1'])->get()->result_array();
	}

	function check_ota_settings_name_exists($settingName) {
		$this->mysql = $this->load->database('mysql', true);
		$query = $this->mysql->select('*')->from('ota_device_settings')->where([ 'device_settings_name' => $settingName ])->get();
		return $query->num_rows();
	}

	public function insert_ota_device_settings($postData) {

		$data['sip_call'] 				= $postData['sipStatus'] ;
		$data['trigger_sos'] 			= $postData['triggersos'] ;
		$data['sos_press_level'] 		= $postData['triggersoslevel'] ;
		$data['rip_alarm'] 				= $postData['ripalarm'] ;
		$data['fall_detect'] 			= $postData['falldetect'] ;
		$data['fall_detect_senstivity'] = $postData['fallsenstivity'] ;
		$data['device_settings_name']	= $postData['name'] ;

		$data['min_man_down_timer_minutes']	= $postData['minmandowntimerminutes'] ;
		$data['min_man_down_timer_seconds']	= $postData['minmandowntimerseconds'] ;
		$data['max_man_down_timer_minutes']	= $postData['maxmandowntimerminutes'] ;
		$data['max_man_down_timer_seconds']	= $postData['maxmandowntimerseconds'] ;
		$data['min_amber_timer_hours']		= $postData['minambertimerhours'] ;
		$data['min_amber_timer_minutes']	= $postData['minambertimerminutes'] ;
		$data['max_amber_timer_hours']		= $postData['maxambertimerhours'] ;
		$data['max_amber_timer_minutes']	= $postData['maxambertimerminutes'] ;
		$data['gps_pos_criteria']			= $postData['gpsposcriteria'] ;
		$data['gps_update_frequ_minutes']	= $postData['gpsfrequencyupdate'] ;
		$data['settings']					= $postData['settings'] ;
		$data['sms']						= $postData['sms'] ;
		$data['finger_print_lock']			= $postData['fingerprint_scanner'] ;
		$data['calendar']					= $postData['calendar'] ;
		$data['activity_based_locations']	= $postData['activity_based_locations'] ;
		$data['cost_center_id']				= $postData['cost_center_id'] ;
		$data['cost_centre_name']			= $postData['costCenterName'] ;
		$data['user_id']					= $postData['user_id'] ;
		$data['coorrdinates_refresh_rate']	= $postData['coorrdinatesRefreshRate'] ;
		$data['escalation_status']			= $postData['escalation_status'] ;
		$data['amber_timer_pre_alert_minutes']			= $postData['ambertimerprealertminutes'] ;
		$data['amber_timer_pre_alert_seconds']			= $postData['ambertimerprealertseconds'] ;

		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->insert('ota_device_settings',$data);
		//echo $this->mysql->last_query();
		//die;

	}


	public function getOTATemplateSettings($dataModel) {

		$this->mysql = $this->load->database('mysql', true);
		if ($dataModel['userId'] == 'superadmin') {
			return $this->mysql->select('*')->from('ota_device_settings')->get()->result_array();
		}else {
			return $this->mysql->select('*')->from('ota_device_settings')->where(['cost_center_id' => $dataModel['costCenterId']])->get()->result_array();
		}
	}

	public function getSingleTemplateData($templateId) {
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('ota_device_settings')->where(['id' => $templateId])->get()->result_array();
	}

	public function getDataFromOperatorsTable($postData) {
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')
						->from('operators')
						->where_in('number', $postData)
						->get()
						->result_array();
	}

	public function getSingleDataFromOperatorsTable($number) {
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('operators')->where([ 'number' => trim($number) ])->get()->first_row('array');
	}

	public function saveInfoHomesafeGeofnece($data) {
		$this->mysql = $this->load->database('mysql', true);


		$checkUser =  $this->mysql->select('id')->from('homesafe_geofencing_user_details')->where([ 'serial_number' => trim($data['serial_number']) ])->get()->first_row('array');

			if($checkUser) {
				$this->mysql->where( 'id', $checkUser['id'] )->update( 'homesafe_geofencing_user_details', $data );
			} else {
				$this->mysql->insert('homesafe_geofencing_user_details',$data);
			}
	}

	public function getUserGeofenceDeatils($serialNumber) {
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('homesafe_geofencing_user_details')->where([ 'serial_number' => trim($serialNumber) ])->get()->first_row('array');
	}

	public function update_ota_device_settings($postData) {
		$data['sip_call'] 				= $postData['sipStatus'] ;
		$data['trigger_sos'] 			= $postData['triggersos'] ;
		$data['sos_press_level'] 		= $postData['triggersoslevel'] ;
		$data['rip_alarm'] 				= $postData['ripalarm'] ;
		$data['fall_detect'] 			= $postData['falldetect'] ;
		$data['fall_detect_senstivity'] = $postData['fallsenstivity'] ;

		$data['min_man_down_timer_minutes']	= $postData['minmandowntimerminutes'] ;
		$data['min_man_down_timer_seconds']	= $postData['minmandowntimerseconds'] ;
		$data['max_man_down_timer_minutes']	= $postData['maxmandowntimerminutes'] ;
		$data['max_man_down_timer_seconds']	= $postData['maxmandowntimerseconds'] ;
		$data['min_amber_timer_hours']		= $postData['minambertimerhours'] ;
		$data['min_amber_timer_minutes']	= $postData['minambertimerminutes'] ;
		$data['max_amber_timer_hours']		= $postData['maxambertimerhours'] ;
		$data['max_amber_timer_minutes']	= $postData['maxambertimerminutes'] ;
		$data['gps_pos_criteria']			= $postData['gpsposcriteria'] ;
		$data['gps_update_frequ_minutes']	= $postData['gpsfrequencyupdate'] ;
		$data['settings']					= $postData['settings'] ;
		$data['sms']						= $postData['sms'] ;
		$data['finger_print_lock']			= $postData['fingerprint_scanner'] ;
		$data['calendar']					= $postData['calendar'] ;
		$data['activity_based_locations']	= $postData['activity_based_locations'] ;
		$data['coorrdinates_refresh_rate']	= $postData['coorrdinatesRefreshRate'] ;
		$data['escalation_status']			= $postData['escalation_status'] ;
		$data['amber_timer_pre_alert_minutes']			= $postData['ambertimerprealertminutes'] ;
		$data['amber_timer_pre_alert_seconds']			= $postData['ambertimerprealertseconds'] ;

		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->where( 'id', $postData['templateId'] )->update( 'ota_device_settings', $data );
	}

	function delete_ota_device_settings($id)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->where('id',$id)->delete('ota_device_settings');
	}


	public function get_All_Template_Settings($requestData) {
		$this->mysql = $this->load->database('mysql', true);
		ini_set('display_errors', 1);
		ini_set('display_startup_errors', 1);
		error_reporting(E_ALL);
		//debug($requestData, 1) ;
		$totalData = $this->mysql->from('ota_device_settings')->count_all_results();
		$totalFiltered = $totalData; // when there is no search parameter then total number rows = total number filtered rows.
		if( !empty($requestData['search']['value']) ) {
			// if there is a search parameter
			$sql = "SELECT id, device_settings_name, cost_center_id, cost_centre_name ";
			$sql.=" FROM ota_device_settings";
			$sql.=" WHERE (device_settings_name LIKE '%".$requestData['search']['value']."%' ";    // $requestData['search']['value'] contains search parameter
			$sql.=" OR cost_centre_name LIKE '%".$requestData['search']['value']."%') ";

			$sql.=" ORDER BY device_settings_name ASC LIMIT ".$requestData['start']." ,".$requestData['length']."   ";
			$query = $this->mysql->query($sql)->result_array();
			$totalFiltered = count($query);

		} else {
			$query = $this->mysql->select('id, device_settings_name, cost_center_id, cost_centre_name')
				->from('ota_device_settings')
				->order_by('device_settings_name', 'asc')
				->limit($requestData['length'], $requestData['start'])
				->get()
				->result_array();
				//echo $this->mysql->last_query();
			    //debug($data, 1) ;
		}

	  $data = [] ;
	  $counter = 0 ;
	  //debug($query, 1) ;

	  foreach ($query as $row) {
		$data[$counter][] 	= '<input type="checkbox" id="'.$row['id'].'" class="__checkBoxTemplateListing" aria-label="'.$row['id'].'">' ;
		$data[$counter][] 	= $row['device_settings_name'] ;

		if ($row['cost_center_id'] && $row['cost_center_id'] != 0) {
			$costCentreName = ( $row['cost_centre_name']  ? $row['cost_centre_name'] : '-' ) ;
		} else {
			$costCentreName = '<span class="___Addcustomerlink">Assign</span>' ;
		}

		$data[$counter][] 	=  $costCentreName ;
		$counter++ ;
	  }

	  return $json_data = array(
			"draw"            => intval( $requestData['draw'] ),   // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw.
			"recordsTotal"    => intval( $totalData ),  // total number of records
			"recordsFiltered" => intval( $totalFiltered ), // total number of records after searching, if there is no searching then totalFiltered = totalData
			"data"            => $data   // total data array
			);

	}

	function getCostCenterNameDynamically($costCentreId) {
		//return $costCentreId ;
		$conexion = new PDO("informix:host=".$this->config->item('pdo_connect')['host'].";service=".$this->config->item('pdo_connect')['service'].";database=".$this->config->item('pdo_connect')['database'].";server=".$this->config->item('pdo_connect')['server'].";protocol=".$this->config->item('pdo_connect')['protocol'].";EnableScrollableCursors=".$this->config->item('pdo_connect')['EnableScrollableCursors'].";client_locale=".$this->config->item('pdo_connect')['client_locale'].";db_locale=".$this->config->item('pdo_connect')['db_locale'] ,$this->config->item('pdo_connect')['db_user'],$this->config->item('pdo_connect')['db_pass']);

		// get CostCentre

		$CostCentre = "select unique linkacc.linkno , linkacc.name from linkacc, webusers where linkacc.parent = 20 and webusers.agctype = 4 and linkacc.linkno = webusers.agcno and linkacc.linkno = '". $costCentreId ."' ";


		$CostCentreQuery   = $conexion->prepare($CostCentre);
		$CostCentreQuery->execute();
		$CostCentreResponse = $CostCentreQuery->fetchAll(PDO::FETCH_ASSOC);


		if(!empty($CostCentreResponse)){
			$CostCentreName = trim(substr($CostCentreResponse[0]['NAME'], 3));
		}
		else{
		  $CostCentreName = '-';
		}

		return $CostCentreName ;
	}

	public function updateAssociatedOTATemplateSettings($postData) {

		$data['cost_center_id'] 				= $postData['costCentreId'] ;
		$data['cost_centre_name'] 			    = $postData['costCentreName'] ;

		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->where( 'id', $postData['templateId'] )->update( 'ota_device_settings', $data );
	}


	public function deleteBulkTemplates($multipleIds) {
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->where_in('id',$multipleIds)->delete('ota_device_settings');
	}


	// Delete Sentry portal users

	public function deleteBulkSentryUsers($multipleIds) {
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->where_in('user_id',$multipleIds)->delete('user');
	}


	// Data to add uniqueid, name, phone, serial number, transmitter type once the first time get configuration is clicked
	function addFirstDataToGetConfiguration($data)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->insert_batch('get_configuration',$data);
	}

	// Data to add uniqueid, name, phone, serial number, transmitter type once the first time get configuration is clicked
	function addFirstDataToGetConfigurationOnRefresh($getConfigUniqueId, $uniqueIdNew)
	{
		$this->mysql = $this->load->database('mysql', true);
		$sql  =  "SELECT `name`,`handset_number`,`serial_number`,`transmitter_type`, '".$uniqueIdNew."' as uniqueId FROM `get_configuration` WHERE `uniqueId` = '".$getConfigUniqueId." '";
		$query = $this->mysql->query($sql)->result_array();
		$insertData = $this->mysql->insert_batch('get_configuration', $query);

		//To get the new inserted data only number
		return $this->mysql->select('handset_number')->from('get_configuration')->where(['uniqueId' => $uniqueIdNew])->get()->result_array();

	}

	//Delete previous configurations when refresh is clicked
	function deletePreviousConfiguration($getConfigUniqueId)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->where('uniqueId',$getConfigUniqueId)->delete('get_configuration');
	}

	function updateFCMGetConfiguration($number, $uniqueId, $status, $deviceType){

		$this->mysql = $this->load->database('mysql', true);

		if ($deviceType == "ios" )  {

			/***Default Settings***/

				$prepareData['settings_name'] 		   = '' ;
				$prepareData['settings_id']	  		   = '' ;
				$prepareData['fcm_status']			   = "Sent" ;
				$prepareData['triggerSos'] 			   = '1' ;
				$prepareData['presslabel'] 			   = '1' ;
				$prepareData['ripAlarm'] 			   = '0';
				$prepareData['fallDetect'] 			   = '0';
				$prepareData['fallSenstivity'] 		   = '3';
				$prepareData['minmandowntimerminutes'] = '5';
				$prepareData['minmandowntimerseconds'] = '0';
				$prepareData['maxmandowntimerminutes'] = '60';
				$prepareData['maxmandowntimerseconds'] = '0';
				$prepareData['minambertimerhours']     = '0';
				$prepareData['minambertimerminutes']   = '5';
				$prepareData['maxambertimerhours']     = '12';
				$prepareData['maxambertimerminutes']   = '0';
				$prepareData['gpsfrequencyupdate']     = '15';
				$prepareData['settings'] 			   = '1';
				$prepareData['gpsposcriteria'] 		   = '3';
				$prepareData['calendar']               = '0';
				$prepareData['finger_print_lock']      = '0';
				$prepareData['gps_lat']     		   = '' ;
				$prepareData['gps_lng']      		   = '' ;
				$prepareData['sms']      			   = '1';
				$prepareData['imei_no']      		   = '-' ;
				$prepareData['serial_number_phone']    = '-' ;
				$prepareData['carrier']      		   = '-' ;
				$prepareData['model']      			   = '-' ;
				$prepareData['version']      		   = '-' ;
				$prepareData['device_id']      		   = '-' ;
				$prepareData['app_version']      	   = '-' ;
				$prepareData['app_name']      		   = '-' ;
				$prepareData['activity_based_locations']      = '0' ;
				$prepareData['device_type']      	   = $deviceType;
				$prepareData['escalation_status']      = '0' ;
				$prepareData['amber_timer_pre_alert_minutes']      = '2' ;
				$prepareData['amber_timer_pre_alert_seconds	']      = '0' ;

			/***Default Settings***/

			$query_mysql =  $this->mysql->select('*')->from('user_template_settings')->where([ 'phone' => trim($number) ])->get()->first_row('array');

			if ( $query_mysql ) {

				$templateId = $query_mysql['template_id'] ;
				$dataOTATable =  $this->mysql->select('*')->from('ota_device_settings')->where(['id' => $templateId])->get()->first_row('array');

				if ( $dataOTATable ) {
					$prepareData['settings_name'] 		   = $dataOTATable['device_settings_name'] ;
					$prepareData['settings_id']	  		   = $dataOTATable['id'] ;
					$prepareData['fcm_status']			   = "Sent" ;
					$prepareData['triggerSos'] 			   = $dataOTATable['trigger_sos'] ;
					$prepareData['presslabel'] 			   = $dataOTATable['sos_press_level'] ;
					$prepareData['ripAlarm'] 			   = $dataOTATable['rip_alarm'] ;
					$prepareData['fallDetect'] 			   = $dataOTATable['fall_detect'] ;
					$prepareData['fallSenstivity'] 		   = $dataOTATable['fall_detect_senstivity'] ;
					$prepareData['minmandowntimerminutes'] = $dataOTATable['min_man_down_timer_minutes'] ;
					$prepareData['minmandowntimerseconds'] = $dataOTATable['min_man_down_timer_seconds'] ;
					$prepareData['maxmandowntimerminutes'] = $dataOTATable['max_man_down_timer_minutes'] ;
					$prepareData['maxmandowntimerseconds'] = $dataOTATable['max_man_down_timer_seconds'] ;
					$prepareData['minambertimerhours']     = $dataOTATable['min_amber_timer_hours'] ;
					$prepareData['minambertimerminutes']   = $dataOTATable['min_amber_timer_minutes'] ;
					$prepareData['maxambertimerhours']     = $dataOTATable['max_amber_timer_hours'] ;
					$prepareData['maxambertimerminutes']   = $dataOTATable['max_amber_timer_minutes'] ;
					$prepareData['gpsfrequencyupdate']     = $dataOTATable['gps_update_frequ_minutes'] ;
					$prepareData['settings'] 			   = $dataOTATable['settings'] ;
					$prepareData['gpsposcriteria'] 		   = $dataOTATable['gps_pos_criteria'] ;
					$prepareData['calendar']               = $dataOTATable['calendar'] ;
					$prepareData['finger_print_lock']      = $dataOTATable['finger_print_lock'] ;
					$prepareData['sms']      			   = $dataOTATable['sms'] ;
					$prepareData['activity_based_locations']      = $dataOTATable['activity_based_locations'] ;
					$prepareData['escalation_status']      = $dataOTATable['escalation_status'] ;
					$prepareData['amber_timer_pre_alert_minutes']      = $dataOTATable['amber_timer_pre_alert_minutes'] ;
					$prepareData['amber_timer_pre_alert_seconds']      = $dataOTATable['amber_timer_pre_alert_seconds'] ;



					/*To set the device info saved in iosDeviceInfo_user_template_settings table*/

					$deviceInfoIOS =  $this->mysql->select('*')->from('iosDeviceInfo_user_template_settings')->where(['user_template_settings_id' => $query_mysql['id']])->get()->first_row('array');

					if ($deviceInfoIOS) {

						$prepareData['carrier']      		   = ( $deviceInfoIOS['device_carrier_name'] ? $deviceInfoIOS['device_carrier_name'] : '-' );
						$prepareData['model']      			   = ( $deviceInfoIOS['device_model_number'] ? $deviceInfoIOS['device_model_number'] : '-' );
						$prepareData['version']      		   = ( $deviceInfoIOS['device_version'] ? $deviceInfoIOS['device_version'] : '-' );
						$prepareData['app_version']      	   = ( $deviceInfoIOS['device_app_version'] ? $deviceInfoIOS['device_app_version'] : '-' );
						$prepareData['app_name']      		   = ( $deviceInfoIOS['device_app_name'] ? $deviceInfoIOS['device_app_name'] : '-' );

					}


					/*To set the device info saved in iosDeviceInfo_user_template_settings table*/

				}
			}

			return $this->mysql->where([ 'handset_number' => $number, 'uniqueId' =>  $uniqueId])->update( 'get_configuration', $prepareData );

		}
		else {
			$data['fcm_status']  = $status ;
			$data['device_type'] = $deviceType ;
			return $this->mysql->where([ 'handset_number' => $number, 'uniqueId' =>  $uniqueId])->update( 'get_configuration', $data );
		}
	}

	function getConfigurationFCM($uniqueId) {
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('get_configuration')->where(['uniqueId' => $uniqueId])->get()->result_array();
	}


	function getSingleConfiguration($Id) {
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('get_configuration')->where(['id' => $Id])->get()->result_array();
	}


	function insertUserDataOperators($data)
	{
		//debug(count($data),1);
		$this->mysql = $this->load->database('mysql', true);
		//$this->mysql->query('truncate operators');
		$counter = 0;
		$insertedUsers = 0 ;
		for( $i=0; $i<count($data); $i++ )
		{
			/*$row['loginname']   = trim($data[$i]['NAME']);
			$row['fullname'] 	= trim($data[$i]['NAME']);
			$row['lindex'] 		= $data[$i]['SERIALNO'];
			$row['app_type'] 	= $data[$i]['RECID'];*/

			/*
			$phoneEncoded	= utf8_decode($data[$i]['PHONE']) ;
			$phoneEncoded   = str_replace('?','', $phoneEncoded) ;

			$nameEncoded	= utf8_decode($data[$i]['NAME']) ;
			$nameEncoded    = str_replace('?',' ', $nameEncoded) ;
			*/

			$phoneEncoded	= preg_replace("/\\s+/iu","",$data[$i]['PHONE']) ;
			//$nameEncoded	= preg_replace("/\\s+/iu","",$data[$i]['NAME']) ;
			$nameEncoded	= $data[$i]['NAME'] ;

			$row['loginname']   = trim($nameEncoded);
			$row['fullname'] 	= trim($nameEncoded);
			$row['lindex'] 		= $data[$i]['SERIALNO'];
			$row['app_type'] 	= $data[$i]['RECID'];
			$row['number'] 		= trim($phoneEncoded);

			
			/*New Added for link accounts */
			
			$row['cost_centre_link_acc_no'] 	= (isset($data[$i]['LINKNO']) && $data[$i]['LINKNO'] ? $data[$i]['LINKNO'] : '-') ;
			$row['contract_area_link_acc_no'] 	= (isset($data[$i]['CALINKNO']) && $data[$i]['CALINKNO'] ? $data[$i]['CALINKNO'] : '-') ;
			$row['office_link_acc_no'] 			= (isset($data[$i]['OFFLINKNO']) && $data[$i]['OFFLINKNO'] ? $data[$i]['OFFLINKNO'] : '-') ;
			
			/*New Added for link accounts */
			
			$checkUser =  $this->mysql->select('ref')->from('operators')->where([ 'number' => trim($phoneEncoded) ])->get()->first_row('array');

			if($checkUser) {
				$this->mysql->where( 'ref', $checkUser['ref'] )->update( 'operators', $row );
				$counter++ ;
			} else {
				$this->mysql->insert('operators',$row);
				$insertedUsers++ ;
			}
		}

		/*
		$etc['loginname'] = 'Jack';
		$etc['fullname']  = 'Jack';
		$etc['lindex'] 	  = '0';
		$etc['number']	  = '918826622177';
		$row['app_type']  = '7';
		$this->mysql->insert('operators',$etc);
		*/
		echo '<br>Total Rows: '.count($data);
		echo '<br>Updated Rows: '. $counter;
		echo '<br>Inserted Rows: '. $insertedUsers;

	}

	// To save the applied template settings

	function saveUserTemplateSettings($templateId, $phone, $gps_pos_criteria, $loginName) {
		$this->mysql = $this->load->database('mysql', true);
		$data = [] ;
		$query_mysql =  $this->mysql->select('*')->from('user_template_settings')->where([ 'phone' => trim($phone) ])->get()->first_row('array');

		if ($query_mysql) { // update if number already exists
			$data['template_id'] 	  =  $templateId;
			$data['gps_pos_criteria'] =  $gps_pos_criteria;
			$data['loginname'] 		  =  $loginName;
			$this->mysql->where( 'phone', trim($phone) )->update( 'user_template_settings', $data );
		} else { // insert if number not exists
			$data['template_id'] 		=  $templateId;
			$data['phone'] 		 		=  $phone;
			$data['gps_pos_criteria'] 	=  $gps_pos_criteria;
			$data['loginname'] 			=  $loginName;
			$this->mysql->insert('user_template_settings',$data);
		}


	}


	// Data to add title, compose message,  from when broadcast message is sent
	function add_compose_message_details($from, $mainMessage, $title)
	{
		$data['from_message'] = $from ;
		$data['message'] 	  = $mainMessage;
		$data['title']        = $title;
		$this->mysql = $this->load->database('mysql', true);
		$this->mysql->insert('compose_message_details',$data);

		$insert_id = $this->mysql->insert_id();
		return  $insert_id;
	}



	function add_broadcast_message_user_details($data)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->insert_batch('broadcast_message_user_details',$data);
	}


	function updateBroadcastmessage($number, $uniqueId, $status){
		$data['fcm_status'] = $status ;
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->where([ 'phone' => $number, 'unique_id' =>  $uniqueId])->update( 'broadcast_message_user_details', $data );
	}


	public function dataSentItems($requestData) {
		$this->mysql = $this->load->database('mysql', true);
		ini_set('display_errors', 1);
		ini_set('display_startup_errors', 1);
		error_reporting(E_ALL);
		//debug($requestData, 1) ;
		$totalData = $this->mysql->from('broadcast_message_user_details')->where('main_user_id', $this->session->userdata('user_id')) ->count_all_results();
		$totalFiltered = $totalData; // when there is no search parameter then total number rows = total number filtered rows.
		$statusSelectToSet = '' ;
		if( !empty($requestData['search']['value']) ) {

			// if there is a search parameter

			$explodeSearch = explode('-', $requestData['search']['value']);

			$stringToSearch = "" ;
			if ( isset($explodeSearch[3]) && $explodeSearch[3] == "textSearch" ){
				 for ($i=4; $i< count($explodeSearch); $i++) {
					$stringToSearch .= $explodeSearch[$i] ;
				 }
			}

			$statusSelectToSet = $explodeSearch[2] ;

			$startDateExplode = explode( '/', trim( $explodeSearch[0]) );
			$startDateExplode = $startDateExplode[2] . '-' . $startDateExplode[1] . '-' . $startDateExplode[0] . " 00:00:00";

			$endDateExplode = explode( '/', trim( $explodeSearch[1]) );
			$endDateExplode = $endDateExplode[2] . '-' . $endDateExplode[1] . '-' . $endDateExplode[0] . " 23:59:59";


			$sql = "SELECT t1.*, t2.message from broadcast_message_user_details as t1 INNER JOIN compose_message_details as t2 ON t2.id = t1.compose_message_id" ;

			$sql .= " WHERE t1.sent_at BETWEEN '" . $startDateExplode ."' and '" . $endDateExplode . "'" ;

			if (trim($explodeSearch[2]) == "all") {

			} elseif($explodeSearch[2] == "null"){

				$sql .= " AND t1.fcm_status IS NULL" ;

			} elseif($explodeSearch[2] == "read"){

				$sql .= " AND t1.fcm_status = 'read' AND t1.read_status = '1'" ;

			} elseif($explodeSearch[2] == "delivered"){

				$sql .= " AND t1.fcm_status = 'delivered' AND t1.read_status = '0'" ;

			} else {

				$sql .= " AND t1.fcm_status = '".$explodeSearch[2]."'" ;
			}

			$sql .= " AND t1.main_user_id = '".$this->session->userdata('user_id')."'" ;


			if ( $stringToSearch ) {

				$sql .=  " AND(t1.phone LIKE '%".$stringToSearch."%' OR t1.name LIKE '%".$stringToSearch."' OR t2.message LIKE '%".$stringToSearch."%' OR t1.fcm_status LIKE '%".$stringToSearch."%')" ;
			}

			$sql.=" ORDER BY t1.sent_at DESC LIMIT ".$requestData['start']." ,".$requestData['length']."   ";

			$query = $this->mysql->query($sql)->result_array();
			$totalFiltered = count($query);

		} else {
			$dateRange 			= $requestData['dateRangeValue'] ;
			$explodedateRange	= explode('-', $dateRange);

			$startDateExplode = explode( '/', trim( $explodedateRange[0]) );
			$startDateExplode = $startDateExplode[2] . '-' . $startDateExplode[1] . '-' . $startDateExplode[0] . " 00:00:00";

			$endDateExplode = explode( '/', trim( $explodedateRange[1]) );
			$endDateExplode = $endDateExplode[2] . '-' . $endDateExplode[1] . '-' . $endDateExplode[0] . " 23:59:59";

			$query = $this->mysql->select('broadcast_message_user_details.*, compose_message_details.message')
				->from('broadcast_message_user_details')
				->join('compose_message_details', 'compose_message_details.id = broadcast_message_user_details.compose_message_id')
				->where('main_user_id', $this->session->userdata('user_id'))
				->where('sent_at >=', $startDateExplode)
				->where('sent_at <=', $endDateExplode)
				->order_by('broadcast_message_user_details.sent_at', 'desc')
				->limit($requestData['length'], $requestData['start'])
				->get()
				->result_array();
		}

	  $data = [] ;
	  $counter = 0 ;

	  foreach ($query as $row) {
		$data[$counter][] 	= $row['phone'] ;
		if (strlen($row['name']) >16) {
		  $title    = 'title="' . $row['name'] . '"';
		  $userName =  substr($row['name'], 0, 16) . '...';
		} else {
		  $title    = '';
		  $userName =  $row['name'];
		}
		$data[$counter][] 	= '<span ' . $title  .  '>' . $userName   . '</span>' ;
		$data[$counter][] 	= $row['message'] ;
		$data[$counter][] 	= date('d M y H:i:s', strtotime($row['sent_at'])) ;

		if ($row['fcm_status'] == 'delivered') {
			$classStatus = "delivered"  ;
		} elseif($row['fcm_status'] == 'read') {
			$classStatus = "messageRead" ;
		} else {
			$classStatus = "failed" ;
		}

		if ($row['fcm_status']) {
			$statusText = $row['fcm_status'] ;
		} else {
			$statusText =  'User does not exist';
		}
		$data[$counter][] = '<span class="SMmstatus '.$classStatus. '">'.ucfirst($statusText).'</span>' ;
		$counter++ ;
	  }

	  $statusQuery 		=  "SELECT DISTINCT(`fcm_status`) FROM broadcast_message_user_details" ;
	  $statusQueryData	= $this->mysql->query($statusQuery)->result_array();
	  $htmlStatusSelect = "" ;
	  if ($statusQueryData) {
		    $htmlStatusSelect .= '<option value="all"' . ($statusSelectToSet == 'all' ? 'selected' : ''). ' >All</option>'  ;
			foreach($statusQueryData as $row) {
				if ($row['fcm_status']) {
					$htmlStatusSelect .= '<option value="' . trim($row['fcm_status']) . '" ' . ($statusSelectToSet == trim($row['fcm_status']) ? 'selected' : ''). '>' . ucfirst($row['fcm_status']) . '</option>' ;
				} else {
					$htmlStatusSelect .= '<option value="null"' . ($statusSelectToSet == 'null' ? 'selected' : ''). ' >User does not exist</option>' ;
				}
			}
			// $htmlStatusSelect .= '<option value="read"' . ($statusSelectToSet == 'read' ? 'selected' : ''). '>Opened/Read</option>'  ;
	  } else {
			$htmlStatusSelect .= '<option value="">No results found.</option>'  ;
	  }

	  return $json_data = array(
			"draw"            => intval( $requestData['draw'] ),   // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw.
			"recordsTotal"    => intval( $totalData ),  // total number of records
			"recordsFiltered" => intval( $totalFiltered ), // total number of records after searching, if there is no searching then totalFiltered = totalData
			"data"            => $data,   // total data array
			"selectData"	  => $htmlStatusSelect // html for status select dropdown
			);

	}

	public function dataSentItemsAdmin($requestData) {
		$this->mysql = $this->load->database('mysql', true);
		ini_set('display_errors', 1);
		ini_set('display_startup_errors', 1);
		error_reporting(E_ALL);
		//debug($requestData, 1) ;
		$totalData = $this->mysql->from('broadcast_message_user_details')->count_all_results();
		$totalFiltered = $totalData; // when there is no search parameter then total number rows = total number filtered rows.
		$statusSelectToSet = '' ;
		if( !empty($requestData['search']['value']) ) {

			// if there is a search parameter

			$explodeSearch = explode('-', $requestData['search']['value']);

			$stringToSearch = "" ;
			if ( isset($explodeSearch[3]) && $explodeSearch[3] == "textSearch" ){
				 for ($i=4; $i< count($explodeSearch); $i++) {
					$stringToSearch .= $explodeSearch[$i] ;
				 }
			}

			$statusSelectToSet = $explodeSearch[2] ;

			$startDateExplode = explode( '/', trim( $explodeSearch[0]) );
			$startDateExplode = $startDateExplode[2] . '-' . $startDateExplode[1] . '-' . $startDateExplode[0] . " 00:00:00";

			$endDateExplode = explode( '/', trim( $explodeSearch[1]) );
			$endDateExplode = $endDateExplode[2] . '-' . $endDateExplode[1] . '-' . $endDateExplode[0] . " 23:59:59";


			$sql = "SELECT t1.*, t2.message from broadcast_message_user_details as t1 INNER JOIN compose_message_details as t2 ON t2.id = t1.compose_message_id" ;

			$sql .= " WHERE t1.sent_at BETWEEN '" . $startDateExplode ."' and '" . $endDateExplode . "'" ;

			if (trim($explodeSearch[2]) == "all") {

			} elseif($explodeSearch[2] == "null"){

				$sql .= " AND t1.fcm_status IS NULL" ;

			} elseif($explodeSearch[2] == "read"){

				$sql .= " AND t1.fcm_status = 'read' AND t1.read_status = '1'" ;

			} elseif($explodeSearch[2] == "delivered"){

				$sql .= " AND t1.fcm_status = 'delivered' AND t1.read_status = '0'" ;

			} else {

				$sql .= " AND t1.fcm_status = '".$explodeSearch[2]."'" ;
			}



			if ( $stringToSearch ) {

				$sql .=  " AND(t1.phone LIKE '%".$stringToSearch."%' OR t1.name LIKE '%".$stringToSearch."' OR t2.message LIKE '%".$stringToSearch."%' OR t1.fcm_status LIKE '%".$stringToSearch."%')" ;
			}

			$sql.=" ORDER BY t1.sent_at DESC LIMIT ".$requestData['start']." ,".$requestData['length']."   ";

			$query = $this->mysql->query($sql)->result_array();
			$totalFiltered = count($query);

		} else {
			$dateRange 			= $requestData['dateRangeValue'] ;
			$explodedateRange	= explode('-', $dateRange);

			$startDateExplode = explode( '/', trim( $explodedateRange[0]) );
			$startDateExplode = $startDateExplode[2] . '-' . $startDateExplode[1] . '-' . $startDateExplode[0] . " 00:00:00";

			$endDateExplode = explode( '/', trim( $explodedateRange[1]) );
			$endDateExplode = $endDateExplode[2] . '-' . $endDateExplode[1] . '-' . $endDateExplode[0] . " 23:59:59";

			$query = $this->mysql->select('broadcast_message_user_details.*, compose_message_details.message')
				->from('broadcast_message_user_details')
				->join('compose_message_details', 'compose_message_details.id = broadcast_message_user_details.compose_message_id')
				->where('sent_at >=', $startDateExplode)
				->where('sent_at <=', $endDateExplode)
				->order_by('broadcast_message_user_details.sent_at', 'desc')
				->limit($requestData['length'], $requestData['start'])
				->get()
				->result_array();
		}

	  $data = [] ;
	  $counter = 0 ;

	  foreach ($query as $row) {
		$data[$counter][] 	= $row['phone'] ;
		if (strlen($row['name']) >16) {
		  $title    = 'title="' . $row['name'] . '"';
		  $userName =  substr($row['name'], 0, 16) . '...';
		} else {
		  $title    = '';
		  $userName =  $row['name'];
		}
		$data[$counter][] 	= '<span ' . $title  .  '>' . $userName   . '</span>' ;
		$data[$counter][] 	= $row['message'] ;
		$data[$counter][] 	= date('d M y H:i:s', strtotime($row['sent_at'])) ;

		if ($row['fcm_status'] == 'delivered') {
			$classStatus = "delivered"  ;
		} elseif($row['fcm_status'] == 'read') {
			$classStatus = "messageRead" ;
		} else {
			$classStatus = "failed" ;
		}

		if ($row['fcm_status']) {
			$statusText = $row['fcm_status'] ;
		} else {
			$statusText =  'User does not exist';
		}
		$data[$counter][] = '<span class="SMmstatus '.$classStatus. '">'.ucfirst($statusText).'</span>' ;
		$counter++ ;
	  }

	  $statusQuery 		=  "SELECT DISTINCT(`fcm_status`) FROM broadcast_message_user_details" ;
	  $statusQueryData	= $this->mysql->query($statusQuery)->result_array();
	  $htmlStatusSelect = "" ;
	  if ($statusQueryData) {
		    $htmlStatusSelect .= '<option value="all"' . ($statusSelectToSet == 'all' ? 'selected' : ''). ' >All</option>'  ;
			foreach($statusQueryData as $row) {
				if ($row['fcm_status']) {
					$htmlStatusSelect .= '<option value="' . trim($row['fcm_status']) . '" ' . ($statusSelectToSet == trim($row['fcm_status']) ? 'selected' : ''). '>' . ucfirst($row['fcm_status']) . '</option>' ;
				} else {
					$htmlStatusSelect .= '<option value="null"' . ($statusSelectToSet == 'null' ? 'selected' : ''). ' >User does not exist</option>' ;
				}
			}
			//$htmlStatusSelect .= '<option value="read"' . ($statusSelectToSet == 'read' ? 'selected' : ''). '>Opened/Read</option>'  ;
	  } else {
			$htmlStatusSelect .= '<option value="">No results found.</option>'  ;
	  }

	  return $json_data = array(
			"draw"            => intval( $requestData['draw'] ),   // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw.
			"recordsTotal"    => intval( $totalData ),  // total number of records
			"recordsFiltered" => intval( $totalFiltered ), // total number of records after searching, if there is no searching then totalFiltered = totalData
			"data"            => $data,   // total data array
			"selectData"	  => $htmlStatusSelect // html for status select dropdown
			);

	}

	public function getCostCenterUsers(){
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('user_id, costcenterID, username, first_name, sur_name')->from('user')->where(['user_status' => '1', 'costcenterID !=' => '0', 'contractareaID =' => '0', 'officeID =' => '0' ])->get()->result_array();
	}

	public function getSharedFolderUsers($foldeName) {

		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('shared_folders_data')->where(['folder_name' => $foldeName ])->get()->result_array();
		echo $this->mysql->last_query() ;
	}

	function delete_shared_users($folderName)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->where('folder_name',$folderName)->delete('shared_folders_data');
	}

	function add_shared_users($data, $folderName)
	{
		$this->mysql = $this->load->database('mysql', true);
		$this->mysql->where('folder_name',$folderName)->delete('shared_folders_data');
		return $this->mysql->insert_batch('shared_folders_data',$data);
	}

	public function get_shared_folder_loggedin_user($costCentreID) {
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('shared_folders_data')->where(['cost_center_id' => $costCentreID ])->get()->result_array();
	}

	public function currentlySharedStatus($folderName, $costCentreID) {
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('shared_folders_data')->where(['folder_name' =>$folderName, 'cost_center_id' => $costCentreID ])->get()->result_array();
	}

	/****Create subscription vodafone market place***/

	function createSubscriptionVodafoneMarketPlace($data)
	{
		$this->mysql = $this->load->database('mysql', true);
		$this->mysql->insert('vodafone_market_place', $data);

		$insert_id = $this->mysql->insert_id();
		return  $insert_id;
	}


	/****Create subscription vodafone market place***/


	function getSubscriptions()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('vodafone_market_place')->order_by('created_at', 'desc')->get()->result_array() ;
	}


	function checkFromAccountIdentifier($accountIdentifier) {

		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('vodafone_market_place')->where([ 'account_identifier' => trim($accountIdentifier) ])->get()->first_row('array');


	}

	function modifySubscriptionVodafoneMarketPlace($data)
	{
		$this->mysql = $this->load->database('mysql', true);
		$this->mysql->insert('vodafone_market_place_modifications', $data);

		$insert_id = $this->mysql->insert_id();
		return  $insert_id;
	}


	public function getOrderModifications() {

		$this->mysql = $this->load->database('mysql', true);

		$SQL = "SELECT tt.*, groupedtt.totalRows FROM vodafone_market_place_modifications tt INNER JOIN (SELECT count(*) as totalRows, vodafone_market_place_id, MAX(created_at) AS MaxDateTime FROM vodafone_market_place_modifications where subscription_type = 'SUBSCRIPTION_CHANGE' GROUP BY vodafone_market_place_id) groupedtt ON tt.vodafone_market_place_id = groupedtt.vodafone_market_place_id AND tt.created_at = groupedtt.MaxDateTime order by tt.created_at DESC" ;

		$query = $this->mysql->query($SQL);
		return $query->result_array();

	}


	function getOrderCancellations()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('vodafone_market_place_modifications')->where([ 'subscription_type' => "SUBSCRIPTION_CANCEL" ])->order_by('created_at', 'desc')->get()->result_array() ;
	}


	public function getOrderNotices() {

		$this->mysql = $this->load->database('mysql', true);

		$SQL = "SELECT tt.*, groupedtt.totalRows FROM vodafone_market_place_modifications tt INNER JOIN (SELECT count(*) as totalRows, vodafone_market_place_id, MAX(created_at) AS MaxDateTime FROM vodafone_market_place_modifications where subscription_type = 'SUBSCRIPTION_NOTICE' GROUP BY vodafone_market_place_id) groupedtt ON tt.vodafone_market_place_id = groupedtt.vodafone_market_place_id AND tt.created_at = groupedtt.MaxDateTime order by tt.created_at DESC" ;

		$query = $this->mysql->query($SQL);
		return $query->result_array();

	}

	function getSingleOrderModifications($vodafone_market_place_id, $account_identifier)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('vodafone_market_place_modifications')->where([ 'subscription_type' => "SUBSCRIPTION_CHANGE", 'vodafone_market_place_id' => $vodafone_market_place_id, 'account_identifier' =>  $account_identifier])->order_by('created_at', 'desc')->get()->result_array() ;
	}


	function getSingleOrderNotices($vodafone_market_place_id, $account_identifier)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('vodafone_market_place_modifications')->where([ 'subscription_type' => "SUBSCRIPTION_NOTICE", 'vodafone_market_place_id' => $vodafone_market_place_id, 'account_identifier' =>  $account_identifier])->order_by('created_at', 'desc')->get()->result_array() ;
	}

	public function checkIsOrderCancelled($vodafone_market_place_id, $account_identifier) {

		$this->mysql = $this->load->database('mysql', true);

		$checkIsOrderCancelled = $this->mysql->select('*')->from('vodafone_market_place_modifications')->where([ 'subscription_type' => "SUBSCRIPTION_CANCEL", 'vodafone_market_place_id' => $vodafone_market_place_id, 'account_identifier' =>  $account_identifier])->order_by('created_at', 'desc')->get()->first_row('array') ;

		return $checkIsOrderCancelled ;
	}


	public function getCurrentOrderModifications($vodafone_market_place_id, $account_identifier) {

		$this->mysql = $this->load->database('mysql', true);

		$getCurrentOrderModifications = $this->mysql->select('*')->from('vodafone_market_place_modifications')->where([ 'subscription_type' => "SUBSCRIPTION_CHANGE", 'vodafone_market_place_id' => $vodafone_market_place_id, 'account_identifier' =>  $account_identifier])->order_by('created_at', 'desc')->get()->first_row('array') ;

		return $getCurrentOrderModifications ;
	}


	public function getAllSignalsAndTimerUsers() {

		$this->mysql = $this->load->database('mysql', true);

		$googleFCMUsers =  $this->mysql->select('number,device_token,loginname')->from('operators')->where([ 'device_token !=' => ''  ])->get()->result_array();

		$googleFCMTOkens = [] ;
		//$userData		 = [] ;

		if ( $googleFCMUsers ) {

			foreach ( $googleFCMUsers as $arrayData) {

				$checkTemplateAlreadyAssigned = $this->mysql->select('phone,gps_pos_criteria')->from('user_template_settings')->where([ 'phone' => $arrayData['number']  ])->get()->first_row('array');


				if ( $checkTemplateAlreadyAssigned ) {

					if ( isset($checkTemplateAlreadyAssigned['gps_pos_criteria'])  && $checkTemplateAlreadyAssigned['gps_pos_criteria'] == '3') {
						$googleFCMTOkens[] = $arrayData['device_token'] ;
						//$userData[]		   = $arrayData ;
					}

				} else {
					$googleFCMTOkens[] = $arrayData['device_token'] ;
					//$userData[]		   = $arrayData ;
				}
			}
		}


		//$data['googleFCMTOkens'] =  $googleFCMTOkens;
		//$data['userData']		 =  $userData;

		return $googleFCMTOkens ;
	}

	public function logCurlDetails($curl_type, $message) {

		$this->mysql = $this->load->database('mysql', true);
		$data = [] ;
		$query_mysql =  $this->mysql->select('*')->from('last_curl_check')->where([ 'curl_type' => trim($curl_type) ])->get()->first_row('array');

		if ($query_mysql) { // update if  already exists

			$data['message'] 	  	  =  $message;
			$data['created_at'] 	  =  date('Y-m-d H:i:s');
			$this->mysql->where( 'curl_type', trim($curl_type) )->update( 'last_curl_check', $data );

		} else { // insert if not exists

			$data['curl_type'] 			=  trim($curl_type) ;
			$data['message'] 		 	=  $message ;

			$this->mysql->insert('last_curl_check',$data) ;

		}


	}


	public function insertCurlRecord() {

		$this->mysql 				= $this->load->database('mysql', true);
		$data['curl_type'] 			=  'getAllSignalsAndTimerUsers' ;
		$data['message'] 		 	=  '' ;

		$this->mysql->insert('last_curl_check',$data) ;

		$insert_id = $this->mysql->insert_id();

		return  $insert_id;
	}



	public function updateCurlRecord($insertRecord, $message, $concatData) {

		$this->mysql			    = $this->load->database('mysql', true);
		$data['message'] 		 	=  $message ;
		$data['resultFCM'] 		 	=  $concatData ;

		$this->mysql->where( 'id', $insertRecord )->update( 'last_curl_check', $data );

	}


	public function updateFCMCronResponse($id, $number, $user_name) {

		$this->mysql 				= $this->load->database('mysql', true);
		$data['main_cron_id'] 	    =  $id ;
		$data['number'] 		 	=  $number ;
		$data['user_name'] 		 	=  $user_name ;

		return $this->mysql->insert('fcm_response_cron',$data) ;

	}



	public function getPreviousOrderModifications($account_identifier) { // To save the edition code and creator details for cancel and notice events.

		$this->mysql = $this->load->database('mysql', true);

		$getPreviousOrderModifications = $this->mysql->select('*')->from('vodafone_market_place_modifications')->where([ 'subscription_type' => "SUBSCRIPTION_CHANGE", 'account_identifier' =>  $account_identifier])->order_by('created_at', 'desc')->get()->first_row('array') ;

		return $getPreviousOrderModifications ;
	}



	public function getFullDetailWithBillingAddress($orderId, $orderTable) {

		$this->mysql = $this->load->database('mysql', true);

		$getFullDetailWithBillingAddress = $this->mysql->select('*')->from($orderTable)->where([ 'id' => $orderId])->get()->first_row('array') ;

		return $getFullDetailWithBillingAddress ;
	}


	public function getProductEditions() {

		$this->mysql = $this->load->database('mysql', true);

		$getProductEditions = $this->mysql->select('*')->from('vodafone_product_editions')->get()->result_array() ;

		return $getProductEditions ;
	}

	public function getTemplates() {

		$this->mysql = $this->load->database('mysql', true);

		//$SQL = 'SELECT t1.*, t2.loginname,t3.device_settings_name FROM user_template_settings as t1 LEFT JOIN operators as t2 on t1.phone = t2.number Left JOIN ota_device_settings as t3 on t1.template_id = t3.id' ;

		$SQL = 'SELECT t1.*, t3.device_settings_name FROM user_template_settings as t1  Left JOIN ota_device_settings as t3 on t1.template_id = t3.id' ;
		 $query = $this->mysql->query($SQL);
		 return $query->result_array();
	}

	public function deleteSingleUserTemplate($templateId) {

		$this->mysql = $this->load->database('mysql', true);

		$deleteSingleReport  = $this->mysql->where('id', $templateId)->delete('user_template_settings');
		return $deleteSingleReport ;
	}



	/***Geofencing functions here***/

	public function addBackgroundProcessData($data) {

		$this->mysql = $this->load->database('mysql', true);
		$this->mysql->insert('test_curl_process',$data) ;
	}

	function insert_users_geofence_background_process($data)
	{
		$this->mysql = $this->load->database('mysql', true);
		$this->mysql->truncate('insert_users_geofence_background_process');
		return $this->mysql->insert_batch('insert_users_geofence_background_process',$data);
	}

	function get_users_geofence_background_process()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('insert_users_geofence_background_process')->get()->result_array() ;
	}

	public function insertStatusTableData($data) {

		$this->mysql = $this->load->database('mysql', true);
		$this->mysql->truncate('add_geofening_users_status');
		return $this->mysql->insert('add_geofening_users_status',$data) ;
	}

	public function updateStatusTableData($processID) {

		$this->mysql = $this->load->database('mysql', true);

		$this->mysql->where('process_id', $processID);
		$this->mysql->set('current_count', 'current_count+1', FALSE);
		$this->mysql->update('add_geofening_users_status');
	}


	public function updateStatusTableDataOnError($processID) {

		$this->mysql = $this->load->database('mysql', true);

		$prepareData['error_status'] = "1" ;
		$this->mysql->where([ 'process_id' => $processID])->update( 'add_geofening_users_status', $prepareData );
	}


	function getStautsOnEscalationPageOnly()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('add_geofening_users_status')->get()->first_row('array');
	}


	function getStautsOnAllPages()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('add_geofening_users_status')->where([ 'user_id' => $this->session->userdata('user_id')])->get()->first_row('array');
	}


	function users_added_for_geofencing($data)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->insert('users_added_for_geofencing',$data);
	}


	function check_users_already_added_for_geofencing($serialNumber)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('users_added_for_geofencing')->where([ 'serial_number' => $serialNumber])->get()->first_row('array');
	}


	function get_users_added_for_geofencing()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('users_added_for_geofencing')->get()->result_array() ;
	}


	function insert_users_geofence_background_process_for_delete($data)
	{
		$this->mysql = $this->load->database('mysql', true);
		$this->mysql->truncate('insert_users_geofence_background_process_for_delete');
		return $this->mysql->insert_batch('insert_users_geofence_background_process_for_delete',$data);
	}

	function get_users_geofence_background_process_for_delete()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('insert_users_geofence_background_process_for_delete')->get()->result_array() ;
	}

	public function insertStatusTableDataForDelete($data) {

		$this->mysql = $this->load->database('mysql', true);
		$this->mysql->truncate('delete_geofening_users_status');
		return $this->mysql->insert('delete_geofening_users_status',$data) ;
	}


	function getStautsOnEscalationPageOnlyForDelete()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('delete_geofening_users_status')->get()->first_row('array');
	}

	function deleteGeofenceAddedUSers($serialNumber, $deviceId) {

		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->delete('users_added_for_geofencing', ['serial_number' => $serialNumber, 'gpswox_id' => $deviceId]);

	}

	public function updateStatusTableDataForDelete($processID) {

		$this->mysql = $this->load->database('mysql', true);

		$this->mysql->where('process_id', $processID);
		$this->mysql->set('current_count', 'current_count+1', FALSE);
		$this->mysql->update('delete_geofening_users_status');
	}

	public function updateStatusTableDataOnErrorForDelete($processID) {

		$this->mysql = $this->load->database('mysql', true);

		$prepareData['error_status'] = "1" ;
		$this->mysql->where([ 'process_id' => $processID])->update( 'delete_geofening_users_status', $prepareData );
	}


	function getStautsOnAllPagesForDelete()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('delete_geofening_users_status')->where([ 'user_id' => $this->session->userdata('user_id')])->get()->first_row('array');
	}


	function insertBackgroundProcessMessagesShownOrNot($userId, $processType, $messageShown) {

		$this->mysql = $this->load->database('mysql', true);

		$checkUser =  $this->mysql->select('id')->from('show_geofnece_background_messages')->where([ 'user_id' => $userId, 'process_type' => $processType])->get()->first_row('array');

		$data['process_type']   = $processType ;
		$data['user_id'] 		= $userId ;
		$data['message_shown']  = $messageShown ;

		if($checkUser) {
			return $this->mysql->where( 'id', $checkUser['id'] )->update( 'show_geofnece_background_messages', $data );
		} else {
			return $this->mysql->insert('show_geofnece_background_messages',$data);
		}


	}


	function backgroundProcessMessagesShownOrNot($userId, $processType) {
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('show_geofnece_background_messages')->where([ 'user_id' => $userId, 'process_type' => $processType, 'message_shown' => "0"])->get()->first_row('array');
	}


	public function updateToMaintainRecordIntegritySentry($serialNUmber, $deviceId, $newName) {

		$prepareData['name'] = $newName ;

		return $this->mysql->where([ 'serial_number' => $serialNUmber, 'gpswox_id' =>  $deviceId])->update( 'users_added_for_geofencing', $prepareData );
	}


	/***Geofencing functions here***/


	public function cronForHomesafeUserDetails() {

		$this->mysql = $this->load->database('mysql', true);

		$query = $this->mysql->select('t1.*, t2.device_token')
					->from('homesafe_geofencing_user_details as t1')
					->join('operators as t2', 't2.lindex = t1.serial_number')
					->where(['t2.device_type' => 'android', 't2.device_token !=' => ''])
					->get()
					->result_array();

		return $query ;

	}

	
	function getAppUsers($linkAccountNumber, $linkAccountType)
	{
		
		if($linkAccountType == 'of') {
			$columnName = "office_link_acc_no" ;
		} elseif($linkAccountType == 'ca'){
			$columnName = "contract_area_link_acc_no" ;
		} else {
			$columnName = "cost_centre_link_acc_no" ;
		}
		
		
		
		$this->mysql = $this->load->database('mysql', true);

		return $this->mysql->select('loginname, lindex, number, device_type, lastin, lastout, carrier, model, version, app_version')->from('operators')->where([$columnName => $linkAccountNumber])->order_by('ref', 'desc')->get()->result_array();
		
	}
	
	
}
