<?php

Class Event extends CI_Model
{
  function __construct()
	{
		parent::__construct();
	}

  function get_total_log()
  {
    $this->mysql = $this->load->database('mysql', true);
    return $this->mysql->select('*')->from('logs')->where('user_type', '1')->get()->result_array();
  }

  function list_log($limit, $offset =null)
  {
    $this->mysql = $this->load->database('mysql', true);
    return $this->mysql->select('*')->from('logs')->where('user_type', '1')->limit( $limit , $offset )->order_by('
    		create_at', 'desc')->get()->result_array();
  }
  
  public function get_All_Logs($requestData) {
		$this->mysql = $this->load->database('mysql', true);
		//~ ini_set('display_errors', 1);
		//~ ini_set('display_startup_errors', 1);
		//~ error_reporting(E_ALL);
		//debug($requestData, 1) ;
		$totalData = $this->mysql->from('logs')->count_all_results();
		$totalFiltered = $totalData; // when there is no search parameter then total number rows = total number filtered rows.
		
		if ( isset( $requestData['order'][0]['column'] ) && isset( $requestData['order'][0]['dir'] ) ) {
			$columnName = $requestData['columns'][$requestData['order'][0]['column']]['name'] ;
			$orderBy	= $requestData['order'][0]['dir'] ;
		} else {
			$columnName = "create_at" ;
			$orderBy	= "DESC" ;
		}
		
		if( !empty($requestData['search']['value']) ) {
			// if there is a search parameter
			$sql = "SELECT * ";
			$sql.=" FROM logs";
			$sql.=" WHERE (ip_address LIKE '%".$requestData['search']['value']."%' ";    // $requestData['search']['value'] contains search parameter
			$sql.=" OR log_name LIKE '%".$requestData['search']['value']."%' OR logMessage LIKE '%".$requestData['search']['value']."%' OR create_at LIKE '%".$requestData['search']['value']."%') ";

			$sql.=" ORDER BY " .$columnName." ". $orderBy." LIMIT ".$requestData['start']." ,".$requestData['length']."   ";
			$query = $this->mysql->query($sql)->result_array();
			
			
			$totalFilteredSearch = "" ;
			$totalFilteredSearch = "SELECT * ";
			$totalFilteredSearch.=" FROM logs";
			$totalFilteredSearch.=" WHERE (ip_address LIKE '%".$requestData['search']['value']."%' ";
			$totalFilteredSearch.=" OR log_name LIKE '%".$requestData['search']['value']."%' OR logMessage LIKE '%".$requestData['search']['value']."%' OR create_at LIKE '%".$requestData['search']['value']."%') ";
			$querySearch = $this->mysql->query($totalFilteredSearch)->result_array();
			$totalFiltered = count($querySearch);
			
			
			

		} else {
			$query = $this->mysql->select('*')
				->from('logs')
				->order_by($columnName, $orderBy)
				->limit($requestData['length'], $requestData['start'])
				->get()
				->result_array();
				//echo $this->mysql->last_query();
			    //debug($data, 1) ;
		}

	  $data = [] ;
	  $counter = 0 ;
	  //debug($query, 1) ;

	  foreach ($query as $row) {
		$data[$counter][] 	= $row['ip_address'] ;
		$data[$counter][] 	= $row['log_name'] ;
		$data[$counter][] 	= $row['logMessage'] ;
		$data[$counter][] 	= $row['create_at'] ;
		
		$counter++ ;
	  }

	  return $json_data = array(
			"draw"            => intval( $requestData['draw'] ),   // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw.
			"recordsTotal"    => intval( $totalData ),  // total number of records
			"recordsFiltered" => intval( $totalFiltered ), // total number of records after searching, if there is no searching then totalFiltered = totalData
			"data"            => $data   // total data array
			);

	}
  
	
	public function getExportDataWithSearch($orderbyCoumnName, $orderbyCoumnDirection, $searchNameValue) {
		
		$this->mysql = $this->load->database('mysql', true);
		
		$sql = "SELECT * ";
		$sql.=" FROM logs";
		$sql.=" WHERE (ip_address LIKE '%".$searchNameValue."%' ";    // $requestData['search']['value'] contains search parameter
		$sql.=" OR log_name LIKE '%".$searchNameValue."%' OR logMessage LIKE '%".$searchNameValue."%' OR create_at LIKE '%".$searchNameValue."%') ";

		$sql.=" ORDER BY " .$orderbyCoumnName." ". $orderbyCoumnDirection;
		$query = $this->mysql->query($sql)->result_array();
		return $query ;
	}
	
	
	public function getExportDataWithOutSearch($orderbyCoumnName, $orderbyCoumnDirection) {
		
		$this->mysql = $this->load->database('mysql', true);
		
		$query = $this->mysql->select('*')
				->from('logs')
				->order_by($orderbyCoumnName, $orderbyCoumnDirection)
				->get()
				->result_array();
				
		return $query ;
	}
}

 ?>
