<?php
/*
	Controller for Office
*/

Class Office extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('cost_center');
		$this->load->model('contractareas');
		$this->load->model('offices');

		$this->load->library('session');
		$this->load->library('pagination');
		if( $this->session->userdata('type') == "" )
		{
			$this->session->set_flashdata('error_msg','Not Login Yet');
			redirect('/');
		}

	}

	function htmlAccount()
	{
		$this->session->unset_userdata('login_id');
		$this->session->unset_userdata('office_id');
		$this->session->unset_userdata('contractarea_id');
		$this->session->unset_userdata('type');
		session_destroy();
		$this->deleteDirectory($this->session->userdata('audioPath'));
		$this->load->view('report/suspendAccount');
	}

	function index()
	{

		//debug($_SESSION,1);
			$this->load->model('users');
			$checkLoggedInToken = $this->users->checkLoggedInToken( $this->session->userdata('user_id'), $this->session->userdata('loginToken') );
		if( !$checkLoggedInToken ){
			$redirect = base_url().'/user/logout/?session=1';
			redirect($redirect);
		}

		//$this->load->view('report/suspendAccount');
		if( $this->session->userdata("user_read") != "1" ){
				$blocked = '1';
				$this->session->unset_userdata('login_id');
				$this->session->unset_userdata('office_id');
				$this->session->unset_userdata('contractarea_id');
				$this->session->unset_userdata('type');
				session_destroy();
				$this->load->library('logger');
				$actual_link = "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
				$this->users->blockUser($blocked,$this->session->userdata('user_id'));
				$this->logger->trigger_log($this->session->userdata('username'),'tried to access restricted page '.$actual_link.'. User account suspeneded ');
				$this->deleteDirectory($this->session->userdata('audioPath'));
				echo '<!DOCTYPE html><html><head><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"><link href="https://fonts.googleapis.com/css?family=Montserrat:400,600" rel="stylesheet"></head><body style="margin:0; padding:0; font-family: Montserrat, sans-serif;"><div style="width:700px; margin:90px auto;"> <div style=" width:680px; border: 10px solid #000; background:#0d1f4f; color:#fff; padding:80px 20px; float:left;"> <span style="font-size:45px; font-weight: 600; float:left; width:100%;"><i class="fa fa-exclamation-triangle" aria-hidden="true"></i> Your account has been temporarily suspended.</span> <span style="font-size: 16px; line-height:26px; float:left; width:100%; padding:30px 0px;">For security reasons, your account has been temporarily suspended. You can contact the Administrator at </span> <span><i class="fa fa-envelope-o" aria-hidden="true"></i> &nbsp;lwpsupport@orbisprotect.com</span> </div></div></body></html>';
				exit;

		}
		//debug($_SESSION);

		$this->load->view('office/user_list');
	   //}
	}

	function add_user()
	{
		$this->load->model('users');
		//debug( $_SESSION,1 );

		$checkLoggedInToken = $this->users->checkLoggedInToken( $this->session->userdata('user_id'), $this->session->userdata('loginToken') );
		if( !$checkLoggedInToken ){
			$redirect = base_url().'/user/logout/?session=1';
			redirect($redirect);
		}



		//echo '===='.$this->uri->segment('3'); exit;
		if( $this->session->userdata('user_read') == 0 || $this->session->userdata('user_write') == 0 ){

				$blocked = '1';
				$this->session->unset_userdata('login_id');
				$this->session->unset_userdata('office_id');
				$this->session->unset_userdata('contractarea_id');
				$this->session->unset_userdata('type');
				session_destroy();
				$this->load->library('logger');
				$actual_link = "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
				$this->users->blockUser($blocked,$this->session->userdata('user_id'));
				$this->logger->trigger_log($this->session->userdata('username'),'tried to access restricted page '.$actual_link.'. User account suspeneded ');
				$this->deleteDirectory($this->session->userdata('audioPath'));
				echo '<!DOCTYPE html><html><head><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"><link href="https://fonts.googleapis.com/css?family=Montserrat:400,600" rel="stylesheet"></head><body style="margin:0; padding:0; font-family: Montserrat, sans-serif;"><div style="width:700px; margin:90px auto;"> <div style=" width:680px; border: 10px solid #000; background:#0d1f4f; color:#fff; padding:80px 20px; float:left;"> <span style="font-size:45px; font-weight: 600; float:left; width:100%;"><i class="fa fa-exclamation-triangle" aria-hidden="true"></i> Your account has been temporarily suspended.</span> <span style="font-size: 16px; line-height:26px; float:left; width:100%; padding:30px 0px;">For security reasons, your account has been temporarily suspended. You can contact the Administrator at </span> <span><i class="fa fa-envelope-o" aria-hidden="true"></i> &nbsp;lwpsupport@orbisprotect.com</span> </div></div></body></html>';
				exit;
		}

		// config for PDO
    $conexion = new PDO("informix:host=".$this->config->item('pdo_connect')['host'].";service=".$this->config->item('pdo_connect')['service'].";database=".$this->config->item('pdo_connect')['database'].";server=".$this->config->item('pdo_connect')['server'].";protocol=".$this->config->item('pdo_connect')['protocol'].";EnableScrollableCursors=".$this->config->item('pdo_connect')['EnableScrollableCursors'].";client_locale=".$this->config->item('pdo_connect')['client_locale'].";db_locale=".$this->config->item('pdo_connect')['db_locale'] ,$this->config->item('pdo_connect')['db_user'],$this->config->item('pdo_connect')['db_pass']);

    // get CostCentre

    $CostCentre = "select linkacc.linkno , linkacc.name from linkacc, webusers where linkacc.parent = 20 and webusers.agctype = 4 and linkacc.linkno = webusers.agcno";
		$CostCentreQuery   = $conexion->prepare($CostCentre);
		$CostCentreQuery->execute();
		$CostCentreResponse = $CostCentreQuery->fetchAll(PDO::FETCH_ASSOC);
    if(!empty($CostCentreResponse)){
      for( $j=0; $j<count($CostCentreResponse); $j++ )
      {
        //$CostCentreResponse[$j]['NAME'] = trim(str_replace('CC', '', $CostCentreResponse[$j]['NAME']));
        $CostCentreResponse[$j]['NAME'] = trim(substr($CostCentreResponse[$j]['NAME'], 3));
      }

      foreach ($CostCentreResponse as $key => $row) {
          // replace 0 with the field's index/key
          $dates[$key]["NAME"]  = $row["NAME"];
          //$dates1[$key]["NAME"]  = $row["NAME"];
      }

       array_multisort($dates, SORT_ASC, $CostCentreResponse);
    }
    else{
      $CostCentreResponse = array();
    }
		$data['CostCentreList'] = $CostCentreResponse;

		$loggedInUserData = $this->users->get_user_data($this->session->userdata('user_id'));
		$data['loggedInUserData'] = $loggedInUserData ;

		if(  $this->uri->segment('3') != '' ){
			if( $_SESSION['user_id'] != $this->uri->segment('3') )
			{
				redirect('/office');
			}
		}
		else {
			$this->load->view('office/office_list',$data);
		}

	}

	function edit_user($id)
	{
		$this->load->model('users');
		if( $this->session->userdata('user_read') == 0 || $this->session->userdata('user_write') == 0){

				$blocked = '1';
				$this->session->unset_userdata('login_id');
				$this->session->unset_userdata('office_id');
				$this->session->unset_userdata('contractarea_id');
				$this->session->unset_userdata('type');
				session_destroy();
				$this->load->library('logger');
				$actual_link = "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
				$this->users->blockUser($blocked,$this->session->userdata('user_id'));
				$this->logger->trigger_log($this->session->userdata('username'),'tried to access restricted page '.$actual_link.'. User account suspeneded ');
				$this->deleteDirectory($this->session->userdata('audioPath'));
				echo '<!DOCTYPE html><html><head><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"><link href="https://fonts.googleapis.com/css?family=Montserrat:400,600" rel="stylesheet"></head><body style="margin:0; padding:0; font-family: Montserrat, sans-serif;"><div style="width:700px; margin:90px auto;"> <div style=" width:680px; border: 10px solid #000; background:#0d1f4f; color:#fff; padding:80px 20px; float:left;"> <span style="font-size:45px; font-weight: 600; float:left; width:100%;"><i class="fa fa-exclamation-triangle" aria-hidden="true"></i> Your account has been temporarily suspended.</span> <span style="font-size: 16px; line-height:26px; float:left; width:100%; padding:30px 0px;">For security reasons, your account has been temporarily suspended. You can contact the Administrator at </span> <span><i class="fa fa-envelope-o" aria-hidden="true"></i> &nbsp;lwpsupport@orbisprotect.com</span> </div></div></body></html>';
				exit;
		}

		if( $id != null )
		{
			$id = base64_decode($id);
			$data['user_data'] = $this->users->get_user_data($id);
			$loggedInUserData = $this->users->get_user_data($this->session->userdata('user_id'));
			$data['loggedInUserData'] = $loggedInUserData ;
			$this->load->view('office/office_list', $data);
		}
	}

	function deleteDirectory($dir) {
	    if (!file_exists($dir)) {
	        return true;
	    }

	    if (!is_dir($dir)) {
	        return unlink($dir);
	    }

	    foreach (scandir($dir) as $item) {
	        if ($item == '.' || $item == '..') {
	            continue;
	        }

	        if (!$this->deleteDirectory($dir . DIRECTORY_SEPARATOR . $item)) {
	            return false;
	        }

	    }

		return rmdir($dir);
	}

	function myaccount($id)
	{

		if( base64_decode($id) != $this->session->userdata('user_id') )
		{
			$redirectTo = base_url().'user/dashboard/'.$this->session->userdata('linkAccountFirstGroupID');
			redirect($redirectTo);
		}

		$this->load->model('users');
		if( $id != null )
		{
			$id = base64_decode($id);
			$data['user_data'] = $this->users->get_user_data($id);
			$this->load->view('office/myaccount', $data);
		}
	}

	function get_office_by_contract($id)
	{
		$this->offices->contractarea_id = $id;
		$filter_office_list = $this->offices->filter_office_list();
		if( !empty($filter_office_list) )
		{
			echo json_encode($filter_office_list);
		}
		else
		{
			$data['LINDEX'] = '0';
			$data['DESCRIPTION'] = ' No row found';
			echo json_encode($data);
		}
	}

	function get_contract_area($costcenterid) {
		$contractarea = $this->offices->contract_area_list($costcenterid);
		if($contractarea){
		        echo json_encode($contractarea);
		}else
		{
			$data['msg'] = 'fail';
			echo json_encode($data);
		}
	}


	function add_Office()
	{
		//debug( $this->input->post() );

		if( !empty(trim($this->input->post('office_id'))) )
		{
			$this->offices->office_id = trim($this->input->post('office_id', true));
			$this->offices->office_name = trim($this->input->post('office_name', true));
			echo $add_offices = $this->offices->office_edit();
		}
		else
		{
			$this->offices->costcenter_id = trim($this->input->post('costcenter', true));
			$this->offices->contractarea_id = trim($this->input->post('contractarea', true));
			$this->offices->office_name = trim($this->input->post('office_name', true));
			echo $add_offices = $this->offices->add_offices();
		}



	}

	function edit_offce()
	{
		$this->offices->office_id = $this->input->post('officeID', true);
		$this->offices->office_name = $this->input->post('office_name', true);
		$this->offices->admin_name = $this->input->post('admin_name', true);
		$this->offices->email_address = $this->input->post('email_address', true);
		$this->offices->contact_number = $this->input->post('contact_number', true);
		$this->offices->password = $this->input->post('password', true);
		$this->offices->password = $this->input->post('cpassword', true);
		$add_offices = $this->offices->office_edit();
		if($add_offices)
		{
			echo 'update';
		}
	}

	function change_status()
	{
		$this->offices->office_id = $this->input->post('id',true);
		$this->offices->status = $this->input->post('status', true);
		echo $office_status = $this->offices->office_status();
	}

	function get_office_edit($id)
	{
		$get_edit_office = $this->offices->get_edit_office($id);
		$get_contract_area_office = $this->offices->get_contract_area_office($get_edit_office['parent']);
		$get_edit_office['contractarea_name'] = $get_contract_area_office['description'] ;

		$get_costcentre_office = $this->offices->get_costcentre_office($get_contract_area_office['parent']);
		$get_edit_office['costcentre_name'] = $get_costcentre_office['description'];
		echo json_encode($get_edit_office);
	}

	// new design

	function get_office_list($officesListId)
	{

		$conexion = new PDO("informix:host=".$this->config->item('pdo_connect')['host'].";service=".$this->config->item('pdo_connect')['service'].";database=".$this->config->item('pdo_connect')['database'].";server=".$this->config->item('pdo_connect')['server'].";protocol=".$this->config->item('pdo_connect')['protocol'].";EnableScrollableCursors=".$this->config->item('pdo_connect')['EnableScrollableCursors'].";client_locale=".$this->config->item('pdo_connect')['client_locale'].";db_locale=".$this->config->item('pdo_connect')['db_locale'] ,$this->config->item('pdo_connect')['db_user'],$this->config->item('pdo_connect')['db_pass']);

		$sql = "select linkno , name from linkacc where parent =".$officesListId;
		$prep   = $conexion->prepare($sql);
		$prep->execute();
		$resultTotal = $prep->fetchAll(PDO::FETCH_ASSOC);
		//debug($resultTotal);
		if( !empty($resultTotal) ){

			$dates = array();
			for( $j=0; $j<count($resultTotal); $j++ )
				{
					//$resultTotal[$j]['NAME'] = trim(str_replace('OF', '', $resultTotal[$j]['NAME']));
					$resultTotal[$j]['NAME'] = trim(substr($resultTotal[$j]['NAME'], 3));
				}

				foreach ($resultTotal as $key => $row) {
				    // replace 0 with the field's index/key
				    $dates[$key]["NAME"]  = $row["NAME"];
				    //$dates1[$key]["NAME"]  = $row["NAME"];
				}

				 array_multisort($dates, SORT_ASC, $resultTotal);

			echo json_encode([ 'error' => 0, 'officesList' => $resultTotal ]);
		}else{
			echo json_encode(['error' => 1, 'message' => 'No result found']);
		}
	}

	function edit_myaccount(){
		$this->load->model('users');

		//check token
		if( !checkToken('myaccountGeneralToken',$this->input->post('myaccountGeneralToken') ) ){
			echo 'fail';
			exit;
		}

			$data['username'] = $this->input->post('username');
			$data['first_name'] = $this->input->post('first_name');
			$data['sur_name'] = $this->input->post('sur_name');
			$data['telephone'] = $this->input->post('telephone');

			$updateMyAccount = $this->users->updateMyAccount($data,$this->input->post('edit_user_id'));

			if($updateMyAccount > 0)
			{

				echo 'done';
			}
			else {
				echo 'fail';
			}

	}


	// Get Office List
  function getOfficeList($id)
  {

	 /*
	 $conexion = new PDO("informix:host=".$this->config->item('pdo_connect')['host'].";service=".$this->config->item('pdo_connect')['service'].";database=".$this->config->item('pdo_connect')['database'].";server=".$this->config->item('pdo_connect')['server'].";protocol=".$this->config->item('pdo_connect')['protocol'].";EnableScrollableCursors=".$this->config->item('pdo_connect')['EnableScrollableCursors'].";client_locale=".$this->config->item('pdo_connect')['client_locale'].";db_locale=".$this->config->item('pdo_connect')['db_locale'] ,$this->config->item('pdo_connect')['db_user'],$this->config->item('pdo_connect')['db_pass']);

      if( !empty($id) ){
        $OfficeList = "select linkno , name from linkacc where parent =".$id;
        $OfficeListRequest   = $conexion->prepare($OfficeList);
        $OfficeListRequest->execute();
        $OfficeListResponse = $OfficeListRequest->fetchAll(PDO::FETCH_ASSOC);
        if( !empty($OfficeListResponse) ){

    			$dates = array();
    			for( $j=0; $j<count($OfficeListResponse); $j++ )
    				{
    					//$OfficeListResponse[$j]['NAME'] = trim(str_replace('OF', '', $OfficeListResponse[$j]['NAME']));
    					$OfficeListResponse[$j]['NAME'] = trim(substr($OfficeListResponse[$j]['NAME'], 3));
    				}

    				foreach ($OfficeListResponse as $key => $row) {
    				    // replace 0 with the field's index/key
    				    $dates[$key]["NAME"]  = $row["NAME"];
    				    //$dates1[$key]["NAME"]  = $row["NAME"];
    				}

    				 array_multisort($dates, SORT_ASC, $OfficeListResponse);

						  echo json_encode(['status'=>"0",'data'=>$OfficeListResponse,'message'=>'record found']); exit;
    		}
        else{
						echo json_encode(['status'=>'1','data'=>[],'message'=>'no records found']); exit;
        }
      }
      else{
					echo json_encode(['status'=>'1','data'=>[],'message'=>'contract area id is not valid']); exit;
      } */

       if( !empty($id) ){
		   $xml_url = 'http://www.monitorsoft.com/SentinelXS/clsSentinelXS/ListLinkAccounts';
		   $xml_request = '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:cls="http://www.monitorsoft.com/SentinelXS/clsSentinelXS" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">

			<soap:Header/>

			<soap:Body>

			<cls:ListLinkAccounts>

			<cls:listLinkAccountsRequestKey>

			<cls:ServiceVersion>Version_1_123_1</cls:ServiceVersion>

			<cls:UserName>sentrymaster</cls:UserName>

			<cls:Password>Pass2121!</cls:Password>

			<cls:AgencyOverride xsi:type="cls:LinkAccountAgencyOverride">

			<cls:LinkAccountIdentifier>'.$id.'</cls:LinkAccountIdentifier>

			</cls:AgencyOverride>

			</cls:listLinkAccountsRequestKey>

			</cls:ListLinkAccounts>

			</soap:Body>

			</soap:Envelope>';


		   $curl_send = $this->curl->curl_send($xml_request, $xml_url);

		   $xmlToArray = $this->curl->xmlToArray($curl_send);


		   $OfficeListResponse = ( isset( $xmlToArray['ListLinkAccountsResponse']['ListLinkAccountsResult']['ListOfLinkAccounts']['LinkAccountListItem'] ) && $xmlToArray['ListLinkAccountsResponse']['ListLinkAccountsResult']['ListOfLinkAccounts']['LinkAccountListItem'] ? $xmlToArray['ListLinkAccountsResponse']['ListLinkAccountsResult']['ListOfLinkAccounts']['LinkAccountListItem'] : '') ;


		   if( !empty($OfficeListResponse) ){

			  $OfficeListResponseNew = [] ;
			  $count = 0 ;
			  for( $j=0; $j<count($OfficeListResponse); $j++ ) {

				  if ( $OfficeListResponse[$j]['Identifier'] != $id ) {

						$OfficeListResponseNew[$count]['LINKNO'] = $OfficeListResponse[$j]['Identifier'];
						$OfficeListResponseNew[$count]['NAME']   = trim(substr($OfficeListResponse[$j]['Name'], 3));
						$count++ ;

				  }

			  }

			  //debug($OfficeListResponseNew, 1) ;
			  if ( $OfficeListResponseNew ) {
				echo json_encode(['status'=>"0",'data'=>$OfficeListResponseNew,'message'=>'record found']); exit;
			  } else {
				echo json_encode(['status'=>'1','data'=>[],'message'=>'no records found']); exit;
			  }
		   }
		   else{
					echo json_encode(['status'=>'1','data'=>[],'message'=>'no records found']); exit;
		   }
      }
      else{
					echo json_encode(['status'=>'1','data'=>[],'message'=>'contract area id is not valid']); exit;
      }
  }

	function getUsersbyID(){
		$this->load->model('users');
		$row = array();
		$data = $this->users->get_system_users_list($this->input->get('id'),$this->input->get('type'),$this->session->userdata('user_id'));
		//debug($data,1);
		if( !empty($data) )
		{
			for( $j=0; $j<count($data); $j++ )
			{
				if( $this->session->userdata('user_write') == 1  )
					{
						//debug($data);
						$data[$j]['permission_write'] = '1';
						$data[$j]['redirect_url'] =  base_url().'office/edit_user/'.base64_encode($data[$j]['user_id']);
					}
					else {
						$data[$j]['permission_write'] = '1';
						$data[$j]['redirect_url'] = '';
					}
			}

			echo json_encode([ 'error' => 0, 'data' => $data]);
		}
		else {
			echo json_encode([ 'error' => 0, 'data' => [], 'msg' => 'no records']);
		}
	}
	function userlocation(){
		$this->load->view('office/userlocation');
	}
	function manageusers(){
		$this->load->view('office/manageusers');
	}

	function homesafe(){
		$this->load->view('office/homesafe');
	}
	
	function homesafe1(){
		$this->load->view('office/homesafe1');
	}
	
	function homesafe_admin(){
		if( $this->session->userdata('type') != 'superadmin' )
		{
			 redirect('/', 'refresh');
			 exit ;
		}
		
		$CostCentreResponse = $this->curl->curlHelperGetCostCentreAPI() ;
		$data['CostCentreList'] = $CostCentreResponse;
		
		$this->load->view('office/homesafe_admin', $data);
	}
	

	function modalerror(){
		$this->load->view('office/modalerror');
	}
	
	
	public function getHomesafeReporting($userLevel,$groupID,$startDate,$endDate) {
		
		$startDate = date( 'Y-m-d' , strtotime($startDate));
		$endDate = date( 'Y-m-d' , strtotime($endDate));
		$endTime = "23:59:59";
	
	
		$conexion = new PDO("informix:host=".$this->config->item('pdo_connect')['host'].";service=".$this->config->item('pdo_connect')['service'].";database=".$this->config->item('pdo_connect')['database'].";server=".$this->config->item('pdo_connect')['server'].";protocol=".$this->config->item('pdo_connect')['protocol'].";EnableScrollableCursors=".$this->config->item('pdo_connect')['EnableScrollableCursors'].";client_locale=".$this->config->item('pdo_connect')['client_locale'].";db_locale=".$this->config->item('pdo_connect')['db_locale'] ,$this->config->item('pdo_connect')['db_user'],$this->config->item('pdo_connect')['db_pass']);
	
		$sql = 'DROP TABLE IF EXISTS Homesafe_109234_max_lseqno;
		SELECT customer.name, customer.contno, systrans.netaddr, eventdef.descr, sumlog.serialno, MAX(sumlog.lseqno) max_lseqno
FROM customer
INNER JOIN systrans ON systrans.serialno = customer.serialno
INNER JOIN sumlog ON sumlog.serialno = customer.serialno
INNER JOIN eventdef ON eventdef.stcode = sumlog.stcode
WHERE sumlog.stcode in (2017, 2018, 2019, 2021)
AND sumlog.evtime >="'.$startDate.' 00:00:00"
AND sumlog.evtime <= "'.$endDate.' '.$endTime.'"
AND customer.linkno IN (SELECT linkno FROM linkacc START WITH linkacc.linkno IN ('.$groupID.') CONNECT BY PRIOR linkacc.linkno=linkacc.parent)
GROUP BY 1,2,3,4,5
INTO TEMP Homesafe_109234_max_lseqno WITH NO LOG;' ;
		$prep   = $conexion->prepare($sql);
		$prep->execute();
		
		
		
		$sql = "DROP TABLE IF EXISTS Homesafe_109234_serialno_lseqno;" ;
		$prep   = $conexion->prepare($sql);
		$prep->execute();
		
		
		
		
		$sql = "SELECT serialno, MAX(max_lseqno) lseqno
FROM Homesafe_109234_max_lseqno
GROUP BY 1
INTO TEMP Homesafe_109234_serialno_lseqno WITH NO LOG" ;
		$prep   = $conexion->prepare($sql);
		$prep->execute();
		
		
		
		$sql = "SELECT customer.name, customer.contno, systrans.netaddr, eventdef.descr, sumlog.evtime, detlog1.latitude, detlog1.longitude
FROM customer, sumlog, eventdef, systrans, Homesafe_109234_serialno_lseqno AS HS, OUTER detlog1
WHERE sumlog.serialno = customer.serialno
AND systrans.serialno = customer.serialno AND systrans.commsno = sumlog.commsno
AND eventdef.stcode = sumlog.stcode
AND detlog1.serialno = sumlog.serialno AND detlog1.lseqno = sumlog.lseqno
AND HS.lseqno = sumlog.lseqno AND HS.serialno = sumlog.serialno
AND detlog1.serialno = sumlog.serialno AND detlog1.lseqno = sumlog.lseqno
AND customer.linkno IN (SELECT linkno FROM linkacc START WITH linkacc.linkno IN ($groupID) CONNECT BY PRIOR linkacc.linkno = linkacc.parent)
AND detlog1.latitude IS NOT NULL
AND detlog1.longitude IS NOT NULL
UNION
SELECT customer.name, customer.contno, systrans.netaddr, NULL::VARCHAR(50), NULL::DATETIME YEAR TO FRACTION(5), NULL::VARCHAR(50), NULL::VARCHAR(50)
FROM customer, systrans
WHERE customer.serialno = systrans.serialno
AND customer.linkno IN (SELECT linkno FROM linkacc START WITH linkacc.linkno IN ($groupID) CONNECT BY PRIOR linkacc.linkno=linkacc.parent)
AND systrans.transtype = 25029
AND customer.serialno NOT IN(SELECT serialno FROM Homesafe_109234_serialno_lseqno)" ;
		$prep   = $conexion->prepare($sql);
		$prep->execute();
		
		$resultTotal = $prep->fetchAll(PDO::FETCH_ASSOC);
		
		//debug($resultTotal, 1) ;
		
		
		if( !empty($resultTotal) ){
			
			for( $m=0; $m<count($resultTotal); $m++ )
				{
					
					if( empty($resultTotal[$m]['NAME']) )
					{
						$resultTotal[$m]['NAME'] = '-';
					} else {
						$nameEncoded	= utf8_decode($resultTotal[$m]['NAME']) ;
						$nameEncoded    = str_replace('?',' ', $nameEncoded) ;
						$resultTotal[$m]['NAME']  = $nameEncoded;
					}

					if( empty($resultTotal[$m]['CONTNO']) )
					{
						$resultTotal[$m]['CONTNO'] = '-';
					}

					if( empty($resultTotal[$m]['NETADDR']) )
					{
						$resultTotal[$m]['NETADDR'] = '-';
					}

					if( empty($resultTotal[$m]['DESCR']) )
					{
						$resultTotal[$m]['DESCR'] = '-';
					} else {
						
						if ( trim($resultTotal[$m]['DESCR']) == "Homesafe Entered" ) {
							$resultTotal[$m]['DESCR'] = '<span class="badge badge-success">YES</span>';
						} elseif ( trim($resultTotal[$m]['DESCR']) == "Homesafe left" ) {
							$resultTotal[$m]['DESCR'] = '<span class="badge badge-danger">NO</span>';
						} else {
							$resultTotal[$m]['DESCR'] = '-';
						}
					}

					if( empty($resultTotal[$m]['EVTIME']) )
					{
						$resultTotal[$m]['EVTIME'] = '-';
					} else {
					
						$resultTotal[$m]['EVTIME'] = date('d F y H:i:s', strtotime($resultTotal[$m]['EVTIME']));
					}

					if ( !empty($resultTotal[$m]['LATITUDE']) && !empty($resultTotal[$m]['LONGITUDE']) && $this->validateLatLong($resultTotal[$m]['LATITUDE'], $resultTotal[$m]['LONGITUDE']) ) {
						
						$resultTotal[$m]['LOCATION'] = '<a href="https://maps.google.com/?q='.$resultTotal[$m]['LATITUDE'].','.$resultTotal[$m]['LONGITUDE'].'" target="__blank">View on map</a>';
						
					} else {
						$resultTotal[$m]['LOCATION'] = '-';
					}
				}
			echo json_encode([ 'error' => 0, 'events' => $resultTotal ]);
		}else{
			echo json_encode(['error' => 1, 'message' => 'No result found']);
		}
		
		
	}
	
	
	function validateLatLong($lat, $long) {
		return preg_match('/^[-]?(([0-8]?[0-9])\.(\d+))|(90(\.0+)?),[-]?((((1[0-7][0-9])|([0-9]?[0-9]))\.(\d+))|180(\.0+)?)$/', $lat.','.$long);
	}

	
	

}
