<?php

Class Autoreport extends CI_Model
{
	public function __construct()
	{
		parent::__construct();
	
		$this->load->database();
	}
	
	
	public function insertAutoReportingData($data) {
		$query 	   = $this->db->insert('auto_reporting', $data);
		return $query ;
	}
	
	
	public function getReports($userId) {
	
		$getReports = $this->db->select('*')->from('auto_reporting')->where('user_id' , $userId)->order_by('created_at', 'desc')->get()->result_array();
		return $getReports;
	}
	
	public function deleteSingleReport($reportId) {
	
		$deleteSingleReport  = $this->db->where('id', $reportId)->delete('auto_reporting');
		return $deleteSingleReport ;
	}
	
	public function updateAutoReportingData($data, $reportId) {
		$query 	   = $this->db->where('id',$reportId)->update('auto_reporting',$data);
		return $query ;
	}
	
	public function getSingleReportData($reportId) {
	
		$getReport = $this->db->select('*')->from('auto_reporting')->where('id' , $reportId)->get()->first_row('array');
		
		return $getReport;
	}
	
	public function getDataSetCron() {
	
		 $SQL = 'Select * from auto_reporting where selected_frequency = "daily"' ; // Change later to select id only to reduce load
		
		 $currentDay = date('l');
		 
		 if($currentDay == "Friday"){
			 $SQL .= ' or selected_frequency = "weekly"' ;
		 }
		 
		 $currentDay = date('d');
		 
		 if ($currentDay == "15"){
			 $SQL .= ' or selected_frequency = "biWeekly"' ;
		 }	elseif($currentDay == "30") {
			$SQL .= ' or selected_frequency = "biWeekly" or selected_frequency = "monthly"' ;
		 }
		 
		 $SQL .= ' order by created_at DESC' ;
		 
		 $query = $this->db->query($SQL);
		 return $query->result_array();
	
	
	
	
	}
	
	
	public function logCron($reportId, $msg = null) {
	
	
		$data['curl_type']    = 'getDataSetCronForAutoReporting'  ;
		$data['message']      = 'report-id = ' . $reportId  ;
		$data['resultFCM']    = $msg  ;
		$query 	   			  = $this->db->insert('last_curl_check', $data);
	
	}
	
	
	public function validateSameDataAlreadyExists($selectedFrequency, $selectedReportName, $reportLinkAccountType, $linkaccountparent, $userId, $linkaccountnumber, $signalType, $reportId) {
	
		if( $reportLinkAccountType == "OF" ) {
			if ($reportId) {
				$data = $this->db->select('*')
						->from('auto_reporting')
						->where([ 'user_id' => $userId, 'selected_frequency' => $selectedFrequency, 'selected_report_name' =>  $selectedReportName, 'report_link_account_number' => $linkaccountnumber, 'signal_type' => $signalType])
						->where_in('report_link_account_parent', $linkaccountparent)
						->where_not_in('id', $reportId)
						->get()
						->first_row('array') ;	
			} else {
			
					$data = $this->db->select('*')
						->from('auto_reporting')
						->where([ 'user_id' => $userId, 'selected_frequency' => $selectedFrequency, 'selected_report_name' =>  $selectedReportName, 'report_link_account_number' => $linkaccountnumber, 'signal_type' => $signalType])
						->where_in('report_link_account_parent', $linkaccountparent)
						->get()
						->first_row('array') ;	
			
			}	
					
					
		} elseif( $reportLinkAccountType == "CA" ) {
			
			if ($reportId) {
				
				$data = $this->db->select('*')
						->from('auto_reporting')
						->where([ 'user_id' => $userId, 'selected_frequency' => $selectedFrequency, 'selected_report_name' =>  $selectedReportName, 'report_link_account_number' => $linkaccountnumber, 'report_link_account_parent' => $linkaccountparent, 'signal_type' => $signalType])
						->where_not_in('id', $reportId)
						->get()
						->first_row('array') ;
				
			} else {
				$data = $this->db->select('*')
						->from('auto_reporting')
						->where([ 'user_id' => $userId, 'selected_frequency' => $selectedFrequency, 'selected_report_name' =>  $selectedReportName, 'report_link_account_number' => $linkaccountnumber, 'report_link_account_parent' => $linkaccountparent, 'signal_type' => $signalType])
						->get()
						->first_row('array') ;
			}
			
			
		} else {
			
			if ($reportId) {
				
				$data = $this->db->select('*')
						->from('auto_reporting')
						->where([ 'user_id' => $userId, 'selected_frequency' => $selectedFrequency, 'selected_report_name' =>  $selectedReportName, 'report_link_account_number' => $linkaccountnumber, 'signal_type' => $signalType])
						->where_not_in('id', $reportId)
						->get()
						->first_row('array') ;
				
			} else {
				$data = $this->db->select('*')
						->from('auto_reporting')
						->where([ 'user_id' => $userId, 'selected_frequency' => $selectedFrequency, 'selected_report_name' =>  $selectedReportName, 'report_link_account_number' => $linkaccountnumber, 'signal_type' => $signalType])
						->get()
						->first_row('array') ;
			}
				
		}
		
		return $data ;
	}
	
	
	function getAppUsers($reportLinkAccountType, $reportLinkAccountNumber)
	{
		
		if($reportLinkAccountType == 'OF') {
			$columnName = "office_link_acc_no" ;
		} elseif($reportLinkAccountType == 'CA'){
			$columnName = "contract_area_link_acc_no" ;
		} else {
			$columnName = "cost_centre_link_acc_no" ;
		}
		
		return $this->db->select('loginname, lindex, number, carrier, model, version, app_version')->from('operators')->where([$columnName => $reportLinkAccountNumber])->order_by('loginname', 'asc')->get()->result_array();
		
	}
	
	
}
