<?php



Class Geofencing extends CI_Controller
{

	public $gpswoxUsername 	   = "jack.singh@orbisprotect.com" ;
	public $gpswoxPassword     = "Orbis2020" ;
	public $gpswoxUrl    	   = "http://165.232.32.11/" ;

	function __construct()
	{
		parent::__construct();
		$this->load->library('session');
		$this->load->helpers('url');
		$this->load->library('backgroundworker');
		$this->load->library('logger');
		
		//~ if ( $this->session->userdata('type') != "superadmin") {
				//~ redirect('/', 'refresh');
				//~ exit;
		//~ }

	}
	
	
	
	public function enableUsersForGeofencing() {
	
		$dataToInsert	 = json_decode($this->input->post('dataToInsert'), true) ;
		$totalcount		 = count($dataToInsert) ;
		echo $totalcount ;
		debug($dataToInsert, 1) ;
		
	}
	
	
	public function gpswox() {
		
		
		/*For deleting a device*/
		
		$ch = curl_init($this->gpswoxUrl.'api/destroy_device?lang=en&user_api_hash=$2y$10$1S8q31RV.qIxAY8Dd5/3A.htkui8riMRpi1u6bnQQ7yUJd6PzPwzy&device_id=64');
		//$data = http_build_query($dataArray);
		//$getUrl = $url."?".$data;
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	//	curl_setopt($ch, CURLOPT_URL, $getUrl);
		curl_setopt($ch, CURLOPT_TIMEOUT, 80);
		 
		$response = curl_exec($ch);
		 
		//~ if(curl_error($ch)){
			//~ echo 'Request Error:' . curl_error($ch);
		//~ }
		//~ else
		//~ {
			//~ echo $response;
		//~ }
		curl_close($ch);
		
		$jsonArrayResponse = json_decode($response, true) ;
		
		echo "<pre>";
			print_r($jsonArrayResponse) ;
		echo "</pre>";
		
		exit; 
		
		
		
		/*For deleting a device*/
		
		
		
		
		/*For Authentication login gpswox*/
		
		$data = array(
			'email' 	=> $this->gpswoxUsername,
			'password'  => $this->gpswoxPassword
		);
 
		$payload = json_encode($data);
		
		$ch = curl_init($this->gpswoxUrl.'api/login');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLINFO_HEADER_OUT, true);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
		 
		// Set HTTP Header for POST request 
		curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			'Content-Type: application/json',
			'Content-Length: ' . strlen($payload))
		);
		 
		// Submit the POST request
		$apiResponse = curl_exec($ch);
		 
		// Close cURL session handle
		curl_close($ch);
		
		
		$jsonArrayResponse = json_decode($apiResponse, true) ;
		
		echo "<pre>";
			print_r($jsonArrayResponse) ;
		echo "</pre>";
		
		exit; 
		/*For Authentication login gpswox*/
		
		
		
		
		
		
		$data = array(
			'name' => 'tecadmin',
			'imei' => '123321098765111',
			'icon_id' => '0',
			'fuel_measurement_id' => '1',
			'tail_length' => '5',
			'min_moving_speed' => '6',
			'min_fuel_fillings' => '10',
			'min_fuel_thefts' => '10'
		);
 
		$payload = json_encode($data);
		 
		// Prepare new cURL resource
		$ch = curl_init($this->gpswoxUrl.'api/add_device?lang=en&user_api_hash=$2y$10$KUJMCYYUsELa2nzxgpD4XeTZkKN0f8TWgWtgSH3XRUfJrFvsPnu3y');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLINFO_HEADER_OUT, true);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
		 
		// Set HTTP Header for POST request 
		curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			'Content-Type: application/json',
			'Content-Length: ' . strlen($payload))
		);
		 
		// Submit the POST request
		$apiResponse = curl_exec($ch);
		 
		// Close cURL session handle
		curl_close($ch);
		
		
		$jsonArrayResponse = json_decode($apiResponse, true) ;
		
		echo "<pre>";
			print_r($jsonArrayResponse) ;
		echo "</pre>";
		
	}
	
	
	public function runBackGroundProcess() {
		
		
		/*For Authentication login gpswox*/
		
		$data = array(
			'email' 	=> $this->gpswoxUsername,
			'password'  => $this->gpswoxPassword
		);
 
		$payload = json_encode($data);
		
		$ch = curl_init($this->gpswoxUrl.'api/login');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLINFO_HEADER_OUT, true);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
		 
		// Set HTTP Header for POST request 
		curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			'Content-Type: application/json',
			'Content-Length: ' . strlen($payload))
		);
		 
		// Submit the POST request
		$apiResponse = curl_exec($ch);
		 
		// Close cURL session handle
		curl_close($ch);
		
		
		$jsonArrayResponse = json_decode($apiResponse, true) ;
		
		if ( ( isset($jsonArrayResponse['status']) && $jsonArrayResponse['status'] == "1" ) &&  ( isset($jsonArrayResponse['user_api_hash']) && $jsonArrayResponse['user_api_hash'] ) ) {
						//do nothing
		} else {
			echo json_encode(['error' => 0 , 'message' => 'Wrong admin credentials']) ;
			exit ;
		}
		
		
		
		/*For Authentication login gpswox*/
		
		if( base_url() == "https://13.58.101.121/orbis/" ) {
			$urlChangedForIp = "http://13.58.101.121/orbis/" ;
		} else {
			$urlChangedForIp = base_url() ;
		} 
		
		$command 	 = "curl " . $urlChangedForIp ."geofencing/processToRun/" . $this->session->userdata('user_id') ; 
		$outputfile  = $this->config->item('directoryPath') . "background/outputfile.php" ; 
		$pidFile	 = $this->config->item('directoryPath') . "background/pidfile.php" ; 
		
		/*To Checkif already any process is not running*/
		
		$processID 	 = trim(file_get_contents($pidFile));
		$result 	 = shell_exec(sprintf("ps %d", $processID));
		if (count(preg_split("/\n/", $result)) > 2) {
			echo json_encode(['error' => 0 , 'message' => 'There is already a process running for adding users to geofence']) ;
			exit ;
        } 
				
		/*To Checkif already any process is not running*/		
		
		$dataToInsert	 = json_decode($this->input->post('dataToInsert'), true) ;
		$totalcount		 = count($dataToInsert) ;
		
		if ( $totalcount > 0 ) {
		
			$this->load->model('users');
			
			//Insert data that to be used by the background process
			$insertData = $this->users->insert_users_geofence_background_process($dataToInsert) ;
			
			if($insertData) {
				$data 		 = $this->backgroundworker->execute($command,$outputfile,$pidFile);
				$this->users->insertBackgroundProcessMessagesShownOrNot($this->session->userdata('user_id'), '1', '0') ;
				echo json_encode(['error' => 1 , 'message' => 'Process started successfully']) ;
			} else {
				echo json_encode(['error' => 0 , 'message' => 'Database error occured']) ;
			}
			
		} else {
			echo json_encode(['error' => 0 , 'message' => 'No users found']) ;
		}
		
	}
	
	
	public function processToRun($loggedInUserId) {
		
		
		/*For Authentication login gpswox*/
		
		$data = array(
			'email' 	=> $this->gpswoxUsername,
			'password'  => $this->gpswoxPassword
		);
 
		$payload = json_encode($data);
		
		$ch = curl_init($this->gpswoxUrl.'api/login');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLINFO_HEADER_OUT, true);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
		 
		// Set HTTP Header for POST request 
		curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			'Content-Type: application/json',
			'Content-Length: ' . strlen($payload))
		);
		 
		// Submit the POST request
		$apiResponse = curl_exec($ch);
		 
		// Close cURL session handle
		curl_close($ch);
		
		
		$jsonArrayResponse = json_decode($apiResponse, true) ;
		
		if ( ( isset($jsonArrayResponse['status']) && $jsonArrayResponse['status'] == "1" ) &&  ( isset($jsonArrayResponse['user_api_hash']) && $jsonArrayResponse['user_api_hash'] ) ) {
						$gpsWoxAdminCredentials = $jsonArrayResponse['user_api_hash'] ;
		} else {
			exit ;
		}
		
		
		
		/*For Authentication login gpswox*/
		
		
		
		$pidFile	 = $this->config->item('directoryPath') . "background/pidfile.php" ; 
		$processID 	 = trim(file_get_contents($pidFile));
		
		$this->load->model('users');
		
		$usersData = $this->users->get_users_geofence_background_process() ;

		$totalCount	 = count($usersData) ;
		
		//$totalCount  = 150 ;
		
		if ( $usersData &&  $totalCount > 0 && $processID) {
			
			$dataInsertTable['total_count'] = $totalCount ;
			$dataInsertTable['process_id']  = $processID ;
			$dataInsertTable['user_id']  	= $loggedInUserId ;
			
			$insertStausTableData = $this->users->insertStatusTableData($dataInsertTable) ;
			
			if ($insertStausTableData) {
				
				$counterStatus = 1 ;
				
				//for($i=1; $i<=$totalCount; $i++) {
				  foreach($usersData as $insertGpsWoxData) {
					  
					 /*check if user already added*/
					 
					 $checkUserAlreadyAdded = $this->users->check_users_already_added_for_geofencing($insertGpsWoxData['serial_number']) ;
					 
					 if ($checkUserAlreadyAdded) {
						$this->users->updateStatusTableData($processID) ;
						continue ;
					 }
					 
					  
					 /*check if user already added*/ 
					  
					//$data['name']			=  "test".$i ;
					//$data['job']			=  "job".$i ;
					//$data['process_id']		=  $processID ;
					
					/*code for gpswox*/
					
					$datagpsWox = array(
						'name' => $insertGpsWoxData['name'],
						'imei' => $insertGpsWoxData['unique_value_gpswox'],
						'icon_id' => '0',
						'fuel_measurement_id' => '1',
						'tail_length' => '5',
						'min_moving_speed' => '6',
						'min_fuel_fillings' => '10',
						'min_fuel_thefts' => '10'
					);
 
					$payload = json_encode($datagpsWox);
					 
					// Prepare new cURL resource
					$ch = curl_init($this->gpswoxUrl.'api/add_device?lang=en&user_api_hash='.$gpsWoxAdminCredentials);
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
					curl_setopt($ch, CURLINFO_HEADER_OUT, true);
					curl_setopt($ch, CURLOPT_POST, true);
					curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
					 
					curl_setopt($ch, CURLOPT_HTTPHEADER, array(
						'Content-Type: application/json',
						'Content-Length: ' . strlen($payload))
					);
					
					$apiResponse = curl_exec($ch);
					 
					curl_close($ch);
					
				   /*code for gpswox*/	
				   
					$result = json_decode($apiResponse, true) ;
					
					
					//$this->users->addBackgroundProcessData($data) ;
					
					/*Update the add_geofening_users_status current count*/
					$this->users->updateStatusTableData($processID) ;
					/*Update the add_geofening_users_status current count*/
					
					if ( ( isset($result['status']) && $result['status'] == "1" ) &&  ( isset($result['id']) && $result['id'] ) ) {
						$insertGpsWoxData['gpswox_id'] = $result['id'] ;
						
						$dataToAddUser['unique_value_gpswox'] 			 = $insertGpsWoxData['unique_value_gpswox'] ;
						$dataToAddUser['name'] 			 				 = $insertGpsWoxData['name'] ;
						$dataToAddUser['handset_number'] 				 = $insertGpsWoxData['handset_number'] ;
						$dataToAddUser['serial_number']  				 = $insertGpsWoxData['serial_number'] ;
						$dataToAddUser['cont_no']        				 = $insertGpsWoxData['cont_no'] ;
						$dataToAddUser['imei']          				 = $insertGpsWoxData['imei'] ;
						$dataToAddUser['trans_type']     				 = $insertGpsWoxData['trans_type'] ;
						$dataToAddUser['gpswox_id']      				 = $result['id'] ;
						$this->users->users_added_for_geofencing($dataToAddUser) ;
						
					} else {
							
							if ( isset($result['errors']) && $result['errors'] ) {
								$this->logger->trigger_log('admin','Error adding user ['.$insertGpsWoxData['name'].'] - to GPSWOX record: ' . print_r($result['errors'], TRUE));
								$this->users->updateStatusTableDataOnError($processID) ;
							}
					}
					
					$counterStatus++ ;
				} //end for each
			}
			
		} 
		
	}
	
	public function currentProcessRunning() {
		
		//debug($_SESSION, 1) ;
		$pidFile	 = "/var/www/html/orbis/orbis_lwp_portal_v1_1/background/pidfile.php" ; 
		$processID 	 = trim(file_get_contents($pidFile));
		$result = shell_exec(sprintf("ps %d", $processID));
		if (count(preg_split("/\n/", $result)) > 2) {
			echo "yes" ;
        } else {
			echo "no" ;
		}
		debug($result) ;
		//~ $pidFile	 = "/var/www/html/orbis/orbis_lwp_portal_v1_1/background/pidfile.php" ; 
		//~ $data = $this->backgroundworker->isRunning($pidFile);
		//~ echo  $data ;
		//debug($this->session->userdata('enableGeofencingForUser_dataSession'), 1) ;
	
	}
	
	
	public function getCurrentProcessStatus() {
		
		$this->load->model('users');
		$usersData = $this->users->getStautsOnEscalationPageOnly() ;
		
		if ($usersData) {
			
			$percentage = ceil($usersData['current_count']/$usersData['total_count'] * 100) ;
			
			if ( $percentage >= "100" ) {
				$this->users->insertBackgroundProcessMessagesShownOrNot($usersData['user_id'], '1', '1') ;
			}
			
			echo json_encode(['error' => 1 , 'message' => 'Data found', 'percentage' =>  $percentage ]) ;
		} else {
			echo json_encode(['error' => 0 , 'message' => 'Some error occured']) ;
		}
	}
	
	
	public function getCurrentProcessStatuAllPages() {
		
		$this->load->model('users');
		$usersData = $this->users->getStautsOnAllPages() ;
		
		if ($usersData) {
			
			$result 	 = shell_exec(sprintf("ps %d", $usersData['process_id']));
			
			if (count(preg_split("/\n/", $result)) > 2) {
				echo json_encode(['error' => 0 , 'message' => 'show', 'processId' => $usersData['process_id']]) ;
			} else {
				
				$messageShownOrNot = $this->users->backgroundProcessMessagesShownOrNot($this->session->userdata('user_id'), '1') ;
				
				if ( $messageShownOrNot ) {
					$this->users->insertBackgroundProcessMessagesShownOrNot($this->session->userdata('user_id'), '1', '1') ;
					echo json_encode(['error' => 2 , 'message' => 'show previous message', 'processId' => $usersData['process_id']]) ;
				} else {
				
					echo json_encode(['error' => 1 , 'message' => 'Do nothing', 'processId' => $usersData['process_id']]) ;
				}
			}
			
		} else {
			
			$messageShownOrNot = $this->users->backgroundProcessMessagesShownOrNot($this->session->userdata('user_id'), '1') ;
				
			if ( $messageShownOrNot ) {
				$this->users->insertBackgroundProcessMessagesShownOrNot($this->session->userdata('user_id'), '1', '1') ;
				echo json_encode(['error' => 2 , 'message' => 'show previous message']) ;
			} else {
			
				echo json_encode(['error' => 1 , 'message' => 'Do nothing']) ;
			}
			
			
		}
	}
	
	/* for delete geofence users start */
	
	public function getDataForAddedGeofenceUsers() {
	
		
		$this->load->model('users');
		$usersData = $this->users->get_users_added_for_geofencing() ;
		
		if ($usersData) {
			echo json_encode(['error' => 0 , 'data' => $usersData]) ;
		} else {
			echo json_encode(['error' => 1 , 'data' => '']) ;
		}
	}
	
	
	
	public function runBackGroundProcessForDelete() {
		
		
		/*For Authentication login gpswox*/
		
		$data = array(
			'email' 	=> $this->gpswoxUsername,
			'password'  => $this->gpswoxPassword
		);
 
		$payload = json_encode($data);
		
		$ch = curl_init($this->gpswoxUrl.'api/login');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLINFO_HEADER_OUT, true);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
		 
		// Set HTTP Header for POST request 
		curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			'Content-Type: application/json',
			'Content-Length: ' . strlen($payload))
		);
		 
		// Submit the POST request
		$apiResponse = curl_exec($ch);
		 
		// Close cURL session handle
		curl_close($ch);
		
		
		$jsonArrayResponse = json_decode($apiResponse, true) ;
		
		if ( ( isset($jsonArrayResponse['status']) && $jsonArrayResponse['status'] == "1" ) &&  ( isset($jsonArrayResponse['user_api_hash']) && $jsonArrayResponse['user_api_hash'] ) ) {
						//do nothing
		} else {
			echo json_encode(['error' => 0 , 'message' => 'Wrong admin credentials']) ;
			exit ;
		}
		
		
		
		/*For Authentication login gpswox*/
		
		if( base_url() == "https://13.58.101.121/orbis/" ) {
			$urlChangedForIp = "http://13.58.101.121/orbis/" ;
		} else {
			$urlChangedForIp = base_url() ;
		} 
		
		$command 	 = "curl " . $urlChangedForIp ."geofencing/processToRunForDelete/" . $this->session->userdata('user_id') ; 
		$outputfile  = $this->config->item('directoryPath') . "background/delete_geofence_users/outputfile.php" ; 
		$pidFile	 = $this->config->item('directoryPath') . "background/delete_geofence_users/pidfile.php" ; 
		
		/*To Checkif already any process is not running*/
		
		$processID 	 = trim(file_get_contents($pidFile));
		$result 	 = shell_exec(sprintf("ps %d", $processID));
		if (count(preg_split("/\n/", $result)) > 2) {
			echo json_encode(['error' => 0 , 'message' => 'There is already a process running for deleting geofence users']) ;
			exit ;
        } 
				
		/*To Checkif already any process is not running*/		
		
		$dataToInsert	 = json_decode($this->input->post('dataToInsert'), true) ;
		$totalcount		 = count($dataToInsert) ;
		
		if ( $totalcount > 0 ) {
		
			$this->load->model('users');
			
			//Insert data that to be used by the background process
			$insertData = $this->users->insert_users_geofence_background_process_for_delete($dataToInsert) ;
			
			if($insertData) {
				$data 		 = $this->backgroundworker->execute($command,$outputfile,$pidFile);
				$this->users->insertBackgroundProcessMessagesShownOrNot($this->session->userdata('user_id'), '2', '0') ;
				echo json_encode(['error' => 1 , 'message' => 'Process started successfully']) ;
			} else {
				echo json_encode(['error' => 0 , 'message' => 'Database error occured']) ;
			}
			
		} else {
			echo json_encode(['error' => 0 , 'message' => 'No users found']) ;
		}
		
	}
	
	
	public function processToRunForDelete($loggedInUserId) {
		
		
		/*For Authentication login gpswox*/
		
		$data = array(
			'email' 	=> $this->gpswoxUsername,
			'password'  => $this->gpswoxPassword
		);
 
		$payload = json_encode($data);
		
		$ch = curl_init($this->gpswoxUrl.'api/login');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLINFO_HEADER_OUT, true);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
		 
		// Set HTTP Header for POST request 
		curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			'Content-Type: application/json',
			'Content-Length: ' . strlen($payload))
		);
		 
		// Submit the POST request
		$apiResponse = curl_exec($ch);
		 
		// Close cURL session handle
		curl_close($ch);
		
		
		$jsonArrayResponse = json_decode($apiResponse, true) ;
		
		if ( ( isset($jsonArrayResponse['status']) && $jsonArrayResponse['status'] == "1" ) &&  ( isset($jsonArrayResponse['user_api_hash']) && $jsonArrayResponse['user_api_hash'] ) ) {
						$gpsWoxAdminCredentials = $jsonArrayResponse['user_api_hash'] ;
		} else {
			exit ;
		}
		
		
		
		/*For Authentication login gpswox*/
		
		
		
		$pidFile	 = $this->config->item('directoryPath') . "background/delete_geofence_users/pidfile.php" ; 
		$processID 	 = trim(file_get_contents($pidFile));
		
		$this->load->model('users');
		
		$usersData = $this->users->get_users_geofence_background_process_for_delete() ;
		//debug($usersData, 1) ;
		$totalCount	 = count($usersData) ;
		
		//$totalCount  = 150 ;
		
		if ( $usersData &&  $totalCount > 0 && $processID) {
			
			$dataInsertTable['total_count'] = $totalCount ;
			$dataInsertTable['process_id']  = $processID ;
			$dataInsertTable['user_id']  	= $loggedInUserId ;
			
			$insertStausTableData = $this->users->insertStatusTableDataForDelete($dataInsertTable) ;
			
			if ($insertStausTableData) {
				
				  
				  
				  foreach($usersData as $insertGpsWoxData) {
					  
						$ch = curl_init($this->gpswoxUrl.'api/destroy_device?lang=en&user_api_hash='.$gpsWoxAdminCredentials.'&device_id='.$insertGpsWoxData['gpxwox_device_id']);
						curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
						curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
						curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
						curl_setopt($ch, CURLOPT_TIMEOUT, 80);
						 
						$response = curl_exec($ch);
						curl_close($ch);
						$result = json_decode($response, true) ;
					 
					 
						
					
						if ( ( isset($result['status']) && $result['status'] == "1" ) &&  ( isset($result['deleted']) && $result['deleted'] == "1" ) ) {
							$deleteGeofenceUsers = $this->users->deleteGeofenceAddedUSers($insertGpsWoxData['serial_number'], $insertGpsWoxData['gpxwox_device_id']) ;
						} else {
							
							if ( isset($result['errors']) && $result['errors'] ) {
								$this->logger->trigger_log('admin','Error deleting user ['.$insertGpsWoxData['serial_number'].'] - from GPSWOX record: ' . print_r($result['errors'], TRUE));
								$this->users->updateStatusTableDataOnErrorForDelete($processID) ;
							}
						}
						 
					    /*Update the add_geofening_users_status current count*/
						$this->users->updateStatusTableDataForDelete($processID) ;
						/*Update the add_geofening_users_status current count*/
						
					  
				} //end for each
			}
			
		} 
		
	}
	
	public function getCurrentProcessStatusForDelete() {
		
		$this->load->model('users');
		$usersData = $this->users->getStautsOnEscalationPageOnlyForDelete() ;
		
		if ($usersData) {
			
			$percentage = ceil($usersData['current_count']/$usersData['total_count'] * 100) ;
			
			if ( $percentage >= "100" ) {
				$this->users->insertBackgroundProcessMessagesShownOrNot($usersData['user_id'], '2', '1') ;
			}
			
			echo json_encode(['error' => 1 , 'message' => 'Data found', 'percentage' =>  $percentage ]) ;
		} else {
			echo json_encode(['error' => 0 , 'message' => 'Some error occured']) ;
		}
	}
	
	public function getCurrentProcessStatuAllPagesForDelete() {
		
		$this->load->model('users');
		$usersData = $this->users->getStautsOnAllPagesForDelete() ;
		$pidFile	 = $this->config->item('directoryPath') . "background/delete_geofence_users/pidfile.php" ; 
		$processID 	 = trim(file_get_contents($pidFile));
		
		if ($usersData && ($usersData['process_id'] == $processID) ) {
			
			$result 	 = shell_exec(sprintf("ps %d", $usersData['process_id']));
			
			if (count(preg_split("/\n/", $result)) > 2) {
				echo json_encode(['error' => 0 , 'message' => 'show', 'processId' => $usersData['process_id']]) ;
			} else {
				
				$messageShownOrNot = $this->users->backgroundProcessMessagesShownOrNot($this->session->userdata('user_id'), '2') ;
				
				if ( $messageShownOrNot ) {
					$this->users->insertBackgroundProcessMessagesShownOrNot($this->session->userdata('user_id'), '2', '1') ;
					echo json_encode(['error' => 2 , 'message' => 'show previous message', 'processId' => $usersData['process_id']]) ;
				} else {
				
					echo json_encode(['error' => 1 , 'message' => 'Do nothing', 'processId' => $usersData['process_id']]) ;
				}
			}
			
		} else {
			
			
			$messageShownOrNot = $this->users->backgroundProcessMessagesShownOrNot($this->session->userdata('user_id'), '2') ;
				
			if ( $messageShownOrNot ) {
				$this->users->insertBackgroundProcessMessagesShownOrNot($this->session->userdata('user_id'), '2', '1') ;
				echo json_encode(['error' => 2 , 'message' => 'show previous message']) ;
			} else {
			
				echo json_encode(['error' => 1 , 'message' => 'Do nothing']) ;
			}
			
			
		}
	}
	
	/* for delete geofence users start */
	
	
	public function enableGeofencing() {
	
	
		$this->load->helper('url');
		if( $this->session->userdata('type') != 'superadmin' )
		{
			 redirect('/', 'refresh');
			 die;
		}
		
		$CostCentreResponse = $this->curl->curlHelperGetCostCentreAPI() ;

		$data['CostCentreList'] = $CostCentreResponse;
		$this->load->view('system/enablegeofencing', $data);
	
	
	}
	
	
	
	public function cronForRecordIntegritySentry() {
	
	
		$this->load->model('users');
		$usersData = $this->users->get_users_added_for_geofencing() ;
		
		
		if ($usersData) {
			
			/*For Authentication login gpswox*/
		
			$dataGpswoxLogin = array(
				'email' 	=> $this->gpswoxUsername ,
				'password'  => $this->gpswoxPassword 
			);
	 
			$payload = json_encode($dataGpswoxLogin);
			
			$ch = curl_init($this->gpswoxUrl.'api/login');
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLINFO_HEADER_OUT, true);
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
			 
			// Set HTTP Header for POST request 
			curl_setopt($ch, CURLOPT_HTTPHEADER, array(
				'Content-Type: application/json',
				'Content-Length: ' . strlen($payload))
			);
			 
			// Submit the POST request
			$apiResponse = curl_exec($ch);
			 
			// Close cURL session handle
			curl_close($ch);
			
			
			$jsonArrayResponse = json_decode($apiResponse, true) ;
			
			if ( ( isset($jsonArrayResponse['status']) && $jsonArrayResponse['status'] == "1" ) &&  ( isset($jsonArrayResponse['user_api_hash']) && $jsonArrayResponse['user_api_hash'] ) ) {
							$gpsWoxAdminCredentials = $jsonArrayResponse['user_api_hash'] ;
			} else {
				echo "Wrong gpswox credentials" ;
				exit ;
			}
			
			/*For Authentication login gpswox*/
			
			
			
			foreach( $usersData as $data ) {
				
				$url = 'http://www.monitorsoft.com/SentinelXS/clsSentinelXS/GetSite';
				$xml = '<?xml version="1.0" encoding="UTF-8" standalone="no" ?>
					<SOAP-ENV:Envelope
					 SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/"
					 xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
					 xmlns:SOAP-ENC="http://schemas.xmlsoap.org/soap/encoding/"
					xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
					xmlns:xsd="http://www.w3.org/2001/XMLSchema">
					<SOAP-ENV:Body>
						<GetSite xmlns="http://www.monitorsoft.com/SentinelXS/clsSentinelXS">
							<getSiteRequestKey>
								<UserName>sentrymaster</UserName>
								<Password>Pass2121!</Password>
								<SerialNumber>' . $data['serial_number'] .'</SerialNumber>
							</getSiteRequestKey>
						</GetSite>
					</SOAP-ENV:Body>
					</SOAP-ENV:Envelope>';

			$curl_getsitedetail = $this->curl->curl_send($xml, $url);
			$xmlToArray_get_sites = $this->curl->xmlParse($curl_getsitedetail);
			
			//debug($xmlToArray_get_sites);
			
			$dataArrayName = ( isset( $xmlToArray_get_sites['soap:Body']['GetSiteResponse']['GetSiteResult']['SiteInformation']['Name'] ) && $xmlToArray_get_sites['soap:Body']['GetSiteResponse']['GetSiteResult']['SiteInformation']['Name'] ? $xmlToArray_get_sites['soap:Body']['GetSiteResponse']['GetSiteResult']['SiteInformation']['Name'] : '' );
				
			if ($dataArrayName) {
					
					if ( trim($dataArrayName) != trim($data['name'])  ) {
						
						
						/*code for gpswox*/
						
						$datagpsWoxUpdate = array(
							'name' => $dataArrayName,
							'imei' => $data['unique_value_gpswox'],
							'icon_id' => '0',
							'fuel_measurement_id' => '1',
							'tail_length' => '5',
							'min_moving_speed' => '6',
							'min_fuel_fillings' => '10',
							'min_fuel_thefts' => '10'
						);
	 
						$payload = json_encode($datagpsWoxUpdate);
						 
						// Prepare new cURL resource
						$ch = curl_init($this->gpswoxUrl.'api/edit_device?lang=en&user_api_hash='.$gpsWoxAdminCredentials.'&device_id='.$data['gpswox_id']);
						curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
						curl_setopt($ch, CURLINFO_HEADER_OUT, true);
						curl_setopt($ch, CURLOPT_POST, true);
						curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
						 
						curl_setopt($ch, CURLOPT_HTTPHEADER, array(
							'Content-Type: application/json',
							'Content-Length: ' . strlen($payload))
						);
						
						$apiResponse = curl_exec($ch);
						 
						curl_close($ch);
						
					   /*code for gpswox*/	
					   
						$result = json_decode($apiResponse, true) ;
						
						if (  isset($result['status']) && $result['status'] == "1"  ) {
							
							//update in our database as well
							
							$updateToMaintainRecordIntegritySentry = $this->users->updateToMaintainRecordIntegritySentry($data['serial_number'], $data['gpswox_id'], $dataArrayName) ;
							
						}
					
					} 
				}
				
				
			} //end for each
			
			
		} else {
			echo "No users added for gpswox." ;
		}
	
	}
	
	public function updateToMaintainRecordIntegritySentry() {
	
		$this->load->model('users');
		

		
		
		$serialNumber =  $this->input->post('serialNumber') ;
		$newName 	  =  $this->input->post('newName') ;
		
		
		//$serialNumber =  "158294" ;
		//$newName 	  =  "SUNDAR NEGI" ;
		
		if ($serialNumber && $newName) {
			
			$data = $this->users->check_users_already_added_for_geofencing($serialNumber) ;
			
			if ($data) { 
				/*For Authentication login gpswox*/
			
				$dataGpswoxLogin = array(
					'email' 	=> $this->gpswoxUsername ,
					'password'  => $this->gpswoxPassword 
				);
		 
				$payload = json_encode($dataGpswoxLogin);
				
				$ch = curl_init($this->gpswoxUrl.'api/login');
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($ch, CURLINFO_HEADER_OUT, true);
				curl_setopt($ch, CURLOPT_POST, true);
				curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
				 
				// Set HTTP Header for POST request 
				curl_setopt($ch, CURLOPT_HTTPHEADER, array(
					'Content-Type: application/json',
					'Content-Length: ' . strlen($payload))
				);
				 
				// Submit the POST request
				$apiResponse = curl_exec($ch);
				 
				// Close cURL session handle
				curl_close($ch);
				
				
				$jsonArrayResponse = json_decode($apiResponse, true) ;
				
				if ( ( isset($jsonArrayResponse['status']) && $jsonArrayResponse['status'] == "1" ) &&  ( isset($jsonArrayResponse['user_api_hash']) && $jsonArrayResponse['user_api_hash'] ) ) {
								$gpsWoxAdminCredentials = $jsonArrayResponse['user_api_hash'] ;
				} else {
					$this->logger->trigger_log($this->session->userdata('username'),'Error Updating Sentry - GPSWOX record integrity: Wrong gpswox credentials.');
					echo json_encode(['error' => 1 , 'message' => 'Wrong gpswox credentials.']) ;
					exit ;
				}
				
				/*For Authentication login gpswox*/
				
				
				 if ( trim($newName) != trim($data['name'])  ) {
						
						
						/*code for gpswox*/
						
						$datagpsWoxUpdate = array(
							'name' => $newName,
							'imei' => $data['unique_value_gpswox'],
							'icon_id' => '0',
							'fuel_measurement_id' => '1',
							'tail_length' => '5',
							'min_moving_speed' => '6',
							'min_fuel_fillings' => '10',
							'min_fuel_thefts' => '10'
						);
	 
						$payload = json_encode($datagpsWoxUpdate);
						 
						// Prepare new cURL resource
						$ch = curl_init($this->gpswoxUrl.'api/edit_device?lang=en&user_api_hash='.$gpsWoxAdminCredentials.'&device_id='.$data['gpswox_id']);
						curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
						curl_setopt($ch, CURLINFO_HEADER_OUT, true);
						curl_setopt($ch, CURLOPT_POST, true);
						curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
						 
						curl_setopt($ch, CURLOPT_HTTPHEADER, array(
							'Content-Type: application/json',
							'Content-Length: ' . strlen($payload))
						);
						
						$apiResponse = curl_exec($ch);
						 
						curl_close($ch);
						
					   /*code for gpswox*/	
					   
						$result = json_decode($apiResponse, true) ;
						
						if (  isset($result['status']) && $result['status'] == "1"  ) {
							
							//update in our database as well
							
							$updateToMaintainRecordIntegritySentry = $this->users->updateToMaintainRecordIntegritySentry($data['serial_number'], $data['gpswox_id'], $newName) ;
							echo json_encode(['error' => 0 , 'message' => 'Gpswox data updated successfully.']) ;
						} else {
							
							if ( isset($result['errors']) && $result['errors'] ) {
								$this->logger->trigger_log($this->session->userdata('username'),'Error Updating Sentry - GPSWOX record integrity: ' . print_r($result['errors'], TRUE));
							}
							
							echo json_encode(['error' => 1 , 'message' => 'There is some problem, please try again later']) ;
						}
					
					} else {
						echo json_encode(['error' => 2 , 'message' => 'Do nothing1']) ;
					}
				 
				 
				 
		  } else {
				echo json_encode(['error' => 2 , 'message' => 'Do nothing2']) ;
		  }
			
		} else {
			echo json_encode(['error' => 1 , 'message' => 'Missing serial number/name.']) ;
		}
		
		
	
	}
	
	
	public function testHomesafeReporting() {
	
	
		$conexion = new PDO("informix:host=".$this->config->item('pdo_connect')['host'].";service=".$this->config->item('pdo_connect')['service'].";database=".$this->config->item('pdo_connect')['database'].";server=".$this->config->item('pdo_connect')['server'].";protocol=".$this->config->item('pdo_connect')['protocol'].";EnableScrollableCursors=".$this->config->item('pdo_connect')['EnableScrollableCursors'].";client_locale=".$this->config->item('pdo_connect')['client_locale'].";db_locale=".$this->config->item('pdo_connect')['db_locale'] ,$this->config->item('pdo_connect')['db_user'],$this->config->item('pdo_connect')['db_pass']);
		
		
		$conexion->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		
		
		//~ $sql = "DROP TABLE IF EXISTS Homesafe_109234_max_lseqno;" ;
		//~ $prep   = $conexion->prepare($sql);
		//~ $prep->execute();
		//~ $resultTotal = $prep->fetchAll(PDO::FETCH_ASSOC);
		//~ debug($resultTotal, 1) ;
		
		$sql = "DROP TABLE IF EXISTS Homesafe_109234_max_lseqno;
		SELECT customer.name, customer.contno, systrans.netaddr, eventdef.descr, sumlog.serialno, MAX(sumlog.lseqno) max_lseqno
FROM customer
INNER JOIN systrans ON systrans.serialno = customer.serialno
INNER JOIN sumlog ON sumlog.serialno = customer.serialno
INNER JOIN eventdef ON eventdef.stcode = sumlog.stcode
WHERE sumlog.stcode in (2017, 2018, 2019, 2021)
AND sumlog.evtime >='2021-03-23 00:00:00' AND sumlog.evtime <= '2021-03-23 23:59:59'
AND customer.linkno IN (SELECT linkno FROM linkacc START WITH linkacc.linkno IN (52574) CONNECT BY PRIOR linkacc.linkno=linkacc.parent)
GROUP BY 1,2,3,4,5
INTO TEMP Homesafe_109234_max_lseqno WITH NO LOG;" ;
		$prep   = $conexion->prepare($sql);
		$prep->execute();
		
		
		
		$sql = "DROP TABLE IF EXISTS Homesafe_109234_serialno_lseqno;" ;
		$prep   = $conexion->prepare($sql);
		$prep->execute();
		
		
		
		
		$sql = "SELECT serialno, MAX(max_lseqno) lseqno
FROM Homesafe_109234_max_lseqno
GROUP BY 1
INTO TEMP Homesafe_109234_serialno_lseqno WITH NO LOG" ;
		$prep   = $conexion->prepare($sql);
		$prep->execute();
		
		
		
		$sql = "SELECT customer.name, customer.contno, systrans.netaddr, eventdef.descr, sumlog.evtime, detlog1.latitude, detlog1.longitude
FROM customer, sumlog, eventdef, systrans, Homesafe_109234_serialno_lseqno AS HS, OUTER detlog1
WHERE sumlog.serialno = customer.serialno
AND systrans.serialno = customer.serialno AND systrans.commsno = sumlog.commsno
AND eventdef.stcode = sumlog.stcode
AND detlog1.serialno = sumlog.serialno AND detlog1.lseqno = sumlog.lseqno
AND HS.lseqno = sumlog.lseqno AND HS.serialno = sumlog.serialno
AND detlog1.serialno = sumlog.serialno AND detlog1.lseqno = sumlog.lseqno
AND customer.linkno IN (SELECT linkno FROM linkacc START WITH linkacc.linkno IN (52574) CONNECT BY PRIOR linkacc.linkno = linkacc.parent)
AND detlog1.latitude IS NOT NULL
AND detlog1.longitude IS NOT NULL
UNION
SELECT customer.name, customer.contno, systrans.netaddr, NULL::VARCHAR(50), NULL::DATETIME YEAR TO FRACTION(5), NULL::VARCHAR(50), NULL::VARCHAR(50)
FROM customer, systrans
WHERE customer.serialno = systrans.serialno
AND customer.linkno IN (SELECT linkno FROM linkacc START WITH linkacc.linkno IN (52574) CONNECT BY PRIOR linkacc.linkno=linkacc.parent)
AND systrans.transtype = 25029
AND customer.serialno NOT IN(SELECT serialno FROM Homesafe_109234_serialno_lseqno)" ;
		$prep   = $conexion->prepare($sql);
		$prep->execute();
		
		$resultTotal = $prep->fetchAll(PDO::FETCH_ASSOC);
		debug($resultTotal, 1) ;
	}
	
	
	function getHomesafeUsersGeofenceData() {
	
	
		 
		$serialNumber = json_decode($this->input->post('serialNumber'));
		
		if (!$serialNumber) {
			echo json_encode(['error' => "1" , 'message' => 'Missing required parameter', 'data' => '']) ;
			exit ;
		}
		
		
		$this->load->model('users');
		
		$getData = $this->users->getHomesafeUsersGeofenceData($serialNumber) ;
		
		if (!$getData) {
			echo json_encode(['error' => "1" , 'message' => 'Homesafe geofencing not set for the selected users', 'data' => '']) ;
			exit ;
		}
		
		echo json_encode(['error' => "0" , 'message' => 'Success', 'data' => $getData]) ;
	
	}
	
}
