<?php

class Geo extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->library('session');
		$this->load->helpers('url');
		$this->load->model('users');
		$this->load->model('cost_center');
		$this->load->model('contractareas');
		$this->load->model('offices');
				$this->load->library('pagination');
		if( $this->session->userdata('type') == "" )
		{
			$this->session->set_flashdata('error_msg','Not Login Yet');
			redirect('/');
		}
	}

	function index()
	{

		$config = [

			'base_url' 			=> site_url("geo/index"),
			'total_rows'		=> count($this->users->count_geo()),
			'per_page'			=> 5,
			'full_tag_open'		=> '<ul class="pagination pull-right">',
			'full_tag_close'	=> '</ul>',
			'first_tag_open'	=> '<li>',
			'first_tag_close'	=> '</li>',
			'last_tag_open'		=> '<li>',
			'last_tag_close'	=> '</li>',
			'cur_tag_open'		=> '<li class="active"><a>',
			'cur_tag_close'		=> '</a></li>',
			'num_tag_open'		=> '<li>',
			'num_tag_close'		=> '</li>',
			'next_tag_open'		=> '<li>',
			'next_tag_close'	=> '</li>',
			'prev_tag_open'		=> '<li>',
			'prev_tag_close'	=> '</li>'
		];

		//$data['geofencelist'] = $this->users->geofencelist($config['per_page'], $this->uri->segment(3));
		$data['geofencelist'] = $this->users->geofencelist($config['per_page'], $this->uri->segment(3));
		$data["links_up"] = $this->pagination->initialize($config);
		$data["links_footer"] = $this->pagination->initialize($config);
		$this->load->view('geo/geolist', $data);
	}

	function dummy_data()
	{
		$this->load->view('geo/geo');
	}


	function viewmap()
	{
		$this->load->view('geo/geotest');
	}

	function saveOfficeArea()
	{

		$area_replace = str_replace( 'MapLocation','new Microsoft.Maps.Location',$this->input->post('saveArea') );
		$replace_all = str_replace( '[','',$area_replace );
		$replace_all = str_replace( ']','',$replace_all );

		$row['area'] = $replace_all;
		$row['officeID'] = $this->input->post('officeID');
		$row['zoomLevel'] = $this->input->post('zoomLevel');
		$saveOfficeArea = $this->offices->saveOfficeArea($row );
		if( $saveOfficeArea )
		{
			echo 'done';
		}
		else
		{
			echo 'fail';
		}
	}

	function checkUser()
	{
		$checkUser = $this->offices->checkUserLwd();
		debug($checkUser);
	}

	function action()
	{
		$this->load->view('geo/geoaction');
	}

	function get_data()
	{
		$data = $this->users->get_location_geofence( $this->input->post('system_id') );

		$data1 = str_replace('new Microsoft.Maps.Location', '', $data);
		$data1 = str_replace('(', '', $data1);
		$data1 = str_replace(')', '', $data1);


		$count = round(count(explode(',',$data['area']))/2);


		if(!empty( $data ))
		{
			$check = explode(',',$data['area'])[$count+1];
			if (strpos($check, 'new Microsoft.Maps.Location') !== false) {
			   	$center_point2 = explode(',',$data['area'])[$count];
				$center_point1 = explode(',',$data['area'])[$count+1];
			}
			else
			{
				$center_point2 = explode(',',$data['area'])[$count+1];
				$center_point1 = explode(',',$data['area'])[$count];
			}
			$data['center_point'] = $center_point1.",".$center_point2;
		}
		else {
			$data['center_point'] = ' ';
		}

		//debug($data,1);
		$this->load->view('geo/dummy',$data);
	}

	function get_data_first_time()
	{
		$data = $this->users->get_data_first_time( );

		$data1 = str_replace('new Microsoft.Maps.Location', '', $data);
		$data1 = str_replace('(', '', $data1);
		$data1 = str_replace(')', '', $data1);


		//debug(explode(',',$data['area']));
		$count = round(count(explode(',',$data['area']))/2);

		if(!empty( $data ))
		{
			$center_point2 = explode(',',$data['area'])[$count+1];
			$center_point1 = explode(',',$data['area'])[$count];
			$data['center_point'] = $center_point1.",".$center_point2;
		}
		else {
			$data['center_point'] = ' ';
		}
		//debug( $data,1 );
		$this->load->view('geo/dummy',$data);
	}

	function draw_map()
	{
		$this->load->view('geo/draw');
	}

	// add geofence
	function add_geo()
	{
		$geofence_add = $this->users->geofence_add( $this->input->post() );
		if($geofence_add)
		{
			echo '1';
		}
		else
		{
			echo '0';
		}
	}

	//edit geofence
	function geofence_edit()
	{
		$data['geofence_name'] = $this->input->post('name');
		$data['geofence_status'] = $this->input->post('status');
		$update_geofence = $this->users->update_geofence($data,$this->input->post('id') );
		if( $update_geofence )
		{
			echo 'done';
		}
		else
		{
			echo 'fail';
		}
	}

	// delete geofence
	function delete_geofence()
	{
		$delete_geofence = $this->users->delete_geofence($this->input->post('id'));
	}

	function test_geo()
	{
		$data['geofencelist'] = $this->users->geofencelist();
		$this->load->view('test/geolist',$data);
	}

}
