<?php
include_once(dirname(dirname(__FILE__)) . "/sfwd-lms/includes/vendor/wp-pro-quiz/lib/model/WpProQuiz_Model_Mapper.php");
class Wpquizmodelquestion extends WpProQuiz_Model_Mapper {
	private $_table;

	public function __construct() {
		parent::__construct();
		
		$this->_table = $this->_prefix."question";
	}
	
	
	public function getMaxSort($quizId) {
		
		
		
		return $this->_wpdb->get_var($this->_wpdb->prepare(
			"SELECT MAX(sort) AS max_sort FROM {$this->_tableQuestion} WHERE quiz_id = %d AND online = 1", $quizId));
	}
	
	public function save(WpProQuiz_Model_Question $question, $auto = false,$name) {
		global $wpdb;
		
		$column =$wpdb->get_results(  "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS
WHERE table_name = {$this->_table} AND column_name = 'name'"  ); //$wpdb->get_row($wpdb->prepare("SELECT * FROM {$this->_table} WHERE `title` LIKE %s",$name));

	if (empty( $column ) ) {
		$wpdb->query("ALTER TABLE {$this->_table} ADD name VARCHAR(550) NOT NULL");
		//echo "coloumn added";
		//print_r($column);
		//return false;
	}
		
	
		$sort = null;
		
		if($auto && $question->getId()) {
			$statisticMapper = new WpProQuiz_Model_StatisticMapper();
			
			if($statisticMapper->isStatisticByQuestionId($question->getId())) {
				$this->setOnlineOff($question->getId());
				$question->setQuizId($this->getQuizId($question->getId()));
				$question->setId(0);
				$sort = $question->getSort();
			}
		}
		
		if($question->getId() != 0) {
			$this->_wpdb->update(
					$this->_table, 
					array(
						'title' => getTitle(),
						'points' => $question->getPoints(),
						'question' => $question->getQuestion(),
						'correct_msg' => $question->getCorrectMsg(),
						'incorrect_msg' => $question->getIncorrectMsg(),
						'correct_same_text' => (int)$question->isCorrectSameText(),
						'tip_enabled' => (int)$question->isTipEnabled(),
						'tip_msg' => $question->getTipMsg(),
						'answer_type' => $question->getAnswerType(),
						'show_points_in_box' => (int)$question->isShowPointsInBox(),
						'answer_points_activated' => (int)$question->isAnswerPointsActivated(),
						'answer_data' => $question->getAnswerData(true),
						'category_id' => $question->getCategoryId(),
						'answer_points_diff_modus_activated' => (int)$question->isAnswerPointsDiffModusActivated(),
						'disable_correct' => (int)$question->isDisableCorrect(),
						'matrix_sort_answer_criteria_width' => $question->getMatrixSortAnswerCriteriaWidth(),
						'name' => $name
					),
					array('id' => $question->getId()),
					array('%s', '%d', '%s', '%s', '%s', '%d', '%d', '%s', '%s', '%d', '%d', '%s', '%d', '%d', '%d', '%d','%s'),
					array('%d'));
		} else {
			$this->_wpdb->insert($this->_table, array(
					'quiz_id' => $question->getQuizId(),
					'online' => 1,
					'sort' => $sort !== null ? $sort : ($this->getMaxSort($question->getQuizId()) + 1),
					'title' => $question->getTitle(),
					'points' => $question->getPoints(),
					'question' => $question->getQuestion(),
					'correct_msg' => $question->getCorrectMsg(),
					'incorrect_msg' => $question->getIncorrectMsg(),
					'correct_same_text' => (int)$question->isCorrectSameText(),
					'tip_enabled' => (int)$question->isTipEnabled(),
					'tip_msg' => $question->getTipMsg(),
					'answer_type' => $question->getAnswerType(),
					'show_points_in_box' => (int)$question->isShowPointsInBox(),
					'answer_points_activated' => (int)$question->isAnswerPointsActivated(),
					'answer_data' => $question->getAnswerData(true),
					'category_id' => $question->getCategoryId(),
					'answer_points_diff_modus_activated' => (int)$question->isAnswerPointsDiffModusActivated(),
					'disable_correct' => (int)$question->isDisableCorrect(),
					'matrix_sort_answer_criteria_width' => $question->getMatrixSortAnswerCriteriaWidth(),
					'name' => $name
				),
				array('%d', '%d', '%d', '%s', '%d', '%s', '%s', '%s', '%d', '%d', '%s', '%s', '%d', '%d', '%s', '%d', '%d', '%d', '%d','%s')
			);
			
			$question->setId($this->_wpdb->insert_id);
		}
		
		return $question;
	}
	

}