<?php

namespace uncanny_automator;

/**
 * Class LD_LESSONDONE
 * @package uncanny_automator
 */
class LD_LESSONDONE {

	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'LD';

	private $trigger_code;
	private $trigger_meta;

	/**
	 * Set up Automator trigger constructor.
	 */
	public function __construct() {
		$this->trigger_code = 'LESSONDONE';
		$this->trigger_meta = 'LDLESSON';
		$this->define_trigger();

		add_action( 'wp_ajax_select_lesson_from_course_LESSONDONE', array( $this, 'select_lesson_from_course_func' ) );
	}

	/**
	 * Define and register the trigger by pushing it into the Automator object
	 */
	public function define_trigger() {

		global $uncanny_automator;

		$args = [
			'post_type'      => 'sfwd-courses',
			'posts_per_page' => 999,
			'orderby'        => 'title',
			'order'          => 'ASC',
			'post_status'    => 'publish',
		];

		$options = $uncanny_automator->options->wp_query( $args, true, 'course' );

		$trigger = array(
			'author'              => $uncanny_automator->get_author_name( $this->trigger_code ),
			'support_link'        => $uncanny_automator->get_author_support_link( $this->trigger_code ),
			'integration'         => self::$integration,
			'code'                => $this->trigger_code,
			/* Translators: 1:Lessons 2:Number of times*/
			'sentence'            => sprintf( __( 'User completes {{a lesson:%1$s}} {{a number of:%2$s}} times', 'uncanny-automator' ), $this->trigger_meta, 'NUMTIMES' ),
			'select_option_name'  => __( 'User completes {{a lesson}}', 'uncanny-automator' ),
			'action'              => 'learndash_lesson_completed',
			'priority'            => 10,
			'accepted_args'       => 1,
			'validation_function' => array( $this, 'lesson_completed' ),
			'options'             => [
				$uncanny_automator->options->number_of_times(),
			],
			'options_group'       => [
				$this->trigger_meta => [
					$uncanny_automator->options->select_field_ajax(
						'LDCOURSE',
						__( 'Select a Course', 'uncanny-automator' ),
						$options,
						'',
						'',
						false,
						true,
						[
							'target_field' => $this->trigger_meta,
							'endpoint'     => 'select_lesson_from_course_LESSONDONE',
						]
					),
					$uncanny_automator->options->select_field( $this->trigger_meta, __( 'Select a Lesson', 'uncanny-automator' ), [ '' => __( 'Select a Course Above', 'uncanny-automator' ) ] ),
				],
			],
		);

		$uncanny_automator->register_trigger( $trigger );

		return;
	}

	/**
	 * Validation function when the trigger action is hit
	 *
	 * @param $data
	 */
	public function lesson_completed( $data ) {

		if ( empty( $data ) ) {
			return;
		}

		global $uncanny_automator;

		$user   = $data['user'];
		$lesson = $data['lesson'];

		$args = [
			'code'    => $this->trigger_code,
			'meta'    => $this->trigger_meta,
			'post_id' => $lesson->ID,
			'user_id' => $user->ID,
		];

		$uncanny_automator->maybe_add_trigger_entry( $args );
	}

	/**
	 * Return all the specific fields of a form ID provided in ajax call
	 */
	public function select_lesson_from_course_func() {

		global $uncanny_automator;

		// Nonce and post object validation
		$uncanny_automator->utilities->ajax_auth_check( $_POST );

		$fields = [];
		if ( isset( $_POST ) ) {

			$args = [
				'post_type'      => 'sfwd-lessons',
				'meta_query'     => array(
					'relation' => 'OR',
					array(
						'key'     => 'course_id',
						'value'   => absint( $_POST['value'] ),
						'compare' => '=',
					),
					array(
						'key'     => 'ld_course_' . absint( $_POST['value'] ),
						'value'   => absint( $_POST['value'] ),
						'compare' => '=',
					),
				),
				'posts_per_page' => 999,
				'orderby'        => 'title',
				'order'          => 'ASC',
				'post_status'    => 'publish',
			];


			$options = $uncanny_automator->options->wp_query( $args, true, 'lesson' );

			foreach ( $options as $lesson_id => $lesson_name ) {
				$fields[] = array(
					'value' => $lesson_id,
					'text'  => $lesson_name,
				);
			}
		}

		echo wp_json_encode( $fields );
		die();
	}
}
