<?php

namespace uncanny_automator;

/**
 * Class LD_COURSEDONE
 * @package uncanny_automator
 */
class LD_COURSEDONE {

	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'LD';

	private $trigger_code;
	private $trigger_meta;

	/**
	 * Set up Automator trigger constructor.
	 */
	public function __construct() {
		$this->trigger_code = 'COURSEDONE';
		$this->trigger_meta = 'LDCOURSE';
		$this->define_trigger();
	}

	/**
	 * Define and register the trigger by pushing it into the Automator object
	 */
	public function define_trigger() {

		global $uncanny_automator;

		$trigger = array(
			'author'              => $uncanny_automator->get_author_name(),
			'support_link'        => $uncanny_automator->get_author_support_link(),
			'integration'         => self::$integration,
			'code'                => $this->trigger_code,
			/* translators: 1:Courses 2:Number of Times */
			'sentence'            => sprintf( __( 'User completes {{a course:%1$s}} {{a number of:%2$s}} times', 'uncanny-automator' ), $this->trigger_meta, 'NUMTIMES' ),
			'select_option_name'  => __( 'User completes {{a course}}', 'uncanny-automator' ),
			'action'              => 'learndash_course_completed',
			'priority'            => 20,
			'accepted_args'       => 1,
			'validation_function' => array( $this, 'course_done' ),
			'options'             => [
				$uncanny_automator->options->all_ld_courses(),
				$uncanny_automator->options->number_of_times(),
			],
		);

		$uncanny_automator->register_trigger( $trigger );

		return;
	}

	/**
	 * Validation function when the trigger action is hit
	 *
	 * @param $data
	 */
	public function course_done( $data ) {

		global $uncanny_automator;

		if ( empty( $data ) ) {
			return;
		}

		$user   = $data['user'];
		$course = $data['course'];

		$args = [
			'code'    => $this->trigger_code,
			'meta'    => $this->trigger_meta,
			'post_id' => $course->ID,
			'user_id' => $user->ID,
		];

		$uncanny_automator->maybe_add_trigger_entry( $args );
	}
}
