<?php

namespace uncanny_automator;

if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Class Enable_Performance_Version
 * @package uncanny_automator
 */
class Enable_Performance_Version {

	/***
	 * @var string $settings_page_slug setting page slug.
	 */
	public $settings_page_slug;

	/**
	 * Class constructor
	 */
	public function __construct() {

		if ( defined( 'WP_DEBUG' ) ) {
			if ( false === WP_DEBUG ) {
				error_reporting( 0 );
			}
		}

		//add_action( 'admin_menu', array( $this, 'register_options_menu_page' ), 11 );
		add_action( 'admin_init', array( $this, 'uap_automator_register_option' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'scripts' ), 2 );
		add_action( 'admin_notices', [ $this, 'performance_notice' ], 99 );
		add_action( 'admin_init', [ $this, 'performance_notice_dismissed' ] );
	}

	/**
	 *
	 */
	public function performance_notice() {
		//$performance_version = get_option( 'uap_automator_performance_version', 0 );
		//Always enabled
		$performance_version = 1;
		//$ajax_prevent        = get_option( 'uap_automator_ajax_prevent', 1 );
		$ajax_prevent = 1;
		$user         = wp_get_current_user();
		if ( 1 === absint( $performance_version ) && 1 === absint( $ajax_prevent ) ) {
			//prevent
		} elseif ( in_array( 'administrator', $user->roles ) ) {
			if ( empty( get_user_meta( get_current_user_id(), 'dismiss_automator_notice', true ) ) ) {
				echo '<div class="notice notice-warning below-h2">
						<button id="automator_btn" type="button" style=" position: relative; top: 0; right: 1px; border: none; margin: 0; padding: 9px; background: 0 0; color: #0073aa; cursor: pointer; float: right;" >Dismiss<span class="screen-reader-text">Dismiss this notice.</span></button>
						<h4>' . sprintf( __( 'Uncanny Automator has new performance settings in version 1.5!  Some are enabled by default. <a href="%s">Review the settings</a>', 'uncanny-automator' ), admin_url( 'admin.php' ) . '?page=uncanny-performance-settings' ) . '</h4>
			</div>
			<script>
jQuery("#automator_btn").on("click", function(){    
    key = encodeURI("automator-notice-dismissed"); value = encodeURI("yes");
    var kvp = document.location.search.substr(1).split("&");
    var i=kvp.length; var x; while(i--) 
    {
        x = kvp[i].split("=");

        if (x[0]==key)
        {
            x[1] = value;
            kvp[i] = x.join("=");
            break;
        }
    }

    if(i<0) {kvp[kvp.length] = [key,value].join("=");}

    //this will reload the page, it\'s likely better to store this until finished
    document.location.search = kvp.join("&"); 
    });
</script>';
				?>
				<!--<div class="notice notice-success is-dismissible">
					<h4><?php /*echo sprintf( __( "Uncanny Automator has new performance settings in version 1.5!  <b>Some are enabled by default</b>.  <a href='%s'>Review the settings</a>", 'uncanny-automator' ), admin_url( 'admin.php' ) . '?page=uncanny-performance-settings' ); */ ?></h4>
				</div>-->
				<?php
			}
		}
	}

	/**
	 *
	 */
	function performance_notice_dismissed() {
		$user_id = get_current_user_id();
		if ( isset( $_GET['automator-notice-dismissed'] ) ) {
			add_user_meta( $user_id, 'dismiss_automator_notice', 'true', true );
		}
	}

	/**
	 * Loading script for logs.
	 *
	 * @param string $hook hook name.
	 */
	public function scripts( $hook ) {

		if ( strpos( $hook, $this->settings_page_slug ) ) {
			// Automator assets.
			wp_enqueue_style( 'uap-admin-performance-settings', Utilities::get_css( 'admin/performance.css' ), array(), Utilities::get_version() );
		}
	}

	/**
	 * Register settings.
	 */
	public function uap_automator_register_option() {
		if ( isset( $_POST['uap_automator_nonce'] ) ) {
			if ( isset( $_POST['uap_automator_performance_version'] ) ) {
				update_option( 'uap_automator_performance_version', 1 );
			} else {
				update_option( 'uap_automator_performance_version', 0 );
			}
			if ( isset( $_POST['uap_automator_ajax_prevent'] ) ) {
				update_option( 'uap_automator_ajax_prevent', 1 );
			} else {
				update_option( 'uap_automator_ajax_prevent', 0 );
			}
		}
	}

	/**
	 * Create Plugin options menu.
	 */
	public function register_options_menu_page() {

		$page_title = __( 'Uncanny Automator Performance (Beta) Settings', 'uncanny-automator' );

		$capability = 'manage_options';

		$menu_title               = 'Performance (Beta)';
		$menu_slug                = 'uncanny-performance-settings';
		$this->settings_page_slug = $menu_slug;
		$function                 = array( $this, 'options_menu_page_output' );

		add_submenu_page( 'uncanny-activities', $page_title, $menu_title, $capability, $menu_slug, $function );


	}

	/**
	 * Create Plugin options menu output.
	 */
	public function options_menu_page_output() {

		$performance_version = get_option( 'uap_automator_performance_version', 0 );
		$ajax_prevent        = get_option( 'uap_automator_ajax_prevent', 1 );
		?>
		<div class="wrap"> <!-- WP container -->
			<div class="uo-purge">
				<div class="uo-purge-content">
					<form class="uo-purge-content-form" method="POST" action="<?php echo admin_url( 'admin.php' ) ?>?page=uncanny-performance-settings">
						<?php wp_nonce_field( 'uap_automator_nonce', 'uap_automator_nonce' ); ?>
						<div class="uo-purge-content-top">
							<div class="uo-purge-content-info">
								<div class="uo-purge-content-title">
									<?php _e( 'Enable Performance Enhancements (Beta)', 'uncanny-automator' ); ?>
								</div>
								<div class="uo-purge-content-description">
									<?php _e( 'These settings are in beta. Enable these settings to improve site responsiveness with Automator enabled. Disable and <a href="mailto:support@automatorplugin.com">notify our support team</a> if you experience any issues with these settings enabled.', 'uncanny-automator' ); ?>
								</div>
								<div class="uo-purge-content-form">
									<input id="uo-enable-performance-version"
									       name="uap_automator_performance_version"
									       type="checkbox"
										<?php if ( 1 === absint( $performance_version ) ) {
											echo 'checked="checked"';
										} ?>
										   value="1"> Enable performance mode
									<p><?php _e( 'Reduce the number of queries Automator performs on each page load.', 'uncanny-automator' ) ?></p>
								</div>
								<div class="uo-purge-content-form">
									<input id="uo-enable-ajax-prevent"
									       name="uap_automator_ajax_prevent"
									       type="checkbox"
										<?php if ( 1 === absint( $ajax_prevent ) ) {
											echo 'checked="checked"';
										} ?>
										   value="1"> Prevent Automator from initializing multiple times on some pages
									<p><?php _e( 'Prevents Automator from loading on AJAX and REST API calls.', 'uncanny-automator' ) ?></p>
								</div>
							</div>
						</div>
						<div class="uo-purge-content-footer">
							<button type="submit" name="uap_automator_purgedays_save" class="uo-purge-btn uo-purge-btn--primary">
								<?php _e( 'Save Settings', 'uncanny-automator' ); ?>
							</button>
						</div>
					</form>
				</div>
			</div>
		</div>
		<?php
	}

}

