<?php

namespace Uncanny_Automator_Pro;

/**
 * Class WP_SENDWEBHOOK
 * @package Uncanny_Automator_Pro
 */
class WP_SENDWEBHOOK {

	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'WP';

	private $action_code;
	private $action_meta;
	private $number_of_keys;

	/**
	 * Set up Automator action constructor.
	 */
	public function __construct() {
		$this->action_code    = 'WPSENDWEBHOOK';
		$this->action_meta    = 'WPWEBHOOK';
		$this->number_of_keys = 7;
		add_action( 'wp_ajax_nopriv_sendtest_wp_webhook', array( $this, 'sendtest_webhook' ) );
		add_action( 'wp_ajax_sendtest_wp_webhook', array( $this, 'sendtest_webhook' ) );
		$this->define_action();

	}

	/**
	 * Define and register the action by pushing it into the Automator object
	 */
	public function define_action() {

		global $uncanny_automator;

		$action = array(
			'author'             => $uncanny_automator->get_author_name( $this->action_code ),
			'support_link'       => $uncanny_automator->get_author_support_link( $this->action_code ),
			'integration'        => self::$integration,
			'code'               => $this->action_code,
			/* Translators: 1:Web Hooks*/
			'sentence'           => sprintf( __( 'Send data to {{webhook:%1$s}}', 'uncanny-automator' ), $this->action_meta ),
			'select_option_name' => __( 'Send data to {{webhook}}', 'uncanny-automator' ),
			'priority'           => 10,
			'accepted_args'      => 1,
			'execution_function' => array( $this, 'send_webhook' ),
			'options_group'      => [
				$this->action_meta => [
					$uncanny_automator->options->text_field( 'WEBHOOKURL', __( 'Webhook URL:', 'uncanny-automator' ), true, 'url', '', true ),
					$uncanny_automator->options->text_field( 'KEY1', __( 'Key 1:', 'uncanny-automator' ), true, 'text', '', false ),
					$uncanny_automator->options->text_field( 'VALUE1', __( 'Value 1:', 'uncanny-automator' ), true, 'text', '', false ),
					$uncanny_automator->options->text_field( 'KEY2', __( 'Key 2:', 'uncanny-automator' ), true, 'text', '', false ),
					$uncanny_automator->options->text_field( 'VALUE2', __( 'Value 2:', 'uncanny-automator' ), true, 'text', '', false ),
					$uncanny_automator->options->text_field( 'KEY3', __( 'Key 3:', 'uncanny-automator' ), true, 'text', '', false ),
					$uncanny_automator->options->text_field( 'VALUE3', __( 'Value 3:', 'uncanny-automator' ), true, 'text', '', false ),
					$uncanny_automator->options->text_field( 'KEY4', __( 'Key 4:', 'uncanny-automator' ), true, 'text', '', false ),
					$uncanny_automator->options->text_field( 'VALUE4', __( 'Value 4:', 'uncanny-automator' ), true, 'text', '', false ),
					$uncanny_automator->options->text_field( 'KEY5', __( 'Key 5:', 'uncanny-automator' ), true, 'text', '', false ),
					$uncanny_automator->options->text_field( 'VALUE5', __( 'Value 5:', 'uncanny-automator' ), true, 'text', '', false ),
					$uncanny_automator->options->text_field( 'KEY6', __( 'Key 6:', 'uncanny-automator' ), true, 'text', '', false ),
					$uncanny_automator->options->text_field( 'VALUE6', __( 'Value 6:', 'uncanny-automator' ), true, 'text', '', false ),
					$uncanny_automator->options->text_field( 'KEY7', __( 'Key 7:', 'uncanny-automator' ), true, 'text', '', false ),
					$uncanny_automator->options->text_field( 'VALUE7', __( 'Value 7:', 'uncanny-automator' ), true, 'text', '', false ),
				],
			],
			'buttons'            => [
				[
					'show_in'     => $this->action_meta,
					'text'        => __( 'Documentation', 'uncanny-automator' ),
					'css_classes' => 'btn btn--transparent',
					'on_click'    => 'function(){ window.open( "https://uncannyowl.com", "_blank" ); }',
				],
				[
					'show_in'     => $this->action_meta,
					'text'        => __( 'Send test', 'uncanny-automator' ),
					'css_classes' => 'btn btn--red',
					'on_click'    => $this->send_test_js(),
					'modules'     => [ 'markdown' ]
				],
			],
		);

		$uncanny_automator->register_action( $action );
	}

	/**
	 * Anonymous JS function invoked as callback when clicking
	 * the custom button "Send test". The JS function requires
	 * the JS module "markdown". Make sure it's included in
	 * the "modules" array
	 * 
	 * @return string The JS code
	 */
	
	public function send_test_js(){
		// Start output
		ob_start();

		// It's option to add the <script> tags
		// This must have only one anonymous function
		?>

		<script>

		// Do when the user clicks on send test
		function( $button, data, modules ){
			// Add loading animation to the button
			$button.addClass( 'btn--loading btn--disabled' );

			// Get the data we're going to send to the AJAX request
			let dataToBeSent = {
				action:         'sendtest_wp_webhook',
				nonce:          UncannyAutomator.nonce,

				integration_id: data.item.integrationCode,
				item_id:        data.item.id,
				values:         data.values
			}

			// Do AJAX
			$.ajax({
			    method:   'POST',
			    dataType: 'json',
			    url:      ajaxurl,
			    data:     dataToBeSent,

			    success: function( response ){
			    	// Remove loading animation from the button
					$button.removeClass( 'btn--loading btn--disabled' );

					// Create notice
					// But first check if the message is defined
					if ( typeof response.message !== 'undefined' ){
						// Get notice type
						let noticeType = typeof response.type !== 'undefined' ? response.type : 'gray';

						// Parse message using markdown
						let markdown = new modules.Markdown( response.message );
						
						// Create notice
						let $notice = $( '<div/>', {
							'class': 'item-options__notice item-options__notice--' + noticeType
						});

						// Get markdown HTML
						let $message = markdown.getHTML();

						// Add message to the notice container
						$notice.html( $message );

						// Get the notices container
						let $noticesContainer = $( '.item[data-id="' + data.item.id + '"] .item-options__notices' );

						// Add notice
						$noticesContainer.html( $notice ); 
					}
			    },

			    statusCode: {
			        403: function(){
			            location.reload();
			        }
			    },

			    fail: function ( response ){}
			});
		}

		</script>

		<?php

		// Get output
		$output = ob_get_clean();

		// Return output
		return $output;
	}

	/**
	 * Validation function when the action is hit
	 *
	 * @param $user_id
	 * @param $action_data
	 * @param $recipe_id
	 * @param $args
	 */
	public function send_webhook( $user_id, $action_data, $recipe_id, $args ) {

		global $uncanny_automator;
		$key_values  = array();
		$webhook_url = $uncanny_automator->parse->text( $action_data['meta']['WEBHOOKURL'], $recipe_id, $user_id, $args );

		for ( $i = 1; $i <= $this->number_of_keys; $i ++ ) {

			$key                = $uncanny_automator->parse->text( $action_data['meta'][ 'KEY' . $i ], $recipe_id, $user_id, $args );
			$value              = $uncanny_automator->parse->text( $action_data['meta'][ 'VALUE' . $i ], $recipe_id, $user_id, $args );
			$key_values[ $key ] = $value;
		}


		$fields_string = http_build_query( $key_values );

		$ch = curl_init();
		curl_setopt( $ch, CURLOPT_URL, $webhook_url );
		curl_setopt( $ch, CURLOPT_POST, 1 );
		curl_setopt( $ch, CURLOPT_POSTFIELDS, $fields_string );
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );

		$result   = curl_exec( $ch );
		$response = curl_getinfo( $ch );

		curl_close( $ch );
		if ( 200 !== $response['http_code'] ) {
			$error_message = 'Error in webhook response found.';
			$uncanny_automator->complete_action( $user_id, $action_data, $recipe_id, $error_message );

			return;
		}

		$uncanny_automator->complete_action( $user_id, $action_data, $recipe_id );
	}

	/**
	 * @param $_POST
	 */
	public function sendtest_webhook() {

		global $uncanny_automator;

		$uncanny_automator->utilities->ajax_auth_check( $_POST );

		$key_values  = array();
		$values      = $_POST['values'];
		$webhook_url = $values['WEBHOOKURL'];

		if ( empty( $webhook_url ) ) {
			wp_send_json( array(
				'type'    => 'error',
				'message' => __( 'Please enter a valid webhook url.', 'uncanny-automator' ),
			) );
		}

		for ( $i = 1; $i <= $this->number_of_keys; $i ++ ) {
			$key                = $values[ 'KEY' . $i ];
			$value              = $values[ 'VALUE' . $i ];
			$key_values[ $key ] = $value;
		}

		$fields_string = http_build_query( $key_values );

		$ch = curl_init();
		curl_setopt( $ch, CURLOPT_URL, $webhook_url );
		curl_setopt( $ch, CURLOPT_POST, 1 );
		curl_setopt( $ch, CURLOPT_POSTFIELDS, $fields_string );
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );

		$result   = curl_exec( $ch );
		$response = curl_getinfo( $ch );
		curl_close( $ch );

		if ( 200 !== $response['http_code'] ) {
			/* Translators: 1:Webhook URL*/
			$error_message = sprintf( __( 'Error in webhook (%s) response found.', 'uncanny-automator' ), $webhook_url );
			wp_send_json( array(
				'type'    => 'error',
				'message' => $error_message,
			) );
		}

		/* Translators: 1:Webhook URL*/
		$success_message = sprintf( __( 'Successfully sent data on %s.', 'uncanny-automator' ), $webhook_url );

		wp_send_json( array(
			'type'    => 'success',
			'message' => $success_message,
		) );
	}
}
