<?php

namespace Uncanny_Automator_Pro;

/**
 * Class WC_VIEWPRODUCT
 * @package Uncanny_Automator_Pro
 */
class WC_VIEWPRODUCT {

	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'WC';

	private $trigger_code;
	private $trigger_meta;

	/**
	 * SetAutomatorTriggers constructor.
	 */
	public function __construct() {
		$this->trigger_code        = 'VIEWWOOPRODUCT';
		$this->trigger_meta        = 'WOOPRODUCT';
		$this->define_trigger();
	}

	/**
	 *
	 */
	public function define_trigger() {
		global $uncanny_automator;

		$trigger = array(
			'author'              => $uncanny_automator->get_author_name(),
			'support_link'        => $uncanny_automator->get_author_support_link(),
			'integration'         => self::$integration,
			'code'                => $this->trigger_code,
			'sentence'            => sprintf( __( 'User views {{a product:%1$s}} {{a number of:%2$s}} times', 'uncanny-automator' ), $this->trigger_meta, 'NUMTIMES' ),
			'select_option_name'  => __( 'User views {{a product}}', 'uncanny-automator' ),
			'action'              => 'template_redirect',
			'priority'            => 90,
			'accepted_args'       => 1,
			'validation_function' => array( $this, 'view_woo_product' ),
			// very last call in WP, we need to make sure they viewed the page and didn't skip before is was fully viewable
			'options'             => [
				$uncanny_automator->options->all_wc_products(),
				$uncanny_automator->options->number_of_times( 'product' ),
			],
		);

		$uncanny_automator->register_trigger( $trigger );

		return;
	}

	/**
	 *
	 */
	public function view_woo_product() {

		global $uncanny_automator;

		global $post;

		if ( 'product' !== $post->post_type ) {
			return;
		}

		$user_id = get_current_user_id();
		$args    = [
			'code'    => $this->trigger_code,
			'meta'    => $this->trigger_meta,
			'post_id' => $post->ID,
			'user_id' => $user_id,
		];

		$arr = $uncanny_automator->maybe_add_trigger_entry( $args, false );

		if ( $arr ) {
			foreach ( $arr as $result ) {
				if ( true === $result['result'] ) {
					$uncanny_automator->maybe_trigger_complete( $result['args'] );
				}
			}
		}
	}

}
