<?php

namespace Uncanny_Automator_Pro;

/**
 * Class WC_ORDERCOMPLETE
 * @package Uncanny_Automator_Pro
 */
class WC_ORDERCOMPLETE {

	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'WC';

	private $trigger_code;
	private $trigger_meta;


	/**
	 * SetAutomatorTriggers constructor.
	 */
	public function __construct() {
		$this->trigger_code        = 'WCORDERCOMPLETE';
		$this->trigger_meta        = 'WOORDERTOTAL';
		$this->define_trigger();
	}

	/**
	 *
	 */
	public function define_trigger() {

		global $uncanny_automator;

		$trigger = array(
			'author'              => $uncanny_automator->get_author_name( $this->trigger_code ),
			'support_link'        => $uncanny_automator->get_author_support_link( $this->trigger_code ),
			'integration'         => self::$integration,
			'code'                => $this->trigger_code,
			'sentence'            => sprintf( __( 'User completes an order and total is {{equal to:%1$s}} ${{0:%2$s}} and placed {{a number of:%3$s}} times', 'uncanny-automator' ), 'NUMBERCOND', $this->trigger_meta, 'NUMTIMES' ),
			'select_option_name'  => __( 'User completes {{an order}}', 'uncanny-automator' ),
			'action'              => 'woocommerce_order_status_changed',
			'priority'            => 30,
			'accepted_args'       => 4,
			'validation_function' => array( $this, 'order_completed' ),
			'options'             => [
				$uncanny_automator->options->float_field( $this->trigger_meta, __( 'Order price', 'uncanny-automator' ) ),
				$uncanny_automator->options->less_or_greater_than(),
				$uncanny_automator->options->number_of_times(),
			]
		);

		$uncanny_automator->register_trigger( $trigger );

		return;
	}

	/**
	 * @param $order_id
	 * @param $from_status
	 * @param $to_status
	 * @param $this_order
	 */
	public function order_completed( $order_id, $from_status, $to_status, $this_order ) {

		if ( ! $order_id ) {
			return;
		}
		global $uncanny_automator;

		if ( 'completed' === (string) $to_status ) {

			$order               = wc_get_order( $order_id );
			$user_id             = $order->get_user_id();
			$order_total         = $order->get_total();
			$recipes             = $uncanny_automator->get->recipes_from_trigger_code( $this->trigger_code );
			$required_totals     = $uncanny_automator->get->meta_from_recipes( $recipes, $this->trigger_meta );
			$required_conditions = $uncanny_automator->get->meta_from_recipes( $recipes, 'NUMBERCOND' );
			$matched_recipe_ids  = [];
			foreach ( $recipes as $recipe_id => $recipe ) {
				foreach ( $recipe['triggers'] as $trigger ) {
					$trigger_id = $trigger['ID'];
					if ( $uncanny_automator->utilities->match_condition_vs_number( $required_conditions[ $recipe_id ][ $trigger_id ], $required_totals[ $recipe_id ][ $trigger_id ], $order_total ) ) {
						$matched_recipe_ids[] = [
							'recipe_id'  => $recipe_id,
							'trigger_id' => $trigger_id,
						];
					}
				}
			}

			if ( ! empty( $matched_recipe_ids ) ) {
				foreach ( $matched_recipe_ids as $matched_recipe_id ) {
					$args = [
						'code'             => $this->trigger_code,
						'meta'             => $this->trigger_meta,
						'user_id'          => $user_id,
						'recipe_to_match'  => $matched_recipe_id['recipe_id'],
						'trigger_to_match' => $matched_recipe_id['trigger_id'],
						'ignore_post_id'   => true,
					];

					$uncanny_automator->maybe_add_trigger_entry( $args );
				}
			}
		}
	}

}