<?php

namespace Uncanny_Automator_Pro;

/**
 * Class ANON_NF_SUBFIELD
 *
 * @package Uncanny_Automator_Pro
 */
class ANON_NF_SUBFIELD {

	/**
	 * Integration code
	 *
	 * @var string
	 */
	public static $integration = 'NF';

	private $trigger_code;
	private $trigger_meta;

	/**
	 * Set up Automator trigger constructor.
	 */
	public function __construct() {
		$this->trigger_code = 'ANONNFSUBFIELD';
		$this->trigger_meta = 'ANONNFFORMS';
		$this->define_trigger();

		add_action( 'wp_ajax_select_form_fields_ANONNFFORMS', array( $this, 'select_form_fields_func' ) );
	}

	/**
	 * Define and register the trigger by pushing it into the Automator object
	 */
	public function define_trigger() {

		global $uncanny_automator;

		$trigger = array(
			'author'              => $uncanny_automator->get_author_name( $this->trigger_code ),
			'support_link'        => $uncanny_automator->get_author_support_link( $this->trigger_code ),
			'integration'         => self::$integration,
			'code'                => $this->trigger_code,
			/* translators: 1:Forms 2:Number of Times */
			'sentence'            => sprintf( __( 'A {{Ninja Form:%1$s}} is submitted with {{a specific value:%2$s}} in {{a specific field:%3$s}}', 'uncanny-automator' ), $this->trigger_meta, 'SUBVALUE', $this->trigger_code ),
			'select_option_name'  => __( 'A {{Ninja Form}} is submitted with {{a specific value}} in {{a specific field}}', 'uncanny-automator' ),
			'action'              => 'ninja_forms_after_submission',
			'type'                => 'anonymous',
			'priority'            => 20,
			'accepted_args'       => 1,
			'validation_function' => array( $this, 'nform_submit' ),
			'options'             => [],
			'options_group'       => [
				$this->trigger_meta => [
					$uncanny_automator->options->list_ninja_forms(
						null,
						$this->trigger_meta,
						[
							'token'        => false,
							'is_ajax'      => true,
							'target_field' => $this->trigger_code,
							'endpoint'     => 'select_form_fields_ANONNFFORMS',
						]
					),
					$uncanny_automator->options->select_field( $this->trigger_code, __( 'Select a field', 'uncanny-automator' ) ),
					$uncanny_automator->options->text_field( 'SUBVALUE' ),
				],
			],
		);

		$uncanny_automator->register_trigger( $trigger );

		return true;
	}

	/**
	 * Validation function when the trigger action is hit
	 *
	 * @param array $entry form submission.
	 */
	public function nform_submit( $entry ) {

		global $uncanny_automator;
		$recipes = $uncanny_automator->get->recipes_from_trigger_code( $this->trigger_code );

		if ( empty( $entry ) ) {
			return;
		}

		$conditions = $this->match_condition( $entry, $recipes, $this->trigger_meta, $this->trigger_code, 'SUBVALUE' );

		if ( ! $conditions ) {
			return;
		}

		$user_id = get_current_user_id();
		if ( ! empty( $conditions ) ) {
			foreach ( $conditions['recipe_ids'] as $recipe_id ) {
				if ( ! $uncanny_automator->is_recipe_completed( $recipe_id, $user_id ) ) {
					$args = [
						'code'            => $this->trigger_code,
						'meta'            => $this->trigger_meta,
						'recipe_to_match' => $recipe_id,
						'ignore_post_id'  => true,
						'user_id'         => $user_id,
					];

					$uncanny_automator->maybe_add_trigger_entry( $args );
				}
			}
		}
	}

	/**
	 * Matching form fields values.
	 *
	 * @param array       $entry form data.
	 * @param array|null  $recipes recipe data.
	 * @param string|null $trigger_meta trigger meta key.
	 * @param string|null $trigger_code trigger code key.
	 * @param string|null $trigger_second_code trigger second code key.
	 *
	 * @return array|bool
	 */
	public function match_condition( $entry, $recipes = null, $trigger_meta = null, $trigger_code = null, $trigger_second_code = null ) {
		if ( null === $recipes ) {
			return false;
		}

		$matches        = [];
		$recipe_ids     = [];
		$entry_to_match = $entry['form_id'];
		foreach ( $recipes as $recipe ) {
			foreach ( $recipe['triggers'] as $trigger ) {
				if ( key_exists( $trigger_meta, $trigger['meta'] ) && $trigger['meta'][ $trigger_meta ] === $entry_to_match ) {
					$matches[ $recipe['ID'] ]    = [
						'field' => $trigger['meta'][ $trigger_code ],
						'value' => $trigger['meta'][ $trigger_second_code ],
					];
					$recipe_ids[ $recipe['ID'] ] = $recipe['ID'];
					break;
				}
			}
		}

		if ( ! empty( $matches ) ) {
			foreach ( $matches as $recipe_id => $match ) {
				if ( $entry['fields'][ $match['field'] ]['value'] !== $match['value'] ) {
					unset( $recipe_ids[ $recipe_id ] );
				}
			}
		}

		if ( ! empty( $recipe_ids ) ) {
			return [
				'recipe_ids' => $recipe_ids,
				'result'     => true,
			];
		}

		return false;
	}

	/**
	 * Return all the specific fields of a form ID provided in ajax call
	 */
	public function select_form_fields_func() {

		global $uncanny_automator;

		$uncanny_automator->utilities->ajax_auth_check( $_POST );

		$fields = [];
		if ( isset( $_POST ) ) {
			$form_id = $_POST['value'];
			$meta    = \Ninja_Forms()->form( $form_id )->get_fields();
			if ( is_array( $meta ) ) {
				foreach ( $meta as $field ) {
					if ( $field->get_setting( 'type' ) !== 'submit' ) {
						$fields[] = array(
							'value' => $field->get_id(),
							'text'  => $field->get_setting( 'label' ),
						);
					}
				}
			}
		}
		echo wp_json_encode( $fields );
		die();
	}
}
