<?php

namespace Uncanny_Automator_Pro;

/**
 * Class LF_ENRLMEMBERSHIP_A
 * @package Uncanny_Automator_Pro
 */
class LF_ENRLMEMBERSHIP_A {

	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'LF';

	private $action_code;
	private $action_meta;

	/**
	 * Set up Automator action constructor.
	 */
	public function __construct() {
		$this->action_code = 'LFENRLMEMBERSHIP-A';
		$this->action_meta = 'LFMEMBERSHIP';
		$this->define_action();
	}

	/**
	 * Define and register the action by pushing it into the Automator object
	 */
	public function define_action() {

		global $uncanny_automator;

		$action = array(
			'author'             => $uncanny_automator->get_author_name( $this->action_code ),
			'support_link'       => $uncanny_automator->get_author_support_link( $this->action_code ),
			'integration'        => self::$integration,
			'code'               => $this->action_code,
			/* Translators: 1:Courses*/
			'sentence'           => sprintf( __( 'Enroll user in {{a membership:%1$s}}', 'uncanny-automator' ), $this->action_meta ),
			'select_option_name' => __( 'Enroll user in {{a membership}}', 'uncanny-automator' ),
			'priority'           => 10,
			'accepted_args'      => 1,
			'execution_function' => array( $this, 'lf_enroll_in_membership' ),
			'options'            => [
				$uncanny_automator->options->all_lf_memberships( __( 'Select a Membership', 'uncanny-automator' ), $this->action_meta, false ),
			],
		);

		$uncanny_automator->register_action( $action );
	}


	/**
	 * Validation function when the action is hit
	 *
	 * @param $user_id
	 * @param $action_data
	 * @param $recipe_id
	 */
	public function lf_enroll_in_membership( $user_id, $action_data, $recipe_id ) {

		global $uncanny_automator;

		if ( ! function_exists( 'llms_enroll_student' ) ) {
			$error_message = 'The function llms_enroll_student does not exist';
			$uncanny_automator->complete_action( $user_id, $action_data, $recipe_id, $error_message );

			return;
		}

		$membership_id = $action_data['meta'][ $this->action_meta ];

		// Enroll to New Membership.
		llms_enroll_student( $user_id, $membership_id );

		$uncanny_automator->complete_action( $user_id, $action_data, $recipe_id );
	}
}
