<?php

namespace Uncanny_Automator_Pro;

/**
 * Class LP_ENRLCOURSE_A
 * @package Uncanny_Automator_Pro
 */
class LP_ENRLCOURSE_A {

	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'LP';

	private $action_code;
	private $action_meta;

	/**
	 * Set up Automator action constructor.
	 */
	public function __construct() {
		$this->action_code = 'LPENRLCOURSE-A';
		$this->action_meta = 'LPCOURSE';
		$this->define_action();
	}

	/**
	 * Define and register the action by pushing it into the Automator object
	 */
	public function define_action() {

		global $uncanny_automator;

		$action = array(
			'author'             => $uncanny_automator->get_author_name( $this->action_code ),
			'support_link'       => $uncanny_automator->get_author_support_link( $this->action_code ),
			'integration'        => self::$integration,
			'code'               => $this->action_code,
			/* Translators: 1:Courses*/
			'sentence'           => sprintf( __( 'Enroll user in {{a course:%1$s}}', 'uncanny-automator' ), $this->action_meta ),
			'select_option_name' => __( 'Enroll user in {{a course}}', 'uncanny-automator' ),
			'priority'           => 10,
			'accepted_args'      => 3,
			'execution_function' => array( $this, 'lp_enroll_in_course' ),
			'options'            => [
				$uncanny_automator->options->all_lp_courses( null, 'LPCOURSE', false ),
			],
		);

		$uncanny_automator->register_action( $action );
	}

	/**
	 * Validation function when the action is hit
	 *
	 * @param $user_id
	 * @param $action_data
	 * @param $recipe_id
	 */
	public function lp_enroll_in_course( $user_id, $action_data, $recipe_id ) {

		global $uncanny_automator;

		if ( ! function_exists( 'learn_press_get_user' ) ) {
			$error_message = 'The function learn_press_get_user does not exist';
			$uncanny_automator->complete_action( $user_id, $action_data, $recipe_id, $error_message );

			return;
		}

		//loading LP user by user_id
		$user = learn_press_get_user( $user_id );

		$course_id = $action_data['meta'][ $this->action_meta ];
		// loading LP course by ID
		$course = learn_press_get_course( $course_id );

		//Enroll to New Course
		if ( $course && $course->exists() ) {
			$enrol_result = $user->enroll( $course_id, 0, true );
		}
		$uncanny_automator->complete_action( $user_id, $action_data, $recipe_id );
	}
}
