<?php

namespace Uncanny_Automator_Pro;

/**
 * Class LD_SUBMITASSIGNMENT
 * @package uncanny_automator
 */
class LD_SUBMITASSIGNMENT {

	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'LD';

	private $trigger_code;
	private $trigger_meta;

	/**
	 * Set up Automator trigger constructor.
	 */
	public function __construct() {
		$this->trigger_code = 'LD_SUBMITASSIGNMENT';
		$this->trigger_meta = 'LDLESSON';
		$this->define_trigger();

		add_action( 'wp_ajax_select_lesson_from_course_LD_SUBMITASSIGNMENT', array( $this, 'lesson_from_course_func' ), 15 );
	}

	/**
	 * Define and register the trigger by pushing it into the Automator object
	 */
	public function define_trigger() {

		global $uncanny_automator;

		$args = [
			'post_type'      => 'sfwd-courses',
			'posts_per_page' => 999,
			'orderby'        => 'title',
			'order'          => 'ASC',
			'post_status'    => 'publish',
		];

		$course_options = $uncanny_automator->options->wp_query( $args, true, 'course' );

		$trigger = array(
			'author'              => $uncanny_automator->get_author_name( $this->trigger_code ),
			'support_link'        => $uncanny_automator->get_author_support_link( $this->trigger_code ),
			'integration'         => self::$integration,
			'code'                => $this->trigger_code,
			/* Translators: 1:Topics 2:Number of times*///User submits
			'sentence'            => sprintf( __( 'User submits a/any assignment for {{lesson/topic:%1$s}}', 'uncanny-automator' ), $this->trigger_meta ),
			'select_option_name'  => __( 'User submits a/any assignment for {{lesson/topic}}', 'uncanny-automator' ),
			'action'              => 'learndash_assignment_uploaded',
			'priority'            => 10,
			'accepted_args'       => 2,
			'validation_function' => array( $this, 'assignment_uploaded' ),
			'options'             => [
				$uncanny_automator->options->number_of_times(),
			],
			'options_group'       => [
				$this->trigger_meta => [
					$uncanny_automator->options->select_field_ajax(
						'LDCOURSE',
						__( 'Select a Course', 'uncanny-automator' ),
						$course_options,
						'',
						'',
						false,
						true,
						[
							'target_field' => 'LDLESSON',
							'endpoint'     => 'select_lesson_from_course_LD_SUBMITASSIGNMENT',
						]
					),
					$uncanny_automator->options->select_field(
						$this->trigger_meta,
						__( 'Select a Lesson/Topic', 'uncanny-automator' )
					),
				],
			],
		);

		$uncanny_automator->register_trigger( $trigger );

		return;
	}

	/**
	 * Validation function when the trigger action is hit
	 *
	 * @param $assignment_post_id
	 * @param $assignment_meta
	 */
	public function assignment_uploaded( $assignment_post_id, $assignment_meta ) {

		if ( empty( $assignment_meta ) ) {
			return;
		}

		global $uncanny_automator;

		$args = [
			'code'    => $this->trigger_code,
			'meta'    => $this->trigger_meta,
			'post_id' => $assignment_meta['lesson_id'],
			'user_id' => $assignment_meta['user_id'],
		];

		$uncanny_automator->maybe_add_trigger_entry( $args );
	}

	/**
	 * Return all the specific fields of a form ID provided in ajax call
	 */
	public function lesson_from_course_func() {

		global $uncanny_automator;

		// Nonce and post object validation
		$uncanny_automator->utilities->ajax_auth_check( $_POST );
		$course_id = $_POST['value'];

		$fields = [];

		if ( isset( $_POST ) ) {

			if ( '-1' === $course_id ) {
				$args = [
					'post_type'      => 'sfwd-lessons',
					'posts_per_page' => 999,
					'orderby'        => 'title',
					'order'          => 'ASC',
					'post_status'    => 'publish',
				];
			} else {
				$args = [
					'post_type'      => 'sfwd-lessons',
					'meta_query'     => array(
						'relation' => 'OR',
						array(
							'key'     => 'course_id',
							'value'   => $course_id,
							'compare' => '=',
						),
						array(
							'key'     => 'ld_course_' . $course_id,
							'value'   => $course_id,
							'compare' => '=',
						),
					),
					'posts_per_page' => 999,
					'orderby'        => 'title',
					'order'          => 'ASC',
					'post_status'    => 'publish',
				];
			}

			$options = get_posts( $args );
			
			if( $course_id === '-1' ){
				$fields[] = [
					'value' => '-1',
					'text'  => __( 'Any Lesson/Topic', 'uncanny-automator' ),
				];
			}

			foreach ( $options as $lesson ) {
				if ( lesson_hasassignments( $lesson ) ) {
					$fields[] = [
						'value' => $lesson->ID,
						'text'  => $lesson->post_title,
					];
				}
				$course = $course_id !== '-1' ? $course_id : null;
				$topics = learndash_get_topic_list( $lesson->ID, $course );
				if ( ! empty( $topics ) ) {
					foreach ( $topics as $topic ) {
						if ( lesson_hasassignments( $topic ) ) {
							$fields[] = [
								'value' => $topic->ID,
								'text'  => $topic->post_title,
							];
						}
					}
				}
			}
		}

		echo wp_json_encode( $fields );
		die();
	}
}
