<?php

namespace Uncanny_Automator_Pro;

/**
 * Class GP_EARNSRANK
 * @package Uncanny_Automator_Pro
 */
class GP_EARNSRANK {

	/**
	 * Integration code
	 *
	 * @var string
	 */
	public static $integration = 'GP';

	private $trigger_code;
	private $trigger_meta;

	/**
	 * SetAutomatorTriggers constructor.
	 */
	public function __construct() {
		$this->trigger_code = 'GPEARNSRANK';
		$this->trigger_meta = 'GPRANK';
		$this->define_trigger();

		add_action( 'wp_ajax_select_ranks_from_types_EARNSRANK', array( $this, 'select_ranks_from_types_func' ) );
	}

	/**
	 * Define trigger settings
	 */
	public function define_trigger() {

		global $uncanny_automator;

		$trigger = array(
			'author'              => $uncanny_automator->get_author_name( $this->trigger_code ),
			'support_link'        => $uncanny_automator->get_author_support_link( $this->trigger_code ),
			'integration'         => self::$integration,
			'code'                => $this->trigger_code,
			'sentence'            => sprintf( __( 'User attains {{a Rank:%1$s}}', 'uncanny-automator' ), $this->trigger_meta ),
			'select_option_name'  => __( 'User attains {{a Rank}}', 'uncanny-automator' ),
			'action'              => 'gamipress_update_user_rank',
			'priority'            => 20,
			'accepted_args'       => 5,
			'validation_function' => array( $this, 'earned_rank' ),
			'options'             => [],
			'options_group'       => [
				$this->trigger_meta => [
					$uncanny_automator->options->list_gp_rank_types(
						__( 'Select a Rank Type', 'uncanny-automator' ),
						'GPRANKTYPES',
						[
							'token'        => false,
							'is_ajax'      => true,
							'target_field' => $this->trigger_meta,
							'endpoint'     => 'select_ranks_from_types_EARNSRANK',
						]
					),
					$uncanny_automator->options->select_field( $this->trigger_meta, __( 'Select a Rank', 'uncanny-automator' ), [ '' => __( 'Select a Type Above', 'uncanny-automator' ) ] ),
				],
			],
		);

		$uncanny_automator->register_trigger( $trigger );

		return;
	}

	/**
	 * Trigger handler function.
	 *
	 * @param sting  $user_id .
	 * @param object $new_rank .
	 * @param object $old_rank .
	 * @param string $admin_id .
	 * @param string $achievement_id .
	 */
	public function earned_rank( $user_id, $new_rank, $old_rank, $admin_id, $achievement_id ) {
		global $uncanny_automator;
		if( ! $user_id ) {
			$user_id = get_current_user_id();
		}
		if ( empty( $user_id ) ) {
			return;
		}

		$args = [
			'code'    => $this->trigger_code,
			'meta'    => $this->trigger_meta,
			'post_id' => absint( $new_rank->ID ),
			'user_id' => $user_id,
		];

		$uncanny_automator->maybe_add_trigger_entry( $args );
	}

	/**
	 * Return all the specific fields of a form ID provided in ajax call
	 */
	public function select_ranks_from_types_func() {

		global $uncanny_automator;

		// Nonce and post object validation.
		$uncanny_automator->utilities->ajax_auth_check( $_POST );

		$fields = [];
		if ( isset( $_POST ) ) {

			$args = [
				'post_type'      => $_POST['value'],
				'posts_per_page' => 999,
				'orderby'        => 'title',
				'order'          => 'ASC',
				'post_status'    => 'publish',
			];
		}

		$options = $uncanny_automator->options->wp_query( $args, false, 'awards' );

		foreach ( $options as $award_id => $award_name ) {
			$fields[] = array(
				'value' => $award_id,
				'text'  => $award_name,
			);
		}

		echo wp_json_encode( $fields );
		die();
	}
}
