<?php

namespace Uncanny_Automator_Pro;

/**
 * Class GP_EARNSPOINTS
 * @package Uncanny_Automator_Pro
 */
class GP_EARNSPOINTS {

	/**
	 * Integration code
	 *
	 * @var string
	 */
	public static $integration = 'GP';

	private $trigger_code;
	private $trigger_meta;

	/**
	 * SetAutomatorTriggers constructor.
	 */
	public function __construct() {
		$this->trigger_code = 'GPEARNSPOINTS';
		$this->trigger_meta = 'GPPOINTS';
		$this->define_trigger();
	}

	/**
	 * Define trigger settings
	 */
	public function define_trigger() {

		global $uncanny_automator;

		$trigger = array(
			'author'              => $uncanny_automator->get_author_name( $this->trigger_code ),
			'support_link'        => $uncanny_automator->get_author_support_link( $this->trigger_code ),
			'integration'         => self::$integration,
			'code'                => $this->trigger_code,
			'sentence'            => sprintf( __( 'User earns {{a number:%1$s}} of {{points:%2$s}}', 'uncanny-automator' ), 'GPPOINTVALUE', $this->trigger_meta ),
			'select_option_name'  => __( 'User earns {{a number}} of {{points}}', 'uncanny-automator' ),
			'action'              => 'gamipress_update_user_points',
			'priority'            => 20,
			'accepted_args'       => 8,
			'validation_function' => array( $this, 'earned_points' ),
			'options'             => [],
			'options_group' => [
				$this->trigger_meta => [
					$uncanny_automator->options->list_gp_points_types( __( 'Select an Point Type', 'uncanny-automator' ), $this->trigger_meta,
						[
							'token'   => false,
							'is_ajax' => false,
						]
					),
					$uncanny_automator->options->integer_field( 'GPPOINTVALUE', __( 'Enter Points', 'uncanny-automator' ), false, '0' ),
				],
			],
		);

		$uncanny_automator->register_trigger( $trigger );

		return;
	}

	/**
	 * Trigger handler function.
	 *
	 * @param sting  $user_id .
	 * @param string $new_points .
	 * @param string $total_points .
	 * @param string $admin_id .
	 * @param string $achievement_id .
	 * @param string $points_type .
	 * @param string $reason .
	 * @param string $log_type .
	 */
	public function earned_points( $user_id, $new_points, $total_points, $admin_id, $achievement_id, $points_type, $reason, $log_type ) {
		global $uncanny_automator;
		$recipes = $uncanny_automator->get->recipes_from_trigger_code( $this->trigger_code );

		$entry = [ $points_type => $new_points ];
		$conditions = $this->match_condition( $entry, $recipes, $this->trigger_meta, $this->trigger_code, 'GPPOINTVALUE' );

		if ( ! $conditions ) {
			return;
		}

		$user_id = get_current_user_id();
		if ( ! empty( $conditions ) ) {
			foreach ( $conditions['recipe_ids'] as $recipe_id ) {
				if ( ! $uncanny_automator->is_recipe_completed( $recipe_id, $user_id ) ) {
					$args = [
						'code'            => $this->trigger_code,
						'meta'            => $this->trigger_meta,
						'recipe_to_match' => $recipe_id,
						'ignore_post_id'  => true,
						'user_id'         => $user_id,
					];

					$uncanny_automator->maybe_add_trigger_entry( $args );
				}
			}
		}
	}

	/**
	 * Points matching function.
	 *
	 * @param array $entry .
	 * @param null  $recipes .
	 * @param null  $trigger_meta .
	 * @param null  $trigger_code .
	 * @param null  $trigger_second_code .
	 *
	 * @return array|bool
	 */
	public function match_condition( $entry, $recipes = null, $trigger_meta = null, $trigger_code = null, $trigger_second_code = null ) {
		if ( null === $recipes ) {
			return false;
		}

		$matches        = [];
		$recipe_ids     = [];

		foreach ( $recipes as $recipe ) {
			foreach ( $recipe['triggers'] as $trigger ) {
				if ( key_exists( $trigger_meta, $trigger['meta'] ) ) {
					$matches[ $recipe['ID'] ]    = [
						'field' => $trigger['meta'][ $trigger_meta ],
						'value' => $trigger['meta'][ $trigger_second_code ],
					];
					$recipe_ids[ $recipe['ID'] ] = $recipe['ID'];
					break;
				}
			}
		}

		if ( ! empty( $matches ) ) {
			foreach ( $matches as $recipe_id => $match ) {
				if ( $entry[ $match['field'] ] != $match['value'] ) {
					unset( $recipe_ids[ $recipe_id ] );
				}
			}
		}

		if ( ! empty( $recipe_ids ) ) {
			return [ 'recipe_ids' => $recipe_ids, 'result' => true ];
		}

		return false;
	}
}
