<?php

namespace Uncanny_Automator_Pro;

/**
 * Class Add_Et_Integration
 * @package Uncanny_Automator_Pro
 */
class Add_Et_Integration {

	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'EC';

	/**
	 * Add_Integration constructor.
	 */
	public function __construct() {

		// Add directories to auto loader
		add_filter( 'uncanny_automator_pro_integration_directory', [ $this, 'add_integration_directory_func' ], 11 );
		
		// Add code, name and icon set to automator
		$this->add_integration_func();

		// Verify is the plugin is active based on integration code
		add_filter( 'uncanny_automator_maybe_add_integration', [
			$this,
			'plugin_active',
		], 30, 2 );
	}

	/**
	 * Only load this integration and its triggers and actions if the related plugin is active
	 *
	 * @param $status
	 * @param $plugin
	 *
	 * @return bool
	 */
	public function plugin_active( $status, $plugin ) {

		if ( self::$integration === $plugin ) {
			if ( class_exists( 'Tribe__Tickets__Main' ) ) {
				$status = true;
			} else {
				$status = false;
			}
		}

		return $status;
	}

	/**
	 * Set the directories that the auto loader will run in
	 *
	 * @param $directory
	 *
	 * @return array
	 */
	public function add_integration_directory_func( $directory ) {

		$directory[] = dirname( __FILE__ ) . '/actions';
		$directory[] = dirname( __FILE__ ) . '/triggers';
		$directory[] = dirname( __FILE__ ) . '/tokens';

		return $directory;
	}

	/**
	 * Register the integration by pushing it into the global automator object
	 */
	public function add_integration_func() {

		global $uncanny_automator;

		$uncanny_automator->register_integration( self::$integration, array(
			'name'        => 'The Events Calendar',
			'icon_16'     => \uncanny_automator\Utilities::get_integration_icon( 'integration-theeventscalendar-icon-16.png' ),
			'icon_32'     => \uncanny_automator\Utilities::get_integration_icon( 'integration-theeventscalendar-icon-32.png' ),
			'icon_64'     => \uncanny_automator\Utilities::get_integration_icon( 'integration-theeventscalendar-icon-64.png' ),
			'logo'        => \uncanny_automator\Utilities::get_integration_icon( 'integration-theeventscalendar.png' ),
			'logo_retina' => \uncanny_automator\Utilities::get_integration_icon( 'integration-theeventscalendar@2x.png' ),
		) );
	}
}