<?php

namespace Uncanny_Automator_Pro;

if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Class Activity_Log_Settings
 *
 * @package Uncanny_Automator_Pro
 */
class Activity_Log_Settings {

	/**
	 * Activity Page Title
	 *
	 * @var string $settings_page_slug setting page slug.
	 */
	public $settings_page_slug;

	/**
	 * Class constructor
	 */
	public function __construct() {

		if ( defined( 'WP_DEBUG' ) ) {
			if ( false === WP_DEBUG ) {
				error_reporting( 0 );
			}
		}

		add_action( 'admin_menu', array( $this, 'register_options_menu_page' ), 11 );
		add_action( 'admin_init', array( $this, 'uap_automator_register_option' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'scripts' ), 2 );
		add_action( 'uapro_auto_purge_logs', array( $this, 'delete_old_logs' ) );
	}

	/**
	 * Loading script for logs.
	 *
	 * @param string $hook hook name.
	 */
	public function scripts( $hook ) {

		if ( strpos( $hook, $this->settings_page_slug ) ) {
			// Automator assets.
			wp_enqueue_style( 'uap-admin-settings', Utilities::get_css( 'admin/purge.css' ), array(), Utilities::get_version() );
		}
	}

	/**
	 * Register settings.
	 */
	public function uap_automator_register_option() {
		// creates our settings in the options table.
		register_setting( 'uap_automator_settings', 'uap_automator_purge_days' );
	}

	/**
	 * Create Plugin options menu.
	 */
	public function register_options_menu_page() {

		$page_title = __( 'Uncanny Automator Settings', 'uncanny-automator' );

		$capability = 'manage_options';

		$menu_title               = 'Settings';
		$menu_slug                = 'uncannys-settings';
		$this->settings_page_slug = $menu_slug;
		$function                 = array( $this, 'options_menu_page_output' );

		add_submenu_page( 'uncanny-activities', $page_title, $menu_title, $capability, $menu_slug, $function );


	}

	/**
	 * Create Plugin options menu output.
	 */
	public function options_menu_page_output() {

		$purge_days = get_option( 'uap_automator_purge_days' );

		?>
        <div class="wrap"> <!-- WP container -->
            <div class="uo-purge">
                <div class="uo-purge-content">
                    <form class="uo-purge-content-form" method="POST" action="options.php">
						<?php settings_fields( 'uap_automator_settings' ); ?>
						<?php wp_nonce_field( 'uap_automator_nonce', 'uap_automator_nonce' ); ?>
                        <div class="uo-purge-content-top">
                            <div class="uo-purge-content-info">
                                <div class="uo-purge-content-title">
									<?php _e( 'Auto-Prune Activity Logs', 'uncanny-automator' ); ?>
                                </div>
                                <div class="uo-purge-content-description">
									<?php _e( 'Enter a number of days below to have trigger and action log entries older than the specified number of days automatically deleted from your site daily.  Trigger and action log entries will only be deleted for recipes with "Completed" status.', 'uncanny-automator' ); ?>
                                </div>
                                <div class="uo-purge-content-form">
                                    <input id="uo-purge-field"
                                           name="uap_automator_purge_days"
                                           type="text"
                                           value="<?php esc_attr_e( $purge_days ); ?>"
                                           placeholder="<?php _e( 'Days', 'uncanny-automator' ); ?>"
                                           required>
                                </div>
                            </div>
                        </div>
                        <div class="uo-purge-content-footer">
                            <button type="submit" name="uap_automator_purgedays_save" class="uo-purge-btn uo-purge-btn--primary">
								<?php _e( 'Save Settings', 'uncanny-automator' ); ?>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
		<?php
	}

	/**
	 * Delete old logs.
	 */
	public function delete_old_logs() {
		global $wpdb;

		$purge_days_limit = get_option( 'uap_automator_purge_days' );
		if ( intval( $purge_days_limit ) > 0 ) {
			$previous_time = date( 'Y-m-d', strtotime( '-' . $purge_days_limit . ' day' ) );
			$query         = "SELECT * FROM {$wpdb->prefix}uap_recipe_log WHERE date_time < '{$previous_time}' AND completed = 1 ";

			$recipes = $wpdb->get_results( $query );
			if ( ! empty( $recipes ) ) {
				foreach ( $recipes as $recipe ) {

					$args = array(
						'post_parent' => $recipe->automator_recipe_id,
						'post_status' => 'any',
						'post_type'   => 'uo-trigger',
						'numberposts' => 99,
					);

					$children = get_children( $args );

					if ( is_array( $children ) && count( $children ) > 0 ) {

						// Delete all the Children logs.
						foreach ( $children as $child ) {
							\uncanny_automator\Recipe_Post_Type::delete_trigger_logs( $child->ID );
						}
					}

					$args = array(
						'post_parent' => $recipe->automator_recipe_id,
						'post_status' => 'any',
						'post_type'   => 'uo-action',
						'numberposts' => 99,
					);

					$children = get_children( $args );

					if ( is_array( $children ) && count( $children ) > 0 ) {

						// Delete all the Children logs.
						foreach ( $children as $child ) {

							\uncanny_automator\Recipe_Post_Type::delete_action_logs( $child->ID );
						}
					}
					$args = array(
						'post_parent' => $recipe->automator_recipe_id,
						'post_status' => 'any',
						'post_type'   => 'uo-closure',
						'numberposts' => 99,
					);

					$children = get_children( $args );

					if ( is_array( $children ) && count( $children ) > 0 ) {

						// Delete all the Children of the Parent Page.
						foreach ( $children as $child ) {

							\uncanny_automator\Recipe_Post_Type::delete_closure_logs( $child->ID );
						}
					}
				}
			}
		}
	}

}

