<?php

if ( ! defined( 'WPINC' ) ) {
	die;
}

$csv_sample_file_link = plugins_url( basename( dirname( UO_FILE ) ) ) . '/src/assets/legacy/backend/csv/import_user_sample.csv';

?>

<div id="import-users-instructions">

	<p>
		<em>
			<?php _e( 'This is a complex module that allows users to be added to courses and LearnDash Groups from a CSV file. The Options tab includes settings that control how updates to users are managed and bulk imported into specific courses and groups. The Emails tab includes settings that control whether to send notifications to imported users and the email templates. These settings should be reviewed before proceeding with the import. Download the sample CSV on this page to see examples of the fields that can be included.', 'uncanny-pro-toolkit' ); ?>
		</em>
	</p>

	<p>
		<?php
		$kb_link = '<a href="https://www.uncannyowl.com/knowledge-base/import-learndash-users/">' . __( 'Knowledge Base article', 'uncanny-pro-toolkit' ) . '</a>';
		echo sprintf( _X( 'You should also review the %s which includes more detailed explanations and specific instructions for different use cases.', 'knowledge base url', 'uncanny-pro-toolkit' ), $kb_link ); ?>
	</p>

	<h2 class="options-header-container">
		<ul class="steps">
			<li class="current">
				<a href="#" data-show="step-1" title="">
					<span class="step-title"><?php _e( 'Step 1', 'uncanny-pro-toolkit' ); ?></span>
				</a>
			</li>
			<li></li>
		</ul>
		<div class="steps-description"><?php _e( 'Review Options', 'uncanny-pro-toolkit' ); ?></div>
	</h2>
	<p><?php _e( 'Use this tab to configure:', 'uncanny-pro-toolkit' ); ?></p>
	<ul class="import-user-list">
		<li><?php _e( 'Whether to update or ignore users that already exist on your website', 'uncanny-pro-toolkit' ); ?></li>
		<li><?php _e( 'Role to assign to imported users', 'uncanny-pro-toolkit' ); ?></li>
		<li><?php _e( 'Course(s) to enroll imported users into', 'uncanny-pro-toolkit' ); ?></li>
		<li><?php _e( 'LearnDash Group(s) to assign imported users to', 'uncanny-pro-toolkit' ); ?></li>
	</ul>

	<h2 class="options-header-container">
		<ul class="steps">
			<li class="current">
				<a href="#" data-show="step-1" title="">
					<span class="step-title"><?php _e( 'Step 2', 'uncanny-pro-toolkit' ); ?></span>
				</a>
			</li>
			<li></li>
		</ul>
		<div class="steps-description"><?php _e( 'Review Email Settings', 'uncanny-pro-toolkit' ); ?></div>
	</h2>
	<p><?php _e( 'Use this tab to:', 'uncanny-pro-toolkit' ); ?></p>
	<ul class="import-user-list">
		<li><?php _e( 'Enable email notifications to new and/or updated users', 'uncanny-pro-toolkit' ); ?></li>
		<li><?php _e( 'Customize email templates', 'uncanny-pro-toolkit' ); ?></li>
	</ul>

	<h2 class="options-header-container">
		<ul class="steps">
			<li class="current">
				<a href="#" data-show="step-1" title="">
					<span class="step-title"><?php _e( 'Step 3', 'uncanny-pro-toolkit' ); ?></span>
				</a>
			</li>
			<li></li>
		</ul>
		<div class="steps-description"><?php _e( 'Create a CSV File', 'uncanny-pro-toolkit' ); ?>
			<a class="options"
			   href="<?php echo $csv_sample_file_link; ?>"><?php _e( 'Download Sample CSV', 'uncanny-pro-toolkit' ); ?></a>
		</div>
	</h2>
	<p>
		<?php _e( 'Your CSV file must be comma-delimited with a .csv extension. It requires user_login and user_email columns, and can include any number of optional meta fields below.', 'uncanny-pro-toolkit' ); ?>
	</p>

	<h2><?php _e( 'Available Meta Fields', 'uncanny-pro-toolkit' ); ?></h2>

	<table class="wp-list-table widefat fixed striped posts">
		<thead>
		<tr>
			<td><?php _e( 'Column Heading', 'uncanny-pro-toolkit' ); ?></td>
			<td><?php _e( 'Description', 'uncanny-pro-toolkit' ); ?></td>
			<td><?php _e( 'Required/Optional', 'uncanny-pro-toolkit' ); ?></td>
		</tr>
		</thead>
		<tbody>
		<tr>
			<td><?php  echo 'user_email'; ?></td>
			<td><?php _e( 'The user\'s email', 'uncanny-pro-toolkit' ); ?></td>
			<td><?php _e( 'required', 'uncanny-pro-toolkit' ); ?></td>
		</tr>
		<tr>
			<td><?php echo 'user_login'; ?></td>
			<td><?php _e( 'The user\'s username', 'uncanny-pro-toolkit' ); ?></td>
			<td><?php _e( 'required', 'uncanny-pro-toolkit' ); ?></td>
		</tr>
		<tr>
			<td><?php echo 'user_pass'; ?></td>
			<td><?php _e( 'The user\'s password', 'uncanny-pro-toolkit' ); ?></td>
			<td><?php _e( 'optional', 'uncanny-pro-toolkit' ); ?></td>
		</tr>
		<tr>
			<td><?php echo 'learndash_courses'; ?></td>
			<td>
				<?php _e( 'One or more courses to enroll the user into, specified by course ID. If this column exists and cell is empty, course(s) in Options will be used. Multiple course IDs must be separated by semi-colons, e.g., 96;107;92', 'uncanny-pro-toolkit' ); ?>
			</td>
			<td><?php _e( 'optional', 'uncanny-pro-toolkit' ); ?></td>
		</tr>
		<tr>
			<td><?php echo 'learndash_groups'; ?></td>
			<td>
				<?php _e( 'One or more LearnDash groups to enroll the user into, specified by group ID. If this column exists and cell is empty, group(s) in Options will be used. Multiple group IDs must be separated by semi-colons, e.g., 91;102;98', 'uncanny-pro-toolkit' ); ?>
			</td>
			<td><?php _e( 'optional', 'uncanny-pro-toolkit' ); ?></td>
		</tr>
		<tr>
			<td><?php echo 'wp_role'; ?></td>
			<td>
				<?php _e( 'Role to assign to the imported user, specified by role slug. If this column exists and cell is empty, the role in Options will be used.', 'uncanny-pro-toolkit' ); ?>
				<br> <b><?php _e( 'Available role slugs:', 'uncanny-pro-toolkit' ); ?></b>
				<?php foreach ( get_editable_roles() as $role_name => $role_info ): ?>
					<?php echo ' ' . $role_name . ' ' ?>
				<?php endforeach; ?>
			</td>
			<td><?php _e( 'optional', 'uncanny-pro-toolkit' ); ?></td>
		</tr>
		<tr>
			<td><?php echo 'first_name'; ?></td>
			<td><?php _e( 'The user\'s first name', 'uncanny-pro-toolkit' ); ?></td>
			<td><?php _e( 'optional', 'uncanny-pro-toolkit' ); ?></td>
		</tr>
		<tr>
			<td><?php echo 'last_name'; ?></td>
			<td><?php _e( 'The user\'s last name', 'uncanny-pro-toolkit' ); ?></td>
			<td><?php _e( 'optional', 'uncanny-pro-toolkit' ); ?></td>
		</tr>
		<tr>
			<td><?php echo 'display_name'; ?></td>
			<td><?php _e( 'The user\'s display name', 'uncanny-pro-toolkit' ); ?></td>
			<td><?php _e( 'optional', 'uncanny-pro-toolkit' ); ?></td>
		</tr>
		<tr>
			<td><?php echo '**'; ?></td>
			<td><?php _e( 'Any other meta column heading will be treated as a custom user meta value', 'uncanny-pro-toolkit' ); ?></td>
			<td><?php _e( 'optional', 'uncanny-pro-toolkit' ); ?></td>
		</tr>
		</tbody>
	</table>

	<h2><?php _e( 'Notes:', 'uncanny-pro-toolkit' ); ?></h2>
	<ul class="import-user-list">
		<li><?php _e( 'If no password value is present for new users, a password will be auto-generated.', 'uncanny-pro-toolkit' ); ?></li>
		<li><?php _e( 'Username and email address cannot be updated via import.', 'uncanny-pro-toolkit' ); ?></li>
	</ul>

	<h2 class="options-header-container">
		<ul class="steps">
			<li class="current">
				<a href="#" data-show="step-1" title="">
					<span class="step-title"><?php _e( 'Step 4', 'uncanny-pro-toolkit' ); ?></span>
				</a>
			</li>
			<li></li>
		</ul>
		<div class="steps-description"><?php _e( 'Import Users', 'uncanny-pro-toolkit' ); ?></div>
	</h2>
	<p><?php _e( 'Go to the Import Users tab once your CSV file is ready to begin the import.', 'uncanny-pro-toolkit' ); ?></p>

</div>


