<?php

namespace uncanny_learndash_groups;
?>

<section class="group-management-header">
	<div class="uo-row uo-groups-selector">
		<?php
		if ( $group_name_selector ) {
			// Only show drop down if user manages 2 or more groups
			if ( 2 <= count( GroupManagementInterface::$ulgm_managed_group_objects ) ) {
				?>
				<form method="GET" action="">
					<span class="uo-looks-like-h3"><?php _e( 'Group', 'uncanny-learndash-groups' ); ?>:</span>

					<div class="uo-select uo-inline-block">
						<select name="group-id" id="group-id" class="users-table">
							<?php foreach ( GroupManagementInterface::$ulgm_managed_group_objects as $group_object ) {
								$selected = '';
								if ( (int) $group_object->ID === (int) GroupManagementInterface::$ulgm_current_managed_group_id ) {
									$selected = 'selected="selected"';
								}
								?>
								<option <?php echo $selected; ?> value="<?php echo $group_object->ID; ?>"><?php echo $group_object->post_title; ?></option>
							<?php } ?>
						</select>
					</div>
				</form>
				<?php

			} else {

				?>

				<span class="uo-looks-like-h3"><?php _e( 'Group', 'uncanny-learndash-groups' ); ?>:</span>

				<h2 class="uo-looks-like-h3 uo-inline"><?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['group_title']; ?></h2>

				<?php

			}
		}
		?>
		<input type="hidden" name="ulgm_current_managed_group_id" id="ulgm_current_managed_group_id" value="<?php echo GroupManagementInterface::$ulgm_current_managed_group_id; ?>"/>
	</div>
</section>