<?php

namespace uncanny_learndash_groups;

if ( ! defined( 'WPINC' ) ) {
	die;
}

?>

<div class="wrap">
	<div class="ulgm">

		<?php

		// Add admin header and tabs
		$tab_active = 'uncanny-groups-email-settings';
		include Utilities::get_template( 'admin-header.php' );

		?>

		<div class="ulgm-admin-content">
			<div class="uo-ulgm-admin form-table group-management-form">
				<input type="hidden" id="action" name="action" value="save-email-templates"/>

				<!-- Messages -->
				<?php if ( '' !== AdminPage::$ulgm_management_admin_page['text']['message'] ) {
					?>
					<div class="updated ulgm-custom-message" style="margin-bottom: 20px">
						<p><?php echo AdminPage::$ulgm_management_admin_page['text']['message']; ?></p>
					</div>
					<?php
				}
				?>

				<!-- Email Settings -->
				<div class="uo-admin-section">
					<div class="uo-admin-header">
						<div class="uo-admin-title"><?php echo AdminPage::$ulgm_management_admin_page['text']['email_settings']; ?></div>
					</div>
					<div class="uo-admin-block">
						<div class="uo-admin-form">

							<!-- From Email -->
							<div class="uo-admin-field">
								<div class="uo-admin-label"><?php echo AdminPage::$ulgm_management_admin_page['text']['email_from']; ?></div>

								<input class="uo-admin-input" type="text" name="ulgm_email_from" id="ulgm_email_from" value="<?php echo AdminPage::$ulgm_management_admin_page['email_from']; ?>"/>
							</div>

							<!-- From Name -->
							<div class="uo-admin-field">
								<div class="uo-admin-label"><?php echo AdminPage::$ulgm_management_admin_page['text']['name_from']; ?></div>

								<input class="uo-admin-input" type="text" name="ulgm_name_from" id="ulgm_name_from" value="<?php echo AdminPage::$ulgm_management_admin_page['name_from']; ?>"/>
							</div>

							<!-- Reply to -->
							<div class="uo-admin-field">
								<div class="uo-admin-label"><?php echo AdminPage::$ulgm_management_admin_page['text']['reply_to']; ?></div>

								<input class="uo-admin-input" type="text" name="ulgm_reply_to" id="ulgm_reply_to" value="<?php echo AdminPage::$ulgm_management_admin_page['reply_to']; ?>"/>
							</div>


							<!-- Submit -->
							<div class="uo-admin-field uo-admin-extra-space">
								<button id="btn-save_template" class="uo-admin-form-submit submit-group-management-form"
								        data-end-point="save_email_templates"><?php echo AdminPage::$ulgm_management_admin_page['text']['save_changes']; ?></button>
							</div>
						</div>
					</div>
				</div>

				<!-- Redemption Email Template -->
				<div class="uo-admin-section">
					<div class="uo-admin-header">
						<div class="uo-admin-title"><?php echo AdminPage::$ulgm_management_admin_page['text']['redemption_email_template']; ?></div>
					</div>
					<div class="uo-admin-block">
						<div class="uo-admin-form">

							<!-- Subject -->
							<div class="uo-admin-field">
								<div class="uo-admin-label"><?php echo AdminPage::$ulgm_management_admin_page['text']['subject']; ?></div>

								<input class="uo-admin-input" type="text" name="ulgm_invitation_user_email_subject" id="ulgm_invitation_user_email_subject" value="<?php echo AdminPage::$ulgm_management_admin_page['ulgm_invitation_user_email_subject']; ?>"/>
							</div>

							<div class="uo-admin-field">
								<div class="uo-admin-label">
									<?php echo AdminPage::$ulgm_management_admin_page['text']['body']; ?>
								</div>

								<div class="uo-admin-description">
									<?php _e( 'Insert these tokens into your email and they will be replaced with the corresponding information.  Click a token to copy it to your clipboard.', 'uncanny-learndash-groups' ); ?>
								</div>

								<div class="uo-admin-tags uo-admin-tags-has-top-description">
									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input s__w" value="#FirstName" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input s__w" value="#LastName" readonly>
									</div>
									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input vs__w" value="#SiteUrl" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input s__w" value="#SiteName" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input m__w" value="#GroupName" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input s__w" value="#LoginUrl" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input vs__w" value="#Email" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input l__w" value="#RedemptionKey" readonly>
									</div>
								</div>

								<div class="uo-admin-wp-editor">
									<?php wp_editor( AdminPage::$ulgm_management_admin_page['ulgm_invitation_user_email_body'], 'ulgm_invitation_user_email_body' ); ?>
								</div>
							</div>

							<!-- Submit -->
							<div class="uo-admin-field uo-admin-extra-space">
								<button id="btn-save_template" class="uo-admin-form-submit submit-group-management-form"
								        data-end-point="save_email_templates"><?php echo AdminPage::$ulgm_management_admin_page['text']['save_changes']; ?></button>
							</div>
						</div>
					</div>
				</div>

				<!-- User Welcome Email Template -->
				<div class="uo-admin-section">
					<div class="uo-admin-header">
						<div class="uo-admin-title"><?php echo AdminPage::$ulgm_management_admin_page['text']['user_welcome_email_template']; ?></div>
					</div>
					<div class="uo-admin-block">
						<div class="uo-admin-form">

							<!-- Subject -->
							<div class="uo-admin-field">
								<div class="uo-admin-label"><?php echo AdminPage::$ulgm_management_admin_page['text']['subject']; ?></div>

								<input class="uo-admin-input" type="text" name="ulgm_user_welcome_email_subject" id="ulgm_user_welcome_email_subject" value="<?php echo AdminPage::$ulgm_management_admin_page['ulgm_user_welcome_email_subject']; ?>"/>
							</div>

							<div class="uo-admin-field">
								<div class="uo-admin-label">
									<?php echo AdminPage::$ulgm_management_admin_page['text']['body']; ?>
								</div>

								<div class="uo-admin-description">
									<?php _e( 'Insert these tokens into your email and they will be replaced with the corresponding information.  Click a token to copy it to your clipboard.', 'uncanny-learndash-groups' ); ?>
								</div>

								<div class="uo-admin-tags uo-admin-tags-has-top-description">
									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input vs__w" value="#SiteUrl" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input s__w" value="#SiteName" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input m__w" value="#GroupName" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input s__w" value="#LoginUrl" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input vs__w" value="#Email" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input s__w" value="#Username" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input s__w" value="#FirstName" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input s__w" value="#LastName" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input m__w" value="#DisplayName" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input s__w" value="#Password" readonly>
									</div>
								</div>

								<div class="uo-admin-wp-editor">
									<?php wp_editor( AdminPage::$ulgm_management_admin_page['ulgm_user_welcome_email_body'], 'ulgm_user_welcome_email_body' ); ?>
								</div>
							</div>

							<!-- Submit -->
							<div class="uo-admin-field uo-admin-extra-space">
								<button id="btn-save_template" class="uo-admin-form-submit submit-group-management-form"
								        data-end-point="save_email_templates"><?php echo AdminPage::$ulgm_management_admin_page['text']['save_changes']; ?></button>
							</div>
						</div>
					</div>
				</div>

				<!-- Existing User Welcome Email Template -->
				<div class="uo-admin-section">
					<div class="uo-admin-header">
						<div class="uo-admin-title"><?php echo AdminPage::$ulgm_management_admin_page['text']['existing_user_welcome_email_template']; ?></div>
					</div>
					<div class="uo-admin-block">
						<div class="uo-admin-form">

							<!-- Subject -->
							<div class="uo-admin-field">
								<div class="uo-admin-label"><?php echo AdminPage::$ulgm_management_admin_page['text']['subject']; ?></div>

								<input class="uo-admin-input" type="text" name="ulgm_existing_user_welcome_email_subject" id="ulgm_user_welcome_email_subject" value="<?php echo AdminPage::$ulgm_management_admin_page['ulgm_existing_user_welcome_email_subject']; ?>"/>
							</div>

							<div class="uo-admin-field">
								<div class="uo-admin-label">
									<?php echo AdminPage::$ulgm_management_admin_page['text']['body']; ?>
								</div>

								<div class="uo-admin-description">
									<?php _e( 'Insert these tokens into your email and they will be replaced with the corresponding information.  Click a token to copy it to your clipboard.', 'uncanny-learndash-groups' ); ?>
								</div>

								<div class="uo-admin-tags uo-admin-tags-has-top-description">
									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input vs__w" value="#SiteUrl" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input s__w" value="#SiteName" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input m__w" value="#GroupName" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input s__w" value="#LoginUrl" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input vs__w" value="#Email" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input s__w" value="#Username" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input s__w" value="#FirstName" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input s__w" value="#LastName" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input m__w" value="#DisplayName" readonly>
									</div>
								</div>

								<div class="uo-admin-wp-editor">
									<?php wp_editor( AdminPage::$ulgm_management_admin_page['ulgm_existing_user_welcome_email_body'], 'ulgm_existing_user_welcome_email_body' ); ?>
								</div>
							</div>

							<!-- Submit -->
							<div class="uo-admin-field uo-admin-extra-space">
								<button id="btn-save_template" class="uo-admin-form-submit submit-group-management-form"
								        data-end-point="save_email_templates"><?php echo AdminPage::$ulgm_management_admin_page['text']['save_changes']; ?></button>
							</div>
						</div>
					</div>
				</div>

				<!-- Add new group leader template -->
				<div class="uo-admin-section">
					<div class="uo-admin-header">
						<div class="uo-admin-title"><?php echo AdminPage::$ulgm_management_admin_page['text']['group_leader_welcome_email_template']; ?></div>
					</div>
					<div class="uo-admin-block">
						<div class="uo-admin-form">

							<!-- Subject -->
							<div class="uo-admin-field">
								<div class="uo-admin-label"><?php echo AdminPage::$ulgm_management_admin_page['text']['subject']; ?></div>

								<input class="uo-admin-input" type="text" name="ulgm_group_leader_welcome_email_subject" id="ulgm_group_leader_welcome_email_subject" value="<?php echo AdminPage::$ulgm_management_admin_page['ulgm_group_leader_welcome_email_subject']; ?>"/>
							</div>

							<div class="uo-admin-field">
								<div class="uo-admin-label">
									<?php echo AdminPage::$ulgm_management_admin_page['text']['body']; ?>
								</div>

								<div class="uo-admin-description">
									<?php _e( 'Insert these tokens into your email and they will be replaced with the corresponding information.  Click a token to copy it to your clipboard.', 'uncanny-learndash-groups' ); ?>
								</div>

								<div class="uo-admin-tags uo-admin-tags-has-top-description">
									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input vs__w" value="#SiteUrl" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input s__w" value="#SiteName" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input m__w" value="#GroupName" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input s__w" value="#LoginUrl" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input vs__w" value="#Email" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input s__w" value="#Username" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input s__w" value="#FirstName" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input s__w" value="#LastName" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input m__w" value="#DisplayName" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input s__w" value="#Password" readonly>
									</div>
								</div>

								<div class="uo-admin-wp-editor">
									<?php wp_editor( AdminPage::$ulgm_management_admin_page['ulgm_group_leader_welcome_email_body'], 'ulgm_group_leader_welcome_email_body' ); ?>
								</div>
							</div>

							<!-- Submit -->
							<div class="uo-admin-field uo-admin-extra-space">
								<button id="btn-save_template" class="uo-admin-form-submit submit-group-management-form"
								        data-end-point="save_email_templates"><?php echo AdminPage::$ulgm_management_admin_page['text']['save_changes']; ?></button>
							</div>

						</div>
					</div>
				</div>

				<!-- Existing Group Leader Welcome Email Template -->
				<div class="uo-admin-section">
					<div class="uo-admin-header">
						<div class="uo-admin-title"><?php echo AdminPage::$ulgm_management_admin_page['text']['existing_group_leader_welcome_email_template']; ?></div>
					</div>
					<div class="uo-admin-block">
						<div class="uo-admin-form">

							<!-- Subject -->
							<div class="uo-admin-field">
								<div class="uo-admin-label"><?php echo AdminPage::$ulgm_management_admin_page['text']['subject']; ?></div>

								<input class="uo-admin-input" type="text" name="ulgm_existing_group_leader_welcome_email_subject" id="ulgm_existing_group_leader_welcome_email_subject" value="<?php echo AdminPage::$ulgm_management_admin_page['ulgm_existing_group_leader_welcome_email_subject']; ?>"/>
							</div>

							<div class="uo-admin-field">
								<div class="uo-admin-label">
									<?php echo AdminPage::$ulgm_management_admin_page['text']['body']; ?>
								</div>

								<div class="uo-admin-description">
									<?php _e( 'Insert these tokens into your email and they will be replaced with the corresponding information.  Click a token to copy it to your clipboard.', 'uncanny-learndash-groups' ); ?>
								</div>

								<div class="uo-admin-tags uo-admin-tags-has-top-description">
									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input vs__w" value="#SiteUrl" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input s__w" value="#SiteName" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input m__w" value="#GroupName" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input s__w" value="#LoginUrl" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input vs__w" value="#Email" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input s__w" value="#Username" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input s__w" value="#FirstName" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input s__w" value="#LastName" readonly>
									</div>

									<div class="uo-admin-copy-to-clipboard">
										<span class="uo-admin-ctc-tooltip"><?php _e( 'Copy to clipboard', 'uncanny-learndash-groups' ) ?></span>
										<input class="uo-admin-copy-to-clipboard-input m__w" value="#DisplayName" readonly>
									</div>
								</div>

								<div class="uo-admin-wp-editor">
									<?php wp_editor( AdminPage::$ulgm_management_admin_page['ulgm_existing_group_leader_welcome_email_body'], 'ulgm_existing_group_leader_welcome_email_body' ); ?>
								</div>
							</div>

							<!-- Submit -->
							<div class="uo-admin-field uo-admin-extra-space">
								<button id="btn-save_template" class="uo-admin-form-submit submit-group-management-form"
								        data-end-point="save_email_templates"><?php echo AdminPage::$ulgm_management_admin_page['text']['save_changes']; ?></button>
							</div>

						</div>
					</div>
				</div>
			</div>
		</div>

	</div>
</div>