<?php

namespace uncanny_learndash_groups;

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Class WoocommerceModifyGroup
 * @package uncanny_learndash_groups
 */
class WoocommerceModifyGroup {
	var $bulk_discount_calculated = false;
	var $discount_coeffs;
	var $is_being_modified = false;


	/**
	 * WoocommerceModifyGroup constructor.
	 */
	function __construct() {
		// Only Run if woocommerce is available
		if ( Utilities::if_woocommerce_active() ) {
			add_action( 'plugins_loaded', array( $this, 'plugins_loaded' ) );
		}
	}

	/**
	 *
	 */
	public function plugins_loaded() {
		//add_action( 'wp_loaded', array( $this, 'modify_group_seats_quantity' ), 500 );
		add_action( 'wp_loaded', array( $this, 'modify_group_seats_qty_v2' ), 500 );
		if ( is_user_logged_in() ) {
			/*add_action( 'woocommerce_cart_calculate_fees', array(
				$this,
				'calculate_cart_discounts_modify_group',
			), 9, 1 );*/
			add_action( 'woocommerce_cart_calculate_fees', array( $this, 'calculate_cart_v2', ), 999, 1 );
			add_action( 'woocommerce_before_cart_contents', array( $this, 'add_additional_qty_notice', ), 11, 1 );
			add_action( 'woocommerce_checkout_before_order_review', array(
				$this,
				'add_additional_qty_notice',
			), 11, 1 );
		}
		add_filter( 'woocommerce_payment_complete_order_status', array( $this, 'payment_complete_status' ), 99, 2 );
		//add_action( 'woocommerce_check_cart_items', array( $this, 'set_minimum_qty_to_purchase' ), 500 );
		add_action( 'woocommerce_order_status_completed', array( $this, 'modify_existing_group' ), 599 );
		add_action( 'woocommerce_thankyou', [ $this, 'cheque_payment_method_payment_made' ], 699, 1 );
	}

	/**
	 * Fallback method for cheques
	 *
	 * @param $order_id
	 */
	public function cheque_payment_method_payment_made( $order_id ) {
		$order          = wc_get_order( $order_id );
		$user_id        = $order->get_user_id();
		$payment_method = $order->get_payment_method();

		if ( 'cheque' === $payment_method ) {

			$get_transient = get_transient( '_ulgm_user_' . $user_id . '_order' );
			if ( $get_transient ) {
				set_transient( '_ulgm_user_' . $user_id . '_order_' . $order_id, $get_transient, 1 * YEAR_IN_SECONDS );
			}
		}

	}

	/**
	 * @param $order_status
	 * @param $order_id
	 *
	 * @return mixed
	 */
	public function payment_complete_status( $order_status, $order_id ) {
		$order   = wc_get_order( $order_id );
		$user_id = $order->get_user_id();
		$status  = $order->get_status();

		if ( 'processing' === $order_status && ( 'on-hold' === $status || 'pending' === $status || 'failed' === $status ) ) {

			$get_transient = get_transient( '_ulgm_user_' . $user_id . '_order' );
			if ( $get_transient ) {
				set_transient( '_ulgm_user_' . $user_id . '_order_' . $order_id, $get_transient, 1 * YEAR_IN_SECONDS );
			}
		}

		return $order_status;

	}

	/**
	 *
	 */
	public function modify_group_seats_qty_v2() {
		if ( isset( $_GET['modify-group'] ) && true == $_GET['modify-group'] ) {
			$group_id      = $_GET['modify-group-id'];
			$existing_qty  = SharedFunctions::total_seats( $group_id );
			$order_details = SharedFunctions::get_product_id_from_group_id( $group_id );
			$all_orders    = SharedFunctions::get_group_leader_all_orders( $group_id, $order_details['product_id'] );
			//Utilities::log( $all_orders, '$all_orders', true, 'orders' );
			if ( is_user_logged_in() && is_array( $order_details ) ) {
				$user_id    = wp_get_current_user()->ID;
				$order_id   = $order_details['order_id'];
				$product_id = $order_details['product_id'];
				$qty        = intval( $_GET['new-qty'] );
				$save_data  = array(
					'user_id'       => $user_id,
					'order_details' => $order_details,
					'group_id'      => $group_id,
					'order_id'      => $order_id,
					'all_orders'    => $all_orders,
					'existing_qty'  => $existing_qty,
					'new_qty'       => $qty,
				);
				//$new_qty    = $qty - $existing_qty;
				//Utilities::log( $save_data, '$save_data', true, 'new-trans' );
				//if ( $new_qty > 0 ) {
				SharedFunctions::remove_transient_cache( 'no', '_ulgm_user_buy_courses_USERID_order', $user_id );
				SharedFunctions::set_transient_cache( '_ulgm_user_USERID_order', $save_data, $user_id );
				//set_transient( '_ulgm_user_' . $user_id . '_order', $save_data, 10 * MINUTE_IN_SECONDS );
				$this->reset_license_on_cart_empty( $product_id );
				WC()->cart->empty_cart();
				wp_redirect( wc_get_cart_url() . '?add-to-cart=' . $product_id . '&quantity=' . $qty . '&add-seats=true' );
				exit;
			}
		}
	}

	/**
	 * @param \WC_Cart $cart
	 */
	public function calculate_cart_v2( \WC_Cart $cart ) {
		$user_id       = wp_get_current_user()->ID;
		$existing_data = get_transient( '_ulgm_user_' . $user_id . '_order' );
		//Utilities::log( $existing_data, '$existing_data', true, 'existing' );
		update_option( '_transient_timeout__ulgm_user_' . $user_id . '_order', strtotime( '+15 minutes' ) );
		if ( count( $cart->cart_contents ) > 0 ) {

			foreach ( $cart->cart_contents as $cart_item_key => $values ) {
				$_product = $values['data'];
				if ( '' !== get_post_meta( $this->get_product_id( $_product ), '_ulgm_bulk_discount_enabled', true ) && 'yes' !== get_post_meta( $this->get_product_id( $_product ), '_ulgm_bulk_discount_enabled', true ) ) {
					continue;
				}
				$license_cost = wc_get_price_excluding_tax( $_product );
				//$all_orders   = $existing_data['all_orders'];

				if ( ! empty( $license_cost ) ) {
					//Utilities::log( $license_cost, '$license_cost', true, 'existing' );
					$additional_qty = absint( WC()->cart->get_cart_contents_count() );
					$existing_qty   = absint( $existing_data['existing_qty'] );
					$total_qty      = absint( $additional_qty ) + absint( $existing_qty );
					$discount       = floatval( $license_cost ) * absint( $total_qty );

					/*Utilities::log( [
						$user_id,
						$existing_data,
						$additional_qty,
						$discount,
						$license_cost
					], '[$user_id, $existing_data, $additional_qty, $discount, $license_cost]', true, 'existing' );*/

					if ( $discount > 0 ) {
						$seats = strtolower( get_option( 'ulgm_per_seat_text_plural', __( 'Seats', 'uncanny-learndash-groups' ) ) );
						//WC()->cart->add_fee( sprintf( __( 'Credit for existing %s', 'uncanny-learndash-groups' ), $seats ), $discount * - 1 );
					}
				}
			}
			$this->bulk_discount_calculated = true;
		}
	}

	/**
	 *
	 */
	public function add_additional_qty_notice() {
		$user_id       = wp_get_current_user()->ID;
		$get_transient = get_transient( '_ulgm_user_' . $user_id . '_order' );
		if ( ! empty( $get_transient ) ) {
			$seats = strtolower( get_option( 'ulgm_per_seat_text_plural', __( 'Seats', 'uncanny-learndash-groups' ) ) );
			echo '<p class="woocommerce-message">' . sprintf( __( 'Add additional %s by changing quantity below.', 'uncanny-learndash-groups' ), $seats ) . '</p>';
		}
	}

	/**
	 *
	 */
	function set_minimum_qty_to_purchase() {
		if ( is_cart() || is_checkout() ) {
			$user_id       = wp_get_current_user()->ID;
			$get_transient = get_transient( '_ulgm_user_' . $user_id . '_order' );
			$existing_qty  = $get_transient['existing_qty'];
			if ( ! empty( $get_transient ) ) {
				// Set the minimum number of products before checking out
				$minimum_num_products = $existing_qty + 1;
				// Get the Cart's total number of products
				$cart_num_products = WC()->cart->cart_contents_count;

				// Compare values and add an error is Cart's total number of products
				// happens to be less than the minimum required before checking out.
				// Will display a message along the lines of
				if ( $cart_num_products < $minimum_num_products ) {
					// Display our error message
					wc_add_notice( sprintf( __( 'A minimum quantity of %s is required to check out.', 'uncanny-learndash-groups' ), $minimum_num_products ),
						'error' );
				}
			}
		}
	}

	/**
	 * @param $order_id
	 */
	public function modify_existing_group( $order_id ) {
		$order     = wc_get_order( $order_id );
		$user_id   = $order->get_user_id();
		$transient = get_transient( '_ulgm_user_' . $user_id . '_order' );
		if ( empty( $transient ) ) {
			$transient = get_transient( '_ulgm_user_' . $user_id . '_order_' . $order_id );
		}
		//Utilities::log( $transient, 'Transient', true, 'transient' );
		$line_items = $order->get_items( 'line_item' );
		$new_qty    = 0;
		if ( ! class_exists( 'Database' ) ) {
			include_once( Utilities::get_include( 'database.php' ) );
		}
		//Utilities::log( $transient, '$transient', true, 'new-transi' );
		if ( $transient ):
			if ( ( $order ) && ( $order->has_status( 'completed' ) ) && $line_items ) :
				foreach ( $line_items as $line_item ) {
					$new_qty += absint( $line_item['qty'] );
				}
				$group_id     = $transient['group_id'];
				$existing_qty = $transient['existing_qty'];
				//$new_qty       = $transient['new_qty'];
				$old_order_id  = $transient['order_details']['order_id'];
				$code_group_id = $transient['order_details']['code_group_id'];
				$generate_qty  = $new_qty;
				$new_codes     = SharedFunctions::generate_random_codes( $generate_qty );
				//Utilities::log( $new_codes, 'Codes', true, 'new-codes' );
				if ( ! class_exists( 'Database' ) ) {
					include_once( Utilities::get_include( 'database.php' ) );
				}
				$attr = array(
					'qty'           => $generate_qty,
					'code_group_id' => $code_group_id,
				);
				Database::add_additional_codes( $attr, $new_codes );
				$updated_qty = absint( $new_qty ) + absint( $existing_qty );
				update_post_meta( $order_id, SharedFunctions::$code_group_id_meta_key, $code_group_id );
				update_post_meta( $order_id, 'parent_order_id', $old_order_id );
				update_post_meta( $group_id, '_ulgm_total_seats', $updated_qty );
				update_post_meta( $order_id, SharedFunctions::$linked_group_id_meta, $group_id );
				SharedFunctions::remove_transient_cache( 'no', '_ulgm_user_USERID_order', $user_id );
				SharedFunctions::remove_transient_cache( 'no', '_ulgm_user_USERID_order_' . $order_id, $user_id );
				//delete_transient( '_ulgm_user_' . $user_id . '_order' );
			endif;
		endif;
	}

	/**
	 * @param $_product
	 *
	 * @return mixed
	 */
	protected function get_product_id( $_product ) {
		if ( version_compare( WOOCOMMERCE_VERSION, '2.7.0' ) >= 0 ) {
			return $_product->get_id();
		}

		return $_product->id;
	}

	/**
	 * @param $price
	 *
	 * @return string
	 */
	protected function get_price( $price ) {
		if ( version_compare( WOOCOMMERCE_VERSION, '2.7.0' ) >= 0 ) {
			return wc_price( $price );
		} else {
			return woocommerce_price( $price );
		}
	}

	/**
	 * @param $id
	 *
	 * @return \WC_Product
	 */
	protected function get_product( $id ) {
		if ( version_compare( WOOCOMMERCE_VERSION, '2.7.0' ) >= 0 ) {
			return wc_get_product( $id );
		} else {
			return get_product( $id );
		}
	}

	/**
	 * @param $product
	 *
	 * @return int
	 */
	protected function get_actual_id( $product ) {

		if ( $product instanceof \WC_Product_Variation ) {
			return $product->variation_id;
		} else {
			return $this->get_product_id( $product );
		}

	}


	/**
	 * @param $product_id
	 */
	public function reset_license_on_cart_empty( $product_id ) {
		delete_post_meta( $product_id, SharedFunctions::$license_meta_field . '_new' );
	}
}
