<?php

namespace uncanny_learndash_groups;

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Class LearndashGroupsPostEditAdditions
 * @package uncanny_learndash_groups
 */
class LearndashGroupsPostEditAdditions {

	/**
	 * class constructor
	 */
	public function __construct() {
		if ( is_admin() ) {
			add_action( 'load-post.php', array( $this, 'init_metabox' ) );
			add_action( 'load-post-new.php', array( $this, 'init_metabox' ) );
		}

	}

	/**
	 * Meta box initialization.
	 */
	public function init_metabox() {
		add_action( 'add_meta_boxes', array( $this, 'add_metabox' ) );
		add_action( 'save_post', array( $this, 'save_total_seats' ), 20, 2 );
		add_action( 'save_post', array( $this, 'update_user_redeemed_seats' ), 40, 2 );
		add_action( 'save_post', array( $this, 'remove_users_from_group_admin' ), 30, 2 );
	}

	/**
	 * Adds the meta box.
	 */
	public function add_metabox() {
		add_meta_box(
			'uo-group-managment',
			__( 'Uncanny Group Management', 'uncanny_learndash_groups' ),
			array( $this, 'render_metabox' ),
			'groups',
			'advanced',
			'high'
		);

	}

	/**
	 * Renders the meta box.
	 */
	public function render_metabox( $post ) {

		// Add nonce for security and authentication.
		wp_nonce_field( 'custom_nonce_action', 'custom_nonce' );

		$group_id = $post->ID;

		$ulgm_total_seats = get_post_meta( $group_id, '_ulgm_total_seats', true );
		$is_upgraded      = get_post_meta( $group_id, '_ulgm_is_upgraded', true );

		// Get the location data if its already been entered
		$total_seats     = SharedFunctions::total_seats( $group_id );
		$remaining_seats = SharedFunctions::remaining_seats( $group_id );


		// Echo out the field
		ob_start();

		if ( ! empty( $ulgm_total_seats ) || 'yes' === $is_upgraded ) {
			?>
            <div class="sfwd_input " id="sfwd-lessons_forced_lesson_time">
                <span class="sfwd_option_label" style="text-align:right;vertical-align:top;">
                    <a class="sfwd_help_text_link" style="cursor:pointer;" title="<?php _e( 'Click for Help!', 'uncanny-learndash-groups' ) ?>" onclick="toggleVisibility('uo-total-seats');">
                        <img src="<?php echo plugins_url(); ?>/sfwd-lms/assets/images/question.png">
                        <label class="sfwd_label textinput"><?php _e( 'Total Seats', 'uncanny-learndash-groups' ) ?></label>
                    </a></span><span class="sfwd_option_input">
                    <div class="sfwd_option_div">
                        <input name="_ulgm_total_seats" type="text" size="57" value="<?php echo $total_seats; ?>">
                    </div>
                    <div class="sfwd_help_text_div" style="display:none" id="uo-total-seats">
                        <label class="sfwd_help_text"><?php _e( 'Total number of seats available to the group administrator for dispersion.', 'uncanny-learndash-groups' ) ?></label>
                    </div>
                </span>
                <p style="clear:left"></p>
            </div>

            <div class="sfwd_input " id="sfwd-lessons_forced_lesson_time">
                <span class="sfwd_option_label" style="text-align:right;vertical-align:top;">
                    <a class="sfwd_help_text_link" style="cursor:pointer;" title="<?php _e( 'Click for Help!', 'uncanny-learndash-groups' ) ?>" onclick="toggleVisibility('uo-remaining-seats');">
                        <img src="<?php echo plugins_url(); ?>/sfwd-lms/assets/images/question.png">
                        <label class="sfwd_label textinput"><?php _e( 'Remaining Seats', 'uncanny-learndash-groups' ) ?></label>
                    </a></span><span class="sfwd_option_input">
                    <div class="sfwd_option_div">
                        <input name="_ulgm_total_seats" disabled="disabled" type="text" size="57" value="<?php echo $remaining_seats; ?>">
                    </div>
                    <div class="sfwd_help_text_div" style="display:none" id="uo-remaining-seats">
                        <label class="sfwd_help_text"><?php _e( 'Total number of seats remaining to the group administrator for dispersion.', 'uncanny-learndash-groups' ) ?></label>
                    </div>
                </span>
                <p style="clear:left"></p>
            </div>
			
			<?php
		} else {
			$link_upgrade = add_query_arg( [ 'migrate_one' => $post->ID, 'wpnonce' => wp_create_nonce( 'ulgm' ) ], get_edit_post_link() );
		    ?>
            <div class="sfwd_input " id="sfwd-lessons_forced_lesson_time">
                <span class="sfwd_option_input">
                    <div class="sfwd_option_div">
                        <a href="<?php echo $link_upgrade;?>" class="button">Upgrade Group</a>
                    </div>
                    <div class="sfwd_help_text_div" style="display:none" id="uo-total-seats">
                        <label class="sfwd_help_text"><?php _e( 'Total number of seats available to the group administrator for dispersion.', 'uncanny-learndash-groups' ) ?></label>
                    </div>
                </span>
                <p style="clear:left">Clicking this button will enable seat management for this group and enable front end management using Uncanny LearnDash Groups. To bulk upgrade all groups, use the button in settings.</p>
            </div>
        <?php
		}
		echo ob_get_clean();
	}

	/**
	 * Handles saving the meta box.
	 *
	 * @param int $post_id Post ID.
	 * @param WP_Post $post Post object.
	 *
	 * @return null
	 */
	public function save_total_seats( $post_id, $post ) {
		$code_group_id = get_post_meta( $post_id, SharedFunctions::$code_group_id_meta_key, true );
		if ( ! empty( $code_group_id ) ) {
			// Add nonce for security and authentication.
			$nonce_name   = isset( $_POST['custom_nonce'] ) ? $_POST['custom_nonce'] : '';
			$nonce_action = 'custom_nonce_action';

			// Check if nonce is set.
			if ( ! isset( $nonce_name ) ) {
				return;
			}

			// Check if nonce is valid.
			if ( ! wp_verify_nonce( $nonce_name, $nonce_action ) ) {
				return;
			}

			// Check if user has permissions to save data.
			if ( ! current_user_can( 'edit_post', $post_id ) ) {
				return;
			}

			// Check if not an autosave.
			if ( wp_is_post_autosave( $post_id ) ) {
				return;
			}

			// Check if not a revision.
			if ( wp_is_post_revision( $post_id ) ) {
				return;
			}
			$existing_seats = get_post_meta( $post_id, '_ulgm_total_seats', true );
			$new_seats      = absint( $_POST['_ulgm_total_seats'] );
			if ( $new_seats > $existing_seats ) {
				$diff      = $new_seats - $existing_seats;
				$new_codes = SharedFunctions::generate_random_codes( $diff );
				if ( ! class_exists( 'Database' ) ) {
					include_once( Utilities::get_include( 'database.php' ) );
				}
				$attr = array(
					'qty'           => $diff,
					'code_group_id' => $code_group_id,
				);
				Database::add_additional_codes( $attr, $new_codes );
				update_post_meta( $post_id, '_ulgm_total_seats', $_POST['_ulgm_total_seats'] );
			} elseif ( $new_seats < $existing_seats ) {
				global $wpdb;

				$diff             = $new_seats - $existing_seats;
				$diff             = $diff * - 1; //convert to positive
				$fetch_code_count = $wpdb->get_var( $wpdb->prepare( 'SELECT COUNT(code) AS available FROM ' . $wpdb->prefix . SharedFunctions::$db_group_codes_tbl . ' WHERE group_id = %d AND student_id IS NULL LIMIT %d', $code_group_id, $diff ) );
				if ( ! empty( $fetch_code_count ) && $fetch_code_count >= $diff ) {
					//difference seats are empty, lets delete them
					$sql = $wpdb->prepare( 'DELETE FROM ' . $wpdb->prefix . SharedFunctions::$db_group_codes_tbl . ' WHERE group_id = %d AND student_id IS NULL LIMIT %d', $code_group_id, $diff );
					$wpdb->query( $sql );
					update_post_meta( $post_id, '_ulgm_total_seats', $existing_seats - $diff );
				}
			}
		}

		return;

	}

	/**
	 * Handles saving the meta box.
	 *
	 * @param int $post_id Post ID.
	 * @param WP_Post $post Post object.
	 *
	 * @return null
	 */
	public function update_user_redeemed_seats( $post_id, $post ) {
		// Add nonce for security and authentication.
		$code_group_id = get_post_meta( $post_id, SharedFunctions::$code_group_id_meta_key, true );
		if ( ! empty( $code_group_id ) ) {
			$nonce_name   = isset( $_POST['custom_nonce'] ) ? $_POST['custom_nonce'] : '';
			$nonce_action = 'custom_nonce_action';

			// Check if nonce is set.
			if ( ! isset( $nonce_name ) ) {
				return;
			}

			// Check if nonce is valid.
			if ( ! wp_verify_nonce( $nonce_name, $nonce_action ) ) {
				return;
			}

			// Check if user has permissions to save data.
			if ( ! current_user_can( 'edit_post', $post_id ) ) {
				return;
			}

			// Check if not an autosave.
			if ( wp_is_post_autosave( $post_id ) ) {
				return;
			}

			// Check if not a revision.
			if ( wp_is_post_revision( $post_id ) ) {
				return;
			}
			$seat_users    = array();
			//$group_leaders = learndash_get_groups_administrators( $post_id );
			$group_users   = learndash_get_groups_users( $post_id );

			/*if ( $group_leaders ) {
				foreach ( $group_leaders as $gl ) {
					$seat_users[ $gl->ID ] = array(
						'ID'         => $gl->ID,
						'user_email' => $gl->user_email,
						'role'       => 'group_leader',
					);
				}
			}*/
			if ( $group_users ) {
				foreach ( $group_users as $key => $user ) {
					if ( ! key_exists( $user->ID, $seat_users ) ) {
						$seat_users[ $user->ID ] = array(
							'ID'         => $user->ID,
							'user_email' => $user->user_email,
							'role'       => 'user',
						);
					}
				}
			}
			$number_of_seats = count( $seat_users );
			$existing_seats  = get_post_meta( $post_id, '_ulgm_total_seats', true );

			if ( $number_of_seats > $existing_seats ) {
				$diff      = $number_of_seats - $existing_seats;
				$new_codes = SharedFunctions::generate_random_codes( $diff );
				if ( ! class_exists( 'Database' ) ) {
					include_once( Utilities::get_include( 'database.php' ) );
				}
				$attr = array(
					'qty'           => $diff,
					'code_group_id' => $code_group_id,
				);
				Database::add_additional_codes( $attr, $new_codes );
				update_post_meta( $post_id, '_ulgm_total_seats', $number_of_seats );
			}
			$order_id = SharedFunctions::get_order_id_from_group_id( $post_id );

			if ( count( $seat_users ) ) {
				foreach ( $seat_users as $user ) {
					$rest_api  = new RestApiEndPoints();
					$user_data = array(
						'user_email' => $user['user_email'],
						'user_id'    => $user['ID'],
					);
					if ( 'group_leader' === $user['role'] ) {
						$status = 'redeemed';
					} else {
						$status = 'Not Started';
					}
					$is_member = SharedFunctions::is_user_already_member_of_group( $user['ID'], $post_id );
					if ( 'no' === $is_member ) {
						$rest_api->add_existing_user( $user_data, true, $post_id, $order_id, $status, false );
					}
				}
			}
		}

		return;
	}

	/**
	 * Handles saving the meta box.
	 *
	 * @param int $post_id Post ID.
	 * @param WP_Post $post Post object.
	 *
	 * @return null
	 */
	public function remove_users_from_group_admin( $post_id, $post ) {
		$codes_group_id = get_post_meta( $post_id, SharedFunctions::$code_group_id_meta_key, true );
		if ( ! empty( $codes_group_id ) ) {
			// Add nonce for security and authentication.
			$nonce_name   = isset( $_POST['custom_nonce'] ) ? $_POST['custom_nonce'] : '';
			$nonce_action = 'custom_nonce_action';

			// Check if nonce is set.
			if ( ! isset( $nonce_name ) ) {
				return;
			}

			// Check if nonce is valid.
			if ( ! wp_verify_nonce( $nonce_name, $nonce_action ) ) {
				return;
			}

			// Check if user has permissions to save data.
			if ( ! current_user_can( 'edit_post', $post_id ) ) {
				return;
			}

			// Check if not an autosave.
			if ( wp_is_post_autosave( $post_id ) ) {
				return;
			}

			// Check if not a revision.
			if ( wp_is_post_revision( $post_id ) ) {
				return;
			}

			global $wpdb;
			$codes_users      = array();
			$code_group_users = $wpdb->get_results( "SELECT student_id, ID FROM {$wpdb->prefix}" . SharedFunctions::$db_group_codes_tbl . " WHERE student_id IS NOT NULL AND group_id = {$codes_group_id}" );
			if ( $code_group_users ) {

				foreach ( $code_group_users as $u ) {
					$codes_users[ $u->student_id ] = $u->ID;
				}
				$seat_users    = array();
				$group_leaders = learndash_get_groups_administrators( $post_id );
				$group_users   = learndash_get_groups_users( $post_id );

				if ( $group_leaders ) {
					foreach ( $group_leaders as $gl ) {
						$seat_users[ $gl->ID ] = array(
							'ID'         => $gl->ID,
							'user_email' => $gl->user_email,
							'role'       => 'group_leader',
						);
					}
				}
				if ( $group_users ) {
					foreach ( $group_users as $key => $user ) {
						if ( ! key_exists( $user->ID, $seat_users ) ) {
							$seat_users[ $user->ID ] = array(
								'ID'         => $user->ID,
								'user_email' => $user->user_email,
								'role'       => 'user',
							);
						}
					}
				}

				if ( count( $codes_users ) ) {
					foreach ( $codes_users as $user_id => $code_id ) {
						if ( ! key_exists( $user_id, $seat_users ) ) {
							$sql = "UPDATE {$wpdb->prefix}" . SharedFunctions::$db_group_codes_tbl . " SET student_id = NULL, user_email = NULL, used_date = NULL, code_status = 'available' WHERE ID = " . $code_id;
							$wpdb->query( $sql );
						}
					}
				}
			}
		}

		return;
	}
}