<?php

namespace uncanny_learndash_groups;

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Class GroupManagementProgress
 * @package uncanny_learndash_groups
 */
class GroupManagementProgress {


	/**
	 * An array of localized and filtered strings that are used in templates
	 *
	 * @since    1.0.0
	 * @access   static
	 * @var      array
	 */
	static $ulgm_management_shortcode = array();

	/**
	 * class constructor
	 */
	public function __construct() {

		// Enqueue Scripts for uo_groups_manage_progress shortcode
		add_action( 'wp_enqueue_scripts', array( $this, 'uo_group_management_scripts' ) );

		/* ADD FILTERS ACTIONS FUNCTION */
		add_shortcode( 'uo_groups_manage_progress', array( $this, 'uo_group_mgr' ), 10, 1 );


	}

	/**
	 * Loads all scripts and styles required by the shortcode
	 *
	 * @since 1.0.0
	 */
	function uo_group_management_scripts() {

		global $post;

		// Only add scripts if shortcode is present on page
		if ( Utilities::has_shortcode( $post, 'uo_groups_manage_progress' ) || Utilities::has_block( $post, 'uncanny-learndash-groups/uo-groups-manage-progress' ) ) {
//			// Load needed scripts
//			wp_enqueue_script( 'ulgm-modernizr', Utilities::get_vendor( 'modernizr/js/modernizr.min.js' ), array( 'jquery' ), Utilities::get_version(), true );
//			wp_enqueue_script( 'ulgm-jquery-lazyload', Utilities::get_vendor( 'jquery-lazyload/js/jquery.lazyload.min.js' ), array( 'jquery' ), Utilities::get_version(), true );
//			wp_enqueue_script( 'ulgm-jplist-core', Utilities::get_vendor( 'jplist/js/jplist.core.min.js' ), array( 'jquery' ), Utilities::get_version(), true );
//			wp_enqueue_script( 'ulgm-jplist-history-bundle', Utilities::get_vendor( 'jplist/js/jplist.history-bundle.min.js' ), array(
//				'jquery',
//				'ulgm-jplist-core',
//			), Utilities::get_version(), true );
//			wp_enqueue_script( 'ulgm-jplist-pagination-bundle', Utilities::get_vendor( 'jplist/js/jplist.pagination-bundle.min.js' ), array(
//				'jquery',
//				'ulgm-jplist-core',
//			), Utilities::get_version(), true );
//			wp_enqueue_script( 'ulgm-jplist-textbox-filter', Utilities::get_vendor( 'jplist/js/jplist.textbox-filter.min.js' ), array(
//				'jquery',
//				'ulgm-jplist-core',
//			), Utilities::get_version(), true );
//			wp_enqueue_script( 'ulgm-jplist-sort-buttons', Utilities::get_vendor( 'jplist/js/jplist.sort-buttons.min.js' ), array(
//				'jquery',
//				'ulgm-jplist-core',
//			), Utilities::get_version(), true );
//			wp_enqueue_style( 'ulgm-font-awesome', Utilities::get_vendor( 'fontawesome/css/font-awesome.min.css' ), array(), Utilities::get_version() );
//
//			// Setup group management JS with localized WP Rest API variables @see rest-api-end-points.php
//			wp_register_script( 'ulgm-frontend', Utilities::get_asset( 'frontend', 'bundle.min.js' ), array(
//				'jquery',
//			), Utilities::get_version(), true );
//
//			// API data
//			$api_setup = array(
//				'root'  => esc_url_raw( rest_url() . 'ulgm_management/v1/' ),
//				'nonce' => \wp_create_nonce( 'wp_rest' ),
//			);
//
//			wp_localize_script( 'ulgm-frontend', 'ulgmRestApiSetup', $api_setup );
//			wp_enqueue_script( 'ulgm-frontend' );
//
//			wp_register_style( 'ulgm-frontend', Utilities::get_asset( 'frontend', 'bundle.min.css' ), array(), Utilities::get_version() );
//			$user_colors = Utilities::user_colors();
//			wp_add_inline_style( 'ulgm-frontend', $user_colors );
//			wp_enqueue_style( 'ulgm-frontend', $user_colors );
//
//			wp_enqueue_editor();
//
//			// Load File saving utility
//			wp_enqueue_script( 'ulgm-file-saver', Utilities::get_vendor( 'filesaver/js/filesaver.js' ), array(), Utilities::get_version(), true ); // @see https://github.com/eligrey/FileSaver.js
//
//			// Load Modal
//			wp_enqueue_script( 'ulgm-modal', Utilities::get_vendor( 'jquery-modal/js/jquery.modal.js' ), array( 'jquery' ), Utilities::get_version(), true ); // @see https://raw.githubusercontent.com/kylefox/jquery-modal/master/jquery.modal.js
//
//			wp_enqueue_style( 'ulgm-modal', Utilities::get_vendor( 'jquery-modal/css/jquery.modal.css' ), array(), Utilities::get_version() ); // @see https://raw.githubusercontent.com/kylefox/jquery-modal/master/jquery.modal.css
		}
	}

	/**
	 * Return the HTML template that is displayed by the shortcode
	 *
	 * @since 1.0.0
	 *
	 * @param array  $attributes The attributes passed in the the shortcode
	 * @param string $content    The content contained by the shortcode
	 *
	 * @return string $shortcode_template The HTML template loaded
	 */
	function uo_group_mgr( $attributes ) {

		ob_start();

		/*
		* Include template
		*/
		include( Utilities::get_template( 'course_info_shortcode.php' ) );

		return ob_get_clean();

	}
}