<?php

namespace uncanny_learndash_groups;

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Class DataShortcodes
 * @package uncanny_learndash_groups
 */
class AddGroupLeaderAccess {

	/**
	 * class constructor
	 */
	public function __construct() {
		if ( 'yes' !== get_option( 'do_not_add_group_leader_as_member', 'no' ) ) {
			add_action( 'wp_login', [ __CLASS__, 'add_to_group_on_login' ], 99 );
		}
	}

	/**
	 * Add Group Leader to all courses
	 *
	 * @since 1.0
	 *
	 **@param $user_login
	 *
	 * @param $user
	 */
	public static function add_to_group_on_login( $user_login = '' ) {
		if ( $user_login ) {
			$user = get_user_by( 'login', $user_login );
			if ( $user ) {
				global $wpdb;
				$user_id = $user->ID;
				if ( isset( $user->roles ) && is_array( $user->roles ) ) {
					if ( in_array( 'group_leader', $user->roles, true ) && ! in_array( 'administrator', $user->roles ) ) {
						$results = $wpdb->get_results( $wpdb->prepare( "SELECT meta_value FROM {$wpdb->usermeta} WHERE user_id = %d AND meta_key LIKE '%%%s%%'", $user_id, 'learndash_group_leaders_' ) );
						if ( $results ) {
							foreach ( $results as $result ) {
								ld_update_group_access( $user_id, $result->meta_value );
								$course_access = $wpdb->get_results( $wpdb->prepare( "SELECT post_id FROM {$wpdb->postmeta} WHERE meta_key LIKE %s", 'learndash_group_enrolled_' . $result->meta_value ) );
								if ( $course_access ) {
									foreach ( $course_access as $c ) {
										ld_update_course_access( $user_id, $c->post_id );
									}
								}
							}
						}
					}
				}
			}
		}
	}


}