const {__} = wp.i18n;

const {
    assign
} = lodash;

const {
    addFilter
} = wp.hooks;

const {
    SelectControl,
    PanelBody,
    TextControl
} = wp.components;

const {
    Fragment
} = wp.element;

const {
    createHigherOrderComponent
} = wp.compose;

const {
    InspectorControls
} = wp.editor;

export const addGroupsUOSettings = createHigherOrderComponent((BlockEdit) => {
    return (props) => {
        // Check if we have to do something
        if (props.name == 'uncanny-learndash-groups/uo-groups' && props.isSelected) {
            return (
                <Fragment>
                    <BlockEdit {...props} />
                    <InspectorControls>

                        <PanelBody title={__('Group Management Settings', 'uncanny-learndash-groups')}>

                            <SelectControl
                                label={__('Group Name Selector', 'uncanny-learndash-groups')}
                                value={props.attributes.groupNameSelector}
                                options={ [
                                    { label: 'Show', value: 'show' },
                                    { label: 'Hide', value: 'hide' },
                                ] }
                                onChange={(value) => {
                                    props.setAttributes({groupNameSelector: value});
                                }}
                            />

                            <SelectControl
                                label={__('Add Courses Button', 'uncanny-learndash-groups')}
                                value={props.attributes.addCoursesButton}
                                options={ [
                                    { label: 'Show', value: 'show' },
                                    { label: 'Hide', value: 'hide' },
                                ] }
                                onChange={(value) => {
                                    props.setAttributes({addCoursesButton: value});
                                }}
                            />

                            <SelectControl
                                label={__('Seats Quantity', 'uncanny-learndash-groups')}
                                value={props.attributes.seatsQuantity}
                                options={ [
                                    { label: 'Show', value: 'show' },
                                    { label: 'Hide', value: 'hide' },
                                ] }
                                onChange={(value) => {
                                    props.setAttributes({seatsQuantity: value});
                                }}
                            />

                            <SelectControl
                                label={__('Add Seats Button', 'uncanny-learndash-groups')}
                                value={props.attributes.addSeatsButton}
                                options={ [
                                    { label: 'Show', value: 'show' },
                                    { label: 'Hide', value: 'hide' },
                                ] }
                                onChange={(value) => {
                                    props.setAttributes({addSeatsButton: value});
                                }}
                            />

                            <SelectControl
                                label={__('Add User Button', 'uncanny-learndash-groups')}
                                value={props.attributes.addUserButton}
                                options={ [
                                    { label: 'Show', value: 'show' },
                                    { label: 'Hide', value: 'hide' },
                                ] }
                                onChange={(value) => {
                                    props.setAttributes({addUserButton: value});
                                }}
                            />

                            <SelectControl
                                label={__('Remove User Button', 'uncanny-learndash-groups')}
                                value={props.attributes.removeUserButton}
                                options={ [
                                    { label: 'Show', value: 'show' },
                                    { label: 'Hide', value: 'hide' },
                                ] }
                                onChange={(value) => {
                                    props.setAttributes({removeUserButton: value});
                                }}
                            />

                            <SelectControl
                                label={__('Upload Users Button', 'uncanny-learndash-groups')}
                                value={props.attributes.uploadUsersButton}
                                options={ [
                                    { label: 'Show', value: 'show' },
                                    { label: 'Hide', value: 'hide' },
                                ] }
                                onChange={(value) => {
                                    props.setAttributes({uploadUsersButton: value});
                                }}
                            />

                            <SelectControl
                                label={__('Download Keys Button', 'uncanny-learndash-groups')}
                                value={props.attributes.downloadKeysButton}
                                options={ [
                                    { label: 'Show', value: 'show' },
                                    { label: 'Hide', value: 'hide' },
                                ] }
                                onChange={(value) => {
                                    props.setAttributes({downloadKeysButton: value});
                                }}
                            />

                            <SelectControl
                                label={__('Progress Report Button', 'uncanny-learndash-groups')}
                                value={props.attributes.progressReportButton}
                                options={ [
                                    { label: 'Show', value: 'show' },
                                    { label: 'Hide', value: 'hide' },
                                ] }
                                onChange={(value) => {
                                    props.setAttributes({progressReportButton: value});
                                }}
                            />

                            <SelectControl
                                label={__('Quiz Report Button', 'uncanny-learndash-groups')}
                                value={props.attributes.quizReportButton}
                                options={ [
                                    { label: 'Show', value: 'show' },
                                    { label: 'Hide', value: 'hide' },
                                ] }
                                onChange={(value) => {
                                    props.setAttributes({quizReportButton: value});
                                }}
                            />
                            <SelectControl
                                label={__('Key Column', 'uncanny-learndash-groups')}
                                value={props.attributes.keyColumn}
                                options={ [
                                    { label: 'Show', value: 'show' },
                                    { label: 'Hide', value: 'hide' },
                                ] }
                                onChange={(value) => {
                                    props.setAttributes({keyColumn: value});
                                }}
                            />

                            <SelectControl
                                label={__('Group Leader Section', 'uncanny-learndash-groups')}
                                value={props.attributes.groupLeaderSection}
                                options={ [
                                    { label: 'Show', value: 'show' },
                                    { label: 'Hide', value: 'hide' },
                                ] }
                                onChange={(value) => {
                                    props.setAttributes({groupLeaderSection: value});
                                }}
                            />

                            <SelectControl
                                label={__('Add Group Leader Button', 'uncanny-learndash-groups')}
                                value={props.attributes.addGroupLeaderButton}
                                options={ [
                                    { label: 'Show', value: 'show' },
                                    { label: 'Hide', value: 'hide' },
                                ] }
                                onChange={(value) => {
                                    props.setAttributes({addGroupLeaderButton: value});
                                }}
                            />

                            <SelectControl
                                label={__('Key Options', 'uncanny-learndash-groups')}
                                value={props.attributes.keyOptions}
                                options={ [
                                    { label: 'Show', value: 'show' },
                                    { label: 'Hide', value: 'hide' },
                                ] }
                                onChange={(value) => {
                                    props.setAttributes({keyOptions: value});
                                }}
                            />

                            <SelectControl
                                label={__('Group Email Button', 'uncanny-learndash-groups')}
                                value={props.attributes.groupEmailEutton}
                                options={ [
                                    { label: 'Show', value: 'show' },
                                    { label: 'Hide', value: 'hide' },
                                ] }
                                onChange={(value) => {
                                    props.setAttributes({groupEmailEutton: value});
                                }}
                            />
                        </PanelBody>

                    </InspectorControls>
                </Fragment>
            );
        }

        return <BlockEdit {...props} />;
    };
}, 'addGroupsUOSettings');

addFilter('editor.BlockEdit', 'uncanny-learndash-groups/uo-groups', addGroupsUOSettings);

export const addGroupsUrlUOSettings = createHigherOrderComponent((BlockEdit) => {
    return (props) => {
        // Check if we have to do something
        if (props.name == 'uncanny-learndash-groups/uo-groups-url' && props.isSelected) {
            return (
                <Fragment>
                    <BlockEdit {...props} />
                    <InspectorControls>

                        <PanelBody title={__('Group Management Link Settings', 'uncanny-learndash-groups')}>

                            <TextControl
                                label={ __( 'Link Text', 'uncanny-learndash-groups' ) }
                                value={ props.attributes.text }
                                type="string"
                                onChange={ ( value ) => {
                                    props.setAttributes({
                                        text: value
                                    });
                                }}
                            />
                        </PanelBody>

                    </InspectorControls>
                </Fragment>
            );
        }

        return <BlockEdit {...props} />;
    };
}, 'addGroupsUrlUOSettings');

addFilter('editor.BlockEdit', 'uncanny-learndash-groups/uo-groups-url', addGroupsUrlUOSettings);