(function($){
	$(document).ready(function(){
		hide_sort_buttons();
		copy_to_clipboard();
		ux_buttons();
		hide_tables_while_loading();
	});

	function hide_sort_buttons(){
		var sort_buttons_container = $('.uo-table-sort-buttons');
		sort_buttons_container.on('click', '.uo-table-sort-btn', function(){
			var closest_group = $(this).closest('.uo-table-sort-buttons'),
				direction = $(this).data('direction');
			$(this).hide();
			closest_group.find('.uo-table-sort-btn:not([data-direction="'+direction+'"])').show();
		});
	}

	function copy_to_clipboard(){
		var button = $('.uo-copy-to-clipboard-button');
		button.click(function(){
			var container = $(this).closest('.uo-copy-to-clipboard'),
				input = $(container.find('input'));
			input.select();
			document.execCommand('Copy');
		});
	}

	function ux_buttons(){
		// group-management > enrolled users Hide "Add user" when an user is selected in the table
		var enrolled_user_checkboxes = $('.uo-groups-enrolled-users input[name="user-id[]"], .uo-groups-enrolled-users input#select-all-users'),
			btn_add_users = $('#uo_add_users_button');

		enrolled_user_checkboxes.change(function(){
			var at_least_one_selected = enrolled_user_checkboxes.is(':checked');

			if (at_least_one_selected)
				btn_add_users.hide();
			else
				btn_add_users.show();
		});

		$( '#uo-open-bulk-add' ).on( 'click', function(){
			let container = $( '.uo-groups-bulk' );
			container.slideToggle( 500 );

			$( 'html, body' ).animate({
				scrollTop: container.offset().top - 100
			}, 500);
		});

		$( '.uo-groups-bulk-close' ).on( 'click', function(){
			let container = $( '.uo-groups-bulk' );
			container.slideToggle( 500 );
		});

		// group-management > group leaders Hide "Add group leader" when a leader is selected in the table
		var group_leaders_checkboxes = $('.uo-groups-group-leaders input[name="group-leader-id[]"], .uo-groups-enrolled-users input#select-all-group-leaders'),
			btn_add_leader = $('.uo-groups-group-leaders .uo-btn[data-modal-id="#group-management-add-group-leader"]');

		group_leaders_checkboxes.on('change', function(){
			var at_least_one_selected = group_leaders_checkboxes.is(':checked');

			if (at_least_one_selected)
				btn_add_leader.hide();
			else
				btn_add_leader.show();
		});

		// Group buttons in small devices
		$( '.uo-groups-list-of-btns-main' ).click( function( event ){
			// Get the clicked button
			var $currentButton    = $( event.currentTarget ),
			// then get the group id
				groupId           = $currentButton.data( 'id' ),
			// and get the direction
				dropdownDirection = typeof $currentButton.data( 'direction' ) == 'undefined' ? 'right' : $currentButton.data( 'direction' );

			// Once we have the group id, get the main container, which contains the items to show
			var $targetGroup   = $( '.uo-groups-list-of-btns[data-id="' + groupId + '"]' );

			// Check if the group exists
			if ( $targetGroup.length == 1 ){
				// Check if it's open
				var isGroupOpen = $targetGroup.hasClass( 'uo-groups-list-of-btns-open' );

				// Check if it's closed
				if ( ! isGroupOpen ){
					// Add class to show it
					$targetGroup.addClass( 'uo-groups-list-of-btns-open' );

					// Add the class to set the direction
					if ( dropdownDirection == 'left' || dropdownDirection == 'right' ){
						$targetGroup.addClass( 'uo-groups-list-of-btns--' + dropdownDirection );
					}

					bind_click_outside();
				}
				else {
					// Remove class to show the group
					$targetGroup.removeClass( 'uo-groups-list-of-btns-open' );
				}
			}
			else {
				console.error( 'We couldn\'t find the dropdown' );
			}
		});

		// Close if clicks on a button inside a list of buttons
		var btns_inside_list = $('.uo-groups-list-of-btns .uo-groups-list .uo-btn');
		btns_inside_list.click(function(){
			var group = $(this).closest('.uo-groups-list-of-btns');
			group.removeClass('uo-groups-list-of-btns-open')
		});

		function bind_click_outside(){
			// Close if user taps outside
			$(document).mouseup(function(e){
				var container = $('.uo-groups-list-of-btns');
				if (!container.is(e.target) && container.has(e.target).length === 0){
					container.removeClass('uo-groups-list-of-btns-open');
					unbind_click_outside();
				}
			});
		}

		function unbind_click_outside(){
			$('.uo-groups-list-of-btns').unbind('click', $(document)); 
		}
	}

	function hide_tables_while_loading(){
		// /group-management-report/
		var progress_report = $('#uo-group-progress-report'),
			triggers = $('.uo-groups.uo-reports #group-report select.change-group-management-form');

		triggers.change(function(){
			progress_report.hide();
		});
	}
})(jQuery);
