(function ($) { // Self Executing function with $ alias for jQuery

    /**
     *  Initialization  similar to include once but since all js is loaded by the browser automatically the all
     *   we have to do is call our functions to initialize them, his is only run in the main configuration file
     */
    $(document).ready(function () {

        $(document).on('modal:open',function(e){
            if(e.target.id === 'group-management-email-users'){
                wp.editor.remove('group_email_text');
                wp.editor.initialize('group_email_text',
                    {
                        tinymce: {
                            min_height: 300,
                            formats:{alignleft: [{selector: "p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li", styles: {textAlign:"left"}},{selector: "img,table,dl.wp-caption", classes: "alignleft"}],aligncenter: [{selector: "p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li", styles: {textAlign:"center"}},{selector: "img,table,dl.wp-caption", classes: "aligncenter"}],alignright: [{selector: "p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li", styles: {textAlign:"right"}},{selector: "img,table,dl.wp-caption", classes: "alignright"}],strikethrough: {inline: "del"}},
                            toolbar1: 'formatselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image | forecolor backcolor emoticons',
                            plugins: "charmap colorpicker hr lists media paste tabfocus textcolor fullscreen wordpress wpautoresize wpeditimage wpemoji wpgallery wplink wpdialogs wptextpattern wpview"
                        },
                        quicktags: {
                            buttons: 'strong,em,link,ul,ol,li,code'
                        }
                    });
            }
        });
        // Select group to manage
        if ( jQuery.fn.select2 ){
            $( '.uo-groups select' ).select2();
        }
        
        if ($('#group-id').length > 0) {


            $('#group-id').change(function () {
                $(this).closest('form').submit();
            });
        }

        window.ulgmGroupManagement.groupManagementModal.constructor();
        window.ulgmGroupManagement.responsiveTables.constructor();
    });

    window.ulgmGroupManagement.downloadCsv = function(csv){

        var blob = new Blob([csv.csvDataString], {type: "text/plain;charset=utf-8"});
        saveAs(blob, csv.fileName+".csv");

    };

    window.ulgmGroupManagement.responsiveTables = {
        constructor: function () {
            if ( $( '#group-management-users' ).length > 0 ){
                this.initializeTable('#group-management-users');
                this.columnSorting();
                this.userSelection();
                this.groupLeaderSelection();
            }    
        },

        initializeTable: function (id) {
            $(id).jplist({
                itemsBox: '.uo-group-management-table'
                , itemPath: '.uo-tbl-item'
                , panelPath: '.jplist-panel'
                , redrawCallback: function(collection, $dataview, statuses){
                    if( 0 === $dataview.length){
                        $('#user-table-header .uo-tbl-item div').hide();
                    }else{
                        $('#user-table-header .uo-tbl-item div').show();
                    }
                }
            });
        },

        columnSorting: function () {
            //alternate up / down buttons on header click
            $('.uo-group-management-table .header').on('click', function () {
                $(this).next('.sort-btns').find('[data-path]:not(.jplist-selected):first').trigger('click');
            });
        },

        userSelection: function () {



            $('#group-management-users #select-all-users').on('change', function () {

                var input = $(this);
                var checkedInputs = input.is(':checked');
                var selectUser = $('.select-user');

                if (checkedInputs) {
                    selectUser.prop('checked', true);
                    $('.group-user-management-buttons').show();
                } else {
                    selectUser.prop('checked', false);
                    $('.group-user-management-buttons').hide();
                }

                var allSelectedUser = $('.select-user:checked');
                // set amount of user in rest form
                $('.amount-users').text(allSelectedUser.length);

                var stringifiedAllSelectedUsers = '';

                $.each(allSelectedUser, function(){
                    stringifiedAllSelectedUsers += $(this).val()+',';
                });

                // add inputs hidden user input
                $('#removing-users' ).val(stringifiedAllSelectedUsers.slice(0, -1));
                $('#resending-users').val(stringifiedAllSelectedUsers.slice(0, -1));



            });

            $('#group-management-users').on('change', '.select-user', function () {

                if ($('.select-user').is(':checked')) {
                    $('.group-user-management-buttons').show();
                } else {
                    $('.group-user-management-buttons').hide();
                    $('#select-all-users').prop('checked', false);
                }

                var allSelectedUser = $('.select-user:checked');

                $('.amount-users').text(allSelectedUser.length);

                var stringifiedAllSelectedUsers = '';

                $.each(allSelectedUser, function(){
                    stringifiedAllSelectedUsers += $(this).val()+',';
                });

                // add inputs hidden user input
                $('#removing-users' ).val(stringifiedAllSelectedUsers.slice(0, -1));
                $('#resending-users').val(stringifiedAllSelectedUsers.slice(0, -1));

            });


        },

        groupLeaderSelection: function () {

            $('#group-management-leaders #select-all-group-leaders').on('change', function () {

                var input = $(this);
                var checkedInputs = input.is(':checked');
                var selectLeader = $('.select-group-leader');

                if (checkedInputs) {
                    selectLeader.prop('checked', true);
                    selectLeader.trigger('change');
                    $('.group-leader-management-buttons').show();
                } else {
                    selectLeader.prop('checked', false);
                    selectLeader.trigger('change');
                    $('.group-leader-management-buttons').hide();
                }

                var allSelectedLeaders = $('.select-group-leader:checked');
                // set amount of user in rest form
                $('.amount-group-leaders').text(allSelectedLeaders.length);

                var stringifiedAllSelectedUsers = '';

                $.each(allSelectedLeaders, function(){
                    stringifiedAllSelectedUsers += $(this).val()+',';
                });

                // add inputs hidden user input
                $('#removing-group-leaders' ).val(stringifiedAllSelectedUsers.slice(0, -1));

            });

            $('#group-management-leaders').on('change', '.select-group-leader', function () {

                if ($('.select-group-leader').is(':checked')) {
                    $('.group-leader-management-buttons').show();
                } else {
                    $('.group-leader-management-buttons').hide();
                    $('#select-all-group-leaders').prop('checked', false);
                }

                var allSelectedLeaders = $('.select-group-leader:checked');

                $('.amount-group-leaders').text(allSelectedLeaders.length);

                var stringifiedAllSelectedLeaders = '';

                $.each(allSelectedLeaders, function(){
                    stringifiedAllSelectedLeaders += $(this).val()+',';
                });

                // add inputs hidden user input
                $('#removing-group-leaders' ).val(stringifiedAllSelectedLeaders.slice(0, -1));

            });

        }

    },

        window.ulgmGroupManagement.groupManagementModal = {

            // initialize the code
            constructor: function () {

                // Add events for the group management page
                this.addGroupManagementEvents();

            },

            addGroupManagementEvents: function () {

                // Clear file so we get a fresh copy every time
                $("#csv-file").on( 'click', function(){
                    $(this).val('');
                });

                // There may be other plugin/themes that are using this modal or using the same trigger. let customize the trigger
                $('.ulgm-modal-link').on('click', this.openModal);

                // User csv file input change
                $('#csv-file').on('change', this.parseCsv);

                //Hide inupts dependent on radio
                $("input:radio[name=action]").click(function() {
                    var value = $(this).val();
                    var modalContainer = $(this).parent();

                    modalContainer.children('#first-name, #last-name, #email, label[for=first-name], label[for=last-name], label[for=email-name]').show();

                    if( 'send-enrollment' === value || 'add-existing-user' === value ){
                        modalContainer.children('#first-name, #last-name, label[for=first-name], label[for=last-name]').hide();
                    }

                });
            },

            openModal: function (e) {

                // clear any error messages
                $('.group-management-form').find('.group-management-rest-message').html('').hide();

                var modalId = $(this).data('modal-id');
                var modal = $(modalId);
                modal.modal();




            },

            parseCsv: function (e) {

                var input = $(this);
                var messageContainer = $( input.closest('.group-management-form') ).find('.group-management-rest-message')

                // Reset Message
                messageContainer.hide();
                messageContainer.text('');

                try {
                    var reader = new FileReader();
                    //do something
                }
                catch (e) {
                    messageContainer.text("Error: File API is not supported. Update your browser.").css('display', 'inline-flex');
                    return false;
                }

                var file = $('#csv-file')[0].files[0];
                var csvText = false;


                if (file) {
                    // check is csv extension
                    if ('csv' !== file.name.split('.').pop()) {
                        messageContainer.text("Please select a CSV (.csv) file.").css('display', 'inline-flex');
                        return false;
                    }

                    reader.readAsText(file);

                    reader.onload = function (e) {

                        csvText = e.target.result;

                        if (!csvText) {
                            messageContainer.text("CSV File Error").css('display', 'inline-flex');
                            return false;
                        }

                        // split file text on line breaks
                        var csvArray = csvText.split(/\r?\n/g);

                        // Preliminary checks

                        // Pull out the header and store it

                        var csvHead = csvArray.shift();
                        csvHead = csvHead.split(",");

                        // Something is off ... create to detect CR only line breaks where CRLF is only supported but may detect other malformations
                        if( csvHead.length !== 3 && csvArray.length === 0 ){
                                messageContainer.text("An incompatible format was detected. Please see the KB for supported .csv formats.").css('display', 'inline-flex');
                                return false;
                        }

                        // Remove last line of csv that is always blank
                        csvArray.pop();

                        // Require emails
                        var emailIndex = window.ulgmGroupManagement.groupManagementModal.verifyRequiredHeaders(csvHead, 'user_email');
                        if ('error' === emailIndex) {
                            messageContainer.text("The first row of the CSV file must contain the column header user_email.").css('display', 'inline-flex');
                            return false;
                        }

                        // Require user first name
                        var firstNameIndex = window.ulgmGroupManagement.groupManagementModal.verifyRequiredHeaders(csvHead, 'first_name');
                        if ('error' === firstNameIndex) {
                            messageContainer.text("The first row of the CSV file must contain the column header first_name.").css('display', 'inline-flex');
                            return false;
                        }

                        // Require user first name
                        var lastNameIndex = window.ulgmGroupManagement.groupManagementModal.verifyRequiredHeaders(csvHead, 'last_name');
                        if ('error' === lastNameIndex) {
                            messageContainer.text("The first row of the CSV file must contain the column header last_name.").css('display', 'inline-flex');
                            return false;
                        }

                        var newArray = csvArray.map(function mapper(v) {
                            if (typeof v == "string") {
                                return v.split(",");
                            } else {
                                return v.map(mapper);
                            }
                        });


                        // Check for blank lines
                        var emptyRows = window.ulgmGroupManagement.groupManagementModal.verifyEmptyRows(newArray, emailIndex);

                        if (emptyRows) {
                            messageContainer.text('Each row in the CSV must contain a user_email value.').css('display', 'inline-flex');
                            return false;
                        }

                        $('#csv-text').val(csvText);


                    };
                } else {
                    $( input.closest('.group-management-form') ).find('.group-management-rest-message').text('Please choose a file to upload.');
                    return false;
                }

            },

            verifyEmptyRows: function (array, emailIndex) {

                for (var i = 0; i < array.length; ++i) {
                    if (array[i][emailIndex] === '' ) {
                        return true;
                    }
                }

                return false;

            },

            verifyRequiredHeaders: function verifyRequiredHeaders(headerArray, type) {

                var columnsAmount = 0;
                var columnIndex = false;
                for (var i = 0; i < headerArray.length; i++) {
                    if (headerArray[i] === type) {
                        columnsAmount++;
                        columnIndex = i;
                    }
                }

                if (0 === columnsAmount) {
                    return 'error';

                }

                if (1 !== columnsAmount) {
                    return 'error';
                }

                return columnIndex;

            }

        }

    jQuery(document).ready(function(){
        jQuery("#group-management-users .pagination-container button").click(function(event){
            //event.preventDefault();
            window.location = '#user-table-header';
        });
    });


})(jQuery);
