<?php

namespace uncanny_ceu;

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Class FrontendCourseReport
 * @package uncanny_ceu
 */
class FrontendCourseReport {

	/**
	 * FrontendCourseReport constructor.
	 */
	public function __construct() {

		add_shortcode( 'uo_ceu_report', array( $this, 'uo_ceu_report_shortcode' ) );
		add_action( 'wp_enqueue_scripts', array( $this, 'load_custom_wp_style' ) );

	}

	/**
	 *
	 */
	public function load_custom_wp_style() {
		global $post;
		if ( $post instanceof \WP_Post ){
			// Check if it has the shortcode
			$has_shortcode = has_shortcode( $post->post_content, 'uo_ceu_report' );

			// Check if it has the Gutenberg block
			$has_gutenberg_block = false;

			// Check if Gutenberg exists (just in case the user
			// is using WP < 5.0 )
			if ( function_exists( 'has_blocks' ) && function_exists( 'parse_blocks' ) ){
				// Check if the post content has blocks
				if ( has_blocks( $post->post_content ) ){
					// Get all the blocks
					$blocks = parse_blocks( $post->post_content );

					// Iterate all the blocks
					foreach ( $blocks as $block ){
						// Check if one of the blocks is the Tin Canny
						// Gutenberg block
						if ( $block[ 'blockName' ] == 'uncanny-ceu/uo-ceu-course-report' ){
							// Change value of variable
							$has_gutenberg_block = true;

							// and stop the iteration. One is enough
							// we don't have to continue searching
							break;
						}
					}
				}
			}

			// Check if it has either the shortcode or the Gutenberg block and enqueue the assets
			if ( $has_shortcode || $has_gutenberg_block ){
				// DataTables
				wp_enqueue_script( 'ucec-datatables', Utilities::get_vendor( 'datatables/datatables.min.js' ), [ 'jquery' ], Utilities::get_version() );
				wp_enqueue_style( 'ucec-datatables',  Utilities::get_vendor( 'datatables/datatables.min.css' ), [], Utilities::get_version() );

				// Global assets
				wp_enqueue_script( 'ucec', Utilities::get_asset( 'frontend', 'bundle.min.js' ), [ 'jquery', 'ucec-datatables' ], Utilities::get_version() );
				wp_enqueue_style( 'ucec',  Utilities::get_asset( 'frontend', 'bundle.min.css' ), [ 'ucec-datatables' ], Utilities::get_version() );
			}
		}
	}

	/**
	 *
	 */
	public function uo_ceu_report_shortcode(){
		// Default values of variables that are going to be changed later
		$users           = [];
		$ceu_completions = [];
		$has_results     = false;

		// Get search terms
		$search_terms     = isset( $_REQUEST[ 'search' ] ) ? $_REQUEST[ 'search' ] : '';

		// Check if it has search terms
		$has_search_terms = ! empty( $search_terms );

		// If it does then do the search
		if ( $has_search_terms ){
			// Get global variable $wpdb
			global $wpdb;

			// Sanitaze user search
			$user_search = sanitize_text_field( $_REQUEST[ 'search' ] );
			
			// Define query
			$query = "
				SELECT DISTINCT user.ID, user.user_email 
				FROM $wpdb->users user
				JOIN $wpdb->usermeta meta1 ON user.ID = meta1.user_id 
				JOIN $wpdb->usermeta meta2 ON user.ID = meta2.user_id 
				WHERE meta1.meta_key LIKE 'ceu_earned_%'
				AND meta2.meta_key LIKE '%_name'
				AND ( 
				user.display_name like '%$user_search%' || 
				user.user_email like '%$user_search%' || 
				user.user_nicename like '%$user_search%' || 
				user.user_login like '%$user_search%' ||
				meta2.meta_value LIKE '%$user_search%'
			)";

			// Get results
			$users = $wpdb->get_results( $query );

			// Check if it has results
			$has_results = $users != false;

			// Iterate each user
			foreach ( $users as $user ){
				// Get user meta
				$user_meta = get_user_meta( $user->ID );

				// Get user data
				$user_id         = $user->ID;
				$user_first_name = $user_meta[ 'first_name' ][0];
				$user_last_name  = $user_meta[ 'last_name' ][0];
				$user_email      = $user->user_email;

				// Set default number of CEUs
				$total_ceus      = 0;

				// Iterate each meta to find CEU information
				foreach ( $user_meta as $meta_key => $meta_value ){
					// Check if it's a CEU's meta
					if ( strpos( $meta_key, 'ceu_' ) !== false ){
						// Get key
						$key        = explode( '_', $meta_key );
						$collection = array( 'title', 'date', 'course', 'earned' );

						if ( ! in_array( $key[1], $collection ) ){
							continue;
						}

						$unique_key = $key[2] . '_' . $key[3]; //unique identifier for ceu completion...  {timestamp}_{course ID}
						$value_key  = $key[0] . '_' . $key[1]; // name of data stored... ceu_title  ceu_date  ceu_course  ceu_earned
						$meta_date  = (int) $key[2];

						if ( 'ceu_earned' === $value_key ) {
							$total_ceus += (float) $meta_value[0];
						}

						if ( ! isset( $ceu_completions[ $unique_key ] ) ) {
							$ceu_completions[ $unique_key ]               = array();
							$ceu_completions[ $unique_key ]['user_id'] = $user_id;
							$ceu_completions[ $unique_key ]['first_name'] = $user_first_name;
							$ceu_completions[ $unique_key ]['last_name']  = $user_last_name;
							$ceu_completions[ $unique_key ]['email']      = $user_email;
							$ceu_completions[ $unique_key ]['total_ceus'] = 0;
						}

						$ceu_completions[ $unique_key ][ $value_key ] = $meta_value[0];

						if ( 'ceu_earned' === $value_key ) {
							$ceu_completions[ $unique_key ]['total_ceus'] += $total_ceus;
						}
					}
				}
			}
		}

		// Start output
	    ob_start();

	    // Include template
	    include Utilities::get_template( 'frontend-course-report.php' );

	    // Return output
        return ob_get_clean();
	}

}