<?php
/**
 * Shortcode: Subscriber Form
 *
 * @since 1.0.0
 */

defined( 'ABSPATH' ) || die();

/**
 * Class LD_ConvertKit_Shortcode_SubscriberForm
 *
 * Adds a subscriber form to the page.
 *
 * @since 1.0.0
 */
class LD_ConvertKit_Shortcode_SubscriberForm {

	/**
	 * LD_ConvertKit_Shortcode_SubscriberForm constructor.
	 *
	 * @since 1.0.0
	 */
	function __construct() {

		add_shortcode( 'ld_convertkit_subscriber_form', array( __CLASS__, 'shortcode' ) );
		add_filter( 'learndash_shortcodes_content_args', array( $this, 'add_shortcode_section' ) );
	}

	/**
	 * Add Subscription Form via Shortcode
	 *
	 * @since 1.0.0
	 *
	 * @param array $atts Shortcode Atts
	 * @param string $content Shortcode Content. Unused.
	 *
	 * @return string HTML
	 */
	public static function shortcode( $atts, $content = '' ) {

		global $post;

		if ( ! is_user_logged_in() ) {

			return '';
		}

		$atts = shortcode_atts( array(
			'course' => false,
		), $atts, 'ld_convertkit' );

		$post_type = get_post_type();
		$course_id = false;

		// You can determine Course from other LearnDash Content Types
		if ( $atts['course'] === false &&
		     strpos( $post_type, 'sfwd' ) !== false
		) {

			if ( $post_type == 'sfwd-courses' ) {

				$course_id = get_the_ID();

			} else {

				$post_meta = get_post_meta( get_the_ID(), '_' . $post_type, true );

				if ( isset( $post_meta[ $post_type . '_course' ] ) &&
				     $post_meta[ $post_type . '_course' ] != '' ) {
					$course_id = $post_meta[ $post_type . '_course' ];
				}
			}

		} else {

			if ( $atts['course'] !== false ) {

				$course_id = trim( $atts['course'] );
			}
		}

		if ( $course_id ) {

			ob_start();

			LD_ConvertKit_Courses::show_subscribe_form( $course_id );

			return ob_get_clean();
		}

		return '';
	}

	/**
	 * Adds this shortcode to the shortcode sections in TinyMCE.
	 *
	 * @since 1.0.0
	 * @access private
	 *
	 * @param array $shortcode_sections
	 */
	function add_shortcode_section( $shortcode_sections ) {

		require_once 'sections/class-ld-convertkit-shortcodes-section-subscriber-form.php';

		$shortcode_sections['ld_convertkit_subscriber_form'] = new LD_ConvertKit_Shortcodes_Section_SubscriberForm();

		return $shortcode_sections;
	}
}