<?php
defined( 'ABSPATH' ) || die();

/**
 * Class LD_ConvertKit_UserProfile
 *
 * Adds information to the user profile page.
 *
 * @since 1.0.0
 *
 * @since 1.0.0
 */
class LD_ConvertKit_UserProfile {

	/**
	 * LD_ConvertKit_UserProfile constructor.
	 *
	 * @since 1.0.0
	 */
	function __construct() {

		add_action( 'show_user_profile', array( $this, 'extra_user_profile_fields' ) );
		add_action( 'edit_user_profile', array( $this, 'extra_user_profile_fields' ) );
	}

	/**
	 * Adds user profile fields.
	 *
	 * @since 1.0.0
	 * @access private
	 *
	 * @param WP_User $user The user object of the user being viewed.
	 */
	function extra_user_profile_fields( $user ) {

		$this->show_subscription_status( $user );
	}

	/**
	 * Shows user subscription status to ConvertKit.
	 *
	 * @since 1.0.0
	 * @access private
	 *
	 * @param WP_User $user The user object of the user being viewed.
	 */
	private function show_subscription_status( $user ) {

		$subscriber_ID = ld_convertkit_get_user_subscribe_id( $user->ID );

		if ( $subscriber_ID ) {

			$subscriber = LD_ConvertKit_API()->get_subscriber( $subscriber_ID );

			include 'views/subscription-status-subscribed.php';

		} else {

			include 'views/subscription-status-not-subscribed.php';
		}
	}
}