<?php
/**
 * IR Feature Showcase Template
 *
 * @since 3.1.0
 */
?>

<?php
    $page_variables = \irInstructorShowcase::fetchPageData();
?>
<head>
    <?php \irInstructorShowcase::irEnqueueShowcaseStyles(); ?>
</head>
<body>
    <span class="ir-previous dashicons dashicons-arrow-left-alt2"></span>
    <div class="ir-feature-container">
        <div class="ir-logo">
            <img src="<?php echo $page_variables['logo_url']?>" alt="<?php echo $page_variables['logo_alt']; ?>" style="">
        </div>
        <div class="ir-main-page">
            <div class="ir-page ir-active">
                <div class="ir-feature-description">
                    <?php _e('Introducing the new admin customizer to give your instructor screens a new vibrant look', 'instructor-role') ?>
                </div>
                <div class="ir-feature-image">
                    <img src="<?php echo $page_variables['img-1']?>" />
                </div>
            </div>
            <div class="ir-page">
                <div class="ir-feature-description">
                    <?php _e('Control the admin customizer visibility for your admin, instructor and all other users', 'instructor-role') ?>
                </div>
                <div class="ir-feature-image">
                    <img src="<?php echo $page_variables['img-2']?>" />
                </div>
            </div>
            <div class="ir-page">
                <div class="ir-feature-description">
                    <?php _e('Now get a view for your course stats on a single screen from the Instructor Overview Page', 'instructor-role') ?>
                </div>
                <div class="ir-feature-image">
                    <img src="<?php echo $page_variables['img-3']?>" />
                </div>
            </div>
            <div class="ir-page">
                <div class="ir-feature-description">
                    <?php _e('Collaborate with other instructors by sharing courses.', 'instructor-role') ?>
                </div>
                <div class="ir-feature-image">
                    <img src="<?php echo $page_variables['img-4']?>" />
                </div>
            </div>
        </div>
    </div>
    <?php \irInstructorShowcase::irEnqueueShowcaseScripts(); ?>
    <span class="ir-after dashicons dashicons-arrow-right-alt2"></span>
    <a class="btn ir-back-btn" href="<?php echo $page_variables['admin_url']; ?>"><?php _e('Back to Dashboard', 'instructor-role')?></a>
</body>