<?php

namespace uncanny_learndash_groups;

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Class WoocommerceBuyCourses
 * @package uncanny_learndash_groups
 */
class WoocommerceBuyCourses {

	/**
	 * WoocommerceBuyCourses constructor.
	 */
	function __construct() {
		if ( Utilities::if_woocommerce_active() ) {

			add_action( 'plugins_loaded', array( $this, 'plugins_loaded' ), 20 );

			add_shortcode( 'uo_groups_buy_courses', array( $this, 'uo_buy_courses_func' ) );
			add_action( 'wp_enqueue_scripts', array( $this, 'uo_group_buy_courses' ), 99 );
			add_action( 'init', array( $this, 'create_custom_product' ), 20 );
		}
	}

	function plugins_loaded() {
		add_action( 'woocommerce_before_calculate_totals', array( $this, 'woo_license_price_update' ), 111 );
		add_filter( 'woocommerce_product_get_price', array( $this, 'return_custom_price' ), 111, 2 );
		/*add_action( 'woocommerce_cart_calculate_fees', array(
			$this,
			'calculate_cart_discounts_modify_group',
		), 20, 1 );*/
		add_action( 'woocommerce_cart_item_removed', array( $this, 'remove_additional_fields' ), 20, 2 );
		add_action( 'woocommerce_order_status_completed', array( $this, 'modify_existing_license' ), 1001 );
		add_action( 'delete_me_if_i_am_not_purchased', array( $this, 'delete_me_if_i_am_not_purchased' ) );
		add_action( 'reset_license_courses_back_to_original', array(
			$this,
			'reset_license_courses_back_to_original_price',
		) );
		add_action( 'woocommerce_before_cart_contents', array( $this, 'add_additional_qty_notice', ), 11, 1 );
		add_action( 'woocommerce_checkout_before_order_review', array( $this, 'add_additional_qty_notice', ), 11, 1 );

	}

	/**
	 *
	 */
	function uo_group_buy_courses() {
		global $post;

		if ( Utilities::has_shortcode( $post, 'uo_groups_buy_courses' ) || Utilities::has_block( $post, 'uncanny-learndash-groups/uo-groups-buy-courses' ) ) {
			wp_register_style( 'ulgm-frontend', Utilities::get_asset( 'frontend', 'bundle.min.css' ), array(), Utilities::get_version() );
			$user_colors = Utilities::user_colors();
			wp_add_inline_style( 'ulgm-frontend', $user_colors );
			wp_enqueue_style( 'ulgm-frontend', $user_colors );
		}
	}

	/**
	 * @param $attr
	 *
	 * @return string
	 */
	function uo_buy_courses_func() {
		ob_start();

		include( Utilities::get_template( 'frontend-uo_groups_buy_courses.php' ) );

		return ob_get_clean();
	}

	/**
	 * @param $product_id
	 */
	function delete_me_if_i_am_not_purchased( $product_id ) {
		$has_order_count = SharedFunctions::get_orders_from_product_id( absint( $product_id ) );
		//Utilities::log( $has_order_count, '$has_order_count', true, 'cron' );
		if ( 0 === absint( $has_order_count ) ) {
			//No order found related to this product-id
			wp_delete_post( $product_id, true );
		}
	}

	/**
	 * @param $product_id
	 */
	function reset_license_courses_back_to_original_price( $product_id ) {
		$last_modified = get_post_meta( $product_id, '_last_modified', true );
		if ( ! empty( $last_modified ) ) {
			$diff = ceil( ( ( time() - $last_modified ) / 60 ) );
			if ( $diff >= 15 ) {
				delete_post_meta( $product_id, SharedFunctions::$license_meta_field . '_new' );
			}
		}
	}

	/**
	 *
	 */
	public function add_additional_qty_notice() {
		$user_id       = wp_get_current_user()->ID;
		$get_transient = get_transient( '_ulgm_user_buy_courses_' . $user_id . '_order' );
		if ( ! empty( $get_transient ) ) {
			//$seats = strtolower( get_option( 'ulgm_per_seat_text_plural', __( 'Seats', 'uncanny-learndash-groups' ) ) );
			echo '<p class="woocommerce-message">' . __( 'Additional cost of license after adding a new course.', 'uncanny-learndash-groups' ) . '</p>';
		}
	}

	/**
	 *
	 */
	function create_custom_product() {
		if ( isset( $_POST['_custom_buy_courses'] ) && wp_verify_nonce( $_POST['_custom_buy_courses'], Utilities::get_plugin_name() ) ) {
			if ( isset( $_POST['modify_license'] ) && 'yes' === $_POST['modify_license'] ) {
				$group_id        = $_POST['group_id'];
				$product_id      = $_POST['product_id'];
				$new_courses     = $_POST['_custom_selected_courses'];
				$existing_course = get_post_meta( $product_id, SharedFunctions::$license_meta_field, true );
				$courses         = array_merge( $new_courses, $existing_course );
				update_post_meta( $product_id, SharedFunctions::$license_meta_field . '_new', $courses );
				update_post_meta( $product_id, '_ulgm_last_courses', $existing_course );
				update_post_meta( $product_id, '_last_modified', time() );
				$order_details = SharedFunctions::get_product_id_from_group_id( $group_id );
				$all_orders    = SharedFunctions::get_group_leader_all_orders( $group_id, $product_id );
				//Utilities::log( $all_orders, '$all_orders', true, 'orders' );
				$existing_qty = get_post_meta( $group_id, '_ulgm_total_seats', true );
				if ( empty( $existing_qty ) ) {
					$new_qty = 1;
				} else {
					$new_qty = $existing_qty;
				}
				if ( is_user_logged_in() && is_array( $order_details ) ) {
					$user_id    = wp_get_current_user()->ID;
					$order_id   = $order_details['order_id'];
					$product_id = $order_details['product_id'];
					$save_data  = array(
						'user_id'       => $user_id,
						'order_details' => $order_details,
						'group_id'      => $group_id,
						'order_id'      => $order_id,
						'all_orders'    => $all_orders,
						'existing_qty'  => $existing_qty,
						'new_qty'       => $new_qty,
					);
					SharedFunctions::remove_transient_cache( 'no', '_ulgm_user_USERID_order', $user_id );
					SharedFunctions::set_transient_cache( '_ulgm_user_buy_courses_USERID_order', $save_data, $user_id );
					wp_schedule_single_event( time() + 879, 'reset_license_courses_back_to_original', array( $product_id ) );
				}
				\WC()->cart->empty_cart();
				wp_safe_redirect( wc_get_checkout_url() . '?add-to-cart=' . $product_id . '&quantity=' . $new_qty );
				exit;

			} else {
				$group_name    = wp_strip_all_tags( $_POST['_custom_group_name'] );
				$group_courses = $_POST['_custom_selected_courses'];
				$qty           = (int) $_POST['_custom_qty'];

				if ( is_user_logged_in() ) {
					$user_id = wp_get_current_user()->ID;
				} else {
					$user_id = 1;
				}
				$new_product_post = array(
					'post_title'  => sprintf( __( '%s - License', 'uncanny-learndash-groups' ), $group_name ),
					'post_status' => 'publish',
					'post_author' => $user_id,
					'post_type'   => 'product',
				);
				$new_product_id   = wp_insert_post( $new_product_post );
				//WC()->cart->empty_cart();
				$cat_id = get_option( 'ulgm_group_license_product_cat', '' );
				if ( ! empty( $cat_id ) ) {
					wp_set_object_terms( $new_product_id, absint( $cat_id ), 'product_cat' );
				}
				wp_set_object_terms( $new_product_id, array( 'license' ), 'product_type' );
				wp_set_object_terms( $new_product_id, array(
					'exclude-from-catalog',
					'exclude-from-search',
				), 'product_visibility' );

				update_post_meta( $new_product_id, SharedFunctions::$license_meta_field, $group_courses );
				update_post_meta( $new_product_id, '_uo_custom_buy_product', 'yes' );
				update_post_meta( $new_product_id, '_group_name', $group_name );

				wp_schedule_single_event( time() + 86400, 'delete_me_if_i_am_not_purchased', array(
					$new_product_id,
				) );

				\WC()->cart->empty_cart();
				delete_transient( '_ulgm_user_' . $user_id . '_order' );
				delete_transient( '_ulgm_user_buy_courses_' . $user_id . '_order' );
				wp_safe_redirect( wc_get_checkout_url() . '?add-to-cart=' . $new_product_id . '&quantity=' . $qty );
				exit;
			}
		}
	}

	/**
	 * @param $cart_object
	 *
	 * @return mixed
	 */
	public function woo_license_price_update( $cart_object ) {
		$total    = 0;
		$products = $cart_object->cart_contents;

		if ( $products ) {
			foreach ( $products as $cart_item_key => $prod ) {
				$id                = $prod['product_id'];
				$product           = wc_get_product( $id );
				$is_being_modified = get_post_meta( $id, '_last_modified', true );
				if ( ! empty( $is_being_modified ) ) :
					$diff = ceil( ( ( time() - $is_being_modified ) / 60 ) / 60 );

					if ( $product->is_type( 'license' ) && $diff < 3 ) {
						//$linked_courses = get_post_meta( $id, SharedFunctions::$license_meta_field . '_new', true );
						$additional_courses = $this->get_additional_courses( $id );
						//Utilities::log( $linked_courses, '$linked_courses', true, 'linked' );
						if ( $additional_courses ) {
							foreach ( $additional_courses as $course ) {
								$course_product = wc_get_product( $course );
								if ( $course_product ) {
									$price = $course_product->get_price();
									$total = floatval( $total ) + floatval( $price );
								}
							}
						}
						//Utilities::log( $total, '$total', true, 'linked' );

						$prod['data']->price = $total;
					}
				endif;
			}
		}

		return $cart_object;
	}

	/**
	 * @param $product_id
	 *
	 * @return int
	 */
	public function get_previous_cost_of_license( $product_id ) {
		$linked_courses = get_post_meta( $product_id, SharedFunctions::$license_meta_field, true );
		$total          = 0;
		//Utilities::log( $linked_courses, '$linked_courses', true, 'linked' );
		if ( $linked_courses ) {
			foreach ( $linked_courses as $course ) {
				$course_product = wc_get_product( $course );
				if ( $course_product ) {
					$price = $course_product->get_price();
					$total = floatval( $total ) + floatval( $price );
				}
			}
		}

		return $total;
	}

	/**
	 * @param $price
	 * @param \WC_Product $product
	 *
	 * @return int
	 */
	public function return_custom_price( $price, \WC_Product $product ) {
		$id                = $product->get_id();
		$is_being_modified = get_post_meta( $id, '_last_modified', true );
		if ( ! empty( $is_being_modified ) ) :
			$diff = ceil( ( ( time() - $is_being_modified ) / 60 ) / 60 );
			if ( $product->is_type( 'license' ) && $diff < 3 ) {
				$additional_courses = $this->get_additional_courses( $id );
				if ( $additional_courses ) {
					$price = 0;
					foreach ( $additional_courses as $course ) {
						$course_product = wc_get_product( $course );
						if ( $course_product ) {
							$price = floatval( $price ) + floatval( $course_product->get_price() );
						}
					}

					return $price;
				}
			}
		endif;

		return $price;
	}

	/**
	 * @param \WC_Cart $cart
	 */
	public function calculate_cart_discounts_modify_group( \WC_Cart $cart ) {
		$user_id       = wp_get_current_user()->ID;
		$existing_data = get_transient( '_ulgm_user_buy_courses_' . $user_id . '_order' );
		if ( $existing_data && count( $cart->cart_contents ) > 0 ) {

			foreach ( $cart->cart_contents as $cart_item_key => $values ) {
				$_product     = $values['data'];
				$license_cost = $this->get_previous_cost_of_license( $_product->get_ID() );
				//Utilities::log( $license_cost, '$license_cost', true, 'new-courses' );
				//$all_orders = $existing_data['all_orders'];
				if ( ! empty( $license_cost ) ) {
					$discount = $license_cost * $existing_data['existing_qty'];
					if ( $discount > 0 ) {
						//Utilities::log( $discount, '$new_amount', true, 'coeff' );
						$seats = strtolower( get_option( 'ulgm_per_seat_text_plural', __( 'Seats', 'uncanny-learndash-groups' ) ) );
						\WC()->cart->add_fee( __( sprintf( 'Credit for existing %s', $seats ), 'uncanny-learndash-groups' ), - $discount );
					}
				}
			}
		}
	}

	/**
	 * @param $cart_item_key
	 * @param $cart
	 */
	function remove_additional_fields( $cart_item_key, $cart ) {
		if ( ! empty( $cart ) ) {
			$cart_contents = $cart->removed_cart_contents;
			//Utilities::log( $cart_contents, '$cart_contents', true, 'remove' );
			foreach ( $cart_contents as $key => $item ) {
				if ( $cart_item_key === $key ) {
					$product_id = $item['product_id'];
					if ( 'yes' === get_post_meta( $product_id, '_uo_custom_buy_product', true ) ) {
						delete_post_meta( $product_id, '_last_modified' );
						delete_post_meta( $product_id, SharedFunctions::$license_meta_field . '_new' );
					}
				}
			}
		}
		SharedFunctions::remove_transient_cache( 'all' );
	}

	/**
	 * @param $product_id
	 *
	 * @return array
	 */
	public function get_additional_courses( $product_id ) {
		$existing_courses = get_post_meta( $product_id, SharedFunctions::$license_meta_field, true );
		$linked_courses   = get_post_meta( $product_id, SharedFunctions::$license_meta_field . '_new', true );
		if ( is_array( $existing_courses ) && is_array( $linked_courses ) ) {
			return array_diff( $linked_courses, $existing_courses );
		}

		return [];
	}

	/**
	 *
	 */
	function add_inline_js() {
		?>
		<script>
          jQuery('.product-quantity .quantity input').attr('disabled', 'disabled')
		</script>
		<?php
	}

	/**
	 * @param $order_id
	 */
	function modify_existing_license( $order_id ) {
		$order     = new \WC_Order( $order_id );
		$user_id   = $order->get_user_id();
		$transient = get_transient( '_ulgm_user_buy_courses_' . $user_id . '_order' );
		//Utilities::log( $transient, 'Transient', true, 'transient' );
		$line_items = $order->get_items( 'line_item' );

		if ( $transient ) :
			if ( ( $order ) && ( $order->has_status( 'completed' ) ) && $line_items ) :
				$group_id   = $transient['group_id'];
				$product_id = $transient['order_details']['product_id'];
				//Utilities::log( get_post_meta( $product_id ), '$product_id', true, 'transient' );
				if ( 'yes' === get_post_meta( $product_id, '_uo_custom_buy_product', true ) ) {
					$old_courses = get_post_meta( $product_id, SharedFunctions::$license_meta_field, true );
					update_post_meta( $product_id, '_ulgm_last_courses', $old_courses );
					$new_courses = get_post_meta( $product_id, SharedFunctions::$license_meta_field . '_new', true );
					update_post_meta( $product_id, SharedFunctions::$license_meta_field, $new_courses );
					update_post_meta( $product_id, 'total_sales', $transient['existing_qty'] );
					delete_post_meta( $product_id, '_last_modified' );
					delete_post_meta( $product_id, SharedFunctions::$license_meta_field . '_new' );

					if ( $new_courses ) {
						foreach ( $new_courses as $course_product ) {
							//Utilities::log( $course_product, 'Course', true, 'license' );
							$course_id = get_post_meta( $course_product, '_ulgm_course', true );
							ld_update_course_group_access( (int) $course_id, (int) $group_id, false );
							$transient_key = 'learndash_course_groups_' . $course_id;
							delete_transient( $transient_key );
						}
					}
				}
				SharedFunctions::remove_transient_cache( 'no', '_ulgm_user_buy_courses_USERID_order', $user_id );
			endif;
		endif;
	}
}