<?php

namespace uncanny_learndash_groups;

/**
 * Class MemberStyleShortcode
 * @package uncanny_learndash_groups
 */
class MemberStyleShortcode {
	/**
	 * MemberStyleShortcode constructor.
	 */
	function __construct() {
		add_shortcode( 'uo_groups_restrict_content', array( $this, 'uo_restrict_content' ) );
	}

	/**
	 * @param $atts
	 * @param null $contents
	 *
	 * @return int|null|string
	 */
	public function uo_restrict_content( $atts, $contents = null ) {
		//check tha the user is logged in
		if ( is_user_logged_in() ) {
			if ( ! in_array( 'administrator', wp_get_current_user()->roles ) ) {
				$user        = wp_get_current_user();
				$user_id     = $user->ID;
				$user_groups = learndash_get_users_group_ids( $user_id );
				$atts        = shortcode_atts(
					array(
						'user_groups' => 'all',
					),
					$atts,
					'uo_restrict_content' );

				if ( 'all' === $atts['user_groups'] ) {
					return do_shortcode( $contents );
				} else {
					$group_ids = explode( ',', $atts['user_groups'] );
					if ( is_array( $group_ids ) ) {
						foreach ( $group_ids as $g_id ) {
							if ( in_array( $g_id, $user_groups ) ) {
								return do_shortcode( $contents );
							}
						}

						return apply_filters('uo_restrict_content_no_access', '', $atts, $contents );
					} else {
						if ( in_array( $atts['user_groups'], $user_groups ) ) {
							return do_shortcode( $contents );
						} else {
							return apply_filters('uo_restrict_content_no_access', '', $atts, $contents );
						}
					}
				}
			} elseif ( in_array( 'administrator', wp_get_current_user()->roles ) ) {
				return do_shortcode( $contents );
			}
		} else {
			return apply_filters('uo_restrict_content_no_access', '', $atts, $contents );
		}
	}
}