<?php

namespace uncanny_learndash_groups;

if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Class GroupEssays
 *
 * @package uncanny_pro_toolkit
 */
class GroupEssays {
	
	/**
	 * Group essay shortcode.
	 *
	 * @since    1.0.0
	 * @access   public
	 * @var      string
	 */
	public static $ulgm_essays_shortcode = [];
	/**
	 * Group drop down
	 *
	 * @since    1.0.0
	 * @access   public
	 * @var      string
	 */
	public static $group_drop_downs = FALSE;
	/**
	 * Rest API root path
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string
	 */
	private $root_path = 'ulgm_essays_report/v1/';
	
	/**
	 * Class constructor
	 */
	public function __construct() {
		
		add_action( 'plugins_loaded', [ $this, 'run_frontend_hooks' ] );
		//register api class
		add_action( 'rest_api_init', [ $this, 'uo_api' ] );
		// register ajax call
		add_action( 'init', [ $this, '_essay_bulk_actions_approve' ] );
	}
	
	/*
	 * Initialize frontend actions and filters
	 */
	public function run_frontend_hooks() {
		add_shortcode( 'uo_groups_essays', [ $this, 'display_essays' ] );
	}
	
	/*
	 * Display the shortcode
	 * @param array $attributes
	 *
	 * @return string $html header and table
	 */
	public function display_essays( $request ) {
	 
		$request = shortcode_atts( [], $request );
		$html    = $this->generate_essays_html();
		$this->essays_scripts();
		
		return $html;
	}
	
	/*
	 * Generate Essays HTML Output
	 *
	 * @return string
	 */
	public function generate_essays_html() {
		
		self::$ulgm_essays_shortcode['text']['group_management_link'] = SharedFunctions::get_group_management_page_id( TRUE );
		
		self::$ulgm_essays_shortcode['text']['group_management'] = __( 'Back to Group Management', 'uncanny-learndash-groups' );
		
		return $this->create_essay_table();
	}
	
	/*
	 * Generate Essays HTML Table
	 *
	 * @return string
	 */
	public function create_essay_table() {
		global $post;
		$user_id = get_current_user_id();

		// Is the user logged in
		if ( ! $user_id ) {
			return __( 'Please log in to view the report.', 'uncanny-learndash-groups' );
		}

		// Is the user a group leader
		if ( user_can( $user_id, 'group_leader' ) ) {

			// Load Selection options for group and quiz list
			$group_drop_downs = $this->get_groups_drop_downs( $user_id );

		} else {
			return __( 'You must be a group leader to view this report.', 'uncanny-learndash-groups' );
		}
		global $wp;
		$current_page = home_url( $wp->request );
		ob_start();
		?>
        <div class="uo-groups uo-reports">
		<?php if ( ! empty( SharedFunctions::get_group_management_page_id() ) && $post->ID === SharedFunctions::get_group_essay_report_page_id() ): ?>
        <div class="uo-row uo-groups-section uo-groups-report-go-back">
            <div class="uo-groups-actions">
                <div class="group-management-buttons">
                    <button class="ulgm-link uo-btn uo-left uo-btn-arrow-left"
                            onclick="location.href='<?php echo GroupEssays::$ulgm_essays_shortcode['text']['group_management_link']; ?>'"
                            type="button">
						<?php echo GroupEssays::$ulgm_essays_shortcode['text']['group_management']; ?>
                    </button>
                </div>
            </div>
        </div>
		<?php endif; ?>
        <div class="uo-groups uo-quiz-report uo-groups-essays" id="uo-groups-essays-management">
            <form id="uo-groups-essays-management-form" method="post">

                <!-- <input type="hidden" id="_wpnonce" name="_wpnonce" value="<?php echo wp_create_nonce(); ?>"> -->
                <input type="hidden" name="_wp_http_referer" value="<?php echo $current_page; ?>">
                <input type="hidden" name="post_status" id="bulk-action-selector-top" value="">
                <input type="hidden" name="essay_id" id="bulk-post-selector-top" value="">
                <input type="hidden" name="_uogm_essay_action" value="sfwd-essay">
                <div class="uo-row uo-groups-section uo-groups-report-go-back">
                    <div class="uo-groups-actions">
                        <div class="group-management-buttons">
                            <!-- <button class="ulgm-link uo-btn uo-left uo-btn-arrow-left"
                                onclick="location.href='<?php echo GroupEssays::$ulgm_essays_shortcode['text']['group_management_link']; ?>'"
                                type="button">
							<?php echo GroupEssays::$ulgm_essays_shortcode['text']['group_management']; ?>
                        </button> -->
                        </div>
                    </div>
                </div>
                <div class="uo-row uo-groups-section uo-groups-selection">
                    <div class="group-management-form">
                        <div class="uo-groups-select-filters">
                            <div class="uo-row uo-groups-select-filter">
                                <div class="uo-select">
                                    <label><?php _e( 'Group', 'uncanny-learndash-groups' ); ?></label>
                                    <select class="change-group-management-form" id="uo-group-report-group"><?php echo $group_drop_downs['groups']; ?></select>
                                </div>
                            </div>
                            <div class="uo-row uo-groups-select-filter">
                                <div class="uo-select">
                                    <label><?php _e( \LearnDash_Custom_Label::get_label( 'courses' ), 'uncanny-learndash-groups' ); ?></label>
                                    <select class="change-group-management-form <?php echo isset($group_drop_downs['courses_class'])?$group_drop_downs['courses_class']:''; ?>" style="display:none;" id="uo-group-report-courses"><?php echo $group_drop_downs['courses']; ?></select>
                                    <div id="uo-group-report-nocourses" class="group-management-rest-message" style="display: none;"><?php echo __( 'No courses found.', 'uncanny-learndash-groups' ); ?></div>
                                </div>
                            </div>
                            <div class="uo-row uo-groups-select-filter">
                                <div class="uo-select">
                                    <label><?php _e( \LearnDash_Custom_Label::get_label( 'lessons' ), 'uncanny-learndash-groups' ); ?></label>
                                    <select class="change-group-management-form <?php echo isset($group_drop_downs['lessons_class'])?$group_drop_downs['lessons_class']:''; ?>" style="" id="uo-group-report-lessons"><?php echo $group_drop_downs['lessons']; ?></select>
                                    <div id="uo-group-report-nolessons" class="group-management-rest-message" style="display: none;"><?php echo __( 'No lessons found.', 'uncanny-learndash-groups' ); ?></div>
                                </div>
                            </div>
                            <div class="uo-row uo-groups-select-filter">
                                <div class="uo-select">
                                    <label><?php _e( \LearnDash_Custom_Label::get_label( 'quizzes' ), 'uncanny-learndash-groups' ); ?></label>
                                    <select class="change-group-management-form <?php echo isset($group_drop_downs['quizzes_class'])?$group_drop_downs['quizzes_class']:''; ?>" style="" id="uo-group-report-quizzes"><?php echo $group_drop_downs['quizzes']; ?></select>
                                    <div id="uo-group-report-noquizzes" class="group-management-rest-message" style="display: none;"><?php echo __( 'No quizzes found.', 'uncanny-learndash-groups' ); ?></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="uo-row uo-groups-table">
                    <div class="group-essays-buttons uo-hidden">
                        <button class="uo-btn uo-left" id="group-approve-essays-button"><?php echo __( 'Approve Essays', 'uncanny-learndash-groups' ); ?></button>
                        <button class="uo-btn uo-left" id="group-trash-essays-button"><?php echo __( 'Delete Essays', 'uncanny-learndash-groups' ); ?></button>
                    </div>
                    <table id="uo-group-essays-table-hidden" class="display responsive no-wrap uo-table-datatable"
                           cellspacing="0" width="100%"></table>

                    <table id="uo-group-essays-table" class="display responsive no-wrap uo-table-datatable" cellspacing="0"
                           width="100%"></table>
                </div>
            </form>
            <div class="uo-row">
                <div style="" class="uo-modal-spinner"></div>
            </div>
        </div>

        <style>
            .uo-groups .uo-select select.h3-select {
                background: none !important;
                border: none;
                -webkit-box-shadow: none;
                box-shadow: none;
                font-size: 18px;
                font-weight: bold;
                padding-left: 0;
                padding-top: 0;
                /*for firefox*/
                -moz-appearance: none;
                /*for chrome*/
                -webkit-appearance: none;
                cursor: auto !important;
            }
            .uo-groups .uo-select select.h3-select:hover {
                color:#000 !important;
                border-color: transparent !important;
            }
            .uo-groups .uo-select:hover select.h3-select{
                color:#000 !important;
                border-color: transparent !important;
            }
            /*for IE10*/
            .uo-groups .uo-select select.h3-select::-ms-expand {
                display: none;
            }

            .showme {
                display: block !important;
            }
        </style>

        <script>
            jQuery(document).ready(function () {
                jQuery('select.h3-select').prop('disabled', 'disabled');

                let groupSelect = jQuery('#uo-group-report-group');
                let groupSelectOptions = jQuery('#uo-group-report-group option');

                if (2 === groupSelectOptions.length) {
                    groupSelect.addClass('h3-select');
                    let groupId = jQuery(groupSelect.find('option')[1]).val();
                    window.ulgmGroupManagement.Essays.groupId = groupId;
                    groupSelect.val(groupId).trigger('change');

                    groupSelect.prop('disabled', 'disabled');

                    let courseGrouplessons = groupEssays.courseGrouplessons[groupId];
                    let coursesSelect = jQuery('#uo-group-report-courses');
                    let coursesSelectOptions = jQuery('#uo-group-report-courses option');

                    if (2 === coursesSelectOptions.length) {

                        coursesSelect.show();
                        coursesSelect.addClass('h3-select');
                        // below line commented BY_AC
                        let courseId = jQuery(coursesSelect.find('option')[1]).val();
                        window.ulgmGroupManagement.Essays.courseId = courseId;
                        coursesSelect.val(courseId).trigger('change');
                        coursesSelect.prop('disabled', 'disabled');

                        jQuery('#uo-group-report-lessons').show();
                        jQuery('#uo-group-report-lessons option').hide();
                        jQuery('#uo-group-report-lessons option').removeAttr('selected');
                        // below line commented BY_AC
                        jQuery('#uo-group-report-lessons option[value=0]').show();
                        
                        let groupslessons = [];
                        if (typeof groupEssays.relationships !== 'undefined' && typeof groupEssays.relationships[window.ulgmGroupManagement.Essays.groupId] !== 'undefined' && typeof groupEssays.relationships[window.ulgmGroupManagement.Essays.groupId][courseId] !== 'undefined') {
                            groupslessons = groupEssays.relationships[window.ulgmGroupManagement.Essays.groupId][courseId];
                        }

                        if (typeof groupslessons !== 'undefined' && groupslessons.length > 0) {
                            jQuery.each(groupslessons, function (key, quizId) {
                                jQuery('#uo-group-report-lessons option[value=' + quizId + ']').addClass('showme');
                                jQuery('#uo-group-report-lessons option[value=' + quizId + ']').css('display', 'block');
                                jQuery('#uo-group-report-lessons option[value=' + quizId + ']').show();
                            });
                            // need a delay and let jquery finish actions in each loop
                            setTimeout(function () {
                                jQuery('#uo-group-report-lessons').trigger('change');
                            }, 200);
                        } else {
                            jQuery('#uo-group-report-lessons option').hide();
                            jQuery('#uo-group-report-lessons option[value=' + 0 + ']').show();
                            //jQuery('#uo-group-report-nolessons').show();
                        }

                        let groupsquizzes = [];
                        if ( typeof groupEssays.quiz_relationships !== 'undefined' && typeof groupEssays.quiz_relationships[window.ulgmGroupManagement.Essays.groupId] !== 'undefined' && typeof groupEssays.quiz_relationships[window.ulgmGroupManagement.Essays.groupId][courseId] !== 'undefined') {
                            groupsquizzes = groupEssays.quiz_relationships[window.ulgmGroupManagement.Essays.groupId][courseId];
                        }

                        if (typeof groupsquizzes !== 'undefined' && groupsquizzes.length > 0) {
                            jQuery.each(groupsquizzes, function (key, quizId) {
                                jQuery('#uo-group-report-quizzes option[value=' + quizId + ']').addClass('showme');
                                jQuery('#uo-group-report-quizzes option[value=' + quizId + ']').css('display', 'block');
                                jQuery('#uo-group-report-quizzes option[value=' + quizId + ']').show();
                            });
                            // need a delay and let jquery finish actions in each loop
                            setTimeout(function () {
                                jQuery('#uo-group-report-quizzes').trigger('change');
                            }, 200);
                        } else {
                            jQuery('#uo-group-report-quizzes option').hide();
                            jQuery('#uo-group-report-quizzes option[value=' + 0 + ']').show();
                            //jQuery('#uo-group-report-nolessons').show();
                        }
                    } else {
                        coursesSelect.show();
                        jQuery('#uo-group-report-courses option').hide();
                        jQuery('#uo-group-report-courses option').removeAttr('selected');
                        jQuery('#uo-group-report-courses option[0]').attr("selected", "selected");
                        jQuery('#uo-group-report-courses option[0]').show();
                        jQuery('#uo-group-report-courses option[value=' + 0 + ']').show();
                        jQuery.each(courseGrouplessons, function (key, courseId) {
                            jQuery('#uo-group-report-courses option[value=' + courseId + ']').show();
                        });
                        setTimeout(function () {
                            jQuery('#uo-group-report-courses').trigger('change');
                        }, 400);
                    }
                    window.ulgmGroupManagement.Essays.groupId = groupId;
                } else {
                    // need a delay and let jquery finish actions in each loop
                    setTimeout(function () {
                        let groupId = jQuery(groupSelect.find('option')[0]).val();
                        window.ulgmGroupManagement.Essays.groupId = groupId;
                        groupSelect.val(groupId).trigger('change');

                    }, 200);
                }
            })
        </script>
        </div>
		<?php
		
		return ob_get_clean();
	}
	
	
	/*
	 * Get all Groups the group leader is an administrator of
	 * @since
	 *
	 * @param int $group_leader_id
	 *
	 * @return string html
	 */
	function get_groups_drop_downs( $user_id = 0 ) {
		
		if ( FALSE !== self::$group_drop_downs ) {
			return self::$group_drop_downs;
		}
		
		$user_id = get_current_user_id();
		
		if ( ! user_can( $user_id, 'group_leader' ) ) {
			return FALSE;
		}
		
		// User is a group leader, get users groups ... We already verified that the user is already a group leader
		$user_groups = learndash_get_administrators_group_ids( $user_id, TRUE );
		
		if ( empty( $user_groups ) ) {
			return __( 'You are not a leader of any groups.', 'uncanny-learndash-groups' );
		}
		
		// LD returns a array of IDs as strings, refactor to Int
		$posts_in = array_map( 'intval', $user_groups );
		
		$args = [
			'post_type'      => 'groups',
			'post__in'       => $posts_in,
			'posts_per_page' => - 1,
			'orderby'        => 'title',
			'order'          => 'ASC',
		];
		
		
		$args = apply_filters( 'lesson_group_dropdown', $args, $user_id, $posts_in );
		
		$group_post_objects = new \WP_Query( $args );
		
		$drop_down['groups'] = '<option value="0">' . __( 'Select Group', 'uncanny-learndash-groups' ) . '</option>';
		//$drop_down['groups'] = '';
		$drop_down['lessons_objects'] = [];
		
		// Collect all the quiz IDs so we can query then altogether
		$course_ids = [];
		$lesson_ids = [];
		$quiz_ids   = [];
		
		if ( $group_post_objects->have_posts() ) {
			while ( $group_post_objects->have_posts() ) {
				$group_post_objects->the_post();
				$drop_down['groups'] .= '<option value="' . get_the_ID() . '">' . get_the_title() . '</option>';
				
				$group_lessons                                = $this->group_lessons( get_the_ID() );
				$drop_down['lessons_objects'][ get_the_ID() ] = $group_lessons['group_lesson_ids'];
				
				$drop_down['course_lessons_objects'][ get_the_ID() ] = $group_lessons['group_course_lessons'];
				
				$course_ids = array_merge( $course_ids, $group_lessons['group_course_lessons'] );
				$lesson_ids = array_merge( $lesson_ids, $group_lessons['group_lesson_ids'] );
				
				$drop_down['relationships'][ get_the_ID() ] = $group_lessons['relationships'];
				
				$group_quizzes                                = $this->group_quizzes( get_the_ID() );
				$drop_down['quizzes_objects'][ get_the_ID() ] = $group_quizzes['group_quiz_ids'];
				
				$drop_down['course_quizzes_objects'][ get_the_ID() ] = $group_quizzes['group_course_quizzes'];
				
				$course_ids = array_merge( $course_ids, $group_quizzes['group_course_quizzes'] );
				$quiz_ids   = array_merge( $quiz_ids, $group_quizzes['group_quiz_ids'] );
				
				$drop_down['quiz_relationships'][ get_the_ID() ] = $group_quizzes['relationships'];
			}
			/* Restore original Post Data */
			wp_reset_postdata();
		} else {
			// no posts found
			$drop_down['groups'] = '<option value="0">' . __( 'No Groups', 'uncanny-learndash-groups' ) . '</option>';
		}
		
		// Get Courses
		$course_ids = array_unique( $course_ids );
		
		$courses = $this->get_objects( $course_ids, 'sfwd-courses', 'title', 'ASC' );
		
		if ( ! empty( $courses ) ) {
			// below line commented BY_AC
			$drop_down['courses_class'] = '';
			$drop_down['courses'] = '<option value="0">' . sprintf( __( 'Select %s', 'uncanny-learndash-groups' ), \LearnDash_Custom_Label::get_label( 'course' ) ) . '</option>';
			//$drop_down['courses'] = '';
			foreach ( $courses as $course ) {
				$drop_down['courses'] .= '<option value="' . $course->ID . '"  style="display:none">' . $course->post_title . '</option>';;
			}
		} else {
			$drop_down['courses_class'] = 'h3-select';
			$drop_down['courses'] = '<option value="0">' . sprintf( __( 'No %s in group', 'uncanny-learndash-groups' ), \LearnDash_Custom_Label::get_label( 'courses' ) )  . '</option>';
		}
		
		// Get lessons
		$relations = [];
		
		if ( ! empty( $drop_down['relationships'] ) ) {
			// below line commented BY_AC
            $drop_down['lessons'] = '';
			$unique_lesson = [];
			foreach ( $drop_down['relationships'] as $group_id => $groups_courses ) {
				if ( ! empty( $groups_courses ) ) {
					foreach ( $groups_courses as $course_id => $course_lesson ) {
						if ( ! empty( $course_lesson ) ) {
							foreach ( $course_lesson as $lesson_id => $lesson ) {
								$relations[ $group_id ][ $course_id ][] = $lesson_id;
								if ( ! in_array( $lesson_id, $unique_lesson ) ) {
									$unique_lesson[]      = $lesson_id;
									$drop_down['lessons'] .= '<option value="' . $lesson_id . '" style="display:none">' . $lesson . '</option>';
								}
							}
						}
					}
				}
				//$drop_down['lessons'] .= '<option value="' . $quiz->ID . '" style="display:none">' . $quiz->post_title . '</option>';;
			}
			if( '' !== $drop_down['lessons'] ){
				$drop_down['lessons'] = '<option value="0">' . sprintf( __( 'Select %s', 'uncanny-learndash-groups' ), \LearnDash_Custom_Label::get_label( 'lesson' ) ) . '</option>'.$drop_down['lessons'];
            }else{
				$drop_down['lessons_class'] = 'h3-select';
				$drop_down['lessons'] = '<option value="0">' . sprintf( __( 'No %s in group', 'uncanny-learndash-groups' ), \LearnDash_Custom_Label::get_label( 'lessons' ) ). '</option>';
            }
			
		} else {
			$drop_down['lessons_class'] = 'h3-select';
			$drop_down['lessons'] = '<option value="0">' . sprintf( __( 'No %s in group', 'uncanny-learndash-groups' ), \LearnDash_Custom_Label::get_label( 'lessons' ) ) . '</option>';
		}
		$drop_down['relationships'] = $relations;
		// Get lessons
		$relations = [];
		if ( ! empty( $drop_down['quiz_relationships'] ) ) {
			// below line commented BY_AC
			
			$drop_down['quizzes'] = '';
			$unique_quiz = [];
			foreach ( $drop_down['quiz_relationships'] as $group_id => $groups_courses ) {
				if ( ! empty( $groups_courses ) ) {
					foreach ( $groups_courses as $course_id => $course_quiz ) {
						if ( ! empty( $course_quiz ) ) {
							foreach ( $course_quiz as $quiz_id => $quiz ) {
								$relations[ $group_id ][ $course_id ][] = $quiz_id;
								if ( ! in_array( $quiz_id, $unique_quiz ) ) {
									$unique_quiz[]        = $quiz_id;
									$drop_down['quizzes'] .= '<option value="' . $quiz_id . '" style="">' . $quiz . '</option>';
								}
							}
						}
					}
				}
				//$drop_down['lessons'] .= '<option value="' . $quiz->ID . '" style="display:none">' . $quiz->post_title . '</option>';;
			}
			if( '' !== $drop_down['quizzes'] ){
				$drop_down['quizzes'] = '<option value="0">' . sprintf( __( 'Select %s', 'uncanny-learndash-groups' ), \LearnDash_Custom_Label::get_label( 'quiz' ) ) . '</option>'.$drop_down['quizzes'];
            }else{
				$drop_down['quizzes_class'] = 'h3-select';
				$drop_down['quizzes'] = '<option value="0">' . sprintf( __( 'No %s in group', 'uncanny-learndash-groups' ), \LearnDash_Custom_Label::get_label( 'quizzes' ) ) . '</option>';
            }
		} else {
			$drop_down['quizzes_class'] = 'h3-select';
			$drop_down['quizzes'] = '<option value="0">' . sprintf( __( 'No %s in group', 'uncanny-learndash-groups' ), \LearnDash_Custom_Label::get_label( 'quizzes' ) ) . '</option>';
		}
		$drop_down['quiz_relationships'] = $relations;
		// Cache results so we don't re-query
		self::$group_drop_downs = $drop_down;
		
		return $drop_down;
	}
	
	/**
	 * Get groups course lessons
	 *
	 * @param int $group_id
	 *
	 * @return mixed
	 */
	function group_lessons( $group_id = 0 ) {
		$group_lesson_ids = [];
		$group_course_ids = [];
		$include_topics   = TRUE;
		$post_array       = [];
		
		$relationships = [];
		if ( ! empty( $group_id ) ) {
			
			$group_course_ids = learndash_group_enrolled_courses( intval( $group_id ) );
			
			if ( ! empty( $group_course_ids ) ) {
				foreach ( $group_course_ids as $course_id ) {
					
					$lesson_ids = learndash_course_get_children_of_step( $course_id, $course_id, 'sfwd-lessons' );
					if ( ! empty( $lesson_ids ) ) {
						foreach ( $lesson_ids as $lesson_id ) {
							$post_array[ $lesson_id ] = get_the_title( $lesson_id );
							if ( $include_topics ) {
								$topic_ids = learndash_course_get_children_of_step( $course_id, $lesson_id, 'sfwd-topic' );
								if ( ! empty( $topic_ids ) ) {
									foreach ( $topic_ids as $topic_id ) {
										$post_array[ $topic_id ] = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . get_the_title( $topic_id );
									}
								}
								$group_lesson_ids = array_merge( $group_lesson_ids, $topic_ids );
								$group_lesson_ids = array_unique( $group_lesson_ids );
							}
						}
					}
					$group_lesson_ids = array_merge( $group_lesson_ids, $lesson_ids );
					$group_lesson_ids = array_unique( $group_lesson_ids );
					if ( isset( $relationships[ $course_id ] ) ) {
						$relationships[ $course_id ] = array_unique( array_merge( $relationships[ $course_id ], $post_array ) );
					} else {
						$relationships[ $course_id ] = $post_array;
					}
				}
			}
		}
		
		return [
			'group_lesson_ids'     => $group_lesson_ids,
			'group_course_lessons' => $group_course_ids,
			'relationships'        => $relationships,
		];
	}
	
	/**
	 * Get groups course quizzes
	 *
	 * @param int $group_id
	 *
	 * @return mixed
	 */
	function group_quizzes( $group_id = 0 ) {
		$group_quiz_ids   = [];
		$group_course_ids = [];
		$include_topics   = TRUE;
		$post_array       = [];
		
		$relationships = [];
		if ( ! empty( $group_id ) ) {
			
			$group_course_ids = learndash_group_enrolled_courses( intval( $group_id ) );
			
			if ( ! empty( $group_course_ids ) ) {
				foreach ( $group_course_ids as $course_id ) {
					
					$lesson_ids = learndash_course_get_children_of_step( $course_id, $course_id, 'sfwd-lessons' );
					$quiz_ids   = learndash_course_get_children_of_step( $course_id, $course_id, 'sfwd-quiz' );
					if ( ! empty( $quiz_ids ) ) {
						$group_quiz_ids = array_merge( $group_quiz_ids, $quiz_ids );
						$group_quiz_ids = array_unique( $group_quiz_ids );
					}
					if ( ! empty( $lesson_ids ) ) {
						foreach ( $lesson_ids as $lesson_id ) {
							$quiz_ids = learndash_course_get_children_of_step( $course_id, $lesson_id, 'sfwd-quiz' );
							if ( ! empty( $quiz_ids ) ) {
								$group_quiz_ids = array_merge( $group_quiz_ids, $quiz_ids );
								$group_quiz_ids = array_unique( $group_quiz_ids );
							}
							if ( $include_topics ) {
								$topic_ids = learndash_course_get_children_of_step( $course_id, $lesson_id, 'sfwd-topic' );
								if ( ! empty( $topic_ids ) ) {
									foreach ( $topic_ids as $topic_id ) {
										$quiz_ids = learndash_course_get_children_of_step( $course_id, $topic_id, 'sfwd-quiz' );
										if ( ! empty( $quiz_ids ) ) {
											$group_quiz_ids = array_merge( $group_quiz_ids, $quiz_ids );
											$group_quiz_ids = array_unique( $group_quiz_ids );
										}
									}
								}
							}
						}
					}
					if ( ! empty( $group_quiz_ids ) ) {
						foreach ( $group_quiz_ids as $quiz_id ) {
							$post_array[ $quiz_id ] = get_the_title( $quiz_id );
						}
					}
					if ( isset( $relationships[ $course_id ] ) ) {
						$relationships[ $course_id ] = array_unique( array_merge( $relationships[ $course_id ], $post_array ) );
					} else {
						$relationships[ $course_id ] = $post_array;
					}
				}
			}
		}
		
		return [
			'group_quiz_ids'       => $group_quiz_ids,
			'group_course_quizzes' => $group_course_ids,
			'relationships'        => $relationships,
		];
	}
	
	/**
	 * Get all lessons/courses post objects
	 *
	 * @param array  $ids
	 * @param string $post_type
	 * @param string $order_by
	 * @param string $order
	 *
	 * @return array $_lessons
	 */
	function get_objects( $ids, $post_type, $order_by = 'title', $order = 'ASC' ) {
		
		if ( empty( $order_by ) ) {
			$order_by = 'title';
		}
		
		if ( empty( $order ) ) {
			$order = 'ASC';
		}
		
		if ( empty( $ids ) ) {
			return [];
		}
		
		$args = [
			'post_type'      => $post_type,
			'post__in'       => $ids,
			'posts_per_page' => - 1,
			'orderby'        => $order_by,
			'order'          => $order,
		];
		
		$lessons = get_posts( $args );
		
		// Set the Key as the post ID so we don't have to run a nested loop
		$_lessons = [];
		foreach ( $lessons as $quiz ) {
			$_lessons[ $quiz->ID ] = $quiz;
		}
		
		return $_lessons;
	}
	
	
	/*
	 * Register rest api endpoints
	 *
	 */

	public function essays_scripts() {
		global $post;

		if ( Utilities::has_shortcode( $post, 'uo_groups_essays' ) || Utilities::has_block( $post, 'uncanny-learndash-groups/uo-groups-essays-report' ) ) {
			// Front End Questionnaire JS
			wp_register_script( 'ulgm-frontend', Utilities::get_asset( 'frontend', 'bundle.min.js' ), [ 'jquery' ], Utilities::get_version(), true );
			
			$group_drop_downs = $this->get_groups_drop_downs();
			
			// Attach API data to custom-toolkit-js // TODO change path
			$api_setup = [
				'root'               => esc_url_raw( rest_url() . $this->root_path ),
				'nonce'              => \wp_create_nonce( 'wp_rest' ),
				'ajax_nonce'         => \wp_create_nonce( 'edit_essays' ),
				'ajaxurl'            => admin_url( 'admin-ajax.php' ),
				'currentUser'        => get_current_user_id(),
				'localized'          => $this->get_frontend_localized_strings(),
				'grouplessons'       => $group_drop_downs['lessons_objects'],
				'courseGrouplessons' => $group_drop_downs['course_lessons_objects'],
				'courseGroupquizzes' => $group_drop_downs['course_quizzes_objects'],
				'relationships'      => $group_drop_downs['relationships'],
				'quiz_relationships' => $group_drop_downs['quiz_relationships'],
			];
			
			wp_localize_script( 'ulgm-frontend', 'groupEssays', $api_setup );
			
			wp_enqueue_script( 'ulgm-frontend' );
            
			wp_enqueue_editor();
			
			wp_enqueue_script( 'ulgm-datatables', Utilities::get_vendor( 'datatables/js/jquery.dataTables.min.js' ), [ 'jquery' ], Utilities::get_version(), TRUE );
			
			wp_enqueue_script( 'ulgm-datatables-responsive', Utilities::get_vendor( 'datatables/js/dataTables.responsive.min.js' ), [
				'jquery',
				'ulgm-datatables',
			], Utilities::get_version(), TRUE );
			wp_enqueue_script( 'ulgm-datatables-buttons', Utilities::get_vendor( 'datatables/js/dataTables.buttons.min.js' ), [
				'jquery',
				'ulgm-datatables',
			], Utilities::get_version(), TRUE );
			wp_enqueue_script( 'ulgm-datatables-buttons-html5', Utilities::get_vendor( 'datatables/js/buttons.html5.min.js' ), [
				'jquery',
				'ulgm-datatables',
				'ulgm-datatables-buttons',
			], Utilities::get_version(), TRUE );
			wp_enqueue_script( 'ulgm-datatables-buttons-flash', Utilities::get_vendor( 'datatables/js/buttons.flash.min.js' ), [
				'jquery',
				'ulgm-datatables',
				'ulgm-datatables-buttons',
			], Utilities::get_version(), TRUE );
			
			wp_enqueue_style( 'ulgm-datatables-styles', Utilities::get_vendor( 'datatables/css/jquery.dataTables.min.css' ), [], Utilities::get_version() );
			wp_enqueue_style( 'ulgm-datatables-responsive', Utilities::get_vendor( 'datatables/css/responsive.dataTables.min.css' ), [], Utilities::get_version() );
			wp_enqueue_style( 'ulgm-font-awesome', Utilities::get_vendor( 'fontawesome/css/font-awesome.min.css' ), [], Utilities::get_version() );
			
			// Load styles
			wp_register_style( 'ulgm-frontend', Utilities::get_asset( 'frontend', 'bundle.min.css' ), array(), Utilities::get_version() );
			$user_colors = Utilities::user_colors();
			wp_add_inline_style( 'ulgm-frontend', $user_colors );
			wp_enqueue_style( 'ulgm-frontend', $user_colors );
			
			// Load Modal
			wp_enqueue_script( 'ulgm-modal', Utilities::get_vendor( 'jquery-modal/js/jquery.modal.js' ), [ 'jquery' ], Utilities::get_version(), TRUE ); // @see https://raw.githubusercontent.com/kylefox/jquery-modal/master/jquery.modal.js
			wp_enqueue_style( 'ulgm-modal', Utilities::get_vendor( 'jquery-modal/css/jquery.modal.css' ), [], Utilities::get_version() ); // @see https://raw.githubusercontent.com/kylefox/jquery-modal/master/jquery.modal.css
			
			// Load Select2
			wp_enqueue_script( 'ulgm-select2', Utilities::get_vendor( 'select2/js/select2.min.js' ), array( 'jquery' ), Utilities::get_version(), true );
			wp_enqueue_style( 'ulgm-select2', Utilities::get_vendor( 'select2/css/select2.min.css' ), array(), Utilities::get_version() );
		}
	}
	
	private function get_frontend_localized_strings() {
		
		$localized_strings = [];
		
        $localized_strings['title'] = __( 'Question', 'uncanny-learndash-groups' );

		$localized_strings['idColumn'] = __( 'ID', 'uncanny-learndash-groups' );
		
		$localized_strings['author'] = __( 'Submitted By', 'uncanny-learndash-groups' );
		
		$localized_strings['status'] = __( 'Status', 'uncanny-learndash-groups' );
		
		$localized_strings['points'] = __( 'Points', 'uncanny-learndash-groups' );
		
		$localized_strings['assignedCourse'] = __( 'Course', 'uncanny-learndash-groups' );
		
		$localized_strings['assignedlesson'] = __( 'Lesson', 'uncanny-learndash-groups' );
		
		$localized_strings['assignedquiz'] = __( 'Quiz', 'uncanny-learndash-groups' );
		
		$localized_strings['comments'] = __( 'Comments', 'uncanny-learndash-groups' );
		
		$localized_strings['date'] = __( 'Date', 'uncanny-learndash-groups' );
		
		$localized_strings['csvExport'] = __( 'CSV Export', 'uncanny-learndash-groups' );
		
		$localized_strings['selectCourse'] = sprintf( __( 'Select %s', 'uncanny-learndash-groups' ), \LearnDash_Custom_Label::get_label( 'course' ) );
		
		$localized_strings['noCourse'] = __( 'No courses Available', 'uncanny-learndash-groups' );
		
		$localized_strings['selectUser'] = __( 'Select User', 'uncanny-learndash-groups' );
		
		$localized_strings['noUsers'] = __( 'No Users Available', 'uncanny-learndash-groups' );
		
		$localized_strings['lengthMenu'] = sprintf( _x( 'Show %s entries', '%s is a number', 'uncanny-learndash-groups' ), '_MENU_' );
		
		$localized_strings['zeroRecords'] = __( 'No essays found for this group', 'uncanny-learndash-groups' );
		
		$localized_strings['info'] = sprintf( _x( 'Showing page %1$s of %2$s', 'Both %1$s and %2$s are numbers', 'uncanny-learndash-groups' ), '_PAGE_', '_PAGES_' );
		
		$localized_strings['infoEmpty'] = __( 'Showing 0 to 0 of 0 entries', 'uncanny-learndash-groups' );
		
		$localized_strings['infoFiltered'] = sprintf( _x( '(filtered from %s total entries)', '%s is a number', 'uncanny-learndash-groups' ), '_MAX_' );
		
		$localized_strings['loadingRecords'] = __( 'Loading', 'uncanny-learndash-groups' );
		
        $localized_strings['sSearch'] = '';

		$localized_strings['searchPlaceholder'] = __( 'Search', 'uncanny-learndash-groups' );
		
		$localized_strings['all'] = __( 'All', 'uncanny-learndash-groups' );
		
		$localized_strings['selectLesson'] = sprintf( __( 'Select %s', 'uncanny-learndash-groups' ), \LearnDash_Custom_Label::get_label( 'lesson' ) );
		
		$localized_strings = apply_filters( 'quiz-report-table-strings', $localized_strings );
		
		
		return $localized_strings;
	}
	
	public function uo_api() {
		register_rest_route( $this->root_path, '/get_essays_data/', [
			'methods'  => 'POST',
			'callback' => [ $this, 'get_essays_data' ],
		] );
		register_rest_route( $this->root_path, '/edit_essays_data/', [
			'methods'  => 'POST',
			'callback' => [ $this, 'edit_essays' ],
		] );
		register_rest_route( $this->root_path, '/save_essays_data/', [
			'methods'  => 'POST',
			'callback' => [ $this, 'save_essays' ],
		] );
	}
	
	function get_essays_data() {
		if ( FALSE === Utilities::get_debug_mode() ) {
			error_reporting( 0 );
		}
		
		$data = $_POST;
		
		// validate inputs
		$lesson_ID    = absint( $data['lessonId'] );
		$course_ID    = absint( $data['courseId'] );
		$group_ID     = absint( $data['groupId'] );
		$quiz_ID      = absint( $data['quizId'] );
		$essays_table = $this->essays_table( $lesson_ID, $course_ID, $group_ID, $quiz_ID );
		
		return $essays_table;
	}
	
	/**
	 * Return html for the essay table
	 *
	 * @param $lesson_ID
	 * @param $course_ID
	 * @param $group_ID
	 *
	 * @return array
	 *
	 */
	function essays_table( $lesson_ID = 0, $course_ID = 0, $group_ID = 0, $quiz_ID = 0 ) {
		
		global $learndash_shortcode_used;
		$essays                   = [];
		$learndash_shortcode_used = TRUE;
		$user_id                  = get_current_user_id();
		$q_vars                   = [
			'post_type'      => 'sfwd-essays',
			'posts_per_page' => - 1,
			'post_status'    => array( 'graded', 'not_graded' ),
		];
		
		if ( learndash_is_group_leader_user( $user_id ) || learndash_is_admin_user( $user_id ) ) {
			$group_ids  = learndash_get_administrators_group_ids( $user_id );
			$course_ids = [];
			$lesson_ids = [];
			$user_ids   = [];
			
			if ( ! empty( $group_ids ) && is_array( $group_ids ) ) {
				if ( absint( $group_ID ) !== 0 ) {
					foreach ( $group_ids as $group_id ) {
						if ( $group_ID === absint( $group_id ) ) {
							$group_course_ids = learndash_group_enrolled_courses( $group_id );
							if ( ! empty( $group_course_ids ) && is_array( $group_course_ids ) ) {
								$course_ids = array_merge( $course_ids, $group_course_ids );
							}
							$lessons    = $this->group_lessons( $group_id );
							$lesson_ids = array_merge( $lesson_ids, $lessons['group_lesson_ids'] );
							
							$group_users = learndash_get_groups_user_ids( $group_id );
							if ( ! empty( $group_users ) && is_array( $group_users ) ) {
								foreach ( $group_users as $group_user_id ) {
									$user_ids[ $group_user_id ] = $group_user_id;
								}
							}
						}
					}
				} else {
					foreach ( $group_ids as $group_id ) {
						$group_course_ids = learndash_group_enrolled_courses( $group_id );
						if ( ! empty( $group_course_ids ) && is_array( $group_course_ids ) ) {
							$course_ids = array_merge( $course_ids, $group_course_ids );
						}
						$lessons    = $this->group_lessons( $group_id );
						$lesson_ids = array_merge( $lesson_ids, $lessons['group_lesson_ids'] );
						
						$group_users = learndash_get_groups_user_ids( $group_id );
						if ( ! empty( $group_users ) && is_array( $group_users ) ) {
							foreach ( $group_users as $group_user_id ) {
								$user_ids[ $group_user_id ] = $group_user_id;
							}
						}
					}
				}
			}
			
			if ( ! empty( $course_ids ) && count( $course_ids ) ) {
				if ( ! isset( $q_vars['meta_query'] ) ) {
					$q_vars['meta_query'] = [];
				}
				
				if ( $course_ID !== 0 && in_array( $course_ID, $course_ids ) ) {
					$course_ids = [ $course_ID ];
				}
				
				if ( ! empty( $lesson_ids ) && count( $lesson_ids ) && $lesson_ID !== 0 && in_array( $lesson_ID, $lesson_ids ) ) {
					$q_vars['meta_query'][] = "'relation' => 'AND'";
					$lesson_ids             = [ $lesson_ID ];
					$q_vars['meta_query'][] = [
						'key'     => 'lesson_id',
						'value'   => $lesson_ids,
						'compare' => 'IN',
					];
				}
				if ( ! empty( $quiz_ID ) && count( $quiz_ID ) && $quiz_ID !== 0 ) {
					$q_vars['meta_query'][] = "'relation' => 'AND'";
					$quiz_IDs               = [ $quiz_ID ];
					$q_vars['meta_query'][] = [
						'key'     => 'quiz_id',
						'value'   => $quiz_IDs,
						'compare' => 'IN',
					];
				}
				
				$q_vars['meta_query'][] = [
					'key'     => 'course_id',
					'value'   => $course_ids,
					'compare' => 'IN',
				];
				
			}
			
			if ( ! empty( $user_ids ) && count( $user_ids ) ) {
				$q_vars['author__in'] = $user_ids;
			} else {
				$q_vars['author__in'] = - 2;
			}
			
		}
		
		$essay_posts = get_posts( $q_vars );
		
		if ( ! empty( $essay_posts ) ) {
			foreach ( $essay_posts as $essay ) {
				$essay_id           = $essay->ID;
				$status             = '';
				$points             = '';
				$post_status_object = get_post_status_object( $essay->post_status );
				if ( ( ! empty( $post_status_object ) ) && ( is_object( $post_status_object ) ) && ( property_exists( $post_status_object, 'label' ) ) ) {
					$status = $post_status_object->label;
				}
				
				if ( $essay->post_status == 'not_graded' ) {
					$status = '<button id="essay_approve_' . $essay_id . '" class="small essay_approve_single">' . esc_html__( 'approve', 'uncanny-learndash-groups' ) . '</button>';
				}
				$course_id   = get_post_meta( $essay_id, 'course_id', TRUE );
				$lesson_id   = get_post_meta( $essay_id, 'lesson_id', TRUE );
				$quiz_id     = get_post_meta( $essay_id, 'quiz_id', TRUE );
				$essay_quiz_post_id = get_post_meta( $essay_id, 'quiz_post_id', true );
				if ( empty( $essay_quiz_post_id ) ) {
					
					$essay_quiz_query_args = array(
						'post_type'		=>	'sfwd-quiz',
						'post_status'	=>	'publish',
						'meta_key'		=>	'quiz_pro_id_' . intval( $quiz_id ),
						'meta_value'	=>	intval( $quiz_id ),
						'meta_compare'	=>	'=',
						'fields'		=>	'ids',
						'orderby'		=>	'title',
						'order'			=>	'ASC'
					);
					
					$essay_quiz_query = new \WP_Query( $essay_quiz_query_args );
					$essay_quiz_post_id = $essay_quiz_query->posts[0];
					
				}
				
				$question_id = get_post_meta( $essay_id, 'question_id', TRUE );
				
				if ( ! empty( $quiz_id ) ) {
					$questionMapper = new \WpProQuiz_Model_QuestionMapper();
					$question       = $questionMapper->fetchById( intval( $question_id ), NULL );
					if ( $question instanceof \WpProQuiz_Model_Question ) {
						
						$submitted_essay_data = learndash_get_submitted_essay_data( $quiz_id, $question_id, $essay );
						
						$max_points = $question->getPoints();
						
						$current_points = 0;
						if ( isset( $submitted_essay_data['points_awarded'] ) ) {
							$current_points = intval( $submitted_essay_data['points_awarded'] );
						}
						
						if ( $essay->post_status == 'not_graded' ) {
							$current_points = '<input id="essay_points_' . $essay_id . '" class="small-text" type="number" value="' . $current_points . '" max="' . $max_points . '" min="0" step="1" name="essay_points[' . $essay_id . ']" />';
							$points         = sprintf( _x( '%1$s / %2$d', 'placeholders: input points / maximum point for essay', 'uncanny-learndash-groups' ), $current_points, $max_points );
						} else {
							$points = sprintf( esc_html_x( '%1$d / %2$d', 'placeholders: current awarded points / maximum point for essay', 'uncanny-learndash-groups' ), $current_points, $max_points );
						}
					} else {
						$points = '-';
					}
				}
				$lesson = get_post( $lesson_id );
				$course = get_post( $course_id );
				$quiz   = get_post( $quiz_id );
				
				//$row_action                         = '<span class="edit"><a href="#" class="edit_essay_single" data-essay-id="' . $essay_id . '">Edit</a> | </span><span class="trash"><a href="#" id="a_essay_trash_' . $essay_id . '" class="delete_essay_single">Trash</a> | </span><span class="view"><a href="' . get_permalink( $essay_id ) . '" rel="bookmark" target="_blank">View</a></span>';
				$row_action                         = '<span class="trash"><a href="#" id="a_essay_trash_' . $essay_id . '" class="delete_essay_single">Trash</a></span>';
				$upload = get_post_meta( $essay_id, 'upload', true );
				if ( ! empty( $upload ) ) {
					$row_action .= ' | <a href="' . esc_url( $upload ) . '" target="_blank">' . esc_html__( 'Download', 'uncanny-learndash-groups' ) . '</a>';
				}
				$essays[] = [
					'id'             => $essay_id,
					'title'          => '<a data-essay-id="' . $essay_id . '" class="edit_essay edit_essay_single">' . $essay->post_title . '</a><div class="row-actions">' . $row_action . '</div>',
					'author'         => get_the_author_meta( 'nicename', $essay->post_author ),
					'status'         => $status,
					'points'         => $points,
					'assignedCourse' => '<a href="' . get_permalink( $course ) . '">' . $course->post_title . '</a>',
					'assignedlesson' => '<a href="' . get_permalink( $lesson ) . '">' . $lesson->post_title . '</a>',
					'assignedquiz'   => '<a href="' . get_permalink( $essay_quiz_post_id ) . '">' . get_the_title( $essay_quiz_post_id ). '</a>',
					'comments'       => '<a target="_blank" href="' . get_permalink( $essay_id ) . '#comments">' . get_comments_number( $essay_id ) . '</a>',
					'date'           => get_the_date( '', $essay ),
				];
			}
		}
		
		return $essays;
	}
	
	public function _essay_bulk_actions_approve() {
		if ( isset( $_REQUEST['_uogm_essay_action'] ) && $_REQUEST['_uogm_essay_action'] === 'sfwd-essay' ) {
			if ( isset( $_REQUEST['action'] ) && $_REQUEST['action'] === 'approve_essay' ) {
				$_REQUEST['post_type'] = 'sfwd-essays';
				learndash_essay_bulk_actions_approve();
				unset( $_REQUEST['post_type'] );
			} elseif ( isset( $_REQUEST['action'] ) && $_REQUEST['action'] === 'trash_essay' ) {
				$this->trash_essays();
			}
		}
	}
	
	public function trash_essays() {
		$essay_ids = $_POST['post'];
		if ( ! empty( $essay_ids ) ) {
			foreach ( $essay_ids as $essay_id ) {
				$essay = get_post( $essay_id );
				if ( ! empty ( $essay ) && $essay->post_type === 'sfwd-essays' ) {
					learndash_before_delete_essay( $essay_id );
				    $return = wp_trash_post( $essay_id );
				}
			}
		}
	}
	
	public function edit_essays() {
		//check_ajax_referer( 'edit_essays', 'security' );
		
		$sfwd_lms      = new \SFWD_LMS();
		$essay_id = absint( $_POST['essay_id'] );
		$essay    = NULL;
		if ( ! empty( $essay_id ) ) {
			$essay = get_post( $essay_id );
		}
		if ( ! empty ( $essay ) ) {
			$post_type            = $essay->post_type;
			$post_type_object     = get_post_type_object( $post_type );
			$can_publish          = current_user_can( $post_type_object->cap->publish_posts );
			$quiz_id              = get_post_meta( $essay->ID, 'quiz_id', true );
			$question_id          = get_post_meta( $essay->ID, 'question_id', true );
			
			if ( ! empty( $quiz_id ) ) {
				$questionMapper = new \WpProQuiz_Model_QuestionMapper();
				$question       = $questionMapper->fetchById( intval( $question_id ), null );
				
			}
			
			if ( $question && is_a( $question, 'WpProQuiz_Model_Question' ) )  {
				$submitted_essay_data = learndash_get_submitted_essay_data( $quiz_id, $question->getId(), $essay );
			}
			ob_start();
			
			?>
            <div class="group-management-modal group-essay-modal modal">
                <form id="edit_essay_form" method="post">
                    <input name="essay_id" type="hidden" value="<?php echo $essay->ID?>"/>
                    <div class="uo-groups">
                        <div class="group-management-form">
                            <div class="uo-groups-message-ok" id="group-management-message"></div>

							<?php wp_nonce_field( 'ld-essay-nonce-' . $essay->ID, 'ld-essay-nonce' ); ?>

                            <div class="uo-row">
                                <div class="uo-row__title" id="title-prompt-text" for="title">
                                    <?php esc_html_e( 'Essay Title', 'uncanny-learndash-groups' ); ?>
                                </div>
                                <?php echo $essay->post_title; ?>
                            </div>
                            <div class="uo-row">
                                <?php if ( $question && is_a( $question, 'WpProQuiz_Model_Question' ) ) : ?>
                                        <div class="uo-row__title">
                                            <?php esc_html_e( 'Essay Question', 'uncanny-learndash-groups' ); ?>
                                        </div>
                                        <?php echo $question->getQuestion(); ?>
                                <?php endif;?>
                            </div>
                            <div class="uo-row">
                                <div class="uo-row__title"><?php echo __( 'Content' ); ?></div>
                                <div class="uo-row__content"><?php echo esc_attr( $essay->post_content ); ?></div>
                            </div>
                            

                            <div class="uo-row">
                                <div class="uo-row__title"><?php _e( 'Author' ); ?></div>
								<?php $author = get_userdata($essay->post_author);
								echo $author->first_name.' '.$author->last_name.' ('.$author->user_login.')';
								?>
                            </div>
                            
                            <div class="uo-row">
                                <div class="uo-row__title">
                                    <?php esc_html_e( 'Approval Status', 'uncanny-learndash-groups' ); ?>
                                </div>

		                        <?php if ( 'not_graded' == $essay->post_status || 'graded' == $essay->post_status || $can_publish ) : ?>
                                    <div id="post-status-select">
                                        <select name='post_status' id='post_status'>
                                            <option<?php selected( $essay->post_status, 'not_graded' ); ?>
                                                    value='not_graded'><?php esc_html_e( 'Not Graded', 'uncanny-learndash-groups' ) ?></option>
                                            <option<?php selected( $essay->post_status, 'graded' ); ?>
                                                    value='graded'><?php esc_html_e( 'Graded', 'uncanny-learndash-groups' ) ?></option>
                                        </select>
                                    </div>
		
		                        <?php endif; ?>

                            </div>

	                        <?php if ( $question && is_a( $question, 'WpProQuiz_Model_Question' ) ) : ?>
                                <div class="uo-row uo-row-modal-points">
                                    <div class="uo-row-modal-points__col">
                                        <div class="uo-row__title">
                                            <?php esc_html_e( 'Points available', 'uncanny-learndash-groups' ); ?>
                                        </div>
                                         <?php echo $question->getPoints(); ?>
                                    </div>
                                    <div class="uo-row-modal-points__col">
                                        <div class="uo-row__title">
                                            <?php esc_html_e( 'Points awarded', 'uncanny-learndash-groups' ); ?>
                                        </div>
                                        
                                        <input name="points_awarded" type="number" min="0" max="<?php echo $question->getPoints(); ?>" value="<?php echo $submitted_essay_data['points_awarded']; ?>">
                                    </div>
                                    
                                    <input name="original_points_awarded" type="hidden" value="<?php echo $submitted_essay_data['points_awarded']; ?>">
                                    <input name="quiz_id" type="hidden" value="<?php echo $quiz_id; ?>">
                                    <input name="ques_id" type="hidden" value="<?php echo $question->getId(); ?>">
                                </div>
	                        <?php else : ?>
                                <div class="uo-row">
                                    <p><?php esc_html_e( 'We could not find the essay question for this response', 'uncanny-learndash-groups' ); ?></p>
                                </div>
	                        <?php endif; ?>

	                        <?php
	                        $essay_quiz_post_id = get_post_meta( $essay->ID, 'quiz_post_id', true );
	                        if ( empty( $essay_quiz_post_id ) ) {
		
		                        $essay_quiz_query_args = array(
			                        'post_type'		=>	'sfwd-quiz',
			                        'post_status'	=>	'publish',
			                        'meta_key'		=>	'quiz_pro_id_' . intval( $quiz_id ),
			                        'meta_value'	=>	intval( $quiz_id ),
			                        'meta_compare'	=>	'=',
			                        'fields'		=>	'ids',
			                        'orderby'		=>	'title',
			                        'order'			=>	'ASC'
		                        );
		
		                        $essay_quiz_query = new \WP_Query( $essay_quiz_query_args );
		                        if ( count( $essay_quiz_query->posts ) > 1 ) {
			                        ?>
                                    <div class="uo-row">
                                        <div class="uo-row__title">
                                            <?php echo sprintf( esc_html_x( 'Essay %s', 'Essay Quiz', 'uncanny-learndash-groups' ), LearnDash_Custom_Label::get_label( 'quiz' ) ); ?>
                                        </div>

                                        <select name="essay_quiz_post_id">
                                            <option value=""><?php echo sprintf( esc_html_x('No %s', 'No Quiz', 'uncanny-learndash-groups' ), LearnDash_Custom_Label::get_label( 'quiz' ) ); ?></option>
					                        <?php
					                        foreach( $essay_quiz_query->posts as $quiz_post_id ) {
						                        ?><option value="<?php echo $quiz_post_id ?>"><?php echo get_the_title( $quiz_post_id ); ?></option><?php
					                        }
					                        ?>
                                        </select>
                                    </div>
			                        <?php
			
		                        } else {
			                        $essay_quiz_post_id = $essay_quiz_query->posts[0];
		                        }
	                        }
	
	                        if ( !empty( $essay_quiz_post_id ) ) { ?>
                                
                                <div class="uo-row">
                                    <div class="uo-row__title">
                                        <?php echo sprintf( esc_html_x( 'Essay %s', 'Essay Quiz', 'uncanny-learndash-groups' ), \LearnDash_Custom_Label::get_label( 'quiz' ) ); ?>
                                    </div>

                                    <?php echo get_the_title( $essay_quiz_post_id ); ?>
                                </div>
                                
		                        <?php
		
		                        $essay_quiz_course_id = get_post_meta( $essay_quiz_post_id, 'course_id', true );
		                        if ( !empty( $essay_quiz_course_id ) ) { ?>
                                    
                                        <div class="uo-row">
                                            <div class="uo-row__title">
                                                <?php echo sprintf( esc_html_x( 'Essay %s', 'Essay Course', 'uncanny-learndash-groups' ), \LearnDash_Custom_Label::get_label( 'course' ) ); ?>
                                            </div>
                                            
                                            <?php echo get_the_title( $essay_quiz_course_id ); ?>
                                        </div>
                                    
			                        <?php
			
			                        $essay_quiz_lesson_id = get_post_meta( $essay_quiz_post_id, 'lesson_id', true );
			                        if ( !empty( $essay_quiz_lesson_id ) ) { ?>
                                        
                                        <div class="uo-row">
                                            <div class="uo-row__title">
                                                <?php echo sprintf( esc_html_x( 'Essay %s', 'Essay Lesson', 'uncanny-learndash-groups' ), \LearnDash_Custom_Label::get_label( 'lesson' ) ); ?>
                                            </div>
                                            <?php echo get_the_title( $essay_quiz_lesson_id ); ?>
                                        </div>
                                        
				                        <?php
			                        }
		                        }
	                        }
	                        ?>

	                        <?php
	                        /* translators: Publish box date format, see http://php.net/date */
	                        $datef = esc_html__( 'M j, Y @ H:i' );
	                        if ( 0 != $essay->ID ) :
		                        $date  = date_i18n( $datef, strtotime( $essay->post_date ) );
	                        endif;
	
	                        if ( $can_publish ) : // Contributors don't get to choose the date of publish ?>
                                <div class="uo-row">
                                    <div class="uo-row__title">
                                        <?php esc_html_e( 'Submitted on', 'uncanny-learndash-groups' ); ?>
                                    </div>

                                    <span id="timestamp">
                                        <?php echo $date; ?>
                                    </span>
                                </div>
	                        <?php endif; ?>
                            
                            <div class="uo-row-footer">
                                <button id="uo-essay-edit-button" class="uo-btn" type="button">
                                    <?php esc_html_e( 'Save', 'uncanny-learndash-groups' ); ?>
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            
            </div>
            
			<?php
			$html = ob_get_clean();
		}
		
		return [ 'html' => $html ];
	}
	
	public function save_essays() {
		$post_data  = $_POST;
		$update_arr = [];
		
		if ( isset( $_REQUEST['post_status'] ) && $_REQUEST['post_status'] === 'trash_essay' ) {
			$_POST['post'] = [ $post_data['essay_id'] ];
			$this->trash_essays();
			
			return [ 'success' => TRUE, 'message' => __( 'Essay has been removed.', 'uncanny-learndash-groups' ) ];
		}
		
		$update_arr['post_status'] = $post_data['post_status'];
		$update_arr['ID']          = $post_data['essay_id'];
		if ( ! isset( $post_data['essay_points'] ) ) {
			wp_update_post( $update_arr );
			$essay_id    = intval( $_POST['essay_id'] );
			$essay       = get_post( $essay_id );
			$quiz_id     = intval( $_POST['quiz_id'] );
			$question_id = intval( $_POST['ques_id'] );
			
			$submitted_essay = learndash_get_submitted_essay_data( $quiz_id, $question_id, $essay );
			
			if ( ( isset( $_POST['essay_quiz_post_id'] ) ) && ( !empty( $_POST['essay_quiz_post_id'] ) ) ) {
				$essay_quiz_post_id = intval( $_POST['essay_quiz_post_id'] );
				update_post_meta( $essay_id, 'quiz_post_id', $essay_quiz_post_id );
			}
			
			$quiz_score_difference = 0;
			if ( isset( $_POST['post_status'] ) ) {
				if ( ( $_POST['post_status'] != $submitted_essay['status'] ) ) {
					if ( $_POST['post_status'] == 'graded' )
						$quiz_score_difference = 1;
					else if ( $_POST['post_status'] == 'not_graded' )
						$quiz_score_difference = -1;
				}
			}
			
			$submitted_essay['status'] = esc_html( $_POST['post_status'] );
			$submitted_essay['points_awarded'] = intval( $_POST['points_awarded'] );
			
			/**
			 * Filter essay status data
			 */
			$submitted_essay = apply_filters( 'learndash_essay_status_data', $submitted_essay );
			learndash_update_submitted_essay_data( $quiz_id, $question_id, $essay, $submitted_essay );
			
			$original_points_awarded = isset( $_POST['original_points_awarded'] ) ? intval( $_POST['original_points_awarded'] ) : null;
			$points_awarded = isset( $_POST['points_awarded'] ) ?  intval( $_POST['points_awarded'] ) : null;
			
			if ( ! is_null( $original_points_awarded ) && ! is_null( $points_awarded ) ) {
				if ( $points_awarded > $original_points_awarded ) {
					$points_awarded_difference = intval( $points_awarded ) - intval( $original_points_awarded );
				} else {
					$points_awarded_difference = ( intval( $original_points_awarded ) - intval( $points_awarded ) ) * -1;
				}
				
				$updated_scoring = array(
					'updated_question_score' => $points_awarded,
					'points_awarded_difference' => $points_awarded_difference,
					'score_difference' => $quiz_score_difference
				);
				
				/**
				 * Filter updated scoring data
				 */
				$updated_scoring = apply_filters( 'learndash_updated_essay_scoring', $updated_scoring );
				learndash_update_quiz_data( $quiz_id, $question_id, $updated_scoring, $essay );
				
				/**
				 * Perform action after all the quiz data is updated
				 */
				do_action( 'learndash_essay_all_quiz_data_updated', $quiz_id, $question_id, $updated_scoring, $essay );
			}
		}
		if ( isset( $post_data['essay_points'] ) ) {
			
			$_REQUEST['post_type'] = 'sfwd-essays';
			$_REQUEST['post']      = [ $post_data['essay_id'] ];
			$_REQUEST['ld_action'] = 'approve_essay';
			learndash_essay_bulk_actions_approve();
			unset( $_REQUEST['post_type'] );
		}
		
		return [ 'success' => TRUE, 'message' => __( 'Your changes have been saved.', 'uncanny-learndash-groups' ) ];
	}
}