<?php

/**
 * Variables
 * 
 * $has_search_terms  (bool)   Check if there are search terms
 * $has_results       (bool)   Check if there are results
 * $search_terms      (string) The search terms
 * $ceu_completions   (array)  The results
 */

// Create array with CSS classes to add to the main element
$container_css_classes = [];

// Add a class if there are search terms
if ( $has_search_terms ){
	$container_css_classes[] = 'uo-ucec-course-report--has-search-terms';
}

// Add a class if there are results
if ( $has_results ){
	$container_css_classes[] = 'uo-ucec-course-report--has-results';
}

?>

<div id="uo-ucec-course-report" class="uo-ucec-course-report <?php echo implode( ' ', $container_css_classes ); ?>" data-has-results="<?php var_export( $has_results ); ?>">
	<div class="uo-ucec-course-report-search">
		<form method="GET">
			<div class="uo-ucec-course-report-search__user">
				<label class="uo-ucec-course-report-search__fake-input">
					<span class="uo-ucec-course-report-search__label">
						<span><?php _e( 'User', 'uncanny-ceu' ); ?></span>
					</span>

					<input class="uo-ucec-course-report-search__input" name="search" type="text" value="<?php esc_html_e( $search_terms ); ?>" title="<?php _e( '3 characters minimum', 'uncanny-ceu' ) ?>" pattern=".{3,}" required>
				</label>
			</div>
			<div class="uo-ucec-course-report-search__actions">
				<button type="submit" class="uo-ucec-course-report-search__submit">
					<?php _e( 'Search', 'uncanny-ceu' ); ?>
				</button>
			</div>
		</form>
	</div>
	
	<?php

	// Check if it has search terms
	if ( $has_search_terms ){
		// Check if it has results
		if ( $has_results ){
			// Create table 
			?>

			<div class="uo-ucec-course-report-table">
				<table id="uo-ucec-course-report-table">
					<thead>
						<tr>
							<th><?php _e( 'First Name', 'uncanny-ceu' ); ?></th>
							<th><?php _e( 'Last Name', 'uncanny-ceu' ); ?></th>
							<th><?php _e( 'Course', 'uncanny-ceu' ); ?></th>
							<th class="uo-ucec-course-report-cell-date-and-time"><?php _e( 'Completion Date', 'uncanny-ceu' ); ?></th>
							<th><?php echo get_option( 'credit_designation_label_plural', __( 'CEU', 'uncanny-ceu' ) ); ?></th>
						</tr>
					</thead>
					<tbody>
						<?php foreach ( $ceu_completions as $entry ){ ?>

							<tr>
								<td><?php echo $entry[ 'first_name' ]; ?></td>
								<td><?php echo $entry[ 'last_name' ]; ?></td>
								<td><?php echo $entry[ 'ceu_title' ]; ?></td>
								<td>
									<div class="uo-ucec-course-report-cell-date-and-time">
	                                    <div class="uo-ucec-course-report-cell-date-and-time__date">
	                                        <?php echo date( 'F d, Y ', $entry[ 'ceu_date' ] ); ?>
	                                    </div>
	                                    <div class="uo-ucec-course-report-cell-date-and-time__time">
	                                        <?php echo date( 'g:i A', $entry[ 'ceu_date' ] ); ?>
	                                    </div>
	                                </div>
								</td>
								<td><?php echo $entry[ 'ceu_earned' ]; ?></td>
							</tr>

						<?php } ?>
					</tbody>
				</table>
			</div>

			<?php
		}
		// Otherwise show "No Results"
		else {
			?>

			<div class="uo-ucec-course-report-no-results">
				<div class="ucec-report-results-no-results__text">
					<?php _e( 'No results', 'uncanny-ceu' ); ?>
				</div>
			</div>

			<?php
		}
	}
	// Otherwise show something related to do a search first
	else {}

	?>

</div>