<?php
/**
 * Handles shortcodes.
 *
 * @since 1.0.0
 */

defined( 'ABSPATH' ) || die();

/**
 * Class LD_ConvertKit_Shortcodes
 *
 * Handles shortcodes.
 *
 * @since 1.0.0
 */
class LD_ConvertKit_Shortcodes {

	/**
	 * Shortcodes.
	 *
	 * @since 1.0.0
	 *
	 * @var array
	 */
	public $shortcodes = array();

	/**
	 * LD_ConvertKit_Shortcodes constructor.
	 *
	 * @since 1.0.0
	 */
	function __construct() {

		$this->require_necessities();
		$this->add_shortcodes();
	}

	/**
	 * Requires necessary files.
	 *
	 * @since 1.0.0
	 * @access private
	 */
	private function require_necessities() {

		require_once 'class-ld-convertkit-shortcode-subscriber-form.php';
	}

	/**
	 * Adds the shortcodes.
	 *
	 * @since 1.0.0
	 * @access private
	 */
	private function add_shortcodes() {

		$this->shortcodes['ld_convertkit_subscriber_form'] = new LD_ConvertKit_Shortcode_SubscriberForm();

		/**
		 * All registered shortcodes.
		 *
		 * @since 1.0.0
		 *
		 * @param array $shortcodes
		 */
		$this->shortcodes = apply_filters( 'ld_convertkit_shortcodes', $this->shortcodes );
	}
}