<?php
$element = array(
    'border-radius' => strval(get_option('lds_cg_item_border_radius')),
    'border-size'   => strval(get_option('lds_cg_item_border_size')),
    'background-color' => strval(get_option('lds_cg_item_background')),
    'padding'       => strval(get_option('lds_cg_item_padding')),
    'border-color'  => strval(get_option('lds_cg_item_border_color')),
    'drop-shadow'   => strval(get_option('lds_cg_item_drop_shadow')),
    'hover-effect'  => strval(get_option('lds_cg_hover_effect')),
);

$ribbon = array(
    'text'          => strval(get_option('lds_cg_ribbon_text') ),
    'background'    => strval(get_option('lds_cg_ribbon_background')),
    'text_free'     => strval(get_option('lds_cg_ribbon_free_text')),
    'background_free' => strval(get_option('lds_cg_ribbon_free_background')),
    'text_enrolled' =>  strval(get_option('lds_cg_ribbon_enrolled_text')),
    'background_enrolled'   =>  strval(get_option('lds_cg_ribbon_enrolled_bg')),
);

/**
 * Element treatments
 * @var [type]
 */
if( $element['border-radius'] == '0' || !empty($element['border-radius']) ): ?>
    .ld-course-list-items .ld_course_grid .thumbnail.course {
        border-radius: <?php echo $element['border-radius'] . 'px'; ?>;
    }
    .ld-course-list-items .ld_course_grid .thumbnail.course img {
        border-radius: <?php echo $element['border-radius'] . 'px'; ?> <?php echo $element['border-radius'] . 'px'; ?> 0 0;
    }
<?php
endif;

if( $element['background-color'] != '' && !empty($element['background-color']) ): ?>
    .ld-course-list-items .ld_course_grid .thumbnail.course {
        background-color: <?php echo $element['background-color']; ?>
    }
<?php
endif;


if( $element['border-size'] == '0' || !empty($element['border-size']) ): ?>
    .ld-course-list-items .ld_course_grid .thumbnail.course {
        border-width: <?php echo $element['border-size'] . 'px'; ?>;
    }
<?php
endif;

if( $element['border-color'] !== '' && !empty($element['border-color']) ): ?>
    .ld-course-list-items .ld_course_grid .thumbnail.course {
        border-color: <?php echo $element['border-color']; ?>;
    }
<?php
endif;

if( $element['drop-shadow'] !== '' && !empty($element['drop-shadow']) ): ?>
    .ld-course-list-items .ld_course_grid .thumbnail.course {
        <?php
        switch($element['drop-shadow']):
            case('light'): ?>
                box-shadow: 0 0 15px rgba(0,0,0,0.05);
                <?php
                break;
            case('light-plus'): ?>
                box-shadow: 0 0 15px rgba(0,0,0,0.1);
                <?php
                break;
            case('medium'): ?>
                box-shadow: 3px 5px 35px rgba(0,0,0,0.05);
                <?php
                break;
            case('medium-plus'): ?>
                box-shadow: 3px 5px 35px rgba(0,0,0,0.1);
                <?php
                break;
            case('heavy'): ?>
                box-shadow: 3px 5px 35px rgba(0,0,0,0.1);
                <?php
                break;
            case('heavy-plus'): ?>
                box-shadow: 3px 5px 40px rgba(0,0,0,0.15);
                <?php
                break;
            endswitch; ?>
        }
<?php
endif;

if( $ribbon['text'] !== '' && !empty($ribbon['text']) ): ?>
.ld-course-list-items .ld_course_grid .thumbnail.course .ld_course_grid_price {
    color: <?php echo $ribbon['text']; ?>;
}
<?php endif;

if( $ribbon['background'] !== '' && !empty($ribbon['background']) ): ?>
.ld-course-list-items .ld_course_grid .thumbnail.course .ld_course_grid_price {
    background: <?php echo $ribbon['background']; ?>;
}
.ld-course-list-items .ld_course_grid .thumbnail.course .ld_course_grid_price::before {
    border-top-color: <?php echo ldvc_color_shift( $ribbon['background'], -0.2 ); ?>;
    border-right-color: <?php echo ldvc_color_shift( $ribbon['background'], -0.2 ); ?>;
}
<?php endif;

if( $ribbon['text_free'] !== '' && !empty($ribbon['text_free']) ): ?>
.ld-course-list-items .ld_course_grid .thumbnail.course .ld_course_grid_price.ribbon-free {
    color: <?php echo $ribbon['text_free']; ?>;
}
<?php endif;

if( $ribbon['background_free'] !== '' && !empty($ribbon['background_free']) ): ?>
.ld-course-list-items .ld_course_grid .thumbnail.course .ld_course_grid_price.ribbon-free {
    background: <?php echo $ribbon['background_free']; ?>;
}
.ld-course-list-items .ld_course_grid .thumbnail.course .ld_course_grid_price.ribbon-free::before {
    border-top-color: <?php echo ldvc_color_shift( $ribbon['background_free'], -0.2 ); ?>;
    border-right-color: <?php echo ldvc_color_shift( $ribbon['background_free'], -0.2 ); ?>;
}
<?php endif;

if( $ribbon['text_enrolled'] !== '' && !empty($ribbon['text_enrolled']) ): ?>
.ld-course-list-items .ld_course_grid .thumbnail.course .ld_course_grid_price.ribbon-enrolled {
    color: <?php echo $ribbon['text_enrolled']; ?>;
}
<?php endif;

if( $ribbon['background_enrolled'] !== '' && !empty($ribbon['background_enrolled']) ): ?>
.ld-course-list-items .ld_course_grid .thumbnail.course .ld_course_grid_price.ribbon-enrolled {
    background: <?php echo $ribbon['background_enrolled']; ?>;
}
.ld-course-list-items .ld_course_grid .thumbnail.course .ld_course_grid_price.ribbon-enrolled::before {
    border-top-color: <?php echo ldvc_color_shift( $ribbon['background_enrolled'], -0.2 ); ?>;
    border-right-color: <?php echo ldvc_color_shift( $ribbon['background_enrolled'], -0.2 ); ?>;
}
<?php endif;

/**
 * Dev admin_notices
 *
 * Left off at ribon colors, still need to do hover effects...
 */
