<?php

if (!defined('ROLE_NAME')) {
    define('ROLE_NAME', 'Instructor');
}
if (!defined('ROLE_ID')) {
    define('ROLE_ID', 'wdm_instructor');
}
if (!defined('WDM_INS_CAPS')) {
    $wdm_ins_caps = array(
        'wpProQuiz_show' => true, // true allows this capability
        'wpProQuiz_add_quiz' => true,
        'wpProQuiz_edit_quiz' => true, // Use false to explicitly deny
        'wpProQuiz_delete_quiz' => true,
        'wpProQuiz_show_statistics' => true,
        'wpProQuiz_import' => true,
        'wpProQuiz_export' => true,
        'read_course' => true,
        'publish_courses' => true,
        'edit_courses' => true,
        'delete_courses' => true,
        'edit_course' => true,
        'delete_course' => true,
        'edit_published_courses' => true,
        'delete_published_courses' => true,
        'edit_assignment' => true,
        'edit_assignments' => true,
        'publish_assignments' => true,
        'read_assignment' => true,
        'delete_assignment' => true,
        'edit_published_assignments' => true,
        'delete_published_assignments' => true,
        //    'read_group'                     => true,
        //    'edit_groups'                     => true,
        //    'propanel_widgets'                 => true,
        'read' => true,
        'edit_others_assignments' => true,
        'instructor_reports' => true, // very important, custom for course report submenu page
        'instructor_page' => true, // very important, for showing instructor submenu page. added in 2.4.0 v
        'manage_categories' => true,
        'wpProQuiz_toplist_edit' => true, // to show leaderboard of quiz
        'upload_files' => true, // to upload files
        'delete_essays' => true,  //added v 2.4.0 for essay
        'delete_others_essays' => true,
        'delete_private_essays' => true,
        'delete_published_essays' => true,
        'edit_essays' => true,
        'edit_others_essays' => true,
        'edit_private_essays' => true,
        'edit_published_essays' => true,
        'publish_essays' => true,
        'read_essays' => true,
        'read_private_essays' => true,
        'edit_posts' => true,
        'publish_posts' => true,
        'edit_published_posts' => true,
        'delete_posts' => true,
        'delete_published_posts' => true,
        'view_h5p_contents'     => true,
        'edit_h5p_contents'     =>  true
        );

    $wdm_ins_wccaps = array(
        'delete_product' => true,
        'delete_products' => true,
        'delete_published_products' => true,
        'edit_product' => true,
        'edit_products' => true,
        'edit_published_products' => true,
        'publish_products' => true,
        'read_product' => true,
        'assign_product_terms' => true,
    );

    $wdm_ins_caps = array_merge($wdm_ins_caps, $wdm_ins_wccaps);

    define('WDM_INS_CAPS', serialize($wdm_ins_caps));
}

// Review course constant
if (!defined('WDMIR_REVIEW_COURSE')) {
    $wdmir_admin_settings = get_option('_wdmir_admin_settings', array());
    // If Review Course setting is enabled.
    if (isset($wdmir_admin_settings['review_course']) &&  '1' == $wdmir_admin_settings['review_course']) {
        define('WDMIR_REVIEW_COURSE', true);
    } else {
        define('WDMIR_REVIEW_COURSE', false);
    }
}

// Review product constant
if (!defined('WDMIR_REVIEW_PRODUCT')) {
    $wdmir_admin_settings = get_option('_wdmir_admin_settings', array());
    // If Review Product setting is enabled.
    if (isset($wdmir_admin_settings['review_product']) && '1' == $wdmir_admin_settings['review_product']) {
        define('WDMIR_REVIEW_PRODUCT', true);
    } else {
        define('WDMIR_REVIEW_PRODUCT', false);
    }
}

// Review download constant v3.0.0
if (!defined('WDMIR_REVIEW_DOWNLOAD')) {
    $wdmir_admin_settings = get_option('_wdmir_admin_settings', array());
    // If Review Product setting is enabled.
    if (isset($wdmir_admin_settings['review_download']) && '1' == $wdmir_admin_settings['review_download']) {
        define('WDMIR_REVIEW_DOWNLOAD', true);
    } else {
        define('WDMIR_REVIEW_DOWNLOAD', false);
    }
}
