
//
//  EditEscalationDetails.swift
//  Orbis
//
//  Created by Shiri Ganesh on 4/17/18.
//  Copyright © 2018 KALSI. All rights reserved.
//

import UIKit

class EditEscalationDetails: UIViewController ,UITableViewDataSource, UITableViewDelegate,UITextFieldDelegate{
    
    @IBOutlet weak var loaderView: UIView!
    @IBOutlet weak var save_button: UIButton!
    @IBOutlet weak var reset_button: UIButton!
    @IBOutlet weak var table_view: UITableView!
    
    @IBOutlet weak var noteLabel: UILabel!
    enum mainTitles : String {
        case Name
        case Emailaddress
        case Mobilenumber
        case Officenumber
        case Homenumber
    }
    @IBOutlet weak var cancelBtn: UIButton!
    
    var myData = EscalationDetailsListModel()
    var tempdata = NSMutableArray()
    var allUserData = NSMutableArray()
    var AddingNew = false
    var titles = ["Name *","Email address","Mobile number *","Office number","Home number"]
    var subject_for_changes = "Add escalation detail"
    private let cellReuseIdentifier: String = "myCell"
    
    //MARK:-
    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)
        t_EscalationDetailsListModel = self.myData
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        print(myData.FULLNAME)
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        
        if AddingNew {
            self.save_button.isHidden = false
            self.reset_button.isHidden = false
            cancelBtn.isHidden = true
            
        } else {
            self.save_button.isHidden = true
            self.reset_button.isHidden = true
            
        }
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
    //MARK:-
    
    @IBAction func GoBack(_ sender: Any) {
        isCancel = false

        if AddingNew {
            self.navigationController?.popViewController(animated: true)
        }else{
            let mycells = getAllCells()
            for cell in mycells {
                print(cell.titleLabel.text!)
                if cell.titleLabel.text! == "Name *" || cell.titleLabel.text! == "Mobile number *" {
                    if cell.titleTextField.text! == "" {
                        Globals().addPrompt(message: "Name & Mobile number are mandatory!", view: self) { }
                        break
                    }
                }
                
                if cell.titleLabel.text! == "Mobile number *" {
                    if cell.titleTextField.text!.count < 10 {
                        Globals().addPrompt(message: "Mobile number must be greater than 10 & less than 15!", view: self) { }
                        break
                    }
                }
                if cell.titleLabel.text! == "Email address" {
                    if cell.titleTextField.text?.count != 0 {
                    if !Globals().isValidEmail(testStr: cell.titleTextField.text!){
                        Globals().addPrompt(message: "Please enter valid email address or leave it empty!", view: self) { }

                        break
                    }
                    }
                }
             
                if mycells.last == cell {
                    self.navigationController?.popViewController(animated: true)
                }
            }
        }

    }
    
    @IBAction func submitClck(_ sender: Any) {
        let mycells = getAllCells()
        for cell in mycells {
            print(cell.titleLabel.text!)
            if cell.titleLabel.text! == "Name *" || cell.titleLabel.text! == "Mobile number *" {
                if cell.titleTextField.text! == "" {
                    Globals().addPrompt(message: "Name & Mobile number are mandatory!", view: self) { }
                    break
                }
            }
            
            if cell.titleLabel.text! == "Mobile number *" {
                if cell.titleTextField.text!.count < 10 {
                    Globals().addPrompt(message: "Mobile number must be greater than 10 & less than 15!", view: self) { }
                    break
                }
            }
            
            
            if mycells.last == cell {
                self.AddNow_webService()
            }
        }
        
    }
    
    func AddNow_webService() {
        let dataToUpload = NSMutableArray()
        
        for i in 0..<tempdata.count {
            
            let listData = tempdata[i] as! EscalationDetailsListModel
            
            let dict : NSDictionary = [
                "FULLNAME":"\(listData.FULLNAME)",
                "EMAIL" : listData.EMAIL ,
                "MOBILE" : listData.MOBILE,
                "BUSINESSTELEPHONE": listData.BUSINESSTELEPHONE,
                "HOMETELEPHONE" : listData.HOMETELEPHONE,
                "SITEINDEX" : UserDefaults.standard.object(forKey: "lindex") as! String,
                "PRIORITY" : listData.PRIORITY,
                ]
            
            dataToUpload.add(dict)
        }
        
        
        let dict2 : NSDictionary = [
            "FULLNAME":"\(myData.FULLNAME)",
            "EMAIL" : myData.EMAIL ,
            "MOBILE" : myData.MOBILE,
            "BUSINESSTELEPHONE": myData.BUSINESSTELEPHONE,
            "HOMETELEPHONE" : myData.HOMETELEPHONE,
            "SITEINDEX" : UserDefaults.standard.object(forKey: "lindex") as! String,
            "PRIORITY" : "\(tempdata.count+1)",
            ]
        dataToUpload.add(dict2)
        
        
        print(subject_for_changes)
        
        let dictToUpload = NSMutableDictionary()
        
        if let theJSssONData = try? JSONSerialization.data(withJSONObject: dataToUpload, options: []) {
            let theJdSONText = String(data: theJSssONData, encoding: .ascii)
            dictToUpload.setValue(theJdSONText, forKey: "parameter")
            dictToUpload.setValue(subject_for_changes, forKey: "subject")
        }
        
        if MyReachability.isConnectedToNetwork() {
            loaderView.isHidden = false
            
            Globals.Services().AlamofirePostString("user/escalation_mail", parameters: dictToUpload) { (result) in
                
                if result.count > 0 {
                    self.InfoUpdated(message: "Escalation details updated successfully! Escalation Details updates take up to 24 hours to be completed")
                    self.loaderView.isHidden = true
                    self.subject_for_changes = ""
                } else {
                    Globals().addPrompt(message: "Server not working", view: self) {
                        self.loaderView.isHidden = true
                    }
                }
            }
            
        } else {
            Globals().addPrompt(message: "Please check your internet connection", view: self) { }
        }

    }

    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat{
        return 90
    }
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return titles.count
    }
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        
        var cell = tableView.dequeueReusableCell(withIdentifier: cellReuseIdentifier , for: indexPath) as? escalationCell
        if cell == nil {
            cell = escalationCell(style: .default, reuseIdentifier: cellReuseIdentifier)
        }
        cell?.selectionStyle = .none
        tableView.separatorStyle = .none
        cell?.titleLabel.text = titles[indexPath.row]
        
        
        switch titles[indexPath.row] {
        case "Name *":
            var myTitle =  myData.FULLNAME.replacingOccurrences(of: "<strong>", with: "")
            myTitle =  myTitle.replacingOccurrences(of: "</strong>", with: "")
            cell?.titleTextField.text = myTitle//myData.FULLNAME.replacingOccurrences(of: "<strong>", with: "")
            cell?.titleTextField.keyboardType = .asciiCapable
            break
        
        case "Email address":
            var myemail =  myData.EMAIL.replacingOccurrences(of: "<strong>", with: "")
            myemail =  myemail.replacingOccurrences(of: "</strong>", with: "")
            cell?.titleTextField.text = myemail// myData.EMAIL
            cell?.titleTextField.keyboardType = .asciiCapable

            break
            
        case "Mobile number *":
            
            var myMOBILE =  myData.MOBILE.replacingOccurrences(of: "<strong>", with: "")
            myMOBILE =  myMOBILE.replacingOccurrences(of: "</strong>", with: "")
            cell?.titleTextField.text = myMOBILE//myData.MOBILE
            cell?.titleTextField.keyboardType = .numberPad

            break
        case "Office number":
            
            var BUSINESSTELEPHONE =  myData.BUSINESSTELEPHONE.replacingOccurrences(of: "<strong>", with: "")
            BUSINESSTELEPHONE =  BUSINESSTELEPHONE.replacingOccurrences(of: "</strong>", with: "")
            cell?.titleTextField.text = BUSINESSTELEPHONE//myData.BUSINESSTELEPHONE
            cell?.titleTextField.keyboardType = .numberPad

            break
        case "Home number":
            var HOMETELEPHONE =  myData.HOMETELEPHONE.replacingOccurrences(of: "<strong>", with: "")
            HOMETELEPHONE =  HOMETELEPHONE.replacingOccurrences(of: "</strong>", with: "")
            cell?.titleTextField.text = HOMETELEPHONE//myData.HOMETELEPHONE
            cell?.titleTextField.keyboardType = .numberPad
            break
        default:
            break
        }
        
        let leftView = UIView()
        leftView.frame = CGRect(x: 0, y : 0 , width : ((cell?.titleTextField.frame.size.height)! - 10), height : (cell?.titleTextField.frame.size.height)!)
        cell?.titleTextField.leftView = leftView
        cell?.titleTextField.leftViewMode = .always
        cell?.titleTextField.layer.cornerRadius = 15.0
        cell?.titleTextField.tag = indexPath.row
        cell?.titleTextField.delegate = self
//        cell.titleTextField.layer.borderWidth = 2.0
        if indexPath.row == 0 {
//            cell.backgroundColor = UIColor.blue

        }
        return cell!
        
    }
    @IBAction func cancelClick(_ sender: Any) {
        
        let controller = UIAlertController(title: "Orbis", message: "Your updates will not be saved. So you wish to continue?", preferredStyle: .alert)
        controller.addAction(UIAlertAction(title: "Yes", style: .default, handler: { (ok) in
            isCancel = true
            self.navigationController?.popViewController(animated: true)
        }))
        controller.addAction(UIAlertAction(title: "No", style: .default, handler: { (ok) in
            isCancel = false

            self.dismiss(animated: true, completion: { })
        }))
        self.present(controller, animated: true) { }
    }
    
    func textFieldDidEndEditing(_ textField: UITextField){
        
        
        if !AddingNew {
            self.noteLabel.isHidden = false
        }
            switch textField.tag {
        case 0:
            myData.FULLNAME = "<strong>\(textField.text!)</strong>"
          //  savedTitles["Name"] = textField.text
            break
        case 1:
            var emailString = textField.text
           emailString =  emailString?.replacingOccurrences(of: " ", with: "")
            if emailString?.count != 0 {

            if Globals().isValidEmail(testStr: textField.text!) {
                myData.EMAIL = "<strong>\(textField.text!)</strong>"
            }else{
                Globals().addPrompt(message: "Invalid email!", view: self) { }
            }
            }else{
                myData.EMAIL = "<strong>\(textField.text!)</strong>"

            }
         //   savedTitles["Email address"] = textField.text
            break
        
        case 2:
            myData.MOBILE = "<strong>\(textField.text!)</strong>"
           // savedTitles["Mobile number"] = textField.text
            break
        case 3:
            myData.BUSINESSTELEPHONE = "<strong>\(textField.text!)</strong>"
           // savedTitles["Office number"] = textField.text
            break
        case 4:
            myData.HOMETELEPHONE = "<strong>\(textField.text!)</strong>"           // savedTitles["Home number"] = textField.text
            break
        default:
            break
        }
    }
    
    @IBAction func ResetAction(_ sender: UIButton) {
        let mycells = getAllCells()
        
        for cell in mycells {
            cell.titleTextField.text = ""
        }
        
    }
    
    func getAllCells() -> [escalationCell] {
        var cells = [escalationCell]()
        
        for j in 0...table_view.numberOfRows(inSection: 0)-1 {
            if let cell = table_view.cellForRow(at: IndexPath(row: j, section: 0)) {
                cells.append(cell as! escalationCell)
                }
            }
        
        return cells
    }

    func InfoUpdated(message : String) {
        let controller = UIAlertController(title: "Orbis", message: message, preferredStyle: .alert)
        controller.addAction(UIAlertAction(title: "OK", style: .default, handler: { (ok) in
            self.dismiss(animated: true, completion: { })
            self.navigationController?.popViewController(animated: true)
        }))
        self.present(controller, animated: true) { }
    }
    
    //MARK:-
    public func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        if string == ""{
            return true
        }
        if textField.tag == 2 {
            if textField.text!.count < 15 {
                return true
            }else{
                return false
            }
        }else{
            return true
        }
    }
    
}
