//
//  MyMessage.swift
//  Orbis
//
//  Created by KALSI on 6/26/17.
//  Copyright © 2017 KALSI. All rights reserved.
//

import UIKit
import MessageUI


class MyMessage: UIViewController, UITextViewDelegate, UITableViewDataSource, UITableViewDelegate ,MFMessageComposeViewControllerDelegate{
    /*!
     @method     messageComposeViewController:didFinishWithResult:
     @abstract   Delegate callback which is called upon user's completion of message composition.
     @discussion This delegate callback will be called when the user completes the message composition.
     How the user chose to complete this task will be given as one of the parameters to the
     callback.  Upon this call, the client should remove the view associated with the controller,
     typically by dismissing modally.
     @param      controller   The MFMessageComposeViewController instance which is returning the result.
     @param      result       MessageComposeResult indicating how the user chose to complete the composition process.
     */
    @available(iOS 4.0, *)
    func messageComposeViewController(_ controller: MFMessageComposeViewController, didFinishWith result: MessageComposeResult) {
        
    }


    
    @IBOutlet weak var statusLabel: UILabel!
    @IBOutlet weak var sendBtn: UIButton!
    @IBOutlet weak var MessageBox: UIView!
    @IBOutlet weak var tableview: UITableView!
    @IBOutlet weak var SelectionView: UIView!
    @IBOutlet weak var MessageTextView: UITextView!
    
    
    var StatusList = NSArray()
    
    //MARK:-
    override func viewDidLoad() {
        super.viewDidLoad()
        SelectionView.alpha = 0
        StatusList = ["Current status", "Arrived", "Departed", "En Route", "Start shift", "End shift"]
        
    }
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
    override func viewWillLayoutSubviews() {
        sendBtn.layer.cornerRadius = sendBtn.frame.size.height / 2
        sendBtn.layer.masksToBounds = true
        MessageBox.layer.cornerRadius = 10
        MessageBox.layer.masksToBounds = true
        Globals.properties().shadow(view: MessageBox, placement: (CGPoint(x: 0, y: 0)), pathType: Constants.kRoundBezierPath, cornerRadius: 10)
    }
    //MARK:-
    
    //MARK:- IBActions -
    @IBAction func CurrentStatusAction(_ sender: UIButton) {
        switch sender.tag {
        case 0:
            Globals.animations().fadeOut(view: SelectionView)
            break
        case 1:
            Globals.animations().fadeIn(view: SelectionView)
            break
        default:
            break
        }
        
    }
    
    @IBAction func SendAction(_ sender: UIButton) {
        if !Globals().checkLocationAuthorization(selectedView: self){
            return
        }
        
        
        if statusLabel.text == "Current status"{
            Globals().addPrompt(message: "Select status for ARC", view: self, completion: {
                Globals.animations().fadeIn(view: self.SelectionView)
            })
        }else if MessageTextView.text == "Type here..." || MessageTextView.text == ""{
            Globals().addPrompt(message: "Add message for ARC", view: self, completion: {
                if !self.MessageTextView.isFirstResponder{
                    self.MessageTextView.becomeFirstResponder()
                }
            })
        }else{
            //Web service
            Globals().SendSignalToARC(controllerObject: self, signalType: Constants.sStatus, status: "\(self.statusLabel.text!) Message: \(self.MessageTextView.text!)")
//            
            
            self.statusLabel.text = "Current status"
            self.MessageTextView.text = "Type here..."
        }
    }
    
    //MARK:- UITextViewDelegate -
    func textViewDidBeginEditing(_ textView: UITextView) {
        if textView.text == "Type here..." {
           textView.text = ""
        }
    }
    func textViewDidEndEditing(_ textView: UITextView) {
        let trimmed = textView.text.trimmingCharacters(in: CharacterSet.whitespacesAndNewlines)
        if trimmed == "" {
            textView.text = "Type here..."
        }
    }
    func textView(_ textView: UITextView, shouldChangeTextIn range: NSRange, replacementText text: String) -> Bool {
        if text == "\n"{
            textView.resignFirstResponder()
        }
        return true
    }
    
    //MARK:- UITableViewDelegate -
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return StatusList.count
    }
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "StatusCell")!
        cell.textLabel?.text = StatusList.object(at: indexPath.row) as? String
        if indexPath.row == 0{
            cell.textLabel?.textColor = UIColor.gray
        }else{
            cell.textLabel?.textColor = UIColor.black
        }
        return cell
    }
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        if indexPath.row == 0{
            tableView.deselectRow(at: indexPath, animated: true)
        }else{
            statusLabel.text = StatusList.object(at: indexPath.row) as? String
            Globals.animations().fadeOut(view: SelectionView)
        }
        
    }
}

func messageComposeViewController(_ controller: MFMessageComposeViewController, didFinishWith result: MessageComposeResult) {
    controller.dismiss(animated: true, completion: nil)
}


// MARK :- send SMS code

/*
 
 @IBAction func Messages(_ sender: UIButton) {
 if MFMessageComposeViewController.canSendText() == true {
 let recipients:[String] = ["1500"]
 let messageController = MFMessageComposeViewController()
 messageController.messageComposeDelegate  = self
 messageController.recipients = recipients
 messageController.body = "Your_text"
 self.present(messageController, animated: true, completion: nil)
 } else {
 //handle text messaging not available
 }
 }
 
 func messageComposeViewController(_ controller: MFMessageComposeViewController, didFinishWith result: MessageComposeResult) {
 controller.dismiss(animated: true, completion: nil)
 }
 
 */


